import os.path

import pytest

from collections import OrderedDict

from estnltk import Text

from estnltk.converters import text_to_dict
from estnltk.converters import layer_to_dict, dict_to_layer

from estnltk.taggers.miscellaneous.propbank.preannotator import DEFAULT_LEXICON
from estnltk.taggers.miscellaneous.propbank.preannotator import PropBankPreannotator

@pytest.mark.skipif(not os.path.exists(DEFAULT_LEXICON),
                    reason="missing propbank lexicon. lexicon file is required for this test")
def test_propbank_preannotator_smoke():
    # Smoke test PropBankPreannotator
    prop_annotator = PropBankPreannotator(input_syntax_layer='stanza_syntax', add_arg_descriptions=True)
    
    # Prepare input text (must have a syntax layer)
    text_obj = Text('Igaüks neist kirjutab Vermeerile kuus kirja. Ma tahaksin, et muusika teeniks minu ideid.')
    stanza_syntax_dict = \
        {'name': 'stanza_syntax',
         'attributes': ('id',
                        'lemma',
                        'upostag',
                        'xpostag',
                        'feats',
                        'head',
                        'deprel',
                        'deps',
                        'misc',
                        'parent_span',
                        'children'),
         'ambiguous': False,
         'enveloping': None,
         'meta': {},
         'parent': None,
         'secondary_attributes': ('parent_span', 'children'),
         'serialisation_module': 'syntax_v0',
         'spans': [{'annotations': [{'deprel': 'nsubj',
                                     'deps': '_',
                                     'feats': OrderedDict([('sg', 'sg'),
                                                           ('nom', 'nom')]),
                                     'head': 3,
                                     'id': 1,
                                     'lemma': 'igaüks',
                                     'misc': '_',
                                     'upostag': 'P',
                                     'xpostag': 'P'}],
                    'base_span': (0, 6)},
                   {'annotations': [{'deprel': 'nmod',
                                     'deps': '_',
                                     'feats': OrderedDict([('pl', 'pl'),
                                                           ('el', 'el')]),
                                     'head': 1,
                                     'id': 2,
                                     'lemma': 'see',
                                     'misc': '_',
                                     'upostag': 'P',
                                     'xpostag': 'P'}],
                    'base_span': (7, 12)},
                   {'annotations': [{'deprel': 'root',
                                     'deps': '_',
                                     'feats': OrderedDict([('main', 'main'),
                                                           ('indic',
                                                            'indic'),
                                                           ('pres', 'pres'),
                                                           ('ps3', 'ps3'),
                                                           ('sg', 'sg'),
                                                           ('ps', 'ps'),
                                                           ('af', 'af')]),
                                     'head': 0,
                                     'id': 3,
                                     'lemma': 'kirjutama',
                                     'misc': '_',
                                     'upostag': 'V',
                                     'xpostag': 'V'}],
                    'base_span': (13, 21)},
                   {'annotations': [{'deprel': 'nmod',
                                     'deps': '_',
                                     'feats': OrderedDict([('prop', 'prop'),
                                                           ('sg', 'sg'),
                                                           ('gen', 'gen')]),
                                     'head': 5,
                                     'id': 4,
                                     'lemma': 'Vermeerile',
                                     'misc': '_',
                                     'upostag': 'S',
                                     'xpostag': 'S'}],
                    'base_span': (22, 32)},
                   {'annotations': [{'deprel': 'nummod',
                                     'deps': '_',
                                     'feats': OrderedDict([('card', 'card'),
                                                           ('sg', 'sg'),
                                                           ('nom', 'nom'),
                                                           ('l', 'l')]),
                                     'head': 6,
                                     'id': 5,
                                     'lemma': 'kuus',
                                     'misc': '_',
                                     'upostag': 'N',
                                     'xpostag': 'N'}],
                    'base_span': (33, 37)},
                   {'annotations': [{'deprel': 'obj',
                                     'deps': '_',
                                     'feats': OrderedDict([('com', 'com'),
                                                           ('sg', 'sg'),
                                                           ('part',
                                                            'part')]),
                                     'head': 3,
                                     'id': 6,
                                     'lemma': 'kiri',
                                     'misc': '_',
                                     'upostag': 'S',
                                     'xpostag': 'S'}],
                    'base_span': (38, 43)},
                   {'annotations': [{'deprel': 'punct',
                                     'deps': '_',
                                     'feats': OrderedDict(),
                                     'head': 3,
                                     'id': 7,
                                     'lemma': '.',
                                     'misc': '_',
                                     'upostag': 'Z',
                                     'xpostag': 'Z'}],
                    'base_span': (43, 44)},
                   {'annotations': [{'deprel': 'nsubj',
                                     'deps': '_',
                                     'feats': OrderedDict([('sg', 'sg'),
                                                           ('nom', 'nom')]),
                                     'head': 2,
                                     'id': 1,
                                     'lemma': 'mina',
                                     'misc': '_',
                                     'upostag': 'P',
                                     'xpostag': 'P'}],
                    'base_span': (45, 47)},
                   {'annotations': [{'deprel': 'root',
                                     'deps': '_',
                                     'feats': OrderedDict([('mod', 'mod'),
                                                           ('cond', 'cond'),
                                                           ('pres', 'pres'),
                                                           ('ps1', 'ps1'),
                                                           ('sg', 'sg'),
                                                           ('ps', 'ps'),
                                                           ('af', 'af')]),
                                     'head': 0,
                                     'id': 2,
                                     'lemma': 'tahtma',
                                     'misc': '_',
                                     'upostag': 'V',
                                     'xpostag': 'V'}],
                    'base_span': (48, 56)},
                   {'annotations': [{'deprel': 'punct',
                                     'deps': '_',
                                     'feats': OrderedDict(),
                                     'head': 6,
                                     'id': 3,
                                     'lemma': ',',
                                     'misc': '_',
                                     'upostag': 'Z',
                                     'xpostag': 'Z'}],
                    'base_span': (56, 57)},
                   {'annotations': [{'deprel': 'mark',
                                     'deps': '_',
                                     'feats': OrderedDict([('sub', 'sub'),
                                                           ('crd', 'crd')]),
                                     'head': 6,
                                     'id': 4,
                                     'lemma': 'et',
                                     'misc': '_',
                                     'upostag': 'J',
                                     'xpostag': 'J'}],
                    'base_span': (58, 60)},
                   {'annotations': [{'deprel': 'nsubj',
                                     'deps': '_',
                                     'feats': OrderedDict([('com', 'com'),
                                                           ('sg', 'sg'),
                                                           ('nom', 'nom')]),
                                     'head': 6,
                                     'id': 5,
                                     'lemma': 'muusika',
                                     'misc': '_',
                                     'upostag': 'S',
                                     'xpostag': 'S'}],
                    'base_span': (61, 68)},
                   {'annotations': [{'deprel': 'ccomp',
                                     'deps': '_',
                                     'feats': OrderedDict([('mod', 'mod'),
                                                           ('cond', 'cond'),
                                                           ('pres', 'pres'),
                                                           ('ps', 'ps'),
                                                           ('neg', 'neg')]),
                                     'head': 2,
                                     'id': 6,
                                     'lemma': 'teenima',
                                     'misc': '_',
                                     'upostag': 'V',
                                     'xpostag': 'V'}],
                    'base_span': (69, 76)},
                   {'annotations': [{'deprel': 'nmod',
                                     'deps': '_',
                                     'feats': OrderedDict([('sg', 'sg'),
                                                           ('gen', 'gen')]),
                                     'head': 8,
                                     'id': 7,
                                     'lemma': 'mina',
                                     'misc': '_',
                                     'upostag': 'P',
                                     'xpostag': 'P'}],
                    'base_span': (77, 81)},
                   {'annotations': [{'deprel': 'obj',
                                     'deps': '_',
                                     'feats': OrderedDict([('com', 'com'),
                                                           ('pl', 'pl'),
                                                           ('part',
                                                            'part')]),
                                     'head': 6,
                                     'id': 8,
                                     'lemma': 'idee',
                                     'misc': '_',
                                     'upostag': 'S',
                                     'xpostag': 'S'}],
                    'base_span': (82, 87)},
                   {'annotations': [{'deprel': 'punct',
                                     'deps': '_',
                                     'feats': OrderedDict(),
                                     'head': 2,
                                     'id': 9,
                                     'lemma': '.',
                                     'misc': '_',
                                     'upostag': 'Z',
                                     'xpostag': 'Z'}],
                    'base_span': (87, 88)}] }
    text_obj.add_layer( dict_to_layer(stanza_syntax_dict) )
    # Add propbank layer
    prop_annotator.tag( text_obj )
    # Check results
    #from pprint import pprint 
    #pprint( layer_to_dict( text_obj[prop_annotator.output_layer] ) )
    assert layer_to_dict( text_obj[prop_annotator.output_layer] ) == \
        {'name': 'pre_semantic_roles',
         'ambiguous': True,
         'attributes': ('sense_id',
                        'arg0_desc',
                        'arg1_desc',
                        'arg2_desc',
                        'arg3_desc',
                        'arg4_desc',
                        'arg5_desc'),
         'span_names': ('verb',
                        'arg0',
                        'arg1',
                        'arg2',
                        'arg3',
                        'arg4',
                        'arg5',
                        'argm_mnr',
                        'argm_tmp',
                        'argm_loc'),
         'display_order': ('verb',
                           'sense_id',
                           'arg0_desc',
                           'arg0',
                           'arg1_desc',
                           'arg1',
                           'arg2_desc',
                           'arg2',
                           'arg3_desc',
                           'arg3',
                           'arg4_desc',
                           'arg4',
                           'arg5_desc',
                           'arg5',
                           'argm_mnr',
                           'argm_tmp',
                           'argm_loc'),
         'enveloping': 'stanza_syntax',
         'meta': {},
         'relations': [{'annotations': [{'arg0_desc': 'kirjutaja',
                                         'arg1_desc': 'et/mida/kuidas',
                                         'sense_id': 'kirjutama_1'}],
                        'named_spans': {'arg0': ((0, 6),),
                                        'arg1': ((38, 43),),
                                        'verb': ((13, 21),)}},
                       {'annotations': [{'arg0_desc': 'tahtja',
                                         'arg1_desc': 'teema',
                                         'sense_id': 'tahtma_1'}],
                        'named_spans': {'arg0': ((45, 47),),
                                        'arg1': ((69, 76),),
                                        'verb': ((48, 56),)}},
                       {'annotations': [{'arg0_desc': 'teenija',
                                         'arg1_desc': 'teema/adressaat',
                                         'sense_id': 'teenima_1'}],
                        'named_spans': {'arg0': ((61, 68),),
                                        'arg1': ((82, 87),),
                                        'verb': ((69, 76),)}}],
         'secondary_attributes': (),
         'serialisation_module': 'relations_v1'}
    

    

    