""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.ubill.schemas import apis


class UBillClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(UBillClient, self).__init__(config, transport, middleware, logger)

    def get_balance(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """GetBalance - 获取账户余额

        **Request**


        **Response**

        - **AccountInfo** (dict) - 见 **AccountInfo** 模型定义

        **Response Model**

        **AccountInfo**
        - **Amount** (str) - 账户余额
        - **AmountAvailable** (str) - 账户可用余额
        - **AmountCredit** (str) - 信用账户余额
        - **AmountFree** (str) - 赠送账户余额
        - **AmountFreeze** (str) - 冻结账户金额


        """
        # build request
        d = {}
        req and d.update(req)
        d = apis.GetBalanceRequestSchema().dumps(d)

        resp = self.invoke("GetBalance", d, **kwargs)
        return apis.GetBalanceResponseSchema().loads(resp)

    def get_bill_data_file_url(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetBillDataFileUrl - 生成账单数据文件下载的 url

        **Request**

        - **BillType** (int) - (Required) 账单类型，传 0 时获取账单总览报表，传 1 获取账单明细报表
        - **BillingCycle** (str) - (Required) 账期(字符串格式，YYYY-MM，例如2021-08).   若BillingCycle 和 BillPeriod同时存在，BillingCycle 优先
        - **BillPeriod** (int) - 此字段不推荐使用，建议使用BillingCycle.   若BillingCycle 和 BillPeriod同时存在，BillingCycle 优先
        - **PaidType** (int) - 获取账单总览报表时，账单的支付状态，传 0 时获取待支付账单，传 1 时获取已支付账单。获取账单明细报表时该参数无效
        - **RequireVersion** (str) - 如需求其他语言版本的账单则使用此参数。默认中文。如 RequireVersion = "EN"，则提供英文版本账单。
        - **Version** (str) - 文件版本，若为"v1"表示获取带有子用户信息的账单，可以为空

        **Response**

        - **FileUrl** (str) - 交易账单数据下载URL
        - **IsValid** (str) - 生成的 URL是否有效，即有对应数据文件

        """
        # build request
        d = {}
        req and d.update(req)
        d = apis.GetBillDataFileUrlRequestSchema().dumps(d)

        resp = self.invoke("GetBillDataFileUrl", d, **kwargs)
        return apis.GetBillDataFileUrlResponseSchema().loads(resp)
