"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScopedAws = exports.Aws = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cfn_reference_1 = require("./private/cfn-reference");
const token_1 = require("./token");
const AWS_ACCOUNTID = 'AWS::AccountId';
const AWS_URLSUFFIX = 'AWS::URLSuffix';
const AWS_NOTIFICATIONARNS = 'AWS::NotificationARNs';
const AWS_PARTITION = 'AWS::Partition';
const AWS_REGION = 'AWS::Region';
const AWS_STACKID = 'AWS::StackId';
const AWS_STACKNAME = 'AWS::StackName';
const AWS_NOVALUE = 'AWS::NoValue';
/**
 * Accessor for pseudo parameters
 *
 * Since pseudo parameters need to be anchored to a stack somewhere in the
 * construct tree, this class takes an scope parameter; the pseudo parameter
 * values can be obtained as properties from an scoped object.
 */
class Aws {
    constructor() { }
}
exports.Aws = Aws;
_a = JSII_RTTI_SYMBOL_1;
Aws[_a] = { fqn: "@aws-cdk/core.Aws", version: "1.153.0" };
Aws.ACCOUNT_ID = pseudoString(AWS_ACCOUNTID);
Aws.URL_SUFFIX = pseudoString(AWS_URLSUFFIX);
Aws.NOTIFICATION_ARNS = token_1.Token.asList({ Ref: AWS_NOTIFICATIONARNS }, { displayHint: AWS_NOTIFICATIONARNS });
Aws.PARTITION = pseudoString(AWS_PARTITION);
Aws.REGION = pseudoString(AWS_REGION);
Aws.STACK_ID = pseudoString(AWS_STACKID);
Aws.STACK_NAME = pseudoString(AWS_STACKNAME);
Aws.NO_VALUE = pseudoString(AWS_NOVALUE);
/**
 * Accessor for scoped pseudo parameters
 *
 * These pseudo parameters are anchored to a stack somewhere in the construct
 * tree, and their values will be exported automatically.
 */
class ScopedAws {
    constructor(scope) {
        this.scope = scope;
        try {
            jsiiDeprecationWarnings._aws_cdk_core_Construct(scope);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    get accountId() {
        return this.asString(AWS_ACCOUNTID);
    }
    get urlSuffix() {
        return this.asString(AWS_URLSUFFIX);
    }
    get notificationArns() {
        return token_1.Token.asList(cfn_reference_1.CfnReference.forPseudo(AWS_NOTIFICATIONARNS, this.scope), {
            displayHint: AWS_NOTIFICATIONARNS,
        });
    }
    get partition() {
        return this.asString(AWS_PARTITION);
    }
    get region() {
        return this.asString(AWS_REGION);
    }
    get stackId() {
        return this.asString(AWS_STACKID);
    }
    get stackName() {
        return this.asString(AWS_STACKNAME);
    }
    asString(name) {
        return token_1.Token.asString(cfn_reference_1.CfnReference.forPseudo(name, this.scope), { displayHint: name });
    }
}
exports.ScopedAws = ScopedAws;
_b = JSII_RTTI_SYMBOL_1;
ScopedAws[_b] = { fqn: "@aws-cdk/core.ScopedAws", version: "1.153.0" };
function pseudoString(name) {
    // we don't want any ':' in the serialized form,
    // as ':' is the ARN separator,
    // and so we don't want ARN components
    // (which these CFN references like AWS::Partition certainly can be)
    // to contain ':'s themselves
    return token_1.Token.asString({ Ref: name }, { displayHint: name.replace('::', '.') });
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2ZuLXBzZXVkby5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNmbi1wc2V1ZG8udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQ0EsMkRBQXVEO0FBQ3ZELG1DQUFnQztBQUVoQyxNQUFNLGFBQWEsR0FBRyxnQkFBZ0IsQ0FBQztBQUN2QyxNQUFNLGFBQWEsR0FBRyxnQkFBZ0IsQ0FBQztBQUN2QyxNQUFNLG9CQUFvQixHQUFHLHVCQUF1QixDQUFDO0FBQ3JELE1BQU0sYUFBYSxHQUFHLGdCQUFnQixDQUFDO0FBQ3ZDLE1BQU0sVUFBVSxHQUFHLGFBQWEsQ0FBQztBQUNqQyxNQUFNLFdBQVcsR0FBRyxjQUFjLENBQUM7QUFDbkMsTUFBTSxhQUFhLEdBQUcsZ0JBQWdCLENBQUM7QUFDdkMsTUFBTSxXQUFXLEdBQUcsY0FBYyxDQUFDO0FBRW5DOzs7Ozs7R0FNRztBQUNILE1BQWEsR0FBRztJQVVkLGlCQUF5Qjs7QUFWM0Isa0JBV0M7OztBQVZ3QixjQUFVLEdBQUcsWUFBWSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0FBQ3pDLGNBQVUsR0FBRyxZQUFZLENBQUMsYUFBYSxDQUFDLENBQUM7QUFDekMscUJBQWlCLEdBQUcsYUFBSyxDQUFDLE1BQU0sQ0FBQyxFQUFFLEdBQUcsRUFBRSxvQkFBb0IsRUFBRSxFQUFFLEVBQUUsV0FBVyxFQUFFLG9CQUFvQixFQUFFLENBQUMsQ0FBQztBQUN2RyxhQUFTLEdBQUcsWUFBWSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0FBQ3hDLFVBQU0sR0FBRyxZQUFZLENBQUMsVUFBVSxDQUFDLENBQUM7QUFDbEMsWUFBUSxHQUFHLFlBQVksQ0FBQyxXQUFXLENBQUMsQ0FBQztBQUNyQyxjQUFVLEdBQUcsWUFBWSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0FBQ3pDLFlBQVEsR0FBRyxZQUFZLENBQUMsV0FBVyxDQUFDLENBQUM7QUFLOUQ7Ozs7O0dBS0c7QUFDSCxNQUFhLFNBQVM7SUFDcEIsWUFBNkIsS0FBZ0I7UUFBaEIsVUFBSyxHQUFMLEtBQUssQ0FBVzs7Ozs7Ozs7OztLQUM1QztJQUVELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUMsYUFBYSxDQUFDLENBQUM7S0FDckM7SUFFRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0tBQ3JDO0lBRUQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxhQUFLLENBQUMsTUFBTSxDQUFDLDRCQUFZLENBQUMsU0FBUyxDQUFDLG9CQUFvQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsRUFBRTtZQUM1RSxXQUFXLEVBQUUsb0JBQW9CO1NBQ2xDLENBQUMsQ0FBQztLQUNKO0lBRUQsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxhQUFhLENBQUMsQ0FBQztLQUNyQztJQUVELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUNsQztJQUVELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUMsV0FBVyxDQUFDLENBQUM7S0FDbkM7SUFFRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0tBQ3JDO0lBRU8sUUFBUSxDQUFDLElBQVk7UUFDM0IsT0FBTyxhQUFLLENBQUMsUUFBUSxDQUFDLDRCQUFZLENBQUMsU0FBUyxDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLEVBQUUsRUFBRSxXQUFXLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztLQUN4Rjs7QUFwQ0gsOEJBcUNDOzs7QUFFRCxTQUFTLFlBQVksQ0FBQyxJQUFZO0lBQ2hDLGdEQUFnRDtJQUNoRCwrQkFBK0I7SUFDL0Isc0NBQXNDO0lBQ3RDLG9FQUFvRTtJQUNwRSw2QkFBNkI7SUFDN0IsT0FBTyxhQUFLLENBQUMsUUFBUSxDQUFDLEVBQUUsR0FBRyxFQUFFLElBQUksRUFBRSxFQUFFLEVBQUUsV0FBVyxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxFQUFFLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQztBQUNqRixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnLi9jb25zdHJ1Y3QtY29tcGF0JztcbmltcG9ydCB7IENmblJlZmVyZW5jZSB9IGZyb20gJy4vcHJpdmF0ZS9jZm4tcmVmZXJlbmNlJztcbmltcG9ydCB7IFRva2VuIH0gZnJvbSAnLi90b2tlbic7XG5cbmNvbnN0IEFXU19BQ0NPVU5USUQgPSAnQVdTOjpBY2NvdW50SWQnO1xuY29uc3QgQVdTX1VSTFNVRkZJWCA9ICdBV1M6OlVSTFN1ZmZpeCc7XG5jb25zdCBBV1NfTk9USUZJQ0FUSU9OQVJOUyA9ICdBV1M6Ok5vdGlmaWNhdGlvbkFSTnMnO1xuY29uc3QgQVdTX1BBUlRJVElPTiA9ICdBV1M6OlBhcnRpdGlvbic7XG5jb25zdCBBV1NfUkVHSU9OID0gJ0FXUzo6UmVnaW9uJztcbmNvbnN0IEFXU19TVEFDS0lEID0gJ0FXUzo6U3RhY2tJZCc7XG5jb25zdCBBV1NfU1RBQ0tOQU1FID0gJ0FXUzo6U3RhY2tOYW1lJztcbmNvbnN0IEFXU19OT1ZBTFVFID0gJ0FXUzo6Tm9WYWx1ZSc7XG5cbi8qKlxuICogQWNjZXNzb3IgZm9yIHBzZXVkbyBwYXJhbWV0ZXJzXG4gKlxuICogU2luY2UgcHNldWRvIHBhcmFtZXRlcnMgbmVlZCB0byBiZSBhbmNob3JlZCB0byBhIHN0YWNrIHNvbWV3aGVyZSBpbiB0aGVcbiAqIGNvbnN0cnVjdCB0cmVlLCB0aGlzIGNsYXNzIHRha2VzIGFuIHNjb3BlIHBhcmFtZXRlcjsgdGhlIHBzZXVkbyBwYXJhbWV0ZXJcbiAqIHZhbHVlcyBjYW4gYmUgb2J0YWluZWQgYXMgcHJvcGVydGllcyBmcm9tIGFuIHNjb3BlZCBvYmplY3QuXG4gKi9cbmV4cG9ydCBjbGFzcyBBd3Mge1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEFDQ09VTlRfSUQgPSBwc2V1ZG9TdHJpbmcoQVdTX0FDQ09VTlRJRCk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgVVJMX1NVRkZJWCA9IHBzZXVkb1N0cmluZyhBV1NfVVJMU1VGRklYKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBOT1RJRklDQVRJT05fQVJOUyA9IFRva2VuLmFzTGlzdCh7IFJlZjogQVdTX05PVElGSUNBVElPTkFSTlMgfSwgeyBkaXNwbGF5SGludDogQVdTX05PVElGSUNBVElPTkFSTlMgfSk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgUEFSVElUSU9OID0gcHNldWRvU3RyaW5nKEFXU19QQVJUSVRJT04pO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJFR0lPTiA9IHBzZXVkb1N0cmluZyhBV1NfUkVHSU9OKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBTVEFDS19JRCA9IHBzZXVkb1N0cmluZyhBV1NfU1RBQ0tJRCk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgU1RBQ0tfTkFNRSA9IHBzZXVkb1N0cmluZyhBV1NfU1RBQ0tOQU1FKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBOT19WQUxVRSA9IHBzZXVkb1N0cmluZyhBV1NfTk9WQUxVRSk7XG5cbiAgcHJpdmF0ZSBjb25zdHJ1Y3RvcigpIHsgfVxufVxuXG4vKipcbiAqIEFjY2Vzc29yIGZvciBzY29wZWQgcHNldWRvIHBhcmFtZXRlcnNcbiAqXG4gKiBUaGVzZSBwc2V1ZG8gcGFyYW1ldGVycyBhcmUgYW5jaG9yZWQgdG8gYSBzdGFjayBzb21ld2hlcmUgaW4gdGhlIGNvbnN0cnVjdFxuICogdHJlZSwgYW5kIHRoZWlyIHZhbHVlcyB3aWxsIGJlIGV4cG9ydGVkIGF1dG9tYXRpY2FsbHkuXG4gKi9cbmV4cG9ydCBjbGFzcyBTY29wZWRBd3Mge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHNjb3BlOiBDb25zdHJ1Y3QpIHtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgYWNjb3VudElkKCk6IHN0cmluZyB7XG4gICAgcmV0dXJuIHRoaXMuYXNTdHJpbmcoQVdTX0FDQ09VTlRJRCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IHVybFN1ZmZpeCgpOiBzdHJpbmcge1xuICAgIHJldHVybiB0aGlzLmFzU3RyaW5nKEFXU19VUkxTVUZGSVgpO1xuICB9XG5cbiAgcHVibGljIGdldCBub3RpZmljYXRpb25Bcm5zKCk6IHN0cmluZ1tdIHtcbiAgICByZXR1cm4gVG9rZW4uYXNMaXN0KENmblJlZmVyZW5jZS5mb3JQc2V1ZG8oQVdTX05PVElGSUNBVElPTkFSTlMsIHRoaXMuc2NvcGUpLCB7XG4gICAgICBkaXNwbGF5SGludDogQVdTX05PVElGSUNBVElPTkFSTlMsXG4gICAgfSk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IHBhcnRpdGlvbigpOiBzdHJpbmcge1xuICAgIHJldHVybiB0aGlzLmFzU3RyaW5nKEFXU19QQVJUSVRJT04pO1xuICB9XG5cbiAgcHVibGljIGdldCByZWdpb24oKTogc3RyaW5nIHtcbiAgICByZXR1cm4gdGhpcy5hc1N0cmluZyhBV1NfUkVHSU9OKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgc3RhY2tJZCgpOiBzdHJpbmcge1xuICAgIHJldHVybiB0aGlzLmFzU3RyaW5nKEFXU19TVEFDS0lEKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgc3RhY2tOYW1lKCk6IHN0cmluZyB7XG4gICAgcmV0dXJuIHRoaXMuYXNTdHJpbmcoQVdTX1NUQUNLTkFNRSk7XG4gIH1cblxuICBwcml2YXRlIGFzU3RyaW5nKG5hbWU6IHN0cmluZykge1xuICAgIHJldHVybiBUb2tlbi5hc1N0cmluZyhDZm5SZWZlcmVuY2UuZm9yUHNldWRvKG5hbWUsIHRoaXMuc2NvcGUpLCB7IGRpc3BsYXlIaW50OiBuYW1lIH0pO1xuICB9XG59XG5cbmZ1bmN0aW9uIHBzZXVkb1N0cmluZyhuYW1lOiBzdHJpbmcpOiBzdHJpbmcge1xuICAvLyB3ZSBkb24ndCB3YW50IGFueSAnOicgaW4gdGhlIHNlcmlhbGl6ZWQgZm9ybSxcbiAgLy8gYXMgJzonIGlzIHRoZSBBUk4gc2VwYXJhdG9yLFxuICAvLyBhbmQgc28gd2UgZG9uJ3Qgd2FudCBBUk4gY29tcG9uZW50c1xuICAvLyAod2hpY2ggdGhlc2UgQ0ZOIHJlZmVyZW5jZXMgbGlrZSBBV1M6OlBhcnRpdGlvbiBjZXJ0YWlubHkgY2FuIGJlKVxuICAvLyB0byBjb250YWluICc6J3MgdGhlbXNlbHZlc1xuICByZXR1cm4gVG9rZW4uYXNTdHJpbmcoeyBSZWY6IG5hbWUgfSwgeyBkaXNwbGF5SGludDogbmFtZS5yZXBsYWNlKCc6OicsICcuJykgfSk7XG59XG4iXX0=