# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetNetworkAclResult',
    'AwaitableGetNetworkAclResult',
    'get_network_acl',
    'get_network_acl_output',
]

@pulumi.output_type
class GetNetworkAclResult:
    """
    A collection of values returned by getNetworkAcl.
    """
    def __init__(__self__, active=None, description=None, id=None, priority=None, rules=None):
        if active and not isinstance(active, bool):
            raise TypeError("Expected argument 'active' to be a bool")
        pulumi.set(__self__, "active", active)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if priority and not isinstance(priority, int):
            raise TypeError("Expected argument 'priority' to be a int")
        pulumi.set(__self__, "priority", priority)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def active(self) -> builtins.bool:
        """
        Whether the Network ACL is active
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the Network ACL
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the Network ACL.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def priority(self) -> builtins.int:
        """
        The priority of the Network ACL. Must be unique between 1 and 10.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetNetworkAclRuleResult']:
        """
        The rule of the Network ACL
        """
        return pulumi.get(self, "rules")


class AwaitableGetNetworkAclResult(GetNetworkAclResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkAclResult(
            active=self.active,
            description=self.description,
            id=self.id,
            priority=self.priority,
            rules=self.rules)


def get_network_acl(id: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkAclResult:
    """
    Data source to retrieve a specific Auth0 Network ACL by ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_auth0 as auth0

    # An Auth0 network acl loaded using its ID.
    my_network_acl = auth0.get_network_acl(id="167f9a50-4444-3333-1111-ndfdaf953ab4")
    ```


    :param builtins.str id: The ID of the Network ACL.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('auth0:index/getNetworkAcl:getNetworkAcl', __args__, opts=opts, typ=GetNetworkAclResult).value

    return AwaitableGetNetworkAclResult(
        active=pulumi.get(__ret__, 'active'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        priority=pulumi.get(__ret__, 'priority'),
        rules=pulumi.get(__ret__, 'rules'))
def get_network_acl_output(id: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkAclResult]:
    """
    Data source to retrieve a specific Auth0 Network ACL by ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_auth0 as auth0

    # An Auth0 network acl loaded using its ID.
    my_network_acl = auth0.get_network_acl(id="167f9a50-4444-3333-1111-ndfdaf953ab4")
    ```


    :param builtins.str id: The ID of the Network ACL.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('auth0:index/getNetworkAcl:getNetworkAcl', __args__, opts=opts, typ=GetNetworkAclResult)
    return __ret__.apply(lambda __response__: GetNetworkAclResult(
        active=pulumi.get(__response__, 'active'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        priority=pulumi.get(__response__, 'priority'),
        rules=pulumi.get(__response__, 'rules')))
