# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SelfServiceProfileArgs', 'SelfServiceProfile']

@pulumi.input_type
class SelfServiceProfileArgs:
    def __init__(__self__, *,
                 allowed_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 branding: Optional[pulumi.Input['SelfServiceProfileBrandingArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 user_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceProfileUserAttributeArgs']]]] = None):
        """
        The set of arguments for constructing a SelfServiceProfile resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_strategies: List of IdP strategies that will be shown to users during the Self-Service SSO flow.
        :param pulumi.Input['SelfServiceProfileBrandingArgs'] branding: Field can be used to customize the look and feel of the wizard.
        :param pulumi.Input[builtins.str] description: The description of the self-service Profile
        :param pulumi.Input[builtins.str] name: The name of the self-service Profile
        :param pulumi.Input[Sequence[pulumi.Input['SelfServiceProfileUserAttributeArgs']]] user_attributes: This array stores the mapping information that will be shown to the user during the SS-SSO flow. The user will be prompted to map the attributes on their identity provider to ensure the specified attributes get passed to Auth0.
        """
        if allowed_strategies is not None:
            pulumi.set(__self__, "allowed_strategies", allowed_strategies)
        if branding is not None:
            pulumi.set(__self__, "branding", branding)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if user_attributes is not None:
            pulumi.set(__self__, "user_attributes", user_attributes)

    @property
    @pulumi.getter(name="allowedStrategies")
    def allowed_strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of IdP strategies that will be shown to users during the Self-Service SSO flow.
        """
        return pulumi.get(self, "allowed_strategies")

    @allowed_strategies.setter
    def allowed_strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_strategies", value)

    @property
    @pulumi.getter
    def branding(self) -> Optional[pulumi.Input['SelfServiceProfileBrandingArgs']]:
        """
        Field can be used to customize the look and feel of the wizard.
        """
        return pulumi.get(self, "branding")

    @branding.setter
    def branding(self, value: Optional[pulumi.Input['SelfServiceProfileBrandingArgs']]):
        pulumi.set(self, "branding", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the self-service Profile
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the self-service Profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="userAttributes")
    def user_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceProfileUserAttributeArgs']]]]:
        """
        This array stores the mapping information that will be shown to the user during the SS-SSO flow. The user will be prompted to map the attributes on their identity provider to ensure the specified attributes get passed to Auth0.
        """
        return pulumi.get(self, "user_attributes")

    @user_attributes.setter
    def user_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceProfileUserAttributeArgs']]]]):
        pulumi.set(self, "user_attributes", value)


@pulumi.input_type
class _SelfServiceProfileState:
    def __init__(__self__, *,
                 allowed_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 branding: Optional[pulumi.Input['SelfServiceProfileBrandingArgs']] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 user_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceProfileUserAttributeArgs']]]] = None):
        """
        Input properties used for looking up and filtering SelfServiceProfile resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_strategies: List of IdP strategies that will be shown to users during the Self-Service SSO flow.
        :param pulumi.Input['SelfServiceProfileBrandingArgs'] branding: Field can be used to customize the look and feel of the wizard.
        :param pulumi.Input[builtins.str] created_at: The ISO 8601 formatted date the profile was created.
        :param pulumi.Input[builtins.str] description: The description of the self-service Profile
        :param pulumi.Input[builtins.str] name: The name of the self-service Profile
        :param pulumi.Input[builtins.str] updated_at: The ISO 8601 formatted date the profile was updated.
        :param pulumi.Input[Sequence[pulumi.Input['SelfServiceProfileUserAttributeArgs']]] user_attributes: This array stores the mapping information that will be shown to the user during the SS-SSO flow. The user will be prompted to map the attributes on their identity provider to ensure the specified attributes get passed to Auth0.
        """
        if allowed_strategies is not None:
            pulumi.set(__self__, "allowed_strategies", allowed_strategies)
        if branding is not None:
            pulumi.set(__self__, "branding", branding)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if user_attributes is not None:
            pulumi.set(__self__, "user_attributes", user_attributes)

    @property
    @pulumi.getter(name="allowedStrategies")
    def allowed_strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of IdP strategies that will be shown to users during the Self-Service SSO flow.
        """
        return pulumi.get(self, "allowed_strategies")

    @allowed_strategies.setter
    def allowed_strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_strategies", value)

    @property
    @pulumi.getter
    def branding(self) -> Optional[pulumi.Input['SelfServiceProfileBrandingArgs']]:
        """
        Field can be used to customize the look and feel of the wizard.
        """
        return pulumi.get(self, "branding")

    @branding.setter
    def branding(self, value: Optional[pulumi.Input['SelfServiceProfileBrandingArgs']]):
        pulumi.set(self, "branding", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ISO 8601 formatted date the profile was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the self-service Profile
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the self-service Profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ISO 8601 formatted date the profile was updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="userAttributes")
    def user_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceProfileUserAttributeArgs']]]]:
        """
        This array stores the mapping information that will be shown to the user during the SS-SSO flow. The user will be prompted to map the attributes on their identity provider to ensure the specified attributes get passed to Auth0.
        """
        return pulumi.get(self, "user_attributes")

    @user_attributes.setter
    def user_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SelfServiceProfileUserAttributeArgs']]]]):
        pulumi.set(self, "user_attributes", value)


@pulumi.type_token("auth0:index/selfServiceProfile:SelfServiceProfile")
class SelfServiceProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 branding: Optional[pulumi.Input[Union['SelfServiceProfileBrandingArgs', 'SelfServiceProfileBrandingArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 user_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceProfileUserAttributeArgs', 'SelfServiceProfileUserAttributeArgsDict']]]]] = None,
                 __props__=None):
        """
        With this resource, you can create and manage Self-Service Profile for a tenant.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_self_service_profile = auth0.SelfServiceProfile("my_self_service_profile",
            user_attributes=[{
                "name": "sample-name",
                "description": "sample-description",
                "is_optional": True,
            }],
            branding={
                "logo_url": "https://mycompany.org/v2/logo.png",
                "colors": {
                    "primary": "#0059d6",
                },
            })
        ```

        ## Import

        This resource can be imported using the id

        Example:

        ```sh
        $ pulumi import auth0:index/selfServiceProfile:SelfServiceProfile id "ssp_32oi5unksja93124"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_strategies: List of IdP strategies that will be shown to users during the Self-Service SSO flow.
        :param pulumi.Input[Union['SelfServiceProfileBrandingArgs', 'SelfServiceProfileBrandingArgsDict']] branding: Field can be used to customize the look and feel of the wizard.
        :param pulumi.Input[builtins.str] description: The description of the self-service Profile
        :param pulumi.Input[builtins.str] name: The name of the self-service Profile
        :param pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceProfileUserAttributeArgs', 'SelfServiceProfileUserAttributeArgsDict']]]] user_attributes: This array stores the mapping information that will be shown to the user during the SS-SSO flow. The user will be prompted to map the attributes on their identity provider to ensure the specified attributes get passed to Auth0.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SelfServiceProfileArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With this resource, you can create and manage Self-Service Profile for a tenant.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_self_service_profile = auth0.SelfServiceProfile("my_self_service_profile",
            user_attributes=[{
                "name": "sample-name",
                "description": "sample-description",
                "is_optional": True,
            }],
            branding={
                "logo_url": "https://mycompany.org/v2/logo.png",
                "colors": {
                    "primary": "#0059d6",
                },
            })
        ```

        ## Import

        This resource can be imported using the id

        Example:

        ```sh
        $ pulumi import auth0:index/selfServiceProfile:SelfServiceProfile id "ssp_32oi5unksja93124"
        ```

        :param str resource_name: The name of the resource.
        :param SelfServiceProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SelfServiceProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 branding: Optional[pulumi.Input[Union['SelfServiceProfileBrandingArgs', 'SelfServiceProfileBrandingArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 user_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceProfileUserAttributeArgs', 'SelfServiceProfileUserAttributeArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SelfServiceProfileArgs.__new__(SelfServiceProfileArgs)

            __props__.__dict__["allowed_strategies"] = allowed_strategies
            __props__.__dict__["branding"] = branding
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["user_attributes"] = user_attributes
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        super(SelfServiceProfile, __self__).__init__(
            'auth0:index/selfServiceProfile:SelfServiceProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_strategies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            branding: Optional[pulumi.Input[Union['SelfServiceProfileBrandingArgs', 'SelfServiceProfileBrandingArgsDict']]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None,
            user_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceProfileUserAttributeArgs', 'SelfServiceProfileUserAttributeArgsDict']]]]] = None) -> 'SelfServiceProfile':
        """
        Get an existing SelfServiceProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_strategies: List of IdP strategies that will be shown to users during the Self-Service SSO flow.
        :param pulumi.Input[Union['SelfServiceProfileBrandingArgs', 'SelfServiceProfileBrandingArgsDict']] branding: Field can be used to customize the look and feel of the wizard.
        :param pulumi.Input[builtins.str] created_at: The ISO 8601 formatted date the profile was created.
        :param pulumi.Input[builtins.str] description: The description of the self-service Profile
        :param pulumi.Input[builtins.str] name: The name of the self-service Profile
        :param pulumi.Input[builtins.str] updated_at: The ISO 8601 formatted date the profile was updated.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SelfServiceProfileUserAttributeArgs', 'SelfServiceProfileUserAttributeArgsDict']]]] user_attributes: This array stores the mapping information that will be shown to the user during the SS-SSO flow. The user will be prompted to map the attributes on their identity provider to ensure the specified attributes get passed to Auth0.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SelfServiceProfileState.__new__(_SelfServiceProfileState)

        __props__.__dict__["allowed_strategies"] = allowed_strategies
        __props__.__dict__["branding"] = branding
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["user_attributes"] = user_attributes
        return SelfServiceProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedStrategies")
    def allowed_strategies(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of IdP strategies that will be shown to users during the Self-Service SSO flow.
        """
        return pulumi.get(self, "allowed_strategies")

    @property
    @pulumi.getter
    def branding(self) -> pulumi.Output['outputs.SelfServiceProfileBranding']:
        """
        Field can be used to customize the look and feel of the wizard.
        """
        return pulumi.get(self, "branding")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The ISO 8601 formatted date the profile was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the self-service Profile
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the self-service Profile
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The ISO 8601 formatted date the profile was updated.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="userAttributes")
    def user_attributes(self) -> pulumi.Output[Optional[Sequence['outputs.SelfServiceProfileUserAttribute']]]:
        """
        This array stores the mapping information that will be shown to the user during the SS-SSO flow. The user will be prompted to map the attributes on their identity provider to ensure the specified attributes get passed to Auth0.
        """
        return pulumi.get(self, "user_attributes")

