"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .webhook_event_types import WebhookEventTypes
from mollie.types import BaseModel
from mollie.utils import FieldMetadata, HeaderMetadata, RequestMetadata
import pydantic
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


CreateWebhookEventTypesTypedDict = TypeAliasType(
    "CreateWebhookEventTypesTypedDict",
    Union[List[WebhookEventTypes], WebhookEventTypes],
)


CreateWebhookEventTypes = TypeAliasType(
    "CreateWebhookEventTypes", Union[List[WebhookEventTypes], WebhookEventTypes]
)


class CreateWebhookRequestBodyTypedDict(TypedDict):
    name: str
    r"""A name that identifies the webhook."""
    url: str
    r"""The URL Mollie will send the events to. This URL must be publicly accessible."""
    event_types: CreateWebhookEventTypesTypedDict
    testmode: NotRequired[bool]
    r"""Whether to create the entity in test mode or live mode.

    You can enable test mode by setting `testmode` to `true`.
    """


class CreateWebhookRequestBody(BaseModel):
    name: str
    r"""A name that identifies the webhook."""

    url: str
    r"""The URL Mollie will send the events to. This URL must be publicly accessible."""

    event_types: Annotated[CreateWebhookEventTypes, pydantic.Field(alias="eventTypes")]

    testmode: Optional[bool] = None
    r"""Whether to create the entity in test mode or live mode.

    You can enable test mode by setting `testmode` to `true`.
    """


class CreateWebhookRequestTypedDict(TypedDict):
    idempotency_key: NotRequired[str]
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""
    request_body: NotRequired[CreateWebhookRequestBodyTypedDict]


class CreateWebhookRequest(BaseModel):
    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="idempotency-key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""

    request_body: Annotated[
        Optional[CreateWebhookRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None
