"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .url import URL, URLTypedDict
from mollie.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListEntityPermissionLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListEntityPermissionLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[URL], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListEntityPermissionTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a permission object. Will always contain the string `permission` for this
    endpoint.
    """
    id: str
    r"""The identifier uniquely referring to this permission. Example: `payments.read`."""
    description: str
    r"""A short description of what kind of access the permission enables."""
    granted: bool
    r"""Whether this permission is granted to the app by the organization."""
    links: ListEntityPermissionLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class ListEntityPermission(BaseModel):
    resource: str
    r"""Indicates the response contains a permission object. Will always contain the string `permission` for this
    endpoint.
    """

    id: str
    r"""The identifier uniquely referring to this permission. Example: `payments.read`."""

    description: str
    r"""A short description of what kind of access the permission enables."""

    granted: bool
    r"""Whether this permission is granted to the app by the organization."""

    links: Annotated[ListEntityPermissionLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
