########################################################################
#
#  Copyright 2024 Johns Hopkins University
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Contact: turbulence@pha.jhu.edu
# Website: http://turbulence.pha.jhu.edu/
#
########################################################################

"""
strings of the y-grid points for the datasets with variable (nonconstant) dy grids.
    - returns an array of the y-values (ys).
"""
import numpy as np

def get_transition_bl_ys():
    ys = """
    0.00357889929984090
    0.0108136187884389
    0.0182038187875144
    0.0257528110407690
    0.0334639765380995
    0.0413407669069299
    0.0493867058289799
    0.0576053904828799
    0.0660004930129365
    0.0745757620244247
    0.0833350241057573
    0.0922821853778544
    0.101421233071093
    0.110756237130181
    0.120291351847255
    0.130030817523590
    0.139978962160230
    0.150140203177855
    0.160519049166266
    0.171120101663729
    0.181948056966539
    0.193007707969122
    0.204303946034945
    0.215841762898512
    0.227626252598758
    0.239662613444112
    0.251956150009476
    0.264512275165363
    0.277336512139454
    0.290434496610794
    0.303811978836779
    0.317474825813247
    0.331429023467738
    0.345680678886140
    0.360236022572855
    0.375101410744581
    0.390283327657863
    0.405788387970443
    0.421623339136472
    0.437795063835662
    0.454310582436297
    0.471177055492129
    0.488401786273123
    0.505992223329912
    0.523955963091862
    0.542300752498610
    0.561034491664854
    0.580165236578156
    0.599701201829532
    0.619650763376460
    0.640022461337957
    0.660825002821321
    0.682067264780095
    0.703758296902692
    0.725907324531132
    0.748523751609298
    0.771617163659981
    0.795197330789950
    0.819274210722290
    0.843857951855060
    0.868958896345333
    0.894587583217612
    0.920754751495452
    0.947471343355100
    0.974748507299932
    1.00259760135424
    1.03103019627492
    1.06005807877956
    1.08969325478912
    1.11994795268360
    1.15083462656875
    1.18236595955174
    1.21455486702382
    1.24741449994768
    1.28095824814714
    1.31519974359660
    1.35015286370789
    1.38583173461135
    1.42225073442859
    1.45942449653368
    1.49736791279954
    1.53609613682620
    1.57562458714740
    1.61596895041173
    1.65714518453444
    1.69916952181584
    1.74205847202206
    1.78582882542362
    1.83049765578714
    1.87608232331543
    1.92260047753075
    1.97007006009597
    2.01850930756817
    2.06793675407879
    2.11837123393450
    2.16983188413245
    2.22233814678345
    2.27590977143637
    2.33056681729680
    2.38632965533266
    2.44321897025933
    2.50125576239645
    2.56046134938842
    2.62085736778015
    2.68246577443958
    2.74530884781792
    2.80940918903855
    2.87478972280491
    2.94147369811784
    3.00948468879198
    3.07884659376113
    3.14958363716157
    3.22172036818263
    3.29528166067304
    3.37029271249141
    3.44677904458905
    3.52476649981282
    3.60428124141559
    3.68534975126136
    3.76799882771198
    3.85225558318230
    3.93814744134962
    4.02570213400400
    4.11494769752486
    4.20591246896961
    4.29862508175948
    4.39311446094776
    4.48940981805512
    4.58754064545681
    4.68753671030614
    4.78942804797854
    4.89324495502032
    4.99901798158625
    5.10677792334975
    5.21655581286963
    5.32838291039728
    5.44229069410776
    5.55831084973903
    5.67647525962283
    5.79681599109131
    5.91936528424341
    6.04415553905522
    6.17121930181876
    6.30058925089388
    6.43229818175820
    6.56637899134045
    6.70286466162303
    6.84178824249985
    6.98318283387629
    7.12708156699849
    7.27351758500000
    7.42252402265436
    7.57413398532307
    7.72838052708925
    7.88529662806819
    8.04491517088689
    8.20726891632595
    8.37239047811828
    8.54031229690012
    8.71106661331146
    8.88468544024418
    9.06120053423787
    9.24064336602465
    9.42304509022606
    9.60843651420708
    9.79684806609376
    9.98830976196317
    10.1828511722163
    10.3805013871469
    10.5812889817203
    10.7852419795813
    10.9923878163083
    11.2027533019382
    11.4163645827840
    11.6332471025753
    11.8534255629491
    12.0769238833241
    12.3037651601952
    12.5339716258847
    12.7675646067924
    13.0045644811891
    13.2449906365994
    13.4888614268253
    13.7361941286630
    13.9870048983704
    14.2413087279425
    14.4991194012601
    14.7604494501749
    15.0253101106007
    15.2937112786821
    15.5656614671150
    15.8411677616958
    16.1202357781810
    16.4028696195373
    16.6890718336702
    16.9788433717168
    17.2721835469944
    17.5690899946963
    17.8695586324287
    18.1735836216855
    18.4811573303588
    18.7922702963821
    19.1069111926088
    19.4250667930255
    19.7467219404014
    20.0718595154773
    20.4004604077942
    20.7325034882644
    21.0679655835868
    21.4068214526045
    21.7490437647060
    22.0946030803660
    22.4434678339216
    22.7956043186769
    23.1509766744264
    23.5095468774851
    23.8712747333079
    24.2361178717797
    24.6040317452506
    24.9749696293893
    25.3488826269187
    25.7257196742968
    26.1054275513964
    26.4879508942342
    """
    
    return np.array(ys.strip().split('\n'), dtype = np.float64)

def get_channel_ys():
    ys = """
    -9.999999999999999e-01
    -9.999834694070191e-01
    -9.999449902371761e-01
    -9.998791453391053e-01
    -9.997805185994304e-01
    -9.996436951481997e-01
    -9.994632615642732e-01
    -9.992338060806554e-01
    -9.989664493827454e-01
    -9.986612016114569e-01
    -9.983180743449220e-01
    -9.979370805980530e-01
    -9.975182348220475e-01
    -9.970615529038419e-01
    -9.965670521655072e-01
    -9.960347513635933e-01
    -9.954646706884165e-01
    -9.948568317632942e-01
    -9.942112576437249e-01
    -9.935279728165133e-01
    -9.928070031988414e-01
    -9.920483761372862e-01
    -9.912521204067818e-01
    -9.904182662095278e-01
    -9.895468451738442e-01
    -9.886378903529718e-01
    -9.876914362238178e-01
    -9.867075186856491e-01
    -9.856861750587294e-01
    -9.846274440829048e-01
    -9.835313659161335e-01
    -9.823979821329635e-01
    -9.812273357229543e-01
    -9.800194710890480e-01
    -9.787744340458836e-01
    -9.774922718180602e-01
    -9.761730330383451e-01
    -9.748167677458299e-01
    -9.734235273840317e-01
    -9.719933647989422e-01
    -9.705263342370233e-01
    -9.690224913431497e-01
    -9.674818931584975e-01
    -9.659045981183816e-01
    -9.642906660500385e-01
    -9.626401581703575e-01
    -9.609531370835583e-01
    -9.592296667788167e-01
    -9.574698126278376e-01
    -9.556736413823750e-01
    -9.538412211717003e-01
    -9.519726215000186e-01
    -9.500679132438312e-01
    -9.481271686492487e-01
    -9.461504613292497e-01
    -9.441378662608887e-01
    -9.420894597824527e-01
    -9.400053195905654e-01
    -9.378855247372397e-01
    -9.357301556268803e-01
    -9.335392940132328e-01
    -9.313130229962833e-01
    -9.290514270191066e-01
    -9.267545918646627e-01
    -9.244226046525438e-01
    -9.220555538356686e-01
    -9.196535291969289e-01
    -9.172166218457825e-01
    -9.147449242147984e-01
    -9.122385300561506e-01
    -9.096975344380619e-01
    -9.071220337411980e-01
    -9.045121256550118e-01
    -9.018679091740380e-01
    -8.991894845941382e-01
    -8.964769535086964e-01
    -8.937304188047661e-01
    -8.909499846591674e-01
    -8.881357565345354e-01
    -8.852878411753202e-01
    -8.824063466037383e-01
    -8.794913821156746e-01
    -8.765430582765373e-01
    -8.735614869170644e-01
    -8.705467811290808e-01
    -8.674990552612101e-01
    -8.644184249145361e-01
    -8.613050069382191e-01
    -8.581589194250628e-01
    -8.549802817070359e-01
    -8.517692143507448e-01
    -8.485258391528615e-01
    -8.452502791355032e-01
    -8.419426585415662e-01
    -8.386031028300133e-01
    -8.352317386711151e-01
    -8.318286939416456e-01
    -8.283940977200313e-01
    -8.249280802814557e-01
    -8.214307730929177e-01
    -8.179023088082450e-01
    -8.143428212630627e-01
    -8.107524454697166e-01
    -8.071313176121525e-01
    -8.034795750407501e-01
    -7.997973562671140e-01
    -7.960848009588195e-01
    -7.923420499341149e-01
    -7.885692451565806e-01
    -7.847665297297438e-01
    -7.809340478916512e-01
    -7.770719450093977e-01
    -7.731803675736124e-01
    -7.692594631929024e-01
    -7.653093805882540e-01
    -7.613302695873916e-01
    -7.573222811190946e-01
    -7.532855672074728e-01
    -7.492202809662000e-01
    -7.451265765927062e-01
    -7.410046093623291e-01
    -7.368545356224248e-01
    -7.326765127864361e-01
    -7.284706993279236e-01
    -7.242372547745537e-01
    -7.199763397020476e-01
    -7.156881157280909e-01
    -7.113727455062038e-01
    -7.070303927195706e-01
    -7.026612220748322e-01
    -6.982653992958381e-01
    -6.938430911173605e-01
    -6.893944652787704e-01
    -6.849196905176745e-01
    -6.804189365635158e-01
    -6.758923741311349e-01
    -6.713401749142954e-01
    -6.667625115791711e-01
    -6.621595577577967e-01
    -6.575314880414823e-01
    -6.528784779741906e-01
    -6.482007040458788e-01
    -6.434983436858043e-01
    -6.387715752557943e-01
    -6.340205780434813e-01
    -6.292455322555019e-01
    -6.244466190106620e-01
    -6.196240203330663e-01
    -6.147779191452152e-01
    -6.099084992610652e-01
    -6.050159453790577e-01
    -6.001004430751129e-01
    -5.951621787955912e-01
    -5.902013398502206e-01
    -5.852181144049931e-01
    -5.802126914750259e-01
    -5.751852609173937e-01
    -5.701360134239264e-01
    -5.650651405139760e-01
    -5.599728345271530e-01
    -5.548592886160300e-01
    -5.497246967388160e-01
    -5.445692536519992e-01
    -5.393931549029601e-01
    -5.341965968225542e-01
    -5.289797765176648e-01
    -5.237428918637272e-01
    -5.184861414972231e-01
    -5.132097248081458e-01
    -5.079138419324380e-01
    -5.025986937444001e-01
    -4.972644818490711e-01
    -4.919114085745817e-01
    -4.865396769644800e-01
    -4.811494907700297e-01
    -4.757410544424823e-01
    -4.703145731253217e-01
    -4.648702526464831e-01
    -4.594082995105464e-01
    -4.539289208909028e-01
    -4.484323246218968e-01
    -4.429187191909435e-01
    -4.373883137306198e-01
    -4.318413180107326e-01
    -4.262779424303618e-01
    -4.206983980098800e-01
    -4.151028963829484e-01
    -4.094916497884894e-01
    -4.038648710626363e-01
    -3.982227736306606e-01
    -3.925655714988764e-01
    -3.868934792465233e-01
    -3.812067120176273e-01
    -3.755054855128403e-01
    -3.697900159812586e-01
    -3.640605202122202e-01
    -3.583172155270825e-01
    -3.525603197709786e-01
    -3.467900513045550e-01
    -3.410066289956883e-01
    -3.352102722111846e-01
    -3.294012008084577e-01
    -3.235796351271907e-01
    -3.177457959809780e-01
    -3.118999046489499e-01
    -3.060421828673796e-01
    -3.001728528212723e-01
    -2.942921371359380e-01
    -2.884002588685473e-01
    -2.824974414996703e-01
    -2.765839089248003e-01
    -2.706598854458616e-01
    -2.647255957627011e-01
    -2.587812649645658e-01
    -2.528271185215648e-01
    -2.468633822761177e-01
    -2.408902824343875e-01
    -2.349080455577012e-01
    -2.289168985539562e-01
    -2.229170686690132e-01
    -2.169087834780773e-01
    -2.108922708770653e-01
    -2.048677590739623e-01
    -1.988354765801652e-01
    -1.927956522018153e-01
    -1.867485150311196e-01
    -1.806942944376616e-01
    -1.746332200597008e-01
    -1.685655217954626e-01
    -1.624914297944183e-01
    -1.564111744485555e-01
    -1.503249863836389e-01
    -1.442330964504632e-01
    -1.381357357160963e-01
    -1.320331354551152e-01
    -1.259255271408336e-01
    -1.198131424365220e-01
    -1.136962131866207e-01
    -1.075749714079459e-01
    -1.014496492808893e-01
    -9.532047914061102e-02
    -8.918769346822775e-02
    -8.305152488199409e-02
    -7.691220612847960e-02
    -7.076997007374050e-02
    -6.462504969448707e-02
    -5.847767806924677e-02
    -5.232808836952347e-02
    -4.617651385095325e-02
    -4.002318784445690e-02
    -3.386834374738965e-02
    -2.771221501468831e-02
    -2.155503515001626e-02
    -1.539703769690663e-02
    -9.238456229903897e-03
    -3.079524345704338e-03
    3.079524345704338e-03
    9.238456229903897e-03
    1.539703769690663e-02
    2.155503515001626e-02
    2.771221501468831e-02
    3.386834374738965e-02
    4.002318784445690e-02
    4.617651385095325e-02
    5.232808836952347e-02
    5.847767806924677e-02
    6.462504969448710e-02
    7.076997007374054e-02
    7.691220612847967e-02
    8.305152488199419e-02
    8.918769346822787e-02
    9.532047914061116e-02
    1.014496492808894e-01
    1.075749714079461e-01
    1.136962131866209e-01
    1.198131424365222e-01
    1.259255271408338e-01
    1.320331354551154e-01
    1.381357357160965e-01
    1.442330964504634e-01
    1.503249863836391e-01
    1.564111744485556e-01
    1.624914297944185e-01
    1.685655217954628e-01
    1.746332200597010e-01
    1.806942944376618e-01
    1.867485150311198e-01
    1.927956522018154e-01
    1.988354765801654e-01
    2.048677590739625e-01
    2.108922708770654e-01
    2.169087834780773e-01
    2.229170686690132e-01
    2.289168985539561e-01
    2.349080455577011e-01
    2.408902824343873e-01
    2.468633822761175e-01
    2.528271185215647e-01
    2.587812649645656e-01
    2.647255957627010e-01
    2.706598854458615e-01
    2.765839089248003e-01
    2.824974414996702e-01
    2.884002588685473e-01
    2.942921371359380e-01
    3.001728528212723e-01
    3.060421828673796e-01
    3.118999046489499e-01
    3.177457959809780e-01
    3.235796351271907e-01
    3.294012008084577e-01
    3.352102722111846e-01
    3.410066289956883e-01
    3.467900513045550e-01
    3.525603197709786e-01
    3.583172155270825e-01
    3.640605202122202e-01
    3.697900159812586e-01
    3.755054855128403e-01
    3.812067120176273e-01
    3.868934792465233e-01
    3.925655714988764e-01
    3.982227736306606e-01
    4.038648710626363e-01
    4.094916497884894e-01
    4.151028963829484e-01
    4.206983980098800e-01
    4.262779424303618e-01
    4.318413180107326e-01
    4.373883137306198e-01
    4.429187191909435e-01
    4.484323246218969e-01
    4.539289208909028e-01
    4.594082995105465e-01
    4.648702526464832e-01
    4.703145731253218e-01
    4.757410544424824e-01
    4.811494907700299e-01
    4.865396769644801e-01
    4.919114085745818e-01
    4.972644818490712e-01
    5.025986937444002e-01
    5.079138419324382e-01
    5.132097248081460e-01
    5.184861414972232e-01
    5.237428918637274e-01
    5.289797765176649e-01
    5.341965968225543e-01
    5.393931549029602e-01
    5.445692536519993e-01
    5.497246967388161e-01
    5.548592886160301e-01
    5.599728345271531e-01
    5.650651405139762e-01
    5.701360134239264e-01
    5.751852609173937e-01
    5.802126914750259e-01
    5.852181144049929e-01
    5.902013398502205e-01
    5.951621787955911e-01
    6.001004430751128e-01
    6.050159453790576e-01
    6.099084992610651e-01
    6.147779191452151e-01
    6.196240203330663e-01
    6.244466190106619e-01
    6.292455322555019e-01
    6.340205780434813e-01
    6.387715752557943e-01
    6.434983436858043e-01
    6.482007040458788e-01
    6.528784779741906e-01
    6.575314880414823e-01
    6.621595577577967e-01
    6.667625115791711e-01
    6.713401749142954e-01
    6.758923741311349e-01
    6.804189365635158e-01
    6.849196905176745e-01
    6.893944652787704e-01
    6.938430911173605e-01
    6.982653992958381e-01
    7.026612220748322e-01
    7.070303927195706e-01
    7.113727455062038e-01
    7.156881157280909e-01
    7.199763397020476e-01
    7.242372547745537e-01
    7.284706993279236e-01
    7.326765127864361e-01
    7.368545356224248e-01
    7.410046093623291e-01
    7.451265765927062e-01
    7.492202809662000e-01
    7.532855672074728e-01
    7.573222811190946e-01
    7.613302695873916e-01
    7.653093805882540e-01
    7.692594631929024e-01
    7.731803675736124e-01
    7.770719450093977e-01
    7.809340478916512e-01
    7.847665297297438e-01
    7.885692451565806e-01
    7.923420499341149e-01
    7.960848009588196e-01
    7.997973562671141e-01
    8.034795750407502e-01
    8.071313176121525e-01
    8.107524454697167e-01
    8.143428212630628e-01
    8.179023088082451e-01
    8.214307730929177e-01
    8.249280802814557e-01
    8.283940977200314e-01
    8.318286939416457e-01
    8.352317386711152e-01
    8.386031028300134e-01
    8.419426585415662e-01
    8.452502791355033e-01
    8.485258391528615e-01
    8.517692143507448e-01
    8.549802817070359e-01
    8.581589194250628e-01
    8.613050069382191e-01
    8.644184249145361e-01
    8.674990552612101e-01
    8.705467811290808e-01
    8.735614869170644e-01
    8.765430582765373e-01
    8.794913821156746e-01
    8.824063466037383e-01
    8.852878411753202e-01
    8.881357565345354e-01
    8.909499846591674e-01
    8.937304188047661e-01
    8.964769535086964e-01
    8.991894845941382e-01
    9.018679091740380e-01
    9.045121256550118e-01
    9.071220337411980e-01
    9.096975344380619e-01
    9.122385300561506e-01
    9.147449242147984e-01
    9.172166218457825e-01
    9.196535291969289e-01
    9.220555538356686e-01
    9.244226046525438e-01
    9.267545918646627e-01
    9.290514270191066e-01
    9.313130229962833e-01
    9.335392940132328e-01
    9.357301556268803e-01
    9.378855247372397e-01
    9.400053195905654e-01
    9.420894597824527e-01
    9.441378662608887e-01
    9.461504613292497e-01
    9.481271686492487e-01
    9.500679132438312e-01
    9.519726215000186e-01
    9.538412211717003e-01
    9.556736413823750e-01
    9.574698126278376e-01
    9.592296667788168e-01
    9.609531370835583e-01
    9.626401581703575e-01
    9.642906660500387e-01
    9.659045981183817e-01
    9.674818931584975e-01
    9.690224913431497e-01
    9.705263342370234e-01
    9.719933647989422e-01
    9.734235273840317e-01
    9.748167677458299e-01
    9.761730330383451e-01
    9.774922718180602e-01
    9.787744340458836e-01
    9.800194710890480e-01
    9.812273357229544e-01
    9.823979821329635e-01
    9.835313659161335e-01
    9.846274440829048e-01
    9.856861750587294e-01
    9.867075186856491e-01
    9.876914362238178e-01
    9.886378903529718e-01
    9.895468451738442e-01
    9.904182662095278e-01
    9.912521204067818e-01
    9.920483761372862e-01
    9.928070031988414e-01
    9.935279728165133e-01
    9.942112576437249e-01
    9.948568317632942e-01
    9.954646706884165e-01
    9.960347513635933e-01
    9.965670521655072e-01
    9.970615529038419e-01
    9.975182348220475e-01
    9.979370805980530e-01
    9.983180743449220e-01
    9.986612016114569e-01
    9.989664493827454e-01
    9.992338060806554e-01
    9.994632615642732e-01
    9.996436951481997e-01
    9.997805185994304e-01
    9.998791453391053e-01
    9.999449902371761e-01
    9.999834694070191e-01
    9.999999999999999e-01
    """
    
    return np.array(ys.strip().split('\n'), dtype = np.float64)

def get_channel5200_ys():
    ys = """
    -1
    -0.999986289286467
    -0.999958300460650
    -0.999915466180512
    -0.999857219162986
    -0.999782992186225
    -0.999692218091859
    -0.999584329787246
    -0.999472470961257
    -0.999356642058213
    -0.999236843538208
    -0.999113075877101
    -0.998985339566520
    -0.998853635113854
    -0.998717963042257
    -0.998578323890642
    -0.998434718213679
    -0.998287146581795
    -0.998135609581170
    -0.997980107813734
    -0.997820641897169
    -0.997657212464899
    -0.997489820166096
    -0.997318465665669
    -0.997143149644269
    -0.996963872798280
    -0.996780635839823
    -0.996593439496744
    -0.996402284512621
    -0.996207171646755
    -0.996008101674166
    -0.995805075385596
    -0.995598093587499
    -0.995387157102044
    -0.995172266767106
    -0.994953423436267
    -0.994730627978810
    -0.994503881279717
    -0.994273184239665
    -0.994038537775023
    -0.993799942817847
    -0.993557400315877
    -0.993310911232534
    -0.993060476546915
    -0.992806097253789
    -0.992547774363596
    -0.992285508902438
    -0.992019301912079
    -0.991749154449940
    -0.991475067589091
    -0.991197042418254
    -0.990915080041793
    -0.990629181579710
    -0.990339348167644
    -0.990045580956864
    -0.989747881114262
    -0.989446249822354
    -0.989140688279273
    -0.988831197698760
    -0.988517779310166
    -0.988200434358443
    -0.987879164104140
    -0.987553969823397
    -0.987224852807942
    -0.986891814365085
    -0.986554855817712
    -0.986213978504281
    -0.985869183778815
    -0.985520473010897
    -0.985167847585668
    -0.984811308903817
    -0.984450858381576
    -0.984086497450717
    -0.983718227558545
    -0.983346050167891
    -0.982969966757109
    -0.982589978820065
    -0.982206087866138
    -0.981818295420209
    -0.981426603022656
    -0.981031012229350
    -0.980631524611645
    -0.980228141756374
    -0.979820865265844
    -0.979409696757828
    -0.978994637865558
    -0.978575690237718
    -0.978152855538443
    -0.977726135447303
    -0.977295531659305
    -0.976861045884880
    -0.976422679849883
    -0.975980435295578
    -0.975534313978636
    -0.975084317671129
    -0.974630448160520
    -0.974172707249656
    -0.973711096756763
    -0.973245618515439
    -0.972776274374642
    -0.972303066198689
    -0.971825995867244
    -0.971345065275312
    -0.970860276333234
    -0.970371630966674
    -0.969879131116616
    -0.969382778739355
    -0.968882575806487
    -0.968378524304905
    -0.967870626236788
    -0.967358883619596
    -0.966843298486058
    -0.966323872884167
    -0.965800608877172
    -0.965273508543567
    -0.964742573977085
    -0.964207807286691
    -0.963669210596570
    -0.963126786046120
    -0.962580535789946
    -0.962030461997849
    -0.961476566854815
    -0.960918852561012
    -0.960357321331777
    -0.959791975397610
    -0.959222817004162
    -0.958649848412227
    -0.958073071897738
    -0.957492489751748
    -0.956908104280430
    -0.956319917805065
    -0.955727932662030
    -0.955132151202793
    -0.954532575793900
    -0.953929208816969
    -0.953322052668676
    -0.952711109760752
    -0.952096382519966
    -0.951477873388121
    -0.950855584822042
    -0.950229519293567
    -0.949599679289536
    -0.948966067311782
    -0.948328685877120
    -0.947687537517342
    -0.947042624779197
    -0.946393950224390
    -0.945741516429570
    -0.945085325986315
    -0.944425381501127
    -0.943761685595419
    -0.943094240905507
    -0.942423050082595
    -0.941748115792769
    -0.941069440716984
    -0.940387027551056
    -0.939700879005646
    -0.939010997806256
    -0.938317386693212
    -0.937620048421658
    -0.936918985761540
    -0.936214201497602
    -0.935505698429367
    -0.934793479371133
    -0.934077547151955
    -0.933357904615641
    -0.932634554620735
    -0.931907500040507
    -0.931176743762944
    -0.930442288690735
    -0.929704137741264
    -0.928962293846592
    -0.928216759953452
    -0.927467539023233
    -0.926714634031970
    -0.925958047970332
    -0.925197783843608
    -0.924433844671698
    -0.923666233489102
    -0.922894953344903
    -0.922120007302758
    -0.921341398440888
    -0.920559129852061
    -0.919773204643582
    -0.918983625937282
    -0.918190396869504
    -0.917393520591091
    -0.916593000267373
    -0.915788839078154
    -0.914981040217701
    -0.914169606894732
    -0.913354542332398
    -0.912535849768277
    -0.911713532454357
    -0.910887593657025
    -0.910058036657051
    -0.909224864749579
    -0.908388081244113
    -0.907547689464499
    -0.906703692748919
    -0.905856094449874
    -0.905004897934170
    -0.904150106582908
    -0.903291723791464
    -0.902429752969485
    -0.901564197540866
    -0.900695060943744
    -0.899822346630478
    -0.898946058067641
    -0.898066198736002
    -0.897182772130513
    -0.896295781760298
    -0.895405231148636
    -0.894511123832946
    -0.893613463364779
    -0.892712253309795
    -0.891807497247756
    -0.890899198772511
    -0.889987361491976
    -0.889071989028127
    -0.888153085016981
    -0.887230653108584
    -0.886304696966994
    -0.885375220270269
    -0.884442226710450
    -0.883505719993548
    -0.882565703839531
    -0.881622181982304
    -0.880675158169698
    -0.879724636163457
    -0.878770619739216
    -0.877813112686495
    -0.876852118808675
    -0.875887641922991
    -0.874919685860512
    -0.873948254466124
    -0.872973351598523
    -0.871994981130189
    -0.871013146947379
    -0.870027852950109
    -0.869039103052135
    -0.868046901180943
    -0.867051251277729
    -0.866052157297388
    -0.865049623208492
    -0.864043652993280
    -0.863034250647639
    -0.862021420181089
    -0.861005165616768
    -0.859985490991414
    -0.858962400355351
    -0.857935897772471
    -0.856905987320219
    -0.855872673089577
    -0.854835959185048
    -0.853795849724638
    -0.852752348839842
    -0.851705460675624
    -0.850655189390406
    -0.849601539156045
    -0.848544514157823
    -0.847484118594425
    -0.846420356677925
    -0.845353232633768
    -0.844282750700757
    -0.843208915131029
    -0.842131730190045
    -0.841051200156568
    -0.839967329322652
    -0.838880121993617
    -0.837789582488039
    -0.836695715137729
    -0.835598524287716
    -0.834498014296232
    -0.833394189534692
    -0.832287054387679
    -0.831176613252924
    -0.830062870541292
    -0.828945830676760
    -0.827825498096403
    -0.826701877250376
    -0.825574972601894
    -0.824444788627218
    -0.823311329815632
    -0.822174600669431
    -0.821034605703899
    -0.819891349447292
    -0.818744836440822
    -0.817595071238636
    -0.816442058407800
    -0.815285802528280
    -0.814126308192923
    -0.812963580007440
    -0.811797622590390
    -0.810628440573155
    -0.809456038599929
    -0.808280421327694
    -0.807101593426205
    -0.805919559577970
    -0.804734324478231
    -0.803545892834945
    -0.802354269368770
    -0.801159458813038
    -0.799961465913744
    -0.798760295429521
    -0.797555952131626
    -0.796348440803919
    -0.795137766242843
    -0.793923933257405
    -0.792706946669160
    -0.791486811312189
    -0.790263532033079
    -0.789037113690908
    -0.787807561157219
    -0.786574879316008
    -0.785339073063700
    -0.784100147309130
    -0.782858106973526
    -0.781612956990485
    -0.780364702305958
    -0.779113347878228
    -0.777858898677891
    -0.776601359687835
    -0.775340735903223
    -0.774077032331468
    -0.772810253992220
    -0.771540405917341
    -0.770267493150886
    -0.768991520749085
    -0.767712493780320
    -0.766430417325106
    -0.765145296476073
    -0.763857136337943
    -0.762565942027508
    -0.761271718673617
    -0.759974471417147
    -0.758674205410988
    -0.757370925820021
    -0.756064637821098
    -0.754755346603020
    -0.753443057366516
    -0.752127775324228
    -0.750809505700680
    -0.749488253732269
    -0.748164024667234
    -0.746836823765643
    -0.745506656299365
    -0.744173527552056
    -0.742837442819132
    -0.741498407407753
    -0.740156426636799
    -0.738811505836848
    -0.737463650350158
    -0.736112865530644
    -0.734759156743855
    -0.733402529366957
    -0.732042988788707
    -0.730680540409435
    -0.729315189641022
    -0.727946941906875
    -0.726575802641912
    -0.725201777292532
    -0.723824871316604
    -0.722445090183433
    -0.721062439373750
    -0.719676924379681
    -0.718288550704730
    -0.716897323863759
    -0.715503249382960
    -0.714106332799836
    -0.712706579663182
    -0.711303995533059
    -0.709898585980772
    -0.708490356588851
    -0.707079312951026
    -0.705665460672205
    -0.704248805368455
    -0.702829352666973
    -0.701407108206071
    -0.699982077635149
    -0.698554266614675
    -0.697123680816160
    -0.695690325922137
    -0.694254207626140
    -0.692815331632678
    -0.691373703657215
    -0.689929329426146
    -0.688482214676774
    -0.687032365157289
    -0.685579786626743
    -0.684124484855029
    -0.682666465622855
    -0.681205734721727
    -0.679742297953920
    -0.678276161132455
    -0.676807330081083
    -0.675335810634253
    -0.673861608637094
    -0.672384729945391
    -0.670905180425560
    -0.669422965954628
    -0.667938092420207
    -0.666450565720469
    -0.664960391764129
    -0.663467576470412
    -0.661972125769041
    -0.660474045600201
    -0.658973341914528
    -0.657470020673074
    -0.655964087847290
    -0.654455549419002
    -0.652944411380384
    -0.651430679733938
    -0.649914360492466
    -0.648395459679050
    -0.646873983327027
    -0.645349937479962
    -0.643823328191629
    -0.642294161525983
    -0.640762443557138
    -0.639228180369342
    -0.637691378056952
    -0.636152042724414
    -0.634610180486231
    -0.633065797466948
    -0.631518899801119
    -0.629969493633289
    -0.628417585117967
    -0.626863180419601
    -0.625306285712554
    -0.623746907181081
    -0.622185051019303
    -0.620620723431181
    -0.619053930630494
    -0.617484678840814
    -0.615912974295479
    -0.614338823237572
    -0.612762231919891
    -0.611183206604929
    -0.609601753564847
    -0.608017879081450
    -0.606431589446160
    -0.604842890959993
    -0.603251789933534
    -0.601658292686909
    -0.600062405549766
    -0.598464134861243
    -0.596863486969947
    -0.595260468233928
    -0.593655085020652
    -0.592047343706979
    -0.590437250679134
    -0.588824812332684
    -0.587210035072514
    -0.585592925312795
    -0.583973489476969
    -0.582351733997712
    -0.580727665316918
    -0.579101289885668
    -0.577472614164204
    -0.575841644621909
    -0.574208387737274
    -0.572572849997877
    -0.570935037900357
    -0.569294957950386
    -0.567652616662644
    -0.566008020560793
    -0.564361176177455
    -0.562712090054177
    -0.561060768741415
    -0.559407218798503
    -0.557751446793625
    -0.556093459303793
    -0.554433262914821
    -0.552770864221293
    -0.551106269826546
    -0.549439486342634
    -0.547770520390309
    -0.546099378598992
    -0.544426067606747
    -0.542750594060252
    -0.541072964614779
    -0.539393185934161
    -0.537711264690767
    -0.536027207565481
    -0.534341021247666
    -0.532652712435147
    -0.530962287834176
    -0.529269754159412
    -0.527575118133890
    -0.525878386488998
    -0.524179565964445
    -0.522478663308241
    -0.520775685276663
    -0.519070638634235
    -0.517363530153695
    -0.515654366615974
    -0.513943154810162
    -0.512229901533490
    -0.510514613591294
    -0.508797297796994
    -0.507077960972064
    -0.505356609946007
    -0.503633251556327
    -0.501907892648499
    -0.500180540075948
    -0.498451200700015
    -0.496719881389935
    -0.494986589022806
    -0.493251330483566
    -0.491514112664959
    -0.489774942467516
    -0.488033826799520
    -0.486290772576982
    -0.484545786723616
    -0.482798876170805
    -0.481050047857580
    -0.479299308730588
    -0.477546665744067
    -0.475792125859818
    -0.474035696047175
    -0.472277383282981
    -0.470517194551558
    -0.468755136844678
    -0.466991217161538
    -0.465225442508733
    -0.463457819900223
    -0.461688356357310
    -0.459917058908609
    -0.458143934590019
    -0.456368990444695
    -0.454592233523022
    -0.452813670882585
    -0.451033309588141
    -0.449251156711592
    -0.447467219331957
    -0.445681504535344
    -0.443894019414918
    -0.442104771070880
    -0.440313766610432
    -0.438521013147754
    -0.436726517803971
    -0.434930287707128
    -0.433132329992160
    -0.431332651800867
    -0.429531260281880
    -0.427728162590638
    -0.425923365889354
    -0.424116877346994
    -0.422308704139241
    -0.420498853448470
    -0.418687332463722
    -0.416874148380670
    -0.415059308401593
    -0.413242819735350
    -0.411424689597346
    -0.409604925209509
    -0.407783533800255
    -0.405960522604467
    -0.404135898863459
    -0.402309669824950
    -0.400481842743039
    -0.398652424878169
    -0.396821423497104
    -0.394988845872897
    -0.393154699284862
    -0.391318991018546
    -0.389481728365699
    -0.387642918624245
    -0.385802569098254
    -0.383960687097911
    -0.382117279939489
    -0.380272354945320
    -0.378425919443764
    -0.376577980769180
    -0.374728546261902
    -0.372877623268200
    -0.371025219140261
    -0.369171341236153
    -0.367315996919799
    -0.365459193560947
    -0.363600938535140
    -0.361741239223688
    -0.359880103013636
    -0.358017537297740
    -0.356153549474430
    -0.354288146947789
    -0.352421337127517
    -0.350553127428905
    -0.348683525272804
    -0.346812538085595
    -0.344940173299164
    -0.343066438350865
    -0.341191340683498
    -0.339314887745273
    -0.337437086989785
    -0.335557945875984
    -0.333677471868140
    -0.331795672435823
    -0.329912555053862
    -0.328028127202327
    -0.326142396366488
    -0.324255370036795
    -0.322367055708841
    -0.320477460883336
    -0.318586593066078
    -0.316694459767919
    -0.314801068504739
    -0.312906426797414
    -0.311010542171789
    -0.309113422158644
    -0.307215074293668
    -0.305315506117424
    -0.303414725175326
    -0.301512739017604
    -0.299609555199274
    -0.297705181280112
    -0.295799624824618
    -0.293892893401991
    -0.291984994586098
    -0.290075935955443
    -0.288165725093134
    -0.286254369586859
    -0.284341877028852
    -0.282428255015864
    -0.280513511149130
    -0.278597653034344
    -0.276680688281625
    -0.274762624505488
    -0.272843469324811
    -0.270923230362812
    -0.269001915247010
    -0.267079531609201
    -0.265156087085423
    -0.263231589315931
    -0.261306045945161
    -0.259379464621703
    -0.257451852998272
    -0.255523218731673
    -0.253593569482773
    -0.251662912916473
    -0.249731256701674
    -0.247798608511247
    -0.245864976022004
    -0.243930366914666
    -0.241994788873836
    -0.240058249587962
    -0.238120756749314
    -0.236182318053946
    -0.234242941201671
    -0.232302633896030
    -0.230361403844257
    -0.228419258757252
    -0.226476206349551
    -0.224532254339294
    -0.222587410448194
    -0.220641682401504
    -0.218695077927994
    -0.216747604759911
    -0.214799270632955
    -0.212850083286246
    -0.210900050462291
    -0.208949179906957
    -0.206997479369439
    -0.205044956602228
    -0.203091619361081
    -0.201137475404991
    -0.199182532496153
    -0.197226798399940
    -0.195270280884864
    -0.193312987722550
    -0.191354926687704
    -0.189396105558083
    -0.187436532114461
    -0.185476214140602
    -0.183515159423228
    -0.181553375751987
    -0.179590870919420
    -0.177627652720937
    -0.175663728954778
    -0.173699107421987
    -0.171733795926380
    -0.169767802274514
    -0.167801134275653
    -0.165833799741743
    -0.163865806487375
    -0.161897162329759
    -0.159927875088689
    -0.157957952586512
    -0.155987402648102
    -0.154016233100822
    -0.152044451774498
    -0.150072066501385
    -0.148099085116138
    -0.146125515455780
    -0.144151365359668
    -0.142176642669469
    -0.140201355229121
    -0.138225510884807
    -0.136249117484921
    -0.134272182880038
    -0.132294714922885
    -0.130316721468304
    -0.128338210373227
    -0.126359189496641
    -0.124379666699559
    -0.122399649844987
    -0.120419146797893
    -0.118438165425176
    -0.116456713595637
    -0.114474799179944
    -0.112492430050603
    -0.110509614081925
    -0.108526359149999
    -0.106542673132654
    -0.104558563909434
    -0.102574039361563
    -0.100589107371915
    -0.0986037758249813
    -0.0966180526068420
    -0.0946319456051320
    -0.0926454627090110
    -0.0906586118091316
    -0.0886714007976084
    -0.0866838375679862
    -0.0846959300152091
    -0.0827076860355888
    -0.0807191135267733
    -0.0787302203877155
    -0.0767410145186421
    -0.0747515038210220
    -0.0727616961975349
    -0.0707715995520397
    -0.0687812217895436
    -0.0667905708161706
    -0.0647996545391295
    -0.0628084808666833
    -0.0608170577081172
    -0.0588253929737075
    -0.0568334945746902
    -0.0548413704232291
    -0.0528490284323851
    -0.0508564765160842
    -0.0488637225890864
    -0.0468707745669539
    -0.0448776403660201
    -0.0428843279033578
    -0.0408908450967479
    -0.0388971998646480
    -0.0369034001261608
    -0.0349094538010029
    -0.0329153688094730
    -0.0309211530724205
    -0.0289268145112144
    -0.0269323610477116
    -0.0249378006042250
    -0.0229431411034929
    -0.0209483904686469
    -0.0189535566231805
    -0.0169586474909180
    -0.0149636709959823
    -0.0129686350627644
    -0.0109735476158911
    -0.00897841658019383
    -0.00698324988067719
    -0.00498805544248746
    -0.00299284119088113
    -0.000997615051193367
    0.000997615051193464
    0.00299284119088123
    0.00498805544248753
    0.00698324988067722
    0.00897841658019381
    0.0109735476158911
    0.0129686350627644
    0.0149636709959823
    0.0169586474909180
    0.0189535566231805
    0.0209483904686469
    0.0229431411034929
    0.0249378006042250
    0.0269323610477115
    0.0289268145112144
    0.0309211530724205
    0.0329153688094730
    0.0349094538010029
    0.0369034001261609
    0.0388971998646480
    0.0408908450967479
    0.0428843279033577
    0.0448776403660201
    0.0468707745669539
    0.0488637225890864
    0.0508564765160842
    0.0528490284323851
    0.0548413704232291
    0.0568334945746901
    0.0588253929737075
    0.0608170577081172
    0.0628084808666833
    0.0647996545391295
    0.0667905708161706
    0.0687812217895437
    0.0707715995520396
    0.0727616961975348
    0.0747515038210220
    0.0767410145186421
    0.0787302203877155
    0.0807191135267733
    0.0827076860355888
    0.0846959300152092
    0.0866838375679862
    0.0886714007976084
    0.0906586118091316
    0.0926454627090110
    0.0946319456051320
    0.0966180526068420
    0.0986037758249814
    0.100589107371915
    0.102574039361563
    0.104558563909434
    0.106542673132654
    0.108526359149999
    0.110509614081925
    0.112492430050603
    0.114474799179944
    0.116456713595637
    0.118438165425176
    0.120419146797893
    0.122399649844987
    0.124379666699559
    0.126359189496641
    0.128338210373227
    0.130316721468304
    0.132294714922885
    0.134272182880038
    0.136249117484921
    0.138225510884807
    0.140201355229121
    0.142176642669469
    0.144151365359668
    0.146125515455780
    0.148099085116138
    0.150072066501385
    0.152044451774498
    0.154016233100822
    0.155987402648102
    0.157957952586513
    0.159927875088689
    0.161897162329759
    0.163865806487375
    0.165833799741743
    0.167801134275653
    0.169767802274514
    0.171733795926380
    0.173699107421987
    0.175663728954778
    0.177627652720937
    0.179590870919420
    0.181553375751987
    0.183515159423228
    0.185476214140602
    0.187436532114461
    0.189396105558083
    0.191354926687704
    0.193312987722550
    0.195270280884864
    0.197226798399940
    0.199182532496153
    0.201137475404991
    0.203091619361081
    0.205044956602228
    0.206997479369439
    0.208949179906957
    0.210900050462291
    0.212850083286246
    0.214799270632955
    0.216747604759911
    0.218695077927994
    0.220641682401504
    0.222587410448194
    0.224532254339295
    0.226476206349551
    0.228419258757252
    0.230361403844257
    0.232302633896030
    0.234242941201671
    0.236182318053946
    0.238120756749314
    0.240058249587962
    0.241994788873836
    0.243930366914666
    0.245864976022004
    0.247798608511247
    0.249731256701674
    0.251662912916473
    0.253593569482773
    0.255523218731673
    0.257451852998272
    0.259379464621703
    0.261306045945161
    0.263231589315931
    0.265156087085423
    0.267079531609201
    0.269001915247010
    0.270923230362812
    0.272843469324811
    0.274762624505488
    0.276680688281625
    0.278597653034344
    0.280513511149130
    0.282428255015864
    0.284341877028852
    0.286254369586859
    0.288165725093134
    0.290075935955443
    0.291984994586098
    0.293892893401991
    0.295799624824618
    0.297705181280112
    0.299609555199274
    0.301512739017604
    0.303414725175326
    0.305315506117424
    0.307215074293668
    0.309113422158644
    0.311010542171789
    0.312906426797414
    0.314801068504739
    0.316694459767919
    0.318586593066078
    0.320477460883336
    0.322367055708841
    0.324255370036795
    0.326142396366488
    0.328028127202327
    0.329912555053862
    0.331795672435823
    0.333677471868140
    0.335557945875984
    0.337437086989785
    0.339314887745273
    0.341191340683498
    0.343066438350865
    0.344940173299164
    0.346812538085595
    0.348683525272804
    0.350553127428905
    0.352421337127518
    0.354288146947789
    0.356153549474430
    0.358017537297740
    0.359880103013636
    0.361741239223688
    0.363600938535140
    0.365459193560947
    0.367315996919799
    0.369171341236153
    0.371025219140261
    0.372877623268200
    0.374728546261902
    0.376577980769180
    0.378425919443764
    0.380272354945320
    0.382117279939489
    0.383960687097911
    0.385802569098254
    0.387642918624245
    0.389481728365699
    0.391318991018546
    0.393154699284862
    0.394988845872897
    0.396821423497104
    0.398652424878169
    0.400481842743039
    0.402309669824951
    0.404135898863459
    0.405960522604467
    0.407783533800255
    0.409604925209509
    0.411424689597346
    0.413242819735350
    0.415059308401593
    0.416874148380670
    0.418687332463722
    0.420498853448470
    0.422308704139241
    0.424116877346994
    0.425923365889354
    0.427728162590638
    0.429531260281880
    0.431332651800867
    0.433132329992160
    0.434930287707128
    0.436726517803971
    0.438521013147754
    0.440313766610433
    0.442104771070880
    0.443894019414918
    0.445681504535344
    0.447467219331957
    0.449251156711592
    0.451033309588141
    0.452813670882585
    0.454592233523022
    0.456368990444695
    0.458143934590019
    0.459917058908609
    0.461688356357310
    0.463457819900223
    0.465225442508733
    0.466991217161538
    0.468755136844678
    0.470517194551558
    0.472277383282981
    0.474035696047175
    0.475792125859818
    0.477546665744067
    0.479299308730588
    0.481050047857580
    0.482798876170805
    0.484545786723616
    0.486290772576982
    0.488033826799520
    0.489774942467516
    0.491514112664959
    0.493251330483565
    0.494986589022806
    0.496719881389935
    0.498451200700015
    0.500180540075948
    0.501907892648499
    0.503633251556327
    0.505356609946007
    0.507077960972064
    0.508797297796994
    0.510514613591294
    0.512229901533490
    0.513943154810162
    0.515654366615974
    0.517363530153695
    0.519070638634235
    0.520775685276663
    0.522478663308241
    0.524179565964445
    0.525878386488998
    0.527575118133890
    0.529269754159412
    0.530962287834176
    0.532652712435147
    0.534341021247666
    0.536027207565481
    0.537711264690767
    0.539393185934161
    0.541072964614779
    0.542750594060252
    0.544426067606747
    0.546099378598992
    0.547770520390309
    0.549439486342634
    0.551106269826546
    0.552770864221293
    0.554433262914821
    0.556093459303793
    0.557751446793625
    0.559407218798503
    0.561060768741415
    0.562712090054177
    0.564361176177455
    0.566008020560793
    0.567652616662644
    0.569294957950386
    0.570935037900357
    0.572572849997877
    0.574208387737274
    0.575841644621909
    0.577472614164204
    0.579101289885668
    0.580727665316918
    0.582351733997712
    0.583973489476969
    0.585592925312795
    0.587210035072514
    0.588824812332684
    0.590437250679134
    0.592047343706979
    0.593655085020652
    0.595260468233928
    0.596863486969947
    0.598464134861243
    0.600062405549766
    0.601658292686909
    0.603251789933534
    0.604842890959993
    0.606431589446160
    0.608017879081450
    0.609601753564847
    0.611183206604929
    0.612762231919891
    0.614338823237572
    0.615912974295479
    0.617484678840814
    0.619053930630494
    0.620620723431180
    0.622185051019303
    0.623746907181081
    0.625306285712554
    0.626863180419601
    0.628417585117967
    0.629969493633289
    0.631518899801119
    0.633065797466948
    0.634610180486231
    0.636152042724414
    0.637691378056952
    0.639228180369342
    0.640762443557138
    0.642294161525983
    0.643823328191629
    0.645349937479962
    0.646873983327027
    0.648395459679050
    0.649914360492466
    0.651430679733938
    0.652944411380384
    0.654455549419002
    0.655964087847290
    0.657470020673074
    0.658973341914528
    0.660474045600201
    0.661972125769041
    0.663467576470412
    0.664960391764129
    0.666450565720469
    0.667938092420207
    0.669422965954628
    0.670905180425560
    0.672384729945390
    0.673861608637094
    0.675335810634253
    0.676807330081083
    0.678276161132455
    0.679742297953920
    0.681205734721727
    0.682666465622855
    0.684124484855029
    0.685579786626743
    0.687032365157289
    0.688482214676774
    0.689929329426146
    0.691373703657215
    0.692815331632678
    0.694254207626140
    0.695690325922137
    0.697123680816160
    0.698554266614675
    0.699982077635149
    0.701407108206071
    0.702829352666973
    0.704248805368455
    0.705665460672205
    0.707079312951026
    0.708490356588851
    0.709898585980772
    0.711303995533059
    0.712706579663182
    0.714106332799836
    0.715503249382960
    0.716897323863759
    0.718288550704730
    0.719676924379681
    0.721062439373750
    0.722445090183433
    0.723824871316604
    0.725201777292532
    0.726575802641912
    0.727946941906875
    0.729315189641022
    0.730680540409435
    0.732042988788707
    0.733402529366957
    0.734759156743855
    0.736112865530644
    0.737463650350158
    0.738811505836848
    0.740156426636799
    0.741498407407753
    0.742837442819132
    0.744173527552056
    0.745506656299365
    0.746836823765643
    0.748164024667234
    0.749488253732269
    0.750809505700680
    0.752127775324228
    0.753443057366516
    0.754755346603020
    0.756064637821098
    0.757370925820021
    0.758674205410988
    0.759974471417147
    0.761271718673617
    0.762565942027508
    0.763857136337943
    0.765145296476073
    0.766430417325106
    0.767712493780320
    0.768991520749085
    0.770267493150886
    0.771540405917341
    0.772810253992220
    0.774077032331468
    0.775340735903223
    0.776601359687835
    0.777858898677891
    0.779113347878228
    0.780364702305958
    0.781612956990485
    0.782858106973526
    0.784100147309130
    0.785339073063700
    0.786574879316008
    0.787807561157219
    0.789037113690908
    0.790263532033079
    0.791486811312189
    0.792706946669160
    0.793923933257405
    0.795137766242843
    0.796348440803919
    0.797555952131626
    0.798760295429521
    0.799961465913744
    0.801159458813038
    0.802354269368770
    0.803545892834945
    0.804734324478231
    0.805919559577970
    0.807101593426205
    0.808280421327694
    0.809456038599929
    0.810628440573155
    0.811797622590390
    0.812963580007440
    0.814126308192923
    0.815285802528280
    0.816442058407800
    0.817595071238636
    0.818744836440822
    0.819891349447292
    0.821034605703899
    0.822174600669431
    0.823311329815632
    0.824444788627218
    0.825574972601894
    0.826701877250376
    0.827825498096403
    0.828945830676760
    0.830062870541292
    0.831176613252924
    0.832287054387679
    0.833394189534692
    0.834498014296232
    0.835598524287716
    0.836695715137729
    0.837789582488039
    0.838880121993617
    0.839967329322652
    0.841051200156568
    0.842131730190045
    0.843208915131029
    0.844282750700757
    0.845353232633768
    0.846420356677925
    0.847484118594425
    0.848544514157823
    0.849601539156045
    0.850655189390406
    0.851705460675624
    0.852752348839842
    0.853795849724638
    0.854835959185048
    0.855872673089577
    0.856905987320219
    0.857935897772471
    0.858962400355351
    0.859985490991414
    0.861005165616768
    0.862021420181089
    0.863034250647639
    0.864043652993280
    0.865049623208492
    0.866052157297388
    0.867051251277729
    0.868046901180943
    0.869039103052135
    0.870027852950109
    0.871013146947379
    0.871994981130189
    0.872973351598523
    0.873948254466124
    0.874919685860512
    0.875887641922991
    0.876852118808675
    0.877813112686495
    0.878770619739216
    0.879724636163457
    0.880675158169698
    0.881622181982304
    0.882565703839531
    0.883505719993548
    0.884442226710450
    0.885375220270269
    0.886304696966994
    0.887230653108584
    0.888153085016981
    0.889071989028127
    0.889987361491976
    0.890899198772511
    0.891807497247756
    0.892712253309795
    0.893613463364779
    0.894511123832946
    0.895405231148636
    0.896295781760298
    0.897182772130513
    0.898066198736002
    0.898946058067641
    0.899822346630478
    0.900695060943744
    0.901564197540866
    0.902429752969485
    0.903291723791464
    0.904150106582908
    0.905004897934170
    0.905856094449874
    0.906703692748919
    0.907547689464499
    0.908388081244113
    0.909224864749580
    0.910058036657051
    0.910887593657025
    0.911713532454357
    0.912535849768277
    0.913354542332398
    0.914169606894732
    0.914981040217701
    0.915788839078154
    0.916593000267373
    0.917393520591091
    0.918190396869504
    0.918983625937282
    0.919773204643582
    0.920559129852061
    0.921341398440888
    0.922120007302758
    0.922894953344903
    0.923666233489102
    0.924433844671698
    0.925197783843608
    0.925958047970332
    0.926714634031970
    0.927467539023233
    0.928216759953452
    0.928962293846592
    0.929704137741264
    0.930442288690735
    0.931176743762944
    0.931907500040507
    0.932634554620735
    0.933357904615641
    0.934077547151955
    0.934793479371133
    0.935505698429367
    0.936214201497602
    0.936918985761540
    0.937620048421658
    0.938317386693212
    0.939010997806256
    0.939700879005646
    0.940387027551056
    0.941069440716984
    0.941748115792769
    0.942423050082595
    0.943094240905507
    0.943761685595419
    0.944425381501127
    0.945085325986315
    0.945741516429570
    0.946393950224390
    0.947042624779197
    0.947687537517342
    0.948328685877120
    0.948966067311782
    0.949599679289536
    0.950229519293567
    0.950855584822042
    0.951477873388121
    0.952096382519966
    0.952711109760752
    0.953322052668676
    0.953929208816969
    0.954532575793900
    0.955132151202793
    0.955727932662030
    0.956319917805065
    0.956908104280430
    0.957492489751748
    0.958073071897738
    0.958649848412227
    0.959222817004162
    0.959791975397610
    0.960357321331777
    0.960918852561012
    0.961476566854815
    0.962030461997849
    0.962580535789946
    0.963126786046120
    0.963669210596570
    0.964207807286691
    0.964742573977085
    0.965273508543567
    0.965800608877172
    0.966323872884167
    0.966843298486058
    0.967358883619596
    0.967870626236788
    0.968378524304905
    0.968882575806487
    0.969382778739355
    0.969879131116616
    0.970371630966674
    0.970860276333234
    0.971345065275312
    0.971825995867244
    0.972303066198689
    0.972776274374642
    0.973245618515439
    0.973711096756763
    0.974172707249656
    0.974630448160520
    0.975084317671129
    0.975534313978636
    0.975980435295578
    0.976422679849883
    0.976861045884880
    0.977295531659305
    0.977726135447303
    0.978152855538443
    0.978575690237718
    0.978994637865558
    0.979409696757828
    0.979820865265844
    0.980228141756374
    0.980631524611645
    0.981031012229350
    0.981426603022656
    0.981818295420209
    0.982206087866138
    0.982589978820065
    0.982969966757109
    0.983346050167891
    0.983718227558545
    0.984086497450717
    0.984450858381576
    0.984811308903817
    0.985167847585668
    0.985520473010897
    0.985869183778815
    0.986213978504281
    0.986554855817712
    0.986891814365085
    0.987224852807942
    0.987553969823397
    0.987879164104140
    0.988200434358443
    0.988517779310166
    0.988831197698760
    0.989140688279273
    0.989446249822354
    0.989747881114262
    0.990045580956864
    0.990339348167644
    0.990629181579710
    0.990915080041793
    0.991197042418254
    0.991475067589091
    0.991749154449940
    0.992019301912080
    0.992285508902438
    0.992547774363596
    0.992806097253789
    0.993060476546915
    0.993310911232534
    0.993557400315877
    0.993799942817847
    0.994038537775023
    0.994273184239665
    0.994503881279717
    0.994730627978810
    0.994953423436267
    0.995172266767106
    0.995387157102044
    0.995598093587499
    0.995805075385596
    0.996008101674166
    0.996207171646755
    0.996402284512621
    0.996593439496744
    0.996780635839823
    0.996963872798280
    0.997143149644269
    0.997318465665669
    0.997489820166096
    0.997657212464899
    0.997820641897169
    0.997980107813734
    0.998135609581170
    0.998287146581795
    0.998434718213679
    0.998578323890642
    0.998717963042257
    0.998853635113854
    0.998985339566520
    0.999113075877101
    0.999236843538208
    0.999356642058213
    0.999472470961257
    0.999584329787246
    0.999692218091859
    0.999782992186225
    0.999857219162986
    0.999915466180512
    0.999958300460650
    0.999986289286467
    1
    """
    
    return np.array(ys.strip().split('\n'), dtype = np.float64)