""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.umem.schemas import apis


class UMemClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(UMemClient, self).__init__(config, transport, middleware, logger)

    def check_udredis_space_allowance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CheckUDredisSpaceAllowance - 检查高性能UMem剩余资源，以及分片扩容前的资源预检查

        **Request**

        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Count** (str) - (Required) 创建实例的数量，[1-10]
        - **Size** (int) - (Required) 创建实例的容量大小,，扩容时的分片目标容量大小
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **GroupId** (str) - 资源ID，扩缩容时的必传参数

        **Response**

        - **Count** (int) - 创建实例资源时，表示可创建的数量；扩容资源时，返回1表示可以扩容，0表示可用区资源不足不能扩容

        """
        # build request
        d = {
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CheckUDredisSpaceAllowanceRequestSchema().dumps(d)

        resp = self.invoke("CheckUDredisSpaceAllowance", d, **kwargs)
        return apis.CheckUDredisSpaceAllowanceResponseSchema().loads(resp)

    def check_uredis_allowance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CheckURedisAllowance - 检查主备Redis的资源是否足够创建新实例，以及主备Redis的扩容资源预检查

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Count** (int) - (Required) 创建实例的数量，[1-10]
        - **Size** (int) - (Required) 创建实例的容量大小, 单位:GB 目前仅支持1/2/4/8/16/32六种规格；扩缩容时，表示实例的目标资源大小
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **GroupId** (str) - 资源ID，扩容实例资源时的必传参数
        - **Protocol** (str) -
        - **RegionFlag** (bool) - 是否是跨机房URedis(默认false)
        - **SlaveZone** (str) -

        **Response**

        - **Count** (int) - 创建实例资源时，表示可创建的数量；扩容资源时，返回1表示可以扩容，0表示可用区资源不足不能扩容

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CheckURedisAllowanceRequestSchema().dumps(d)

        resp = self.invoke("CheckURedisAllowance", d, **kwargs)
        return apis.CheckURedisAllowanceResponseSchema().loads(resp)

    def create_scan_hot_big_keys(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateScanHotBigKeys - 创建执行扫大key和热key的任务

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **GroupId** (str) - (Required) 资源id
        - **Type** (str) - (Required) 任务类型。"ScanBigKeys"：扫大key，"ScanHotKeys"：扫热key
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **IsRetry** (bool) - 是否要重试任务，如果是的话，TaskId必填
        - **TaskId** (str) - 要重试的任务id

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateScanHotBigKeysRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateScanHotBigKeys", d, **kwargs)
        return apis.CreateScanHotBigKeysResponseSchema().loads(resp)

    def create_umem_backup(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateUMemBackup - 创建分布式redis备份

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **BackupName** (str) - (Required) 请求创建备份的名称 (范围[6-63],只能包含英文、数字以及符号-和_)
        - **SpaceId** (str) - (Required) 资源id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**

        - **BackupId** (str) - 备份Id

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateUMemBackupRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateUMemBackup", d, **kwargs)
        return apis.CreateUMemBackupResponseSchema().loads(resp)

    def create_umem_space(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateUMemSpace - 创建UMem内存空间

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Name** (str) - (Required) 空间名称,长度(6<=size<=63)
        - **Size** (int) - (Required) 内存大小, 单位:GB, 范围[1~1024]
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **BackupId** (str) - 备份ID，选择从该备份新建集群
        - **BlockCnt** (int) - 分片个数
        - **ChargeType** (str) - Year , Month, Dynamic 默认: Month
        - **ClusterMode** (str) - "RWMode"：表示创建读写分离版本;其他为创建普通版本
        - **CouponId** (str) - 使用的代金券id
        - **HighPerformance** (bool) - 是否创建性能增强性。默认为false，或者不填，填true为性能增强型。
        - **Password** (str) - URedis密码。请遵照 `字段规范 <https://docs.ucloud.cn/api/uhost-api/specification>`_ 设定密码。密码需使用base64进行编码，举例如下：# echo -n Password1 | base64UGFzc3dvcmQx。
        - **Port** (int) - 分片端口, 默认为 6379
        - **Protocol** (str) - 协议:memcache, redis (默认redis).注意:redis无single类型
        - **ProxyPort** (int) - 代理端口, 默认为 6379
        - **ProxySize** (int) - 分布式代理CPU核数，不填或者传0时默认不创建代理
        - **Quantity** (int) - 购买时长 默认: 1
        - **SlaveZone** (str) - 跨机房UDRedis，slave所在可用区（必须和Zone在同一Region，且不可相同）
        - **SpaceId** (str) - 集群ID，选择某个备份创建时，需要填写源集群ID
        - **SubnetId** (str) - 子网ID
        - **Tag** (str) - 业务组名称
        - **Type** (str) - 空间类型:single(无热备),double(热备)(默认: double)
        - **UlbMode** (bool) - 是否创建负载均衡型分布式代理，true时表示创建负载均衡型代理
        - **VPCId** (str) - VPC的ID
        - **Version** (str) - 分布式分片版本（默认版本是4.0，其他版本见DescribeUDRedisBlockVersion）

        **Response**

        - **SpaceId** (str) - 创建内存空间ID列表

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateUMemSpaceRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateUMemSpace", d, **kwargs)
        return apis.CreateUMemSpaceResponseSchema().loads(resp)

    def create_umem_cache_group(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateUMemcacheGroup - 创建单机Memcache

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **Name** (str) - (Required) 请求创建组的名称 范围[6-60]
        - **ChargeType** (str) - 计费模式，Year , Month, Dynamic 默认: Month
        - **ConfigId** (str) - 配置ID,目前仅支持默认配置id 默认配置id:"9a891891-c245-4b66-bce8-67e59430d67c"
        - **CouponId** (str) - 代金券ID
        - **Protocol** (str) -
        - **Quantity** (int) - 购买时长，默认为1
        - **Size** (int) - 每个节点的内存大小,单位GB,默认1GB 目前仅支持1/2/4/8/16/32这几档
        - **SubnetId** (str) -
        - **Tag** (str) - 业务组 默认：Default
        - **VPCId** (str) -
        - **Version** (str) - Memcache版本信息,默认为1.4.31
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**

        - **GroupId** (str) - 创建的组ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateUMemcacheGroupRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateUMemcacheGroup", d, **kwargs)
        return apis.CreateUMemcacheGroupResponseSchema().loads(resp)

    def create_uredis_backup(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateURedisBackup - 创建主备Redis备份

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **BackupName** (str) - (Required) 请求创建组的名称 (范围[6-63],只能包含英文、数字以及符号-和_)
        - **GroupId** (str) - (Required) 资源id
        - **SlaveZone** (str) - 跨机房URedis，slave所在可用区（必须和Zone在同一Region，且不可相同）
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**

        - **BackupId** (str) - 备份id

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateURedisBackupRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateURedisBackup", d, **kwargs)
        return apis.CreateURedisBackupResponseSchema().loads(resp)

    def create_uredis_group(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateURedisGroup - 创建主备redis

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **HighAvailability** (str) - (Required) 是否开启高可用,enable或disable
        - **Name** (str) - (Required) 请求创建组的名称 (范围[6-63],只能包含英文、数字以及符号-和_)
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **AOFID** (str) - 回档的AOF文件ID
        - **AutoBackup** (str) - 是否自动备份,enable或disable，默认disable
        - **BackupId** (str) - 有此项代表从备份中创建，无代表正常创建
        - **BackupTime** (int) - 自动备份开始时间,范围[0-23],默认3点
        - **ChargeType** (str) - 计费模式，Year , Month, Dynamic 默认: Month
        - **ConfigId** (str) - 配置ID,目前支持 4.0版本配置ID:"6c9298a3-9d7f-428c-b1d0-e87ab3b8a1ea", 5.0版本配置ID:"3cdeeb90-dcbf-46e8-95cd-a05d8860a22c",6.0版本配置ID:"1d990520-aac8-4e0f-9384-f58611e8eb28",7.0版本配置ID:"48dcf534-db41-11ec-a1a6-52670028d520",默认版本4.0,从备份创建为必传项
        - **CouponId** (str) - 代金券ID
        - **EnableIpV6** (bool) - 【即将下线,请勿使用】是否创建使用ipv6 资源， 默认为false， 或者不填， 创建ipv6为true
        - **HighPerformance** (bool) - 是否创建高性能Redis， 默认为false， 或者不填， 创建高性能为true
        - **MasterGroupId** (str) - Master Redis Group的ID，创建只读Slave时，必须填写
        - **Password** (str) - 初始化密码,需要 base64 编码
        - **Port** (int) - 端口
        - **Quantity** (int) - 购买时长，默认为1
        - **RollbackGroupId** (str) - 如果是通过回档创建实例，需要传回档实例的GroupId
        - **RollbackTime** (int) - 回档时间点
        - **Size** (int) - 每个节点的内存大小,单位GB,默认1GB,目前仅支持1/2/4/8/16/32,六种
        - **SlaveZone** (str) - 跨机房URedis，slave所在可用区（必须和Zone在同一Region，且不可相同）
        - **SubnetId** (str) - 子网ID
        - **Tag** (str) - 业务组名称
        - **VPCId** (str) - VPC的ID
        - **Version** (str) - Redis版本信息(详见DescribeURedisVersion返回结果),默认版本4.0

        **Response**

        - **GroupId** (str) - 创建的组ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateURedisGroupRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateURedisGroup", d, **kwargs)
        return apis.CreateURedisGroupResponseSchema().loads(resp)

    def delete_umem_space(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteUMemSpace - 删除UMem内存空间

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **SpaceId** (str) - (Required) UMem内存空间ID
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DeleteUMemSpaceRequestSchema().dumps(d)

        resp = self.invoke("DeleteUMemSpace", d, **kwargs)
        return apis.DeleteUMemSpaceResponseSchema().loads(resp)

    def delete_umem_cache_group(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteUMemcacheGroup - 删除单机Memcache

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **GroupId** (str) - (Required) 组ID
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DeleteUMemcacheGroupRequestSchema().dumps(d)

        resp = self.invoke("DeleteUMemcacheGroup", d, **kwargs)
        return apis.DeleteUMemcacheGroupResponseSchema().loads(resp)

    def delete_uredis_group(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteURedisGroup - 删除主备redis

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **GroupId** (str) - (Required) 组ID

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DeleteURedisGroupRequestSchema().dumps(d)

        resp = self.invoke("DeleteURedisGroup", d, **kwargs)
        return apis.DeleteURedisGroupResponseSchema().loads(resp)

    def describe_ud_redis_proxy_info(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUDRedisProxyInfo - 拉取udredis所有的代理信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **SpaceId** (str) - (Required) udredis实例id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **DataSet** (list) - 见 **UDRedisProxyInfo** 模型定义

        **Response Model**

        **UDRedisProxyInfo**
        - **ProxyId** (str) - 代理id
        - **ResourceId** (str) - 代理资源id
        - **State** (str) - 代理状态
        - **Vip** (str) - 代理ip


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUDRedisProxyInfoRequestSchema().dumps(d)

        resp = self.invoke("DescribeUDRedisProxyInfo", d, **kwargs)
        return apis.DescribeUDRedisProxyInfoResponseSchema().loads(resp)

    def describe_ud_redis_slowlog(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUDRedisSlowlog - 查询UDRedis慢日志

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **InstanceId** (str) - (Required) 实例id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Limit** (int) - 分页显示的条目数，默认为10
        - **ProxyId** (str) - 代理Id

        **Response**

        - **DataSet** (list) - 见 **UDRedisSlowlogSet** 模型定义
        - **TotalCount** (int) - 总条目数

        **Response Model**

        **UDRedisSlowlogSet**
        - **BlockId** (str) - 分片id
        - **Command** (str) - 查询命令
        - **SpendTime** (int) - 查询消耗的时间
        - **StartTime** (int) - 查询发生的时间


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUDRedisSlowlogRequestSchema().dumps(d)

        resp = self.invoke("DescribeUDRedisSlowlog", d, **kwargs)
        return apis.DescribeUDRedisSlowlogResponseSchema().loads(resp)

    def describe_umem(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUMem - 获取UMem列表

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Protocol** (str) - (Required) 协议类型: memcache, redis
        - **Limit** (int) - 分页显示的条目数, 默认值为20
        - **Offset** (int) - 分页显示的起始偏移, 默认值为0
        - **ResourceId** (str) - 资源ID
        - **ResourceType** (str) -
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **DataSet** (list) - 见 **UMemDataSet** 模型定义
        - **TotalCount** (int) - 根据过滤条件得到的总数

        **Response Model**

        **UMemDataSet**
        - **Address** (list) - 见 **UMemSpaceAddressSet** 模型定义
        - **AutoBackup** (str) - 是否需要自动备份,enable,disable
        - **BackupTime** (int) - 自动备份开始时间,单位小时计,范围[0-23]
        - **ChargeType** (str) - 计费模式，Year, Month, Dynamic, Trial
        - **ConfigId** (str) - 节点的配置ID
        - **CreateTime** (int) - 创建时间
        - **DataSet** (list) - 见 **UMemSlaveDataSet** 模型定义
        - **ExpireTime** (int) - 到期时间
        - **HighAvailability** (str) - 是否开启高可用,enable,disable
        - **Name** (str) - 资源名称
        - **OwnSlave** (str) - 是否拥有只读Slave“Yes” 包含“No” 不包含
        - **Protocol** (str) - 协议类型: memcache, redis
        - **ResourceId** (str) - 资源ID
        - **ResourceType** (str) - distributed: 分布式版Redis,或者分布式Memcache；single：主备版Redis,或者单机Memcache；performance：高性能版
        - **RewriteTime** (int) - 主备redis和分布式redis运维时间0  //0点1  //1点以此类推单机版memcache不返回该项
        - **Role** (str) - 表示实例是主库还是从库,master,slave仅主备redis返回该项参数
        - **Size** (int) - 容量单位GB
        - **SlaveZone** (str) - 跨机房URedis，slave redis所在可用区，参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **State** (str) - 实例状态                                  Starting                  // 创建中       Creating                  // 初始化中     CreateFail                // 创建失败     Fail                      // 创建失败     Deleting                  // 删除中       DeleteFail                // 删除失败     Running                   // 运行         Resizing                  // 容量调整中   ResizeFail                // 容量调整失败 Configing                 // 配置中       ConfigFail                // 配置失败Restarting                // 重启中SetPasswordFail    //设置密码失败
        - **SubnetId** (str) - 子网
        - **Tag** (str) - 业务组名称
        - **Type** (str) - 空间类型:single(无热备),double(热备)
        - **UsedSize** (int) - 使用量单位MB
        - **VPCId** (str) - vpc
        - **Version** (str) - Redis版本信息
        - **Zone** (str) - 实例所在可用区，或者master redis所在可用区，参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_


        **UMemSpaceAddressSet**
        - **IP** (str) - UMem实例访问IP
        - **Port** (int) - UMem实例访问Port


        **UMemSlaveDataSet**
        - **ChargeType** (str) - 计费模式，Year, Month, Dynamic, Trial
        - **ConfigId** (str) - 节点的配置ID
        - **CreateTime** (int) - 创建时间
        - **ExpireTime** (int) - 到期时间
        - **GroupId** (str) - 资源id
        - **GroupName** (str) - 资源名称
        - **MasterGroupId** (str) - 主实例id
        - **MemorySize** (int) - 实力大小
        - **ModifyTime** (int) - 修改时间
        - **Name** (str) - 资源名称
        - **Port** (int) - 端口
        - **ResourceType** (str) - distributed: 分布式版Redis,或者分布式Memcache；single：主备版Redis,或者单机Memcache；performance：高性能版
        - **RewriteTime** (int) - 主备Redis返回运维时间 0//0点 1 //1点 以此类推
        - **Role** (str) - 表示实例是主库还是从库,master,slave
        - **Size** (int) - 容量单位GB
        - **State** (str) - 实例状态                                  Starting                  // 创建中       Creating                  // 初始化中     CreateFail                // 创建失败     Fail                      // 创建失败     Deleting                  // 删除中       DeleteFail                // 删除失败     Running                   // 运行         Resizing                  // 容量调整中   ResizeFail                // 容量调整失败 Configing                 // 配置中       ConfigFail                // 配置失败Restarting                // 重启中SetPasswordFail  //设置密码失败
        - **SubnetId** (str) - 子网
        - **Tag** (str) - 业务组名称
        - **UsedSize** (int) - 使用量单位MB
        - **VPCId** (str) - vpc
        - **Version** (str) - Redis版本信息
        - **VirtualIP** (str) -
        - **Zone** (str) - 实例所在可用区，或者master redis所在可用区，参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUMemRequestSchema().dumps(d)

        resp = self.invoke("DescribeUMem", d, **kwargs)
        return apis.DescribeUMemResponseSchema().loads(resp)

    def describe_umem_backup(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUMemBackup - 查询分布式redis备份

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **SpaceId** (str) - (Required) 资源id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **Limit** (int) - 分页显示的条目数, 默认值为10
        - **Offset** (int) - 分页显示的起始偏移, 默认值为0

        **Response**

        - **DataSet** (list) - 见 **UMemBackupSet** 模型定义

        **Response Model**

        **UMemBackupSet**
        - **BackupId** (str) - 空间的备份ID
        - **BackupName** (str) - 备份名称
        - **BackupType** (str) - 备份类型: auto(自动) ,manual(手动)
        - **BlockCount** (int) - 本次备份，分片的数量
        - **CreateTime** (int) - 创建时间
        - **State** (str) - Starting:备份中 Done:完成


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUMemBackupRequestSchema().dumps(d)

        resp = self.invoke("DescribeUMemBackup", d, **kwargs)
        return apis.DescribeUMemBackupResponseSchema().loads(resp)

    def describe_umem_backup_url(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUMemBackupURL - 获取分布式redis 备份下载链接

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **BackupId** (str) - (Required) 备份Id
        - **SpaceId** (str) - (Required) 资源id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **BlockId** (str) - 分片id

        **Response**

        - **BackupURL** (list) - 备份url，每个分片一个下载URL

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUMemBackupURLRequestSchema().dumps(d)

        resp = self.invoke("DescribeUMemBackupURL", d, **kwargs)
        return apis.DescribeUMemBackupURLResponseSchema().loads(resp)

    def describe_umem_block_info(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUMemBlockInfo - 拉取UDRedis分片信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Limit** (int) - (Required) 分页显示的条目数, 默认值为10
        - **Offset** (int) - (Required) 分页显示的起始偏移, 默认值为0
        - **SpaceId** (str) - (Required) UMem内存资源ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **DataSet** (list) - 见 **UMemBlockInfo** 模型定义
        - **ReadMode** (str) - 集群读写分离策略。 枚举值[ "Custom": 用户自定义节点权重， "Uniform": 包括主节点在内的所有节点平均读请求， "ReadOnly": 读请求均分至只读节点]

        **Response Model**

        **UMemBlockInfo**
        - **BlockId** (str) - 分片id
        - **BlockName** (str) - 分片名称
        - **BlockPort** (int) - 分片端口
        - **BlockReadWeight** (int) - 分片读权重
        - **BlockSize** (int) - 容量单位GB
        - **BlockSlotBegin** (int) - 分片维护的键槽起始值
        - **BlockSlotEnd** (int) - 分片维护的键槽结束值
        - **BlockState** (str) - 实例状态 Starting // 创建中 Creating // 初始化中 CreateFail // 创建失败 Fail // 创建失败 Deleting // 删除中 DeleteFail // 删除失败 Running // 运行 Resizing // 容量调整中 ResizeFail // 容量调整失败 Configing // 配置中 ConfigFail // 配置失败Restarting // 重启中 SetPasswordFail //设置密码失败UpgradeMemInit  //任务初始化
        - **BlockType** (str) - 分片类型，master 或者 slave
        - **BlockUsedSize** (int) - 使用量单位MB
        - **BlockVip** (str) - 分片ip


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUMemBlockInfoRequestSchema().dumps(d)

        resp = self.invoke("DescribeUMemBlockInfo", d, **kwargs)
        return apis.DescribeUMemBlockInfoResponseSchema().loads(resp)

    def describe_umem_price(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUMemPrice - 获取UMem实例价格信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Size** (int) - (Required) 购买umem大小,单位:GB,范围[1~1024]
        - **Type** (str) - (Required) 空间类型:single(无热备),double(热备)(默认: double)
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **BlockCnt** (int) - umem 分片个数
        - **ChargeType** (str) - Year， Month， Dynamic 如果不指定，则一次性获取三种计费
        - **ClusterMode** (str) - 数据库类型，RWMode为读写分离
        - **HighPerformance** (bool) - 实例类型是否为性能增强型。默认为false，或者不填，true为性能增强型。
        - **ProxySize** (int) - umem 代理CPU核心数
        - **Quantity** (int) - 购买UMem的时长，默认值为1
        - **UlbMode** (str) - umem分布式代理类型，默认false，true为负载均衡型代理

        **Response**

        - **DataSet** (list) - 见 **UMemPriceSet** 模型定义

        **Response Model**

        **UMemPriceSet**
        - **ChargeType** (str) - Year， Month， Dynamic，Trial
        - **OriginalPrice** (int) - 原价
        - **Price** (int) - 现价


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUMemPriceRequestSchema().dumps(d)

        resp = self.invoke("DescribeUMemPrice", d, **kwargs)
        return apis.DescribeUMemPriceResponseSchema().loads(resp)

    def describe_umem_space(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUMemSpace - 获取UMem内存空间列表

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **Limit** (int) - 返回数据长度, 默认为20
        - **Offset** (int) - 数据偏移量, 默认为0
        - **Protocol** (str) - 协议类型: memcache, redis
        - **SpaceId** (str) - 内存空间ID (无ID，则获取所有)
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**

        - **DataSet** (list) - 见 **UMemSpaceSet** 模型定义
        - **TotalCount** (int) - 根据过滤条件得到的总数

        **Response Model**

        **UMemSpaceSet**
        - **Address** (list) - 见 **UMemSpaceAddressSet** 模型定义
        - **ChargeType** (str) - Year, Month, Dynamic, Trial
        - **CreateTime** (int) - 创建时间
        - **ExpireTime** (int) - 到期时间
        - **Name** (str) - 内存空间名称
        - **Protocol** (str) - 协议类型: memcache, redis
        - **RewriteTime** (int) - 运维时间0   //0点1   //1点依次类推
        - **Size** (int) - 容量单位GB
        - **SpaceId** (str) - 内存空间ID
        - **State** (str) - Starting:创建中 Running:运行中 Fail:失败
        - **SubnetId** (str) -
        - **Tag** (str) -
        - **Type** (str) - 空间类型:single(无热备),double(热备)
        - **UsedSize** (int) - 使用量单位MB
        - **VPCId** (str) -
        - **Zone** (str) - 可用区，参见 `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_


        **UMemSpaceAddressSet**
        - **IP** (str) - UMem实例访问IP
        - **Port** (int) - UMem实例访问Port


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUMemSpaceRequestSchema().dumps(d)

        resp = self.invoke("DescribeUMemSpace", d, **kwargs)
        return apis.DescribeUMemSpaceResponseSchema().loads(resp)

    def describe_umem_upgrade_price(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUMemUpgradePrice - 获取UMem升级价格信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Size** (int) - (Required) 购买UMem大小,单位:GB
        - **SpaceId** (str) - (Required) 需要升级的空间的SpaceId
        - **Type** (str) - (Required) 空间类型:single(无热备),double(热备)(默认: double)
        - **BlockIds** (list) - 进行容量调整分片的分片ID(性能增强型不需要传入)
        - **BlockSize** (list) - 进行容量调整的分片的目标容量,单位 GB(性能增强型不需要传入)
        - **HighPerformance** (str) - 是否为性能增强型。默认为false，或者不填，true为性能增强型。
        - **IsSplit** (str) - 如果是拆分按钮查询价格就填 true, 否则就填 false,默认为 false
        - **NewCPU** (int) - 代理升级后CPU核数
        - **ProxyId** (str) - 代理id
        - **ReplicaSize** (int) - 新增读写分离节点容量大小
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **OriginalPrice** (int) - 原价
        - **Price** (int) - 价格

        **Response Model**

        **PriceDataSet**
        - **CustomPrice** (int) -
        - **PurchaseValue** (int) -
        - **TotalPrice** (int) -


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUMemUpgradePriceRequestSchema().dumps(d)

        resp = self.invoke("DescribeUMemUpgradePrice", d, **kwargs)
        return apis.DescribeUMemUpgradePriceResponseSchema().loads(resp)

    def describe_umem_cache_group(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUMemcacheGroup - 显示Memcache

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **GroupId** (str) - 组的ID,如果指定则获取描述，否则为列表操 作,需指定Offset/Limit
        - **Limit** (int) - 分页显示的条目数, 默认值为20
        - **Offset** (int) - 分页显示的起始偏移, 默认值为0
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**

        - **DataSet** (list) - 见 **UMemcacheGroupSet** 模型定义
        - **TotalCount** (int) - 组的总的节点个数

        **Response Model**

        **UMemcacheGroupSet**
        - **ChargeType** (str) - 计费类型:Year,Month,Dynamic 默认Dynamic
        - **ConfigId** (str) - 节点的配置ID
        - **CreateTime** (int) - 创建时间 (UNIX时间戳)
        - **ExpireTime** (int) - 过期时间 (UNIX时间戳)
        - **GroupId** (str) - 组ID
        - **ModifyTime** (int) - 修改时间 (UNIX时间戳)
        - **Name** (str) - 组名称
        - **Port** (int) - 节点分配的服务端口
        - **Size** (int) - 容量单位GB
        - **State** (str) - 状态标记 Creating // 初始化中 CreateFail // 创建失败 Deleting // 删除中 DeleteFail // 删除失败 Running // 运行 Resizing // 容量调整中 ResizeFail // 容量调整失败 Configing // 配置中 ConfigFail // 配置失败Restarting // 重启中
        - **SubnetId** (str) -
        - **Tag** (str) - 业务组名称
        - **UsedSize** (int) - 使用量单位MB
        - **VPCId** (str) -
        - **Version** (str) - Memcache版本信息,默认为1.4.31
        - **VirtualIP** (str) - 节点的虚拟IP地址


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUMemcacheGroupRequestSchema().dumps(d)

        resp = self.invoke("DescribeUMemcacheGroup", d, **kwargs)
        return apis.DescribeUMemcacheGroupResponseSchema().loads(resp)

    def describe_umem_cache_price(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUMemcachePrice - 获取umemcache组价格信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **Size** (int) - (Required) 容量大小,单位:GB 取值范围[1-32]
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **ChargeType** (str) - 计费模式，Year， Month， Dynamic，默认: Dynamic 默认: 获取所有计费模式的价格
        - **Quantity** (int) - 购买umemcache的时长，默认值为1
        - **Type** (str) - 空间类型:single(无热备),double(热备)(默认: double)

        **Response**

        - **DataSet** (list) - 见 **UMemcachePriceSet** 模型定义

        **Response Model**

        **UMemcachePriceSet**
        - **ChargeType** (str) - 计费模式，Year, Month, Dynamic
        - **ListPrice** (int) - 产品列表价
        - **OriginalPrice** (int) - 原价
        - **Price** (int) - 总价格


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUMemcachePriceRequestSchema().dumps(d)

        resp = self.invoke("DescribeUMemcachePrice", d, **kwargs)
        return apis.DescribeUMemcachePriceResponseSchema().loads(resp)

    def describe_umem_cache_upgrade_price(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUMemcacheUpgradePrice - 获取umemcache升级价格信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **GroupId** (str) - (Required) 需要升级的空间的GroupId,请参考DescribeUMemcacheGroup接口
        - **Size** (int) - (Required) 购买umemcache大小,单位:GB
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **ListPrice** (int) - 列表价格
        - **OriginalPrice** (int) - 原价
        - **Price** (int) - 价格

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUMemcacheUpgradePriceRequestSchema().dumps(d)

        resp = self.invoke("DescribeUMemcacheUpgradePrice", d, **kwargs)
        return apis.DescribeUMemcacheUpgradePriceResponseSchema().loads(resp)

    def describe_uredis_backup(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeURedisBackup - 查询主备redis备份

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **GroupId** (str) - 组的ID
        - **Limit** (int) - 分页显示的条目数, 默认值为10
        - **Offset** (int) - 分页显示的起始偏移, 默认值为0

        **Response**

        - **DataSet** (list) - 见 **URedisBackupSet** 模型定义
        - **TotalCount** (int) - 用户名下总的备份个数

        **Response Model**

        **URedisBackupSet**
        - **BackupId** (str) - 备份ID
        - **BackupName** (str) - 备份的名称
        - **BackupSize** (int) - 备份文件大小, 以字节为单位
        - **BackupTime** (int) - 备份时间 (UNIX时间戳)
        - **BackupType** (str) - 备份类型: Manual 手动 Auto 自动
        - **GroupId** (str) - 对应的实例ID
        - **GroupName** (str) - 组名称
        - **State** (str) - 备份的状态: Backuping 备份中 Success 备份成功 Error 备份失败 Expired 备份过期
        - **Zone** (str) - 可用区，参见 `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeURedisBackupRequestSchema().dumps(d)

        resp = self.invoke("DescribeURedisBackup", d, **kwargs)
        return apis.DescribeURedisBackupResponseSchema().loads(resp)

    def describe_uredis_backup_url(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeURedisBackupURL - 获取主备Redis备份下载链接

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **BackupId** (str) - (Required) 备份ID
        - **GroupId** (str) - 实例ID
        - **RegionFlag** (bool) - 是否是跨机房URedis(默认false)
        - **SlaveZone** (str) - 跨机房URedis，slave所在可用区（必须和Zone在同一Region，且不可相同）
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **BackupPath** (str) - 备份文件公网的地址
        - **BackupURL** (str) - [即将下线,请使用BackupPath]

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeURedisBackupURLRequestSchema().dumps(d)

        resp = self.invoke("DescribeURedisBackupURL", d, **kwargs)
        return apis.DescribeURedisBackupURLResponseSchema().loads(resp)

    def describe_uredis_config(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeURedisConfig - 查询主备Redis所有配置文件

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **RegionFlag** (bool) - (Required) 是否是跨机房URedis(默认false)
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **ConfigId** (str) - 配置文件ID
        - **Limit** (int) - 页显示的条目数, 默认值为10
        - **Offset** (int) - 页显示的起始偏移, 默认值为0
        - **Version** (str) - Redis版本号

        **Response**

        - **DataSet** (list) - 见 **URedisConfigSet** 模型定义
        - **TotalCount** (int) - 根据过滤条件得到的总数

        **Response Model**

        **URedisConfigSet**
        - **ConfigId** (str) - 配置ID
        - **CreateTime** (int) - 创建时间 (UNIX时间戳)
        - **Description** (str) - 配置描述
        - **IsModify** (str) - 置是否可以修改
        - **ModifyTime** (int) - 修改时间 (UNIX时间戳)
        - **Name** (str) - 配置名称
        - **RegionFlag** (bool) - 是否是跨机房URedis(默认false)
        - **State** (str) - 配置所处的状态
        - **Version** (str) - 配置对应的Redis版本
        - **Zone** (str) - Zone


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeURedisConfigRequestSchema().dumps(d)

        resp = self.invoke("DescribeURedisConfig", d, **kwargs)
        return apis.DescribeURedisConfigResponseSchema().loads(resp)

    def describe_uredis_group(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeURedisGroup - 查询主备Redis

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **GroupId** (str) - 组的ID,如果指定则获取描述，否则为列表操 作,需指定Offset/Limit
        - **Limit** (int) - 分页显示的条目数, 默认值为20
        - **Offset** (int) - 分页显示的起始偏移, 默认值为0
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **DataSet** (list) - 见 **URedisGroupSet** 模型定义
        - **TotalCount** (int) - 组的总的节点个数

        **Response Model**

        **URedisGroupSet**
        - **AutoBackup** (str) - 是否需要自动备份,enable,disable
        - **BackupTime** (int) - 组自动备份开始时间,单位小时计,范围[0-23]
        - **ChargeType** (str) - 计费类型:Year,Month,Dynamic 默认Dynamic
        - **ConfigId** (str) - 节点的配置ID
        - **CreateTime** (int) - 创建时间 (UNIX时间戳)
        - **ExpireTime** (int) - 过期时间 (UNIX时间戳)
        - **GroupId** (str) - 组ID
        - **GroupName** (str) - [即将下线,请使用Name] 组名称
        - **HighAvailability** (str) - 是否开启高可用,enable,disable
        - **IsHighPerformance** (bool) - 是否是高性能Redis， true表示是； false表示否
        - **MemorySize** (int) - [即将下线,请使用Size] 容量单位GB
        - **ModifyTime** (int) - 修改时间 (UNIX时间戳)
        - **Name** (str) - 组名称
        - **Port** (int) - 节点分配的服务端口
        - **Protocol** (str) - 协议
        - **RewriteTime** (int) - 返回运维时间 0 //0点 1 //1点 以此类推
        - **Role** (str) - 实例类型
        - **Size** (int) - 容量单位GB
        - **SlaveZone** (str) - 跨机房URedis，slave redis所在可用区，参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **State** (str) - 状态标记 Creating // 初始化中 CreateFail // 创建失败 Deleting // 删除中 DeleteFail // 删除失败 Running // 运行 Resizing // 容量调整中 ResizeFail // 容量调整失败 Configing // 配置中 ConfigFail // 配置失败
        - **SubnetId** (str) - subnetid
        - **Tag** (str) - 业务组名称
        - **Type** (str) - 空间类型:single(无热备),double(热备)
        - **UsedSize** (int) - 使用量单位MB
        - **VPCId** (str) - vpcid
        - **Version** (str) - Redis版本信息
        - **VirtualIP** (str) - 节点的虚拟IP地址
        - **Zone** (str) - 实例所在可用区，或者master redis所在可用区，参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeURedisGroupRequestSchema().dumps(d)

        resp = self.invoke("DescribeURedisGroup", d, **kwargs)
        return apis.DescribeURedisGroupResponseSchema().loads(resp)

    def describe_uredis_price(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeURedisPrice - 获取URedis价格信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Size** (int) - (Required) 量大小,单位:GB  取值范围[1-32]
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **ChargeType** (str) - 计费模式，Year， Month， Dynamic；如果不指定，则一次性获取三种计费
        - **HighPerformance** (bool) - 查询高性能Redis， 默认为false， 或者不填， 查询高性能为true
        - **ProductType** (str) - 产品类型：MS_Redis（标准主备版），S_Redis（从库），默认为MS_Redis
        - **Quantity** (int) - 计费模式为Dynamic时，购买的时长, 默认为1
        - **RegionFlag** (bool) - 是否是跨机房URedis(默认false)

        **Response**

        - **DataSet** (list) - 见 **URedisPriceSet** 模型定义

        **Response Model**

        **URedisPriceSet**
        - **ChargeType** (str) - Year， Month， Dynamic，Trial
        - **ListPrice** (int) - 产品列表价
        - **OriginalPrice** (int) - 原价
        - **Price** (int) - 总价格


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeURedisPriceRequestSchema().dumps(d)

        resp = self.invoke("DescribeURedisPrice", d, **kwargs)
        return apis.DescribeURedisPriceResponseSchema().loads(resp)

    def describe_uredis_slowlog(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeURedisSlowlog - 查询URedis慢日志

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **GroupId** (str) - (Required) 资源ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **Limit** (int) - 分页显示的条目数，默认为10

        **Response**

        - **DataSet** (list) - 见 **URedisSlowlogSet** 模型定义
        - **TotalCount** (int) - 总条目数

        **Response Model**

        **URedisSlowlogSet**
        - **Command** (str) - 查询命令
        - **SpendTime** (int) - 查询消耗的时间
        - **StartTime** (int) - 查询发生的时间


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeURedisSlowlogRequestSchema().dumps(d)

        resp = self.invoke("DescribeURedisSlowlog", d, **kwargs)
        return apis.DescribeURedisSlowlogResponseSchema().loads(resp)

    def describe_uredis_upgrade_price(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeURedisUpgradePrice - 获取uredis升级价格信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **GroupId** (str) - (Required) 要升级的空间的GroupId,请参考DescribeURedisGroup接口
        - **Size** (int) - (Required) 购买uredis大小,单位:GB,范围是[1-32]
        - **HighPerformance** (bool) - 查询高性能Redis， 默认为false， 或者不填， 查询高性能为true
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **OriginalPrice** (int) - 原价
        - **Price** (float) - 价格

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeURedisUpgradePriceRequestSchema().dumps(d)

        resp = self.invoke("DescribeURedisUpgradePrice", d, **kwargs)
        return apis.DescribeURedisUpgradePriceResponseSchema().loads(resp)

    def describe_uredis_version(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeURedisVersion - 获取主Redis可用版本

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**

        - **DataSet** (list) - 见 **URedisVersionSet** 模型定义
        - **TotalCount** (int) - 总版本个数

        **Response Model**

        **URedisVersionSet**
        - **Version** (str) - Redis版本


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeURedisVersionRequestSchema().dumps(d)

        resp = self.invoke("DescribeURedisVersion", d, **kwargs)
        return apis.DescribeURedisVersionResponseSchema().loads(resp)

    def flushall_uredis_group(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """FlushallURedisGroup - 清除主备redis数据

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **FlushType** (str) - (Required) FlushDb或FlushAll
        - **GroupId** (str) - (Required) 组的ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **DbNum** (int) - 清空的db，FlushType为FlushDb，此项为必传项
        - **OrganizationId** (int) - OrganizationId
        - **SlaveZone** (str) - 跨机房URedis，slave所在可用区（必须和Zone在同一Region，且不可相同）
        - **TopOrganizationId** (int) - company_id

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.FlushallURedisGroupRequestSchema().dumps(d)

        resp = self.invoke("FlushallURedisGroup", d, **kwargs)
        return apis.FlushallURedisGroupResponseSchema().loads(resp)

    def get_umem_space_state(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetUMemSpaceState - 获取UMem内存空间列表

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **SpaceId** (str) - (Required) 内存空间ID
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**

        - **State** (str) - Starting:创建中 Running:运行中 Fail:失败

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.GetUMemSpaceStateRequestSchema().dumps(d)

        resp = self.invoke("GetUMemSpaceState", d, **kwargs)
        return apis.GetUMemSpaceStateResponseSchema().loads(resp)

    def i_solation_uredis_group(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ISolationURedisGroup - 打开/关闭URedis

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **GroupId** (str) - (Required) 组的ID
        - **TransformType** (str) - (Required) UNBind(关闭)或Bind(打开)
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **SlaveZone** (str) - 跨机房URedis，slave所在可用区（必须和Zone在同一Region，且不可相同）

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ISolationURedisGroupRequestSchema().dumps(d)

        resp = self.invoke("ISolationURedisGroup", d, **kwargs)
        return apis.ISolationURedisGroupResponseSchema().loads(resp)

    def modify_umem_space_name(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ModifyUMemSpaceName - 修改UMem内存空间名称

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **Name** (str) - (Required) 新的名称,长度(6<=size<=63)
        - **SpaceId** (str) - (Required) UMem内存空间ID
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ModifyUMemSpaceNameRequestSchema().dumps(d)

        resp = self.invoke("ModifyUMemSpaceName", d, **kwargs)
        return apis.ModifyUMemSpaceNameResponseSchema().loads(resp)

    def modify_uredis_config(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ModifyURedisConfig - 修改主备Redis配置文件参数

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **ConfigId** (str) - (Required) 配置文件的ID
        - **Key** (str) - (Required) 参数名称
        - **Value** (str) - (Required) 对应参数的值
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **GroupId** (str) - 如果实例使用默认配置创建，修改配置信息需要填写GroupId
        - **RegionFlag** (bool) - 是否是跨机房URedis(默认false)

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ModifyURedisConfigRequestSchema().dumps(d)

        resp = self.invoke("ModifyURedisConfig", d, **kwargs)
        return apis.ModifyURedisConfigResponseSchema().loads(resp)

    def modify_uredis_group_name(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ModifyURedisGroupName - 修改主备redis名称

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **GroupId** (str) - (Required) 组的ID
        - **Name** (str) - (Required) Redis组名称 (范围[6-63],只能包含英文、数字以及符号-和_)

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ModifyURedisGroupNameRequestSchema().dumps(d)

        resp = self.invoke("ModifyURedisGroupName", d, **kwargs)
        return apis.ModifyURedisGroupNameResponseSchema().loads(resp)

    def modify_uredis_group_password(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ModifyURedisGroupPassword - 修改主备密码/重置密码

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **GroupId** (str) - (Required) 组的ID
        - **Password** (str) - (Required) 新密码字符串，要求长度为6~36个字符,且只能包含英文、数字以及-和下划线；并且需要base64加密；如要取消密码，此值为空字符串，
        - **ResourceType** (str) -
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ModifyURedisGroupPasswordRequestSchema().dumps(d)

        resp = self.invoke("ModifyURedisGroupPassword", d, **kwargs)
        return apis.ModifyURedisGroupPasswordResponseSchema().loads(resp)

    def register_umem_defrag(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """RegisterUMemDefrag - 动态开关redis碎片整理选项

        **Request**

        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **ResourceId** (str) - (Required) 资源ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **EndHour** (int) - 结束整点数值（分布式实例该参数无效）。
        - **EndMin** (int) - 结束分钟数（分布式实例该参数无效）。
        - **EndTime** (int) - 关闭时间戳
        - **FragSize** (int) - 碎片整理阈值，范围为 100-200（分布式实例该参数无效）。
        - **FragTime** (int) - 任务时间周期，单位为分钟。
        - **IsUnion** (bool) - AND逻辑字段，表示 阈值和时间段都满足（分布式实例该参数无效）。
        - **OperateType** (str) - 操作类型：“Once”： 表示单次执行， “Open”：表示开启策略“Close”:  表示关闭策略（分布式实例只支持Once）。
        - **StartHour** (int) - 开始整点数值（分布式实例该参数无效）。
        - **StartMin** (int) - 开始分钟数（分布式实例该参数无效）。
        - **StartTime** (int) - 开始时间戳

        **Response**


        """
        # build request
        d = {
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.RegisterUMemDefragRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("RegisterUMemDefrag", d, **kwargs)
        return apis.RegisterUMemDefragResponseSchema().loads(resp)

    def remove_ud_redis_data(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """RemoveUDRedisData - 清除udredis实例数据

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **SpaceId** (str) - (Required) 实例id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.RemoveUDRedisDataRequestSchema().dumps(d)

        resp = self.invoke("RemoveUDRedisData", d, **kwargs)
        return apis.RemoveUDRedisDataResponseSchema().loads(resp)

    def resize_ud_redis_block_size(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ResizeUDRedisBlockSize - 更改udredis分片容量

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **BlockId** (str) - (Required) 分片id
        - **BlockSize** (int) - (Required) 分片容量（单位GB）4/8/12/16/20
        - **SpaceId** (str) - (Required) spaceid
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **HighPerformance** (bool) - 是否为性能增强型。默认为false，或者不填，true为性能增强型。
        - **StartTime** (int) - 任务执行时间戳，时间戳需满足未来一天时间范围内。默认不传或者值为0时，即为立即执行

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ResizeUDRedisBlockSizeRequestSchema().dumps(d)

        resp = self.invoke("ResizeUDRedisBlockSize", d, **kwargs)
        return apis.ResizeUDRedisBlockSizeResponseSchema().loads(resp)

    def resize_umem_space(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ResizeUMemSpace - 调整内存空间容量，只支持存量老分布式产品，不支持高性能分布式

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Size** (int) - (Required) 内存大小, 单位:GB (需要大于原size,<= 1024)
        - **SpaceId** (str) - (Required) UMem 内存空间Id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **CouponId** (str) - 使用的代金券Id
        - **Type** (str) - 空间类型:single(无热备),double(热备)(默认: double)

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ResizeUMemSpaceRequestSchema().dumps(d)

        resp = self.invoke("ResizeUMemSpace", d, **kwargs)
        return apis.ResizeUMemSpaceResponseSchema().loads(resp)

    def resize_uredis_group(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ResizeURedisGroup - 通过调用CheckURedisAllowance接口，检查资源情况，根据不同情形来调整主备redis容量，其中主要包括可用区资源不足无法扩容，主备所在宿主机资源不足需要迁移完成扩容（需要主从切换，会闪断及负载升高），以及直接扩容（业务无感知）

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **GroupId** (str) - (Required) 组ID
        - **Size** (int) - (Required) 内存大小, 单位:GB (需要大于原size,且小于等于32) 目前仅支持1/2/4/8/16/32 G 六种容量规格
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **ChargeType** (str) - 计费类型
        - **CouponId** (int) - 代金券ID 请参考DescribeCoupon接口
        - **HighPerformance** (bool) - 高性能Redis， 默认为false， 或者不填， 高性能为true
        - **StartTime** (int) - 任务执行时间戳，默认为0或者不传时，为立即执行，传入时间需满足未来一天范围
        - **Type** (str) - 空间类型:single(无热备),double(热备)(默认: double)

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ResizeURedisGroupRequestSchema().dumps(d)

        resp = self.invoke("ResizeURedisGroup", d, **kwargs)
        return apis.ResizeURedisGroupResponseSchema().loads(resp)

    def restart_umem_cache_group(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """RestartUMemcacheGroup - 重启单机Memcache

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **GroupId** (str) - (Required) 组的ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.RestartUMemcacheGroupRequestSchema().dumps(d)

        resp = self.invoke("RestartUMemcacheGroup", d, **kwargs)
        return apis.RestartUMemcacheGroupResponseSchema().loads(resp)

    def restart_uredis_group(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """RestartURedisGroup - 重启主备实例

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **GroupId** (str) - (Required) 资源ID
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.RestartURedisGroupRequestSchema().dumps(d)

        resp = self.invoke("RestartURedisGroup", d, **kwargs)
        return apis.RestartURedisGroupResponseSchema().loads(resp)

    def shutdown_uredis_group(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ShutdownURedisGroup - 关闭主备实例

        **Request**

        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **GroupId** (str) - (Required) 资源ID

        **Response**


        """
        # build request
        d = {
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ShutdownURedisGroupRequestSchema().dumps(d)

        resp = self.invoke("ShutdownURedisGroup", d, **kwargs)
        return apis.ShutdownURedisGroupResponseSchema().loads(resp)

    def start_uredis_group(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """StartURedisGroup - 实例关闭状态下，启动实例

        **Request**

        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **GroupId** (str) - (Required) 资源ID

        **Response**


        """
        # build request
        d = {
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.StartURedisGroupRequestSchema().dumps(d)

        resp = self.invoke("StartURedisGroup", d, **kwargs)
        return apis.StartURedisGroupResponseSchema().loads(resp)

    def update_uredis_backup_strategy(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """UpdateURedisBackupStrategy - URedisBackupStrategy

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **BackupTime** (str) - (Required) 备份时间，默认为0
        - **GroupId** (str) - (Required) 组的ID
        - **AutoBackup** (str) - 是否打开默认备份功能。enable(打开)，disable(关闭)，默认enable
        - **SlaveZone** (str) - 跨机房URedis，slave所在可用区（必须和Zone在同一Region，且不可相同）
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.UpdateURedisBackupStrategyRequestSchema().dumps(d)

        resp = self.invoke("UpdateURedisBackupStrategy", d, **kwargs)
        return apis.UpdateURedisBackupStrategyResponseSchema().loads(resp)

    def update_uredis_rewrite_time(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """UpdateURedisRewriteTime - 修改主备redis重写时间

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **GroupId** (str) - (Required) 实例名称
        - **RewriteTime** (int) - (Required) 重写时间
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **SlaveZone** (str) - 跨机房URedis，slave所在可用区（必须和Zone在同一Region，且不可相同）

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.UpdateURedisRewriteTimeRequestSchema().dumps(d)

        resp = self.invoke("UpdateURedisRewriteTime", d, **kwargs)
        return apis.UpdateURedisRewriteTimeResponseSchema().loads(resp)
