// pmx  Copyright Notice
// ============================
//
// The pmx source code is copyrighted, but you can freely use and
// copy it as long as you don't change or remove any of the copyright
// notices.
//
// ----------------------------------------------------------------------
// pmx is Copyright (C) 2006-2011 by Daniel Seeliger
//
//                        All Rights Reserved
//
// Permission to use, copy, modify, distribute, and distribute modified
// versions of this software and its documentation for any purpose and
// without fee is hereby granted, provided that the above copyright
// notice appear in all copies and that both the copyright notice and
// this permission notice appear in supporting documentation, and that
// the name of Daniel Seeliger not be used in advertising or publicity
// pertaining to distribution of the software without specific, written
// prior permission.
//
// DANIEL SEELIGER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
// SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS.  IN NO EVENT SHALL DANIEL SEELIGER BE LIABLE FOR ANY
// SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
// RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
// CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
// CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
// ----------------------------------------------------------------------
#include <pmx.h>

static PyMethodDef pmx_methods[]={
  {(char *) "dist",wrap_dist, METH_VARARGS, NULL},
  {(char *) "dist2",wrap_distance2, METH_VARARGS, NULL},
  {(char *) "angle",wrap_angle_ijk, METH_VARARGS, NULL},
  {(char *) "dihedral",wrap_dihedral, METH_VARARGS, NULL},
  {(char *) "planarity",wrap_planarity, METH_VARARGS, NULL},
  {(char *) "fit",wrap_fit, METH_VARARGS, NULL},
  {(char *) "calc_fit_R",wrap_calc_fit_R, METH_VARARGS, NULL},
  {(char *) "center_vec",wrap_center_vec, METH_VARARGS, NULL},
  {(char *) "box_from_cryst1",wrap_cryst1_to_box, METH_VARARGS, NULL},
  {(char *) "box_as_cryst1",wrap_box_to_cryst1, METH_VARARGS, NULL},
  {(char *) "search_neighbors",wrap_search_neighbors, METH_VARARGS, NULL},
  {(char *) "calc_lj_energy",wrap_calc_lj_energy, METH_VARARGS, NULL},
  {(char *) "calc_coulomb_energy",wrap_calc_coulomb_energy, METH_VARARGS, NULL},
  {(char *) "calc_bond_energy",wrap_calc_bond_energy, METH_VARARGS, NULL},
  {(char *) "calc_angle_energy",wrap_calc_angle_energy, METH_VARARGS, NULL},
  {(char *) "calc_dihedral_energy",wrap_calc_dihedral_energy, METH_VARARGS, NULL},
  {(char *) "calc_improper_energy",wrap_calc_improper_energy, METH_VARARGS, NULL},
  {(char *) "total_bond_energy",wrap_total_bond_energy, METH_VARARGS, NULL},
  {(char *) "total_angle_energy",wrap_total_angle_energy, METH_VARARGS, NULL},
  {(char *) "total_dihedral_energy",wrap_total_dihedral_energy, METH_VARARGS, NULL},
  {(char *) "total_improper_energy",wrap_total_improper_energy, METH_VARARGS, NULL},
  {(char *) "nb_lj_energy",wrap_nb_lj_energy, METH_VARARGS, NULL},
  {(char *) "nb_coul_energy",wrap_nb_coul_energy, METH_VARARGS, NULL},
  {(char *) "lj14_energy",wrap_lj14_energy, METH_VARARGS, NULL},
  {(char *) "coul14_energy",wrap_coul14_energy, METH_VARARGS, NULL},
  {(char *) "nb_energy",wrap_nb_energy, METH_VARARGS, NULL},
  {(char *) "apply_rotation",apply_rotation, METH_VARARGS, NULL},

  {NULL,NULL,0,NULL}
};

// module initialization compatible with python 3
#if PY_MAJOR_VERSION >= 3
  static struct PyModuleDef pmxmodule = {
  PyModuleDef_HEAD_INIT,
  "_pmx", /* name of module */
  NULL, /* module documentation, may be NULL */
  -1, /* size of per-interpreter state of the module,
  or -1 if the module keeps state in global variables. */
  pmx_methods
  };

  PyMODINIT_FUNC
  PyInit__pmx(void)
  {
    return PyModule_Create(&pmxmodule);
  }
#else
  void init_pmx(void)
  {
    (void) Py_InitModule3("_pmx",pmx_methods,NULL);
  }
#endif
