/*
 * Copyright (c) 2021, 2023 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#pragma once

#ifdef __ARM_FEATURE_SVE


namespace {

void sve_transpose_interleave_12VL_2x4_fp32bf16(bfloat16 *out, const float *in, size_t width, size_t in_stride, size_t height)
{
    float *pad_row = reinterpret_cast<float *>(alloca(width * sizeof(float)));

    if (height % 4) {
        memset(pad_row, 0, width * sizeof(float));
    }

    size_t out_stride = 12 * roundup<size_t>(height, 4) * get_vector_length<uint32_t>();

    __asm__ __volatile__(
      "ptrue p6.b\n"
      "1:"  // Main row loop: Head
      "mov x28, %x[in]\n"
      "add x27, x28, %x[in_stride]\n"
      "add x26, x27, %x[in_stride]\n"
      "mov x25, %x[width]\n"
      "cnth x24, ALL, MUL #6\n"
      "add x23, x26, %x[in_stride]\n"
      "cmp %x[height], #0x3\n"
      "add %x[in], x23, %x[in_stride]\n"
      "csel x23, x23, %x[pad_row], GT\n"
      "csel x26, x26, %x[pad_row], GE\n"
      "cmp %x[height], #0x1\n"
      "csel x27, x27, %x[pad_row], GT\n"
      "cmp x25, x24\n"
      "mov x22, %x[out]\n"
      "sub %x[height], %x[height], #0x4\n"
      "blt 3f\n"
      "2:"  // Main row loop: Unroll column loop
      "ld1w { z22.s }, p6/Z, [x28]\n"
      "ld1w { z7.s }, p6/Z, [x28, #1, MUL VL]\n"
      "mov x21, x22\n"
      "add x22, x22, %x[out_stride]\n"
      "ld1w { z19.s }, p6/Z, [x28, #2, MUL VL]\n"
      "ld1w { z18.s }, p6/Z, [x28, #3, MUL VL]\n"
      "mov x20, x22\n"
      "sub x25, x25, x24\n"
      "ld1w { z5.s }, p6/Z, [x28, #4, MUL VL]\n"
      "ld1w { z25.s }, p6/Z, [x28, #5, MUL VL]\n"
      "cmp x25, x24\n"
      "add x22, x22, %x[out_stride]\n"
      "ld1w { z20.s }, p6/Z, [x28, #6, MUL VL]\n"
      "ld1w { z23.s }, p6/Z, [x28, #7, MUL VL]\n"
      "addvl x28, x28, #12\n"
      "ld1w { z4.s }, p6/Z, [x26]\n"
      "ld1w { z10.s }, p6/Z, [x26, #1, MUL VL]\n"
      "zip1 z14.s, z22.s, z4.s\n"
      "zip2 z22.s, z22.s, z4.s\n"
      "ld1w { z28.s }, p6/Z, [x26, #2, MUL VL]\n"
      "ld1w { z27.s }, p6/Z, [x26, #3, MUL VL]\n"
      "zip1 z24.s, z7.s, z10.s\n"
      "zip2 z15.s, z7.s, z10.s\n"
      "ld1w { z7.s }, p6/Z, [x26, #4, MUL VL]\n"
      "ld1w { z2.s }, p6/Z, [x26, #5, MUL VL]\n"
      "zip1 z9.s, z19.s, z28.s\n"
      "zip2 z0.s, z19.s, z28.s\n"
      "ld1w { z19.s }, p6/Z, [x26, #6, MUL VL]\n"
      "ld1w { z16.s }, p6/Z, [x26, #7, MUL VL]\n"
      "addvl x26, x26, #12\n"
      "zip1 z1.s, z18.s, z27.s\n"
      "ld1w { z30.s }, p6/Z, [x28, #-4, MUL VL]\n"
      "ld1w { z29.s }, p6/Z, [x28, #-3, MUL VL]\n"
      "zip2 z17.s, z18.s, z27.s\n"
      ".inst 0x658ab9d5  // bfcvt z21.h, p6/M, z14.s\n"
      "ld1w { z31.s }, p6/Z, [x27]\n"
      "ld1w { z8.s }, p6/Z, [x27, #1, MUL VL]\n"
      ".inst 0x658abacc  // bfcvt z12.h, p6/M, z22.s\n"
      ".inst 0x658abb0e  // bfcvt z14.h, p6/M, z24.s\n"
      "ld1w { z22.s }, p6/Z, [x27, #2, MUL VL]\n"
      "ld1w { z28.s }, p6/Z, [x27, #3, MUL VL]\n"
      ".inst 0x658ab9ea  // bfcvt z10.h, p6/M, z15.s\n"
      ".inst 0x658ab92f  // bfcvt z15.h, p6/M, z9.s\n"
      "ld1w { z27.s }, p6/Z, [x27, #4, MUL VL]\n"
      "ld1w { z13.s }, p6/Z, [x27, #5, MUL VL]\n"
      ".inst 0x658ab803  // bfcvt z3.h, p6/M, z0.s\n"
      ".inst 0x658ab832  // bfcvt z18.h, p6/M, z1.s\n"
      "ld1w { z26.s }, p6/Z, [x27, #6, MUL VL]\n"
      "ld1w { z9.s }, p6/Z, [x27, #7, MUL VL]\n"
      "addvl x27, x27, #12\n"
      ".inst 0x658aba26  // bfcvt z6.h, p6/M, z17.s\n"
      "ld1w { z1.s }, p6/Z, [x26, #-4, MUL VL]\n"
      "ld1w { z0.s }, p6/Z, [x26, #-3, MUL VL]\n"
      "zip1 z17.s, z5.s, z7.s\n"
      "zip2 z5.s, z5.s, z7.s\n"
      "ld1w { z24.s }, p6/Z, [x23]\n"
      "ld1w { z11.s }, p6/Z, [x23, #1, MUL VL]\n"
      "zip1 z7.s, z31.s, z24.s\n"
      "zip2 z31.s, z31.s, z24.s\n"
      "ld1w { z4.s }, p6/Z, [x23, #2, MUL VL]\n"
      "ld1w { z24.s }, p6/Z, [x23, #3, MUL VL]\n"
      ".inst 0x648ab8f5  // bfcvtnt z21.h, p6/M, z7.s\n"
      "zip1 z7.s, z8.s, z11.s\n"
      "zip2 z11.s, z8.s, z11.s\n"
      "ld1w { z8.s }, p6/Z, [x23, #4, MUL VL]\n"
      ".inst 0x648abbec  // bfcvtnt z12.h, p6/M, z31.s\n"
      "ld1w { z31.s }, p6/Z, [x23, #5, MUL VL]\n"
      ".inst 0x648ab8ee  // bfcvtnt z14.h, p6/M, z7.s\n"
      "ld1w { z7.s }, p6/Z, [x23, #6, MUL VL]\n"
      ".inst 0x648ab96a  // bfcvtnt z10.h, p6/M, z11.s\n"
      "zip1 z11.s, z22.s, z4.s\n"
      "zip2 z4.s, z22.s, z4.s\n"
      "ld1w { z22.s }, p6/Z, [x23, #7, MUL VL]\n"
      "addvl x23, x23, #12\n"
      ".inst 0x648ab96f  // bfcvtnt z15.h, p6/M, z11.s\n"
      "ld1w { z11.s }, p6/Z, [x28, #-2, MUL VL]\n"
      ".inst 0x648ab883  // bfcvtnt z3.h, p6/M, z4.s\n"
      "zip1 z4.s, z28.s, z24.s\n"
      "zip2 z24.s, z28.s, z24.s\n"
      "ld1w { z28.s }, p6/Z, [x28, #-1, MUL VL]\n"
      ".inst 0x648ab892  // bfcvtnt z18.h, p6/M, z4.s\n"
      "ld1w { z4.s }, p6/Z, [x27, #-4, MUL VL]\n"
      ".inst 0x648abb06  // bfcvtnt z6.h, p6/M, z24.s\n"
      "zip1 z24.s, z25.s, z2.s\n"
      "zip2 z25.s, z25.s, z2.s\n"
      "zip1 z2.s, z20.s, z19.s\n"
      "zip2 z20.s, z20.s, z19.s\n"
      "zip1 z19.s, z23.s, z16.s\n"
      "zip2 z16.s, z23.s, z16.s\n"
      "zip1 z23.s, z30.s, z1.s\n"
      "zip2 z30.s, z30.s, z1.s\n"
      "zip1 z1.s, z29.s, z0.s\n"
      "zip2 z0.s, z29.s, z0.s\n"
      ".inst 0x658aba31  // bfcvt z17.h, p6/M, z17.s\n"
      "zip1 z29.s, z27.s, z8.s\n"
      ".inst 0x658ab8a5  // bfcvt z5.h, p6/M, z5.s\n"
      "zip2 z27.s, z27.s, z8.s\n"
      "ld1w { z8.s }, p6/Z, [x27, #-3, MUL VL]\n"
      ".inst 0x658abb18  // bfcvt z24.h, p6/M, z24.s\n"
      ".inst 0x658abb39  // bfcvt z25.h, p6/M, z25.s\n"
      ".inst 0x658ab842  // bfcvt z2.h, p6/M, z2.s\n"
      ".inst 0x658aba94  // bfcvt z20.h, p6/M, z20.s\n"
      ".inst 0x658aba73  // bfcvt z19.h, p6/M, z19.s\n"
      ".inst 0x658aba10  // bfcvt z16.h, p6/M, z16.s\n"
      ".inst 0x658abaf7  // bfcvt z23.h, p6/M, z23.s\n"
      ".inst 0x658abbde  // bfcvt z30.h, p6/M, z30.s\n"
      ".inst 0x658ab821  // bfcvt z1.h, p6/M, z1.s\n"
      ".inst 0x658ab800  // bfcvt z0.h, p6/M, z0.s\n"
      ".inst 0x648abbb1  // bfcvtnt z17.h, p6/M, z29.s\n"
      "ld1w { z29.s }, p6/Z, [x26, #-2, MUL VL]\n"
      ".inst 0x648abb65  // bfcvtnt z5.h, p6/M, z27.s\n"
      "zip1 z27.s, z13.s, z31.s\n"
      "zip2 z31.s, z13.s, z31.s\n"
      "ld1w { z13.s }, p6/Z, [x26, #-1, MUL VL]\n"
      ".inst 0x648abb78  // bfcvtnt z24.h, p6/M, z27.s\n"
      "ld1w { z27.s }, p6/Z, [x23, #-4, MUL VL]\n"
      ".inst 0x648abbf9  // bfcvtnt z25.h, p6/M, z31.s\n"
      "zip1 z31.s, z26.s, z7.s\n"
      "zip2 z26.s, z26.s, z7.s\n"
      "ld1w { z7.s }, p6/Z, [x23, #-3, MUL VL]\n"
      ".inst 0x648abbe2  // bfcvtnt z2.h, p6/M, z31.s\n"
      "ld1w { z31.s }, p6/Z, [x27, #-2, MUL VL]\n"
      ".inst 0x648abb54  // bfcvtnt z20.h, p6/M, z26.s\n"
      "zip1 z26.s, z9.s, z22.s\n"
      "zip2 z9.s, z9.s, z22.s\n"
      "ld1w { z22.s }, p6/Z, [x27, #-1, MUL VL]\n"
      ".inst 0x648abb53  // bfcvtnt z19.h, p6/M, z26.s\n"
      "ld1w { z26.s }, p6/Z, [x23, #-2, MUL VL]\n"
      ".inst 0x648ab930  // bfcvtnt z16.h, p6/M, z9.s\n"
      "ld1w { z9.s }, p6/Z, [x23, #-1, MUL VL]\n"
      "st1h { z21.h }, p6, [x21]\n"
      "zip1 z21.s, z4.s, z27.s\n"
      "zip2 z27.s, z4.s, z27.s\n"
      "zip1 z4.s, z8.s, z7.s\n"
      "zip2 z8.s, z8.s, z7.s\n"
      "st1h { z12.h }, p6, [x21, #1, MUL VL]\n"
      "zip1 z7.s, z11.s, z29.s\n"
      "zip2 z11.s, z11.s, z29.s\n"
      "st1h { z14.h }, p6, [x21, #2, MUL VL]\n"
      "zip1 z29.s, z28.s, z13.s\n"
      "zip2 z12.s, z28.s, z13.s\n"
      "st1h { z10.h }, p6, [x21, #3, MUL VL]\n"
      "st1h { z15.h }, p6, [x21, #4, MUL VL]\n"
      ".inst 0x648abab7  // bfcvtnt z23.h, p6/M, z21.s\n"
      ".inst 0x648abb7e  // bfcvtnt z30.h, p6/M, z27.s\n"
      "st1h { z3.h }, p6, [x21, #5, MUL VL]\n"
      ".inst 0x648ab881  // bfcvtnt z1.h, p6/M, z4.s\n"
      ".inst 0x648ab900  // bfcvtnt z0.h, p6/M, z8.s\n"
      "st1h { z18.h }, p6, [x21, #6, MUL VL]\n"
      ".inst 0x658ab8e8  // bfcvt z8.h, p6/M, z7.s\n"
      "zip1 z27.s, z31.s, z26.s\n"
      "st1h { z6.h }, p6, [x21, #7, MUL VL]\n"
      "addvl x21, x21, #12\n"
      ".inst 0x658ab96e  // bfcvt z14.h, p6/M, z11.s\n"
      "zip2 z28.s, z31.s, z26.s\n"
      ".inst 0x658abbbd  // bfcvt z29.h, p6/M, z29.s\n"
      "zip1 z21.s, z22.s, z9.s\n"
      "st1h { z17.h }, p6, [x21, #-4, MUL VL]\n"
      ".inst 0x658ab992  // bfcvt z18.h, p6/M, z12.s\n"
      "zip2 z17.s, z22.s, z9.s\n"
      "st1h { z5.h }, p6, [x21, #-3, MUL VL]\n"
      "st1h { z24.h }, p6, [x21, #-2, MUL VL]\n"
      ".inst 0x648abb68  // bfcvtnt z8.h, p6/M, z27.s\n"
      ".inst 0x648abb8e  // bfcvtnt z14.h, p6/M, z28.s\n"
      "st1h { z25.h }, p6, [x21, #-1, MUL VL]\n"
      ".inst 0x648ababd  // bfcvtnt z29.h, p6/M, z21.s\n"
      ".inst 0x648aba32  // bfcvtnt z18.h, p6/M, z17.s\n"
      "st1h { z2.h }, p6, [x20]\n"
      "st1h { z20.h }, p6, [x20, #1, MUL VL]\n"
      "st1h { z19.h }, p6, [x20, #2, MUL VL]\n"
      "st1h { z16.h }, p6, [x20, #3, MUL VL]\n"
      "st1h { z23.h }, p6, [x20, #4, MUL VL]\n"
      "st1h { z30.h }, p6, [x20, #5, MUL VL]\n"
      "st1h { z1.h }, p6, [x20, #6, MUL VL]\n"
      "st1h { z0.h }, p6, [x20, #7, MUL VL]\n"
      "addvl x20, x20, #12\n"
      "st1h { z8.h }, p6, [x20, #-4, MUL VL]\n"
      "st1h { z14.h }, p6, [x20, #-3, MUL VL]\n"
      "st1h { z29.h }, p6, [x20, #-2, MUL VL]\n"
      "st1h { z18.h }, p6, [x20, #-1, MUL VL]\n"
      "bge 2b\n"
      "3:"  // Main row loop: Unroll column loop skip
      "cbz x25, 5f\n"
      "4:"  // Main row loop: Column loop
      "mov x20, x25\n"
      "whilelt p5.s, XZR, x20\n"
      "ld1w { z22.s }, p5/Z, [x28]\n"
      "ld1w { z21.s }, p5/Z, [x26]\n"
      "decw x20\n"
      "whilelt p4.s, XZR, x20\n"
      "ld1w { z20.s }, p4/Z, [x28, #1, MUL VL]\n"
      "ld1w { z19.s }, p4/Z, [x26, #1, MUL VL]\n"
      "decw x20\n"
      "whilelt p3.s, XZR, x20\n"
      "ld1w { z18.s }, p3/Z, [x28, #2, MUL VL]\n"
      "ld1w { z17.s }, p3/Z, [x26, #2, MUL VL]\n"
      "decw x20\n"
      "whilelt p2.s, XZR, x20\n"
      "ld1w { z30.s }, p2/Z, [x28, #3, MUL VL]\n"
      "ld1w { z16.s }, p2/Z, [x26, #3, MUL VL]\n"
      "decw x20\n"
      "whilelt p1.s, XZR, x20\n"
      "ld1w { z13.s }, p1/Z, [x28, #4, MUL VL]\n"
      "ld1w { z29.s }, p5/Z, [x27]\n"
      "decw x20\n"
      "whilelt p0.s, XZR, x20\n"
      "ld1w { z12.s }, p0/Z, [x28, #5, MUL VL]\n"
      "ld1w { z28.s }, p4/Z, [x27, #1, MUL VL]\n"
      "ld1w { z11.s }, p3/Z, [x27, #2, MUL VL]\n"
      "ld1w { z10.s }, p2/Z, [x27, #3, MUL VL]\n"
      "zip1 z27.s, z22.s, z21.s\n"
      "zip2 z26.s, z22.s, z21.s\n"
      "ld1w { z9.s }, p1/Z, [x26, #4, MUL VL]\n"
      "ld1w { z8.s }, p0/Z, [x26, #5, MUL VL]\n"
      "zip1 z25.s, z20.s, z19.s\n"
      "zip2 z24.s, z20.s, z19.s\n"
      "ld1w { z23.s }, p5/Z, [x23]\n"
      "ld1w { z22.s }, p4/Z, [x23, #1, MUL VL]\n"
      "zip1 z21.s, z18.s, z17.s\n"
      "zip2 z20.s, z18.s, z17.s\n"
      "ld1w { z19.s }, p3/Z, [x23, #2, MUL VL]\n"
      "ld1w { z18.s }, p2/Z, [x23, #3, MUL VL]\n"
      "zip1 z17.s, z30.s, z16.s\n"
      "zip2 z16.s, z30.s, z16.s\n"
      "ld1w { z7.s }, p1/Z, [x27, #4, MUL VL]\n"
      "ld1w { z6.s }, p0/Z, [x27, #5, MUL VL]\n"
      ".inst 0x658abb65  // bfcvt z5.h, p6/M, z27.s\n"
      "zip1 z4.s, z29.s, z23.s\n"
      "ld1w { z3.s }, p1/Z, [x23, #4, MUL VL]\n"
      "ld1w { z2.s }, p0/Z, [x23, #5, MUL VL]\n"
      ".inst 0x658abb41  // bfcvt z1.h, p6/M, z26.s\n"
      "zip2 z0.s, z29.s, z23.s\n"
      ".inst 0x658abb3f  // bfcvt z31.h, p6/M, z25.s\n"
      "zip1 z30.s, z28.s, z22.s\n"
      "mov x20, x22\n"
      "decd x25, ALL, MUL #12\n"
      ".inst 0x658abb1d  // bfcvt z29.h, p6/M, z24.s\n"
      "zip2 z28.s, z28.s, z22.s\n"
      "cmp x25, #0x0\n"
      "addvl x28, x28, #6\n"
      ".inst 0x658ababb  // bfcvt z27.h, p6/M, z21.s\n"
      "zip1 z23.s, z11.s, z19.s\n"
      "addvl x27, x27, #6\n"
      "addvl x26, x26, #6\n"
      ".inst 0x658aba9a  // bfcvt z26.h, p6/M, z20.s\n"
      "zip2 z22.s, z11.s, z19.s\n"
      "addvl x23, x23, #6\n"
      "add x22, x22, %x[out_stride]\n"
      ".inst 0x658aba39  // bfcvt z25.h, p6/M, z17.s\n"
      "zip1 z21.s, z10.s, z18.s\n"
      ".inst 0x658aba18  // bfcvt z24.h, p6/M, z16.s\n"
      "zip2 z20.s, z10.s, z18.s\n"
      "zip1 z19.s, z13.s, z9.s\n"
      "zip2 z18.s, z13.s, z9.s\n"
      "zip1 z17.s, z12.s, z8.s\n"
      "zip2 z16.s, z12.s, z8.s\n"
      ".inst 0x648ab885  // bfcvtnt z5.h, p6/M, z4.s\n"
      ".inst 0x648ab801  // bfcvtnt z1.h, p6/M, z0.s\n"
      "st1h { z5.h }, p6, [x20]\n"
      ".inst 0x648abbdf  // bfcvtnt z31.h, p6/M, z30.s\n"
      ".inst 0x648abb9d  // bfcvtnt z29.h, p6/M, z28.s\n"
      "st1h { z1.h }, p6, [x20, #1, MUL VL]\n"
      ".inst 0x648abafb  // bfcvtnt z27.h, p6/M, z23.s\n"
      ".inst 0x648abada  // bfcvtnt z26.h, p6/M, z22.s\n"
      "st1h { z31.h }, p6, [x20, #2, MUL VL]\n"
      ".inst 0x648abab9  // bfcvtnt z25.h, p6/M, z21.s\n"
      ".inst 0x648aba98  // bfcvtnt z24.h, p6/M, z20.s\n"
      "st1h { z29.h }, p6, [x20, #3, MUL VL]\n"
      ".inst 0x658aba77  // bfcvt z23.h, p6/M, z19.s\n"
      "zip1 z22.s, z7.s, z3.s\n"
      "st1h { z27.h }, p6, [x20, #4, MUL VL]\n"
      ".inst 0x658aba55  // bfcvt z21.h, p6/M, z18.s\n"
      "zip2 z20.s, z7.s, z3.s\n"
      "st1h { z26.h }, p6, [x20, #5, MUL VL]\n"
      ".inst 0x658aba33  // bfcvt z19.h, p6/M, z17.s\n"
      "zip1 z18.s, z6.s, z2.s\n"
      "st1h { z25.h }, p6, [x20, #6, MUL VL]\n"
      ".inst 0x658aba11  // bfcvt z17.h, p6/M, z16.s\n"
      "zip2 z16.s, z6.s, z2.s\n"
      "st1h { z24.h }, p6, [x20, #7, MUL VL]\n"
      "addvl x20, x20, #12\n"
      ".inst 0x648abad7  // bfcvtnt z23.h, p6/M, z22.s\n"
      ".inst 0x648aba95  // bfcvtnt z21.h, p6/M, z20.s\n"
      "st1h { z23.h }, p6, [x20, #-4, MUL VL]\n"
      ".inst 0x648aba53  // bfcvtnt z19.h, p6/M, z18.s\n"
      ".inst 0x648aba11  // bfcvtnt z17.h, p6/M, z16.s\n"
      "st1h { z21.h }, p6, [x20, #-3, MUL VL]\n"
      "st1h { z19.h }, p6, [x20, #-2, MUL VL]\n"
      "st1h { z17.h }, p6, [x20, #-1, MUL VL]\n"
      "bgt 4b\n"
      "5:"  // Main row loop: Column loop skip
      "cmp %x[height], #0x1\n"
      "addvl %x[out], %x[out], #12\n"
      "bge 1b\n"
      : [height] "+&r" (height), [in] "+&r" (in), [out] "+&r" (out)
      : [in_stride] "r" (in_stride), [out_stride] "r" (out_stride), [pad_row] "r" (pad_row), [width] "r" (width)
      : "cc", "memory", "p0", "p1", "p2", "p3", "p4", "p5", "p6", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "x28", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "z16", "z17", "z18", "z19", "z20", "z21", "z22", "z23", "z24", "z25", "z26", "z27", "z28", "z29", "z30", "z31"
    );
}

} // anonymous namespace
template<>
void Transform<12, 4, true, VLType::SVE>(
    bfloat16 *out, const float *in, int stride, int x0, int xmax, int k0, int kmax)
{
    sve_transpose_interleave_12VL_2x4_fp32bf16(
        out,
        in + k0 * stride + x0,
        (xmax-x0),
        stride * sizeof(float),
        (kmax-k0)
    );
}

#endif
