# -*- coding: utf-8 -*-
from congo.conf import settings
from congo.utils.text import strip_special_chars
from django.db.models import Q
from django.db.utils import IntegrityError
from django.utils.encoding import force_text
from django.utils.translation import get_language
import datetime
import re

STOPWORDS = {
    'en': (u"a", u"about", u"above", u"after", u"again", u"against", u"all", u"am", u"an", u"and", u"any", u"are", u"aren't", u"as", u"at", u"be", u"because", u"been", u"before", u"being", u"below", u"between", u"both", u"but", u"by", u"cannot", u"can't", u"could", u"couldn't", u"did", u"didn't", u"do", u"does", u"doesn't", u"doing", u"don't", u"down", u"during", u"each", u"few", u"for", u"from", u"further", u"had", u"hadn't", u"has", u"hasn't", u"have", u"haven't", u"having", u"he", u"he'd", u"he'll", u"her", u"here", u"here's", u"hers", u"herself", u"he's", u"him", u"himself", u"his", u"how", u"how's", u"i", u"i'd", u"if", u"i'll", u"i'm", u"in", u"into", u"is", u"isn't", u"it", u"its", u"it's", u"itself", u"i've", u"let's", u"me", u"more", u"most", u"mustn't", u"my", u"myself", u"no", u"nor", u"not", u"of", u"off", u"on", u"once", u"only", u"onto", u"or", u"other", u"ought", u"our", u"ours ", u"ourselves", u"out", u"over", u"own", u"per", u"same", u"shan't", u"she", u"she'd", u"she'll", u"she's", u"should", u"shouldn't", u"so", u"some", u"such", u"than", u"that", u"that's", u"the", u"their", u"theirs", u"them", u"themselves", u"then", u"there", u"there's", u"these", u"they", u"they'd", u"they'll", u"they're", u"they've", u"this", u"those", u"through", u"to", u"too", u"under", u"until", u"up", u"very", u"via", u"was", u"wasn't", u"we", u"we'd", u"we'll", u"were", u"we're", u"weren't", u"we've", u"what", u"what's", u"when", u"when's", u"where", u"where's", u"which", u"while", u"who", u"whom", u"who's", u"why", u"why's", u"with", u"won't", u"would", u"wouldn't", u"you", u"you'd", u"you'll", u"your", u"you're", u"yours", u"yourself", u"yourselves", u"you've"),
    'de': (u"ab", u"aber", u"ähnlich", u"alle", u"allein", u"allem", u"allen", u"aller", u"allerdings", u"allerlei", u"alles", u"allmählich", u"allzu", u"als", u"alsbald", u"also", u"am", u"an", u"and", u"ander", u"andere", u"anderem", u"anderen", u"anderer", u"andererseits", u"anderes", u"anderm", u"andern", u"andernfalls", u"anders", u"anstatt", u"auch", u"auf", u"aus", u"ausgenommen", u"ausser", u"ausserdem", u"außerhalb", u"bald", u"bei", u"beide", u"beiden", u"beiderlei", u"beides", u"beim", u"beinahe", u"bereits", u"besonders", u"besser", u"beträchtlich", u"bevor", u"bezüglich", u"bin", u"bis", u"bisher", u"bislang", u"bist", u"bloß", u"bsp.", u"bzw", u"ca", u"ca.", u"content", u"da", u"dabei", u"dadurch", u"dafür", u"dagegen", u"daher", u"dahin", u"damals", u"damit", u"danach", u"daneben", u"dann", u"daran", u"darauf", u"daraus", u"darin", u"darüber", u"darüberhinaus", u"darum", u"darunter", u"das", u"daß", u"dasselbe", u"davon", u"davor", u"dazu", u"dein", u"deine", u"deinem", u"deinen", u"deiner", u"deines", u"dem", u"demnach", u"demselben", u"den", u"denen", u"denn", u"dennoch", u"denselben", u"der", u"derart", u"derartig", u"derem", u"deren", u"derer", u"derjenige", u"derjenigen", u"derselbe", u"derselben", u"derzeit", u"des", u"deshalb", u"desselben", u"dessen", u"desto", u"deswegen", u"dich", u"die", u"diejenige", u"dies", u"diese", u"dieselbe", u"dieselben", u"diesem", u"diesen", u"dieser", u"dieses", u"diesseits", u"dir", u"direkt", u"direkte", u"direkten", u"direkter", u"doch", u"dort", u"dorther", u"dorthin", u"drauf", u"drin", u"drüber", u"drunter", u"du", u"dunklen", u"durch", u"durchaus", u"eben", u"ebenfalls", u"ebenso", u"eher", u"eigenen", u"eigenes", u"eigentlich", u"ein", u"eine", u"einem", u"einen", u"einer", u"einerseits", u"eines", u"einfach", u"einführen", u"einführte", u"einführten", u"eingesetzt", u"einig", u"einige", u"einigem", u"einigen", u"einiger", u"einigermaßen", u"einiges", u"einmal", u"eins", u"einseitig", u"einseitige", u"einseitigen", u"einseitiger", u"einst", u"einstmals", u"einzig", u"entsprechend", u"entweder", u"er", u"erst", u"es", u"etc", u"etliche", u"etwa", u"etwas", u"euch", u"euer", u"eure", u"eurem", u"euren", u"eurer", u"eures", u"falls", u"fast", u"ferner", u"folgende", u"folgenden", u"folgender", u"folgendes", u"folglich", u"fuer", u"für", u"gab", u"ganze", u"ganzem", u"ganzen", u"ganzer", u"ganzes", u"gänzlich", u"gar", u"gegen", u"gemäss", u"ggf", u"gleich", u"gleichwohl", u"gleichzeitig", u"glücklicherweise", u"hab", u"habe", u"haben", u"haette", u"hast", u"hat", u"hätt", u"hatte", u"hätte", u"hatten", u"hätten", u"hattest", u"hattet", u"heraus", u"herein", u"hier", u"hier hinter", u"hiermit", u"hiesige", u"hin", u"hinein", u"hinten", u"hinter", u"hinterher", u"höchstens", u"http", u"ich", u"igitt", u"ihm", u"ihn", u"ihnen", u"ihr", u"ihre", u"ihrem", u"ihren", u"ihrer", u"ihres", u"im", u"immer", u"immerhin", u"in", u"indem", u"indessen", u"infolge", u"innen", u"innerhalb", u"ins", u"insofern", u"inzwischen", u"irgend", u"irgendeine", u"irgendwas", u"irgendwen", u"irgendwer", u"irgendwie", u"irgendwo", u"ist", u"ja", u"jährig", u"jährige", u"jährigen", u"jähriges", u"je", u"jed", u"jede", u"jedem", u"jeden", u"jedenfalls", u"jeder", u"jederlei", u"jedes", u"jedoch", u"jemand", u"jene", u"jenem", u"jenen", u"jener", u"jenes", u"jenseits", u"jetzt", u"kam", u"kann", u"kannst", u"kaum", u"kein", u"keine", u"keinem", u"keinen", u"keiner", u"keinerlei", u"keines", u"keineswegs", u"klar", u"klare", u"klaren", u"klares", u"klein", u"kleinen", u"kleiner", u"kleines", u"koennen", u"koennt", u"koennte", u"koennten", u"komme", u"kommen", u"kommt", u"konkret", u"konkrete", u"konkreten", u"konkreter", u"konkretes", u"können", u"könnt", u"künftig", u"leider", u"machen", u"man", u"manche", u"manchem", u"manchen", u"mancher", u"mancherorts", u"manches", u"manchmal", u"mehr", u"mehrere", u"mein", u"meine", u"meinem", u"meinen", u"meiner", u"meines", u"mich", u"mir", u"mit", u"mithin", u"muessen", u"muesst", u"muesste", u"muß", u"müssen", u"mußt", u"müßt", u"musste", u"müsste", u"mussten", u"müssten", u"nach", u"nachdem", u"nachher", u"nachhinein", u"nächste", u"nahm", u"nämlich", u"natürlich", u"neben", u"nebenan", u"nehmen", u"nein", u"nicht", u"nichts", u"nie", u"niemals", u"niemand", u"nirgends", u"nirgendwo", u"noch", u"nötigenfalls", u"nun", u"nur", u"ob", u"oben", u"oberhalb", u"obgleich", u"obschon", u"obwohl", u"oder", u"oft", u"per", u"plötzlich", u"schließlich", u"schon", u"sehr", u"sehrwohl", u"seid", u"sein", u"seine", u"seinem", u"seinen", u"seiner", u"seines", u"seit", u"seitdem", u"seither", u"selber", u"selbst", u"sich", u"sicher", u"sicherlich", u"sie", u"sind", u"so", u"sobald", u"sodass", u"soeben", u"sofern", u"sofort", u"sogar", u"solange", u"solch", u"solche", u"solchem", u"solchen", u"solcher", u"solches", u"soll", u"sollen", u"sollst", u"sollt", u"sollte", u"sollten", u"solltest", u"somit", u"sondern", u"sonst", u"sonstwo", u"sooft", u"soviel", u"soweit", u"sowie", u"sowohl", u"tatsächlich", u"tatsächlichen", u"tatsächlicher", u"tatsächliches", u"trotzdem", u"übel", u"über", u"überall", u"überallhin", u"überdies", u"übermorgen", u"übrig", u"übrigens", u"ueber", u"um", u"umso", u"unbedingt", u"und", u"unmöglich", u"unmögliche", u"unmöglichen", u"unmöglicher", u"uns", u"unser", u"unser unsere", u"unsere", u"unserem", u"unseren", u"unserer", u"unseres", u"unter", u"usw", u"viel", u"viele", u"vielen", u"vieler", u"vieles", u"vielleicht", u"vielmals", u"völlig", u"vom", u"von", u"vor", u"voran", u"vorher", u"vorüber", u"während", u"währenddessen", u"wann", u"war", u"wär", u"wäre", u"waren", u"wären", u"warst", u"warum", u"was", u"weder", u"weil", u"weiß", u"weiter", u"weitere", u"weiterem", u"weiteren", u"weiterer", u"weiteres", u"weiterhin", u"welche", u"welchem", u"welchen", u"welcher", u"welches", u"wem", u"wen", u"wenig", u"wenige", u"weniger", u"wenigstens", u"wenn", u"wenngleich", u"wer", u"werde", u"werden", u"werdet", u"weshalb", u"wessen", u"wichtig", u"wie", u"wieder", u"wieso", u"wieviel", u"wiewohl", u"will", u"willst", u"wir", u"wird", u"wirklich", u"wirst", u"wo", u"wodurch", u"wogegen", u"woher", u"wohin", u"wohingegen", u"wohl", u"wohlweislich", u"womit", u"woraufhin", u"woraus", u"worin", u"wurde", u"würde", u"wurden", u"würden", u"z.B.", u"zahlreich", u"zB", u"zeitweise", u"zu", u"zudem", u"zuerst", u"zufolge", u"zugleich", u"zuletzt", u"zum", u"zumal", u"zur", u"zurück", u"zusammen", u"zuviel", u"zwar", u"zwischen"),
    'pl': (u"a", u"aby", u"ach", u"acz", u"aczkolwiek", u"aj", u"albo", u"ale", u"ależ", u"aż", u"bardziej", u"bardzo", u"bez", u"będą", u"będzie", u"bo", u"bowiem", u"by", u"być", u"byli", u"był", u"była", u"było", u"były", u"bynajmniej", u"cali", u"cała", u"cały", u"ci", u"ciebie", u"cię", u"co", u"cokolwiek", u"coś", u"czasami", u"czasem", u"czemu", u"czy", u"czyli", u"daleko", u"dla", u"dlaczego", u"dlatego", u"do", u"dobrze", u"dokąd", u"dość", u"dużo", u"dwa", u"dwaj", u"dwie", u"dwoje", u"dzisiaj", u"dziś", u"gdy", u"gdyby", u"gdyż", u"gdzie", u"gdziekolwiek", u"gdzieś", u"go", u"i", u"ich", u"ile", u"im", u"inna", u"inne", u"inny", u"innych", u"iż", u"ja", u"jak", u"jakaś", u"jakby", u"jaki", u"jakichś", u"jakie", u"jakiś", u"jakiż", u"jakkolwiek", u"jako", u"jakoś", u"ją", u"je", u"jeden", u"jedna", u"jednak", u"jednakże", u"jedno", u"jego", u"jej", u"jemu", u"jest", u"jestem", u"jeszcze", u"jeśli", u"jeżeli", u"już", u"każdy", u"kiedy", u"kierunku", u"kilka", u"kimś", u"kto", u"ktokolwiek", u"ktoś", u"która", u"które", u"którego", u"której", u"który", u"których", u"którym", u"którzy", u"ku", u"lat", u"lecz", u"lub", u"ma", u"mają", u"mam", u"mi", u"między", u"mimo", u"mną", u"mnie", u"mogą", u"moi", u"moim", u"moja", u"moje", u"może", u"możliwe", u"można", u"mój", u"mu", u"musi", u"my", u"na", u"nad", u"nam", u"nami", u"nas", u"nasi", u"nasz", u"nasza", u"nasze", u"naszego", u"naszych", u"natomiast", u"natychmiast", u"nawet", u"nią", u"nic", u"nich", u"nie", u"niego", u"niej", u"niemu", u"nigdy", u"nim", u"nimi", u"niż", u"no", u"o", u"obok", u"od", u"około", u"on", u"ona", u"one", u"oni", u"ono", u"oraz", u"ow", u"owszem", u"owy", u"pan", u"pana", u"pani", u"po", u"pod", u"podczas", u"pomimo", u"ponad", u"ponieważ", u"powinien", u"powinna", u"powinni", u"powinno", u"poza", u"prawie", u"przecież", u"przed", u"przede", u"przedtem", u"przez", u"przy", u"roku", u"również", u"sam", u"sama", u"są", u"się", u"skąd", u"sobą", u"sobie", u"sposób", u"swoje", u"ta", u"tak", u"taka", u"taki", u"takie", u"także", u"tam", u"te", u"tego", u"tej", u"ten", u"teraz", u"też", u"to", u"tobą", u"tobie", u"toteż", u"totobą", u"trzeba", u"tu", u"tutaj", u"twoi", u"twoim", u"twoja", u"twoje", u"twój", u"twym", u"ty", u"tych", u"tylko", u"tym", u"u", u"uów", u"uwięc", u"w", u"wam", u"wami", u"was", u"wasi", u"wasz", u"wasza", u"wasze", u"we", u"według", u"wiele", u"wielu", u"więc", u"więcej", u"właśnie", u"wszyscy", u"wszystkich", u"wszystkie", u"wszystkim", u"wszystko", u"wtedy", u"wy", u"z", u"za", u"zapewne", u"zawsze", u"ze", u"zeznowu", u"znad", u"znów", u"został", u"zpod", u"zprzed", u"zza", u"żaden", u"żadna", u"żadne", u"żadnych", u"że", u"żeby"),
    'ru': (),
#    'ru': (u"а", u"алло", u"без", u"близко", u"более", u"больше", u"будем", u"будет", u"будете", u"будешь", u"будто", u"буду", u"будут", u"будь", u"бы", u"бывает", u"бывь", u"был", u"была", u"были", u"было", u"быть", u"в", u"важна�?", u"важное", u"важные", u"важный", u"вам", u"вами", u"ва�?", u"ваш", u"ваша", u"ваше", u"ваши", u"вверх", u"вдали", u"вдруг", u"ведь", u"везде", u"ве�?ь", u"вниз", u"внизу", u"во", u"вокруг", u"вон", u"во�?емнадцатый", u"во�?емнадцать", u"во�?емь", u"во�?ьмой", u"вот", u"впрочем", u"времени", u"врем�?", u"в�?е", u"в�?ё", u"в�?егда", u"в�?его", u"в�?ем", u"в�?еми", u"в�?ему", u"в�?ех", u"в�?ею", u"в�?ю", u"в�?юду", u"в�?�?", u"второй", u"вы", u"г", u"где", u"говорил", u"говорит", u"год", u"года", u"году", u"да", u"давно", u"даже", u"далеко", u"дальше", u"даром", u"два", u"двадцатый", u"двадцать", u"две", u"двенадцатый", u"двенадцать", u"двух", u"дев�?тнадцатый", u"дев�?тнадцать", u"дев�?тый", u"дев�?ть", u"дей�?твительно", u"дел", u"день", u"де�?�?тый", u"де�?�?ть", u"дл�?", u"до", u"довольно", u"долго", u"должно", u"друга�?", u"другие", u"других", u"друго", u"другое", u"другой", u"е", u"его", u"ее", u"её", u"ей", u"ему", u"е�?ли", u"е�?ть", u"еще", u"ещё", u"ею", u"ж", u"же", u"жизнь", u"за", u"зан�?т", u"зан�?та", u"зан�?то", u"зан�?ты", u"затем", u"зато", u"зачем", u"зде�?ь", u"значит", u"и", u"из", u"или", u"им", u"именно", u"иметь", u"ими", u"им�?", u"иногда", u"их", u"к", u"кажда�?", u"каждое", u"каждые", u"каждый", u"кажет�?�?", u"как", u"кака�?", u"какой", u"кем", u"когда", u"кого", u"ком", u"кому", u"конечно", u"котора�?", u"которого", u"которой", u"которые", u"который", u"которых", u"кроме", u"кругом", u"кто", u"куда", u"лет", u"ли", u"лишь", u"лучше", u"люди", u"м", u"мало", u"между", u"мел�?", u"менее", u"меньше", u"мен�?", u"миллионов", u"мимо", u"мира", u"мне", u"много", u"многочи�?ленна�?", u"многочи�?ленное", u"многочи�?ленные", u"многочи�?ленный", u"мной", u"мною", u"мог", u"могут", u"моё", u"мож", u"может", u"можно", u"можхо", u"мои", u"мой", u"мор", u"мочь", u"мо�?", u"мы", u"на", u"наверху", u"над", u"надо", u"назад", u"наиболее", u"наконец", u"нам", u"нами", u"на�?", u"начала", u"наш", u"наша", u"наше", u"наши", u"не", u"него", u"недавно", u"недалеко", u"нее", u"неё", u"ней", u"нельз�?", u"нем", u"немного", u"нему", u"непрерывно", u"нередко", u"не�?колько", u"нет", u"нею", u"ни", u"нибудь", u"ниже", u"низко", u"никогда", u"никуда", u"ними", u"них", u"ничего", u"но", u"ну", u"нужно", u"нх", u"о", u"об", u"оба", u"обычно", u"один", u"одиннадцатый", u"одиннадцать", u"однажды", u"однако", u"одного", u"одной", u"около", u"он", u"она", u"они", u"оно", u"оп�?ть", u"о�?обенно", u"от", u"отов�?юду", u"от�?юда", u"очень", u"первый", u"перед", u"по", u"под", u"пожалуй�?та", u"позже", u"пока", u"пор", u"пора", u"по�?ле", u"по�?реди", u"потом", u"потому", u"почему", u"почти", u"прекра�?но", u"при", u"про", u"про�?то", u"против", u"процентов", u"п�?тнадцатый", u"п�?тнадцать", u"п�?тый", u"п�?ть", u"раз", u"разве", u"рано", u"раньше", u"р�?дом", u"�?", u"�?ам", u"�?ама", u"�?ами", u"�?амим", u"�?амими", u"�?амих", u"�?амо", u"�?амого", u"�?амой", u"�?амом", u"�?амому", u"�?аму", u"�?вое", u"�?воего", u"�?воей", u"�?вои", u"�?воих", u"�?вою", u"�?еаой", u"�?ебе", u"�?еб�?", u"�?егодн�?", u"�?едьмой", u"�?ейча�?", u"�?емнадцатый", u"�?емнадцать", u"�?емь", u"�?их", u"�?казал", u"�?казала", u"�?казать", u"�?колько", u"�?лишком", u"�?начала", u"�?нова", u"�?о", u"�?обой", u"�?обою", u"�?ов�?ем", u"�?па�?ибо", u"�?тал", u"�?уть", u"т", u"та", u"так", u"така�?", u"также", u"такие", u"такое", u"такой", u"там", u"твоё", u"твой", u"тво�?", u"те", u"тебе", u"теб�?", u"тем", u"теми", u"теперь", u"тех", u"то", u"тобой", u"тобою", u"тогда", u"того", u"тоже", u"только", u"том", u"тому", u"тот", u"тою", u"третий", u"три", u"тринадцатый", u"тринадцать", u"ту", u"туда", u"тут", u"ты", u"ты�?�?ч", u"у", u"уж", u"уже", u"уметь", u"хорошо", u"хотеть", u"хоть", u"хот�?", u"хочешь", u"ча�?то", u"чаще", u"чего", u"человек", u"чем", u"чему", u"через", u"четвертый", u"четыре", u"четырнадцатый", u"четырнадцать", u"что", u"чтоб", u"чтобы", u"чуть", u"ше�?тнадцатый", u"ше�?тнадцать", u"ше�?той", u"ше�?ть", u"�?та", u"�?ти", u"�?тим", u"�?тими", u"�?тих", u"�?то", u"�?того", u"�?той", u"�?том", u"�?тому", u"�?тот", u"�?ту", u"�?"),
}

def escape_mysql_query(search_text, default_operator = "+"):
    words = []

    for word in search_text.split():
        if word[0] in "+-":
            operator = word[0]
            word = word[1:]
        else:
            operator = default_operator
        word = strip_special_chars(word)
        if len(word) < 3 and operator:
            operator = ""
        words.append("%s%s*" % (operator, word))

    return " ".join(words)
