"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaErrorSnsSender = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const sns = require("aws-cdk-lib/aws-sns");
const subscription = require("aws-cdk-lib/aws-sns-subscriptions");
const constructs_1 = require("constructs");
class LambdaErrorSnsSender extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (!props.snsTopics || props?.snsTopics.length === 0) {
            throw new Error('No SNS Topics provided');
        }
        const snsErrorFunc = new lambda.Function(this, 'lambdaSnsError', {
            handler: 'index.handler',
            code: lambda.Code.fromAsset(path.join(__dirname, '../lib/functions/lambdaSnsError')),
            runtime: lambda.Runtime.NODEJS_18_X,
            environment: {
                MAX_NUMBER_OF_LOGS: props?.maxNumberOfLogs?.toString() ?? '100',
            },
            timeout: cdk.Duration.minutes(1),
        });
        //grand access to cloudwatch logs
        snsErrorFunc.addToRolePolicy(new iam.PolicyStatement({
            actions: ['logs:FilterLogEvents'],
            resources: ['*'], // I do not know which resources I will need to access
        }));
        for (const snsTopic of props?.snsTopics) {
            const defaultFilter = {
                MetricName: sns.FilterOrPolicy.filter(sns.SubscriptionFilter.stringFilter({
                    allowlist: ['Errors'],
                })),
                Namespace: sns.FilterOrPolicy.filter(sns.SubscriptionFilter.stringFilter({
                    allowlist: ['AWS/Lambda'],
                })),
                StatisticType: sns.FilterOrPolicy.filter(sns.SubscriptionFilter.stringFilter({
                    allowlist: ['Statistic'],
                })),
                Statistic: sns.FilterOrPolicy.filter(sns.SubscriptionFilter.stringFilter({
                    allowlist: ['SUM'],
                })),
            };
            snsTopic.addSubscription(new subscription.LambdaSubscription(snsErrorFunc, {
                filterPolicyWithMessageBody: {
                    Trigger: sns.FilterOrPolicy.policy(props.filter ?? defaultFilter),
                },
            }));
            snsTopic.grantPublish(snsErrorFunc);
        }
    }
}
exports.LambdaErrorSnsSender = LambdaErrorSnsSender;
_a = JSII_RTTI_SYMBOL_1;
LambdaErrorSnsSender[_a] = { fqn: "lambda-error-sns-sender.LambdaErrorSnsSender", version: "0.0.49" };
//# sourceMappingURL=data:application/json;base64,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