"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoScalar = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
class AutoScalar extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const karpenterNodeRole = new aws_cdk_lib_1.aws_iam.Role(this, 'KarpenterNodeRole', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('ec2.amazonaws.com'),
            managedPolicies: [
                aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonEKSWorkerNodePolicy'),
                aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonEKS_CNI_Policy'),
                aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonEC2ContainerRegistryReadOnly'),
                aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'),
            ],
        });
        const karpenterInstanceProfile = new aws_cdk_lib_1.aws_iam.CfnInstanceProfile(this, 'KarpenterInstanceProfile', {
            roles: [karpenterNodeRole.roleName],
            path: '/',
        });
        props.cluster.awsAuth.addRoleMapping(karpenterNodeRole, {
            groups: ['system:bootstrapper', 'system:nodes'],
            username: 'system:node:{{EC2PrivateDNSName}}',
        });
        const autoscaler_service_account = props.cluster.addServiceAccount('ClusterAutoScalerSA', { namespace: props.namespace });
        autoscaler_service_account.addToPrincipalPolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            resources: ['*'],
            actions: [
                'ec2:CreateLaunchTemplate',
                'ec2:CreateFleet',
                'ec2:RunInstances',
                'ec2:CreateTags',
                'iam:PassRole',
                'ec2:TerminateInstances',
                'ec2:DeleteLaunchTemplate',
                'ec2:DescribeLaunchTemplates',
                'ec2:DescribeInstances',
                'ec2:DescribeSecurityGroups',
                'ec2:DescribeSubnets',
                'ec2:DescribeInstanceTypes',
                'ec2:DescribeInstanceTypeOfferings',
                'ec2:DescribeAvailabilityZones',
                'ssm:GetParameter',
            ],
        }));
        const karpenter_helm_chart = props.cluster.addHelmChart('ClusterAutoScalerHelm', {
            repository: 'https://charts.karpenter.sh/',
            chart: 'karpenter',
            namespace: props.namespace,
            wait: true,
            release: 'karpenter',
            values: {
                serviceAccount: {
                    create: false,
                    annotations: {
                        'eks.amazonaws.com/role-arn': autoscaler_service_account.role.roleArn,
                    },
                    name: autoscaler_service_account.serviceAccountName,
                },
                clusterName: props.cluster.clusterName,
                clusterEndpoint: props.cluster.clusterEndpoint,
                aws: {
                    defaultInstanceProfile: karpenterInstanceProfile.instanceProfileName,
                },
            },
        });
        karpenter_helm_chart.node.addDependency(autoscaler_service_account);
    }
}
exports.AutoScalar = AutoScalar;
_a = JSII_RTTI_SYMBOL_1;
AutoScalar[_a] = { fqn: "kong-core.AutoScalar", version: "2.0.10" };
//# sourceMappingURL=data:application/json;base64,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