"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmPca = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class AcmPca extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.route53Zone = new aws_cdk_lib_1.aws_route53.PrivateHostedZone(this, 'CpInternalHostedZone', {
            vpc: props.vpc,
            zoneName: props.hostedZoneName,
        });
        const cfnCertificateAuthority = new aws_cdk_lib_1.aws_acmpca.CfnCertificateAuthority(this, 'CA', {
            type: 'ROOT',
            keyAlgorithm: 'RSA_2048',
            signingAlgorithm: 'SHA256WITHRSA',
            subject: {
                country: 'US',
                organization: 'Amazon',
                organizationalUnit: 'AWS',
                state: 'WA',
                commonName: props.hostedZoneName,
                locality: 'Seattle',
            },
        });
        this.privateCaArn = cfnCertificateAuthority.attrArn;
        const internalRootCaCert = new aws_cdk_lib_1.aws_acmpca.CfnCertificate(this, 'PrivCaCert', {
            certificateAuthorityArn: this.privateCaArn,
            certificateSigningRequest: cfnCertificateAuthority.attrCertificateSigningRequest,
            templateArn: 'arn:aws:acm-pca:::template/RootCACertificate/V1',
            signingAlgorithm: 'SHA256WITHRSA',
            validity: {
                value: 10,
                type: 'YEARS',
            },
        });
        const internalRootCaActivation = new aws_cdk_lib_1.aws_acmpca.CfnCertificateAuthorityActivation(this, 'PrivCaActivation', {
            certificateAuthorityArn: this.privateCaArn,
            certificate: internalRootCaCert.attrCertificate,
        });
        const wild_card_cert = new aws_cdk_lib_1.aws_certificatemanager.CfnCertificate(this, 'CpCert', {
            domainName: `*.${props.hostedZoneName}`,
            certificateAuthorityArn: this.privateCaArn,
        });
        wild_card_cert.node.addDependency(internalRootCaActivation);
    }
}
exports.AcmPca = AcmPca;
_a = JSII_RTTI_SYMBOL_1;
AcmPca[_a] = { fqn: "kong-core.AcmPca", version: "2.0.10" };
//# sourceMappingURL=data:application/json;base64,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