"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Certificates = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const acm = require("aws-cdk-lib/aws-certificatemanager");
const constructs_1 = require("constructs");
class Certificates extends constructs_1.Construct {
    //public rootCaArn: string;
    constructor(scope, id, props) {
        super(scope, id);
        const certificate = new acm.CfnCertificate(this, 'KongCert', {
            domainName: props.topLevelDomain,
            certificateAuthorityArn: props.privateCaArn,
            subjectAlternativeNames: props.dnsNames,
        });
        //this.rootCaArn = props.rootCaArn;
        this.certificate = certificate;
    }
}
exports.Certificates = Certificates;
_a = JSII_RTTI_SYMBOL_1;
Certificates[_a] = { fqn: "kong-core.Certificates", version: "2.0.10" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2VydGlmaWNhdGVzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2NlcnRpZmljYXRlcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDBEQUEwRDtBQUMxRCwyQ0FBdUM7QUFRdkMsTUFBYSxZQUFhLFNBQVEsc0JBQVM7SUFHekMsMkJBQTJCO0lBRTNCLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBNEI7UUFDcEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLFdBQVcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxjQUFjLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUMzRCxVQUFVLEVBQUUsS0FBSyxDQUFDLGNBQWM7WUFDaEMsdUJBQXVCLEVBQUUsS0FBSyxDQUFDLFlBQVk7WUFDM0MsdUJBQXVCLEVBQUUsS0FBSyxDQUFDLFFBQVE7U0FDeEMsQ0FBQyxDQUFDO1FBRUgsbUNBQW1DO1FBQ25DLElBQUksQ0FBQyxXQUFXLEdBQUMsV0FBVyxDQUFDO0lBQy9CLENBQUM7O0FBaEJILG9DQWlCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGFjbSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtY2VydGlmaWNhdGVtYW5hZ2VyJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuZXhwb3J0IGludGVyZmFjZSBLb25nQ2VydGlmaWNhdGVzUHJvcHMge1xuICByZWFkb25seSB0b3BMZXZlbERvbWFpbjogc3RyaW5nO1xuICByZWFkb25seSBwcml2YXRlQ2FBcm46IHN0cmluZztcbiAgLy9yZWFkb25seSByb290Q2FBcm46IHN0cmluZztcbiAgcmVhZG9ubHkgZG5zTmFtZXM6IHN0cmluZ1tdO1xuXG59XG5leHBvcnQgY2xhc3MgQ2VydGlmaWNhdGVzIGV4dGVuZHMgQ29uc3RydWN0IHtcblxuICBwdWJsaWMgY2VydGlmaWNhdGUgOiBhY20uQ2ZuQ2VydGlmaWNhdGU7XG4gIC8vcHVibGljIHJvb3RDYUFybjogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBLb25nQ2VydGlmaWNhdGVzUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3QgY2VydGlmaWNhdGUgPSBuZXcgYWNtLkNmbkNlcnRpZmljYXRlKHRoaXMsICdLb25nQ2VydCcsIHtcbiAgICAgIGRvbWFpbk5hbWU6IHByb3BzLnRvcExldmVsRG9tYWluLFxuICAgICAgY2VydGlmaWNhdGVBdXRob3JpdHlBcm46IHByb3BzLnByaXZhdGVDYUFybixcbiAgICAgIHN1YmplY3RBbHRlcm5hdGl2ZU5hbWVzOiBwcm9wcy5kbnNOYW1lcyxcbiAgICB9KTtcblxuICAgIC8vdGhpcy5yb290Q2FBcm4gPSBwcm9wcy5yb290Q2FBcm47XG4gICAgdGhpcy5jZXJ0aWZpY2F0ZT1jZXJ0aWZpY2F0ZTtcbiAgfVxufVxuIl19