"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EksNodeHandler = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class EksNodeHandler extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.serviceAccount = props.cluster.addServiceAccount('NodeHandlerSA');
        this.serviceAccount.addToPrincipalPolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            resources: ['*'],
            actions: [
                'autoscaling:CompleteLifecycleAction',
                'autoscaling:DescribeAutoScalingInstances',
                'autoscaling:DescribeTags',
                'ec2:DescribeInstances',
            ],
        }));
        this.notificationQueue = new aws_cdk_lib_1.aws_sqs.Queue(this, 'NotificationQueue');
        this.notificationQueue.grantSendMessages(new aws_cdk_lib_1.aws_iam.ServicePrincipal('events.amazonaws.com'));
        this.notificationQueue.grantSendMessages(new aws_cdk_lib_1.aws_iam.ServicePrincipal('sqs.amazonaws.com'));
        this.notificationQueue.grantConsumeMessages(this.serviceAccount.role);
        new aws_cdk_lib_1.aws_events.Rule(this, 'K8sASGTermRule', {
            eventPattern: {
                source: ['aws.autoscaling'],
                detailType: ['EC2 Instance-terminate Lifecycle Action'],
            },
            targets: [new aws_cdk_lib_1.aws_events_targets.SqsQueue(this.notificationQueue)],
        });
        new aws_cdk_lib_1.aws_events.Rule(this, 'K8sRebalanceRule', {
            eventPattern: {
                source: ['aws.ec2'],
                detailType: ['EC2 Instance Rebalance Recommendation', 'EC2 Spot Instance Interruption Warning'],
            },
            targets: [new aws_cdk_lib_1.aws_events_targets.SqsQueue(this.notificationQueue)],
        });
        const termination_hook = new aws_cdk_lib_1.aws_autoscaling_hooktargets.QueueHook(this.notificationQueue);
        props.nodegroup.addLifecycleHook('NodeTerminationHook', {
            lifecycleTransition: aws_cdk_lib_1.aws_autoscaling.LifecycleTransition.INSTANCE_TERMINATING,
            heartbeatTimeout: aws_cdk_lib_1.Duration.seconds(300),
            defaultResult: aws_cdk_lib_1.aws_autoscaling.DefaultResult.CONTINUE,
            notificationTarget: termination_hook,
        });
        props.cluster.addHelmChart('NodeTerminationHandler', {
            repository: 'https://aws.github.io/eks-charts',
            chart: 'aws-node-termination-handler',
            release: 'aws-node-termination-handler',
            namespace: 'kube-system',
            values: {
                enableRebalanceMonitoring: 'true',
                enableRebalanceDraining: 'true',
                checkASGTagBeforeDraining: 'true',
                // enableSqsTerminationDraining: 'true',
                queueURL: this.notificationQueue.queueUrl,
                taintNode: 'true',
                serviceAccount: {
                    annotations: {
                        'eks.amazonaws.com/role-arn': this.serviceAccount.role.roleArn,
                    },
                },
            },
        });
    }
}
exports.EksNodeHandler = EksNodeHandler;
_a = JSII_RTTI_SYMBOL_1;
EksNodeHandler[_a] = { fqn: "kong-core.EksNodeHandler", version: "2.0.10" };
//# sourceMappingURL=data:application/json;base64,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