"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RdsStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class RdsStack extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.kongPostgresSql = new aws_cdk_lib_1.aws_rds.DatabaseInstance(this, 'PGInstance', {
            engine: aws_cdk_lib_1.aws_rds.DatabaseInstanceEngine.postgres({
                version: props.postgresversion,
            }),
            deletionProtection: false,
            instanceType: aws_cdk_lib_1.aws_ec2.InstanceType.of(aws_cdk_lib_1.aws_ec2.InstanceClass.M4, aws_cdk_lib_1.aws_ec2.InstanceSize.LARGE),
            vpc: props.vpc,
            databaseName: props.databasename,
            // maxAllocatedStorage : 10,
            multiAz: true,
            credentials: {
                username: props.username,
            },
            publiclyAccessible: false,
            storageEncrypted: true,
        });
        this.kongPostgresSql.node.defaultChild.deletionProtection = false;
        this.kongPostgresSql.connections.allowDefaultPortFrom(aws_cdk_lib_1.aws_ec2.Peer.ipv4(props.vpc.vpcCidrBlock));
        // new CfnOutput(this, 'SMArnOutput', { value: this.kong_postgres_sql.secret?.secretArn! });
        // new CfnOutput(this, 'PGOutput', { value: this.kong_postgres_sql.dbInstanceEndpointAddress });
    }
}
exports.RdsStack = RdsStack;
_a = JSII_RTTI_SYMBOL_1;
RdsStack[_a] = { fqn: "kong-core.RdsStack", version: "2.0.10" };
//# sourceMappingURL=data:application/json;base64,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