// Generated by paddle/phi/api/generator/tensor_operants_gen.py

#pragma once

#include "paddle/phi/api/include/operants_base.h"
#include "paddle/phi/api/include/tensor.h"
#include "paddle/phi/common/scalar.h"
#include "paddle/phi/common/int_array.h"
#include "paddle/common/macros.h"


namespace paddle {

namespace operants {

using Scalar = paddle::experimental::Scalar;
using IntArray = paddle::experimental::IntArray;

class PhiTensorOperants : public TensorOperantsBase {
 private:
  DISABLE_COPY_AND_ASSIGN(PhiTensorOperants);

 public:
  PhiTensorOperants() = default;

  PADDLE_API Tensor add(const Tensor& x, const Scalar& y);

  PADDLE_API Tensor subtract(const Tensor& x, const Scalar& y);

  PADDLE_API Tensor multiply(const Tensor& x, const Scalar& y);

  PADDLE_API Tensor divide(const Tensor& x, const Scalar& y);

  PADDLE_API Tensor add(const Scalar& x, const Tensor& y);

  PADDLE_API Tensor subtract(const Scalar& x, const Tensor& y);

  PADDLE_API Tensor multiply(const Scalar& x, const Tensor& y);

  PADDLE_API Tensor divide(const Scalar& x, const Tensor& y);

  PADDLE_API Tensor pow(const Tensor& x, const Tensor& y);

  PADDLE_API Tensor pow(const Tensor& x, const Scalar& y);


  PADDLE_API Tensor abs(const Tensor& x);

  PADDLE_API Tensor bitwise_and(const Tensor& x, const Tensor& y);

  PADDLE_API Tensor bitwise_not(const Tensor& x);

  PADDLE_API Tensor bitwise_or(const Tensor& x, const Tensor& y);

  PADDLE_API Tensor bitwise_xor(const Tensor& x, const Tensor& y);

  PADDLE_API Tensor exp(const Tensor& x);

  PADDLE_API Tensor expand(const Tensor& x, const IntArray& shape = {});

  PADDLE_API Tensor floor(const Tensor& x);

  PADDLE_API Tensor gather_nd(const Tensor& x, const Tensor& index);

  PADDLE_API Tensor log(const Tensor& x);

  PADDLE_API Tensor max(const Tensor& x, const IntArray& axis = {}, bool keepdim = false);

  PADDLE_API Tensor roll(const Tensor& x, const IntArray& shifts = {}, const std::vector<int64_t>& axis = {});

  PADDLE_API Tensor scale(const Tensor& x, const Scalar& scale = 1.0, const Scalar& bias = 0.0, bool bias_after_scale = true);

  PADDLE_API Tensor scatter(const Tensor& x, const Tensor& index, const Tensor& updates, bool overwrite = true);

  PADDLE_API Tensor scatter_nd_add(const Tensor& x, const Tensor& index, const Tensor& updates);

  PADDLE_API Tensor sum(const Tensor& x, const IntArray& axis = {}, DataType dtype = DataType::UNDEFINED, bool keepdim = false);

  PADDLE_API Tensor add(const Tensor& x, const Tensor& y);

  PADDLE_API Tensor assign(const Tensor& x);

  PADDLE_API Tensor divide(const Tensor& x, const Tensor& y);

  PADDLE_API Tensor elementwise_pow(const Tensor& x, const Tensor& y);

  PADDLE_API Tensor equal(const Tensor& x, const Tensor& y);

  PADDLE_API Tensor greater_equal(const Tensor& x, const Tensor& y);

  PADDLE_API Tensor greater_than(const Tensor& x, const Tensor& y);

  PADDLE_API Tensor less_equal(const Tensor& x, const Tensor& y);

  PADDLE_API Tensor less_than(const Tensor& x, const Tensor& y);

  PADDLE_API Tensor matmul(const Tensor& x, const Tensor& y, bool transpose_x = false, bool transpose_y = false);

  PADDLE_API Tensor maximum(const Tensor& x, const Tensor& y);

  PADDLE_API Tensor minimum(const Tensor& x, const Tensor& y);

  PADDLE_API Tensor multiply(const Tensor& x, const Tensor& y);

  PADDLE_API Tensor not_equal(const Tensor& x, const Tensor& y);

  PADDLE_API Tensor subtract(const Tensor& x, const Tensor& y);

  PADDLE_API Tensor tile(const Tensor& x, const IntArray& repeat_times = {});
};

}  // namespace operants
}  // namespace paddle

