"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DenoLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const deno_version_1 = require("./deno-version");
class DenoLayer extends lambda.LayerVersion {
    constructor(scope, id, options) {
        const version = options.version ?? deno_version_1.DenoVersion.V1_23_3;
        const image = aws_cdk_lib_1.DockerImage.fromBuild(path.join(__dirname, "../layer"), {
            buildArgs: { DENO_VERSION: version.version },
        });
        image.cp("/layer.zip", path.join(__dirname));
        const props = {
            code: lambda.Code.fromAsset(path.join(__dirname, "layer.zip")),
            description: "/bin/deno",
        };
        super(scope, id, props);
    }
    static getOrCreate(scope, options) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const id = "DenoLayer";
        const existing = stack.node.tryFindChild(id);
        return existing || new DenoLayer(stack, id, options);
    }
}
exports.DenoLayer = DenoLayer;
_a = JSII_RTTI_SYMBOL_1;
DenoLayer[_a] = { fqn: "@pepperize/cdk-lambda-deno.DenoLayer", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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