# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: c323500
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, Optional
from typing_extensions import Annotated
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class RespTenant(BaseModel):
    """
    Clean tenant response schema for listing.
    """ # noqa: E501
    id: UUID = Field(description="The unique identifier for the tenant")
    organization_id: UUID = Field(description="The ID of the organization this tenant belongs to")
    name: Annotated[str, Field(min_length=1, strict=True, max_length=255)] = Field(description="The name of the tenant")
    description: Optional[StrictStr] = Field(default=None, description="The description of the tenant")
    settings: Optional[Dict[str, Any]] = Field(default=None, description="Tenant settings that allows arbitrary keys.")
    deleted_at: Optional[datetime] = Field(default=None, description="When the tenant was deleted")
    __properties: ClassVar[List[str]] = ["id", "organization_id", "name", "description", "settings", "deleted_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespTenant from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespTenant from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "organization_id": obj.get("organization_id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "settings": obj.get("settings"),
            "deleted_at": obj.get("deleted_at")
        })
        return _obj


