# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: c323500
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, Optional
from knowledge_stack.models.chunk_type import ChunkType
from typing import Optional, Set
from typing_extensions import Self

class TurnAssetItem(BaseModel):
    """
    Schema for an asset (image/table) in a turn.
    """ # noqa: E501
    content: StrictStr = Field(description="Base64-encoded content of the asset (image/table)")
    chunk_type: ChunkType = Field(description="Type of chunk represented by the asset (IMAGE or TABLE)")
    summary: Optional[StrictStr] = Field(default=None, description="Optional summary description of the asset")
    __properties: ClassVar[List[str]] = ["content", "chunk_type", "summary"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TurnAssetItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TurnAssetItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "content": obj.get("content"),
            "chunk_type": obj.get("chunk_type"),
            "summary": obj.get("summary")
        })
        return _obj


