"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerConfigSecret = exports.TlsSecret = exports.ServiceAccountTokenSecret = exports.SshAuthSecret = exports.BasicAuthSecret = exports.Secret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const base = require("./base");
const container_1 = require("./container");
const k8s = require("./imports/k8s");
class ImportedSecret extends constructs_1.Construct {
    constructor(scope, id, name) {
        super(scope, id);
        this.resourceType = 'secrets';
        this._name = name;
    }
    get name() {
        return this._name;
    }
    get apiVersion() {
        return k8s.KubeSecret.GVK.apiVersion;
    }
    get apiGroup() {
        return '';
    }
    get kind() {
        return k8s.KubeSecret.GVK.kind;
    }
    get resourceName() {
        return this.name;
    }
    envValue(key, options) {
        return container_1.EnvValue.fromSecretValue({ secret: this, key }, options);
    }
}
/**
 * Kubernetes Secrets let you store and manage sensitive information, such as
 * passwords, OAuth tokens, and ssh keys. Storing confidential information in a
 * Secret is safer and more flexible than putting it verbatim in a Pod
 * definition or in a container image.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret
 */
class Secret extends base.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.resourceType = 'secrets';
        this.stringData = props.stringData ?? {};
        this.immutable = props.immutable ?? false;
        this.apiObject = new k8s.KubeSecret(this, 'Resource', {
            metadata: props.metadata,
            type: props.type,
            stringData: this.stringData,
            immutable: this.immutable,
        });
    }
    /**
     * Imports a secret from the cluster as a reference.
     */
    static fromSecretName(scope, id, name) {
        return new ImportedSecret(scope, id, name);
    }
    /**
     * Adds a string data field to the secert.
     * @param key Key
     * @param value Value
     */
    addStringData(key, value) {
        this.stringData[key] = value;
    }
    /**
     * Gets a string data by key or undefined
     * @param key Key
     */
    getStringData(key) {
        return this.stringData[key];
    }
    envValue(key, options) {
        return container_1.EnvValue.fromSecretValue({ secret: this, key }, options);
    }
}
exports.Secret = Secret;
_a = JSII_RTTI_SYMBOL_1;
Secret[_a] = { fqn: "cdk8s-plus-23.Secret", version: "2.4.2" };
/**
 * Create a secret for basic authentication.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#basic-authentication-secret
 */
class BasicAuthSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/basic-auth',
            stringData: {
                username: props.username,
                password: props.password,
            },
            immutable: props.immutable,
        });
    }
}
exports.BasicAuthSecret = BasicAuthSecret;
_b = JSII_RTTI_SYMBOL_1;
BasicAuthSecret[_b] = { fqn: "cdk8s-plus-23.BasicAuthSecret", version: "2.4.2" };
/**
 * Create a secret for ssh authentication.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#ssh-authentication-secrets
 */
class SshAuthSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/ssh-auth',
            stringData: {
                'ssh-privatekey': props.sshPrivateKey,
            },
            immutable: props.immutable,
        });
    }
}
exports.SshAuthSecret = SshAuthSecret;
_c = JSII_RTTI_SYMBOL_1;
SshAuthSecret[_c] = { fqn: "cdk8s-plus-23.SshAuthSecret", version: "2.4.2" };
/**
 * Create a secret for a service account token.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#service-account-token-secrets
 */
class ServiceAccountTokenSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/service-account-token',
            metadata: {
                annotations: {
                    'kubernetes.io/service-account.name': props.serviceAccount.name,
                },
            },
            immutable: props.immutable,
        });
    }
}
exports.ServiceAccountTokenSecret = ServiceAccountTokenSecret;
_d = JSII_RTTI_SYMBOL_1;
ServiceAccountTokenSecret[_d] = { fqn: "cdk8s-plus-23.ServiceAccountTokenSecret", version: "2.4.2" };
/**
 * Create a secret for storing a TLS certificate and its associated key.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#tls-secrets
 */
class TlsSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/tls',
            stringData: {
                'tls.crt': props.tlsCert,
                'tls.key': props.tlsKey,
            },
            immutable: props.immutable,
        });
    }
}
exports.TlsSecret = TlsSecret;
_e = JSII_RTTI_SYMBOL_1;
TlsSecret[_e] = { fqn: "cdk8s-plus-23.TlsSecret", version: "2.4.2" };
/**
 * Create a secret for storing credentials for accessing a container image
 * registry.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#docker-config-secrets
 */
class DockerConfigSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/dockerconfigjson',
            stringData: {
                '.dockerconfigjson': JSON.stringify(props.data),
            },
            immutable: props.immutable,
        });
    }
}
exports.DockerConfigSecret = DockerConfigSecret;
_f = JSII_RTTI_SYMBOL_1;
DockerConfigSecret[_f] = { fqn: "cdk8s-plus-23.DockerConfigSecret", version: "2.4.2" };
//# sourceMappingURL=data:application/json;base64,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