import abc
from . import StorageError as StorageError, base as base
from ..core.base import ExecutorEntity as ExecutorEntity, LoggingEntity as LoggingEntity
from ..core.formatter import FormattedEntity as FormattedEntity
from ..http import URL as URL
from ..net.web.client import Session as Session
from abc import abstractmethod
from typing import Any

class StorageConnectionError(StorageError): ...
class StorageDataFormatError(StorageError): ...

class AbstractHttpStorage(FormattedEntity, LoggingEntity, base.AbstractStorageReadOnly, metaclass=abc.ABCMeta):
    session: Any
    def __init__(self, *args, **kwargs) -> None: ...
    session_params: Any
    async def init(self) -> None: ...
    @abstractmethod
    async def session_factory(self, **kwargs): ...
    async def reset_session(self, **kwargs) -> None: ...
    async def stop(self) -> None: ...
    def raw_key(self, key): ...
    async def request(self, url, **kwargs): ...
    def get(self, key): ...
    async def copy(self, key_source, storage_dest, key_dest): ...

class RoStorage(ExecutorEntity, AbstractHttpStorage):
    def set_config(self, config) -> None: ...
    async def session_factory(self, **kwargs): ...
    async def request(self, url, **kwargs): ...

class Storage(RoStorage, base.AbstractStorageWriteOnly):
    def set(self, key, value): ...
