import abc
from .. import humanize as humanize, utils as utils
from ..utils import mapping_repr as mapping_repr
from abc import abstractmethod
from aioworkers.net.uri import URI as URI, URL as URL
from typing import Any, Callable, Iterator, Mapping, MutableMapping

logger: Any

class MergeDict(dict):
    def __init__(self, iterable: Any | None = ..., **kwargs) -> None: ...
    def __getattr__(self, item): ...
    def __setattr__(self, key, value) -> None: ...
    def __setitem__(self, key, value) -> None: ...
    def update(self, d, *args, **kwargs) -> None: ...
    def get(self, key, default: Any | None = ...): ...
    def __getitem__(self, item): ...
    def __contains__(self, key): ...
    def __call__(self, *args, **kwargs) -> None: ...
    def __dir__(self): ...
    def copy(self): ...

def merge(source: Mapping, destination: MutableMapping): ...

class ConfigFileLoader(metaclass=abc.ABCMeta):
    extensions: tuple
    mime_types: tuple
    @abstractmethod
    def load_str(self, s): ...
    def load_bytes(self, b): ...
    def load_fd(self, fd): ...
    def load_path(self, path): ...
    def load_url(self, url): ...

class YamlLoader(ConfigFileLoader):
    extensions: Any
    def __init__(self, *args, **kwargs): ...
    def load_str(self, s): ...

class JsonLoader(ConfigFileLoader):
    extensions: Any
    mime_types: Any
    def __init__(self, *args, **kwargs) -> None: ...
    def load_str(self, s): ...

class ValueMatcher(metaclass=abc.ABCMeta):
    fn: Callable
    def __init__(self, value) -> None: ...
    @abstractmethod
    def match(cls, value): ...
    @abstractmethod
    def get_value(self): ...

class IntValueMatcher(ValueMatcher):
    fn: Any
    @classmethod
    def match(cls, value): ...
    def get_value(self): ...

class BooleanValueMatcher(IntValueMatcher):
    true: Any
    false: Any
    @classmethod
    def fn(cls, value): ...

class FloatValueMatcher(IntValueMatcher):
    fn: Any

class MultilineValueMatcher(ValueMatcher):
    re: Any
    @classmethod
    def match(cls, value): ...
    def get_value(self): ...

class ListValueMatcher(ValueMatcher):
    @classmethod
    def match(cls, value): ...
    def get_value(self): ...

class StringReplaceLoader(ConfigFileLoader, metaclass=abc.ABCMeta):
    matchers: Any

class IniLoader(StringReplaceLoader):
    extensions: Any
    def __init__(self, *args, **kwargs) -> None: ...
    def new_configparser(self, **kwargs): ...
    def load_fd(self, fd): ...
    def load_path(self, path): ...
    def load_str(self, string): ...

class Registry(dict):
    def __call__(self, cls) -> None: ...
    def get(self, key): ...

registry: Any
extractors: Any

class ValueExtractor(Mapping):
    def __init__(self, mapping) -> None: ...
    def __setattr__(self, key, value) -> None: ...
    def new_child(self, *mappings, **kwargs) -> ValueExtractor: ...
    def new_parent(self, *mappings, **kwargs) -> ValueExtractor: ...
    def __getitem__(self, item): ...
    def get(self, item, default: Any | None = ...): ...
    def __contains__(self, item): ...
    def __getattr__(self, item): ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator: ...

class Config(ValueExtractor):
    env: Any
    logging: Any
    search_dirs: Any
    uris: Any
    def __init__(self, search_dirs=..., **kwargs) -> None: ...
    def load_conf(self, fd, *, path: Any | None = ..., mime_type: Any | None = ..., response: Any | None = ...): ...
    def load(self, *filenames, base: Any | None = ...): ...
    def update(self, *mappings, **kwargs) -> None: ...
    def load_plugins(self, *modules, force: bool = ...): ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator: ...
    def __getitem__(self, item): ...
    def __contains__(self, item): ...
