# coding: utf-8

"""
    NiFi Rest Api

    The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.5.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class VariableDTO(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'value': 'str',
        'process_group_id': 'str',
        'affected_components': 'list[AffectedComponentEntity]'
    }

    attribute_map = {
        'name': 'name',
        'value': 'value',
        'process_group_id': 'processGroupId',
        'affected_components': 'affectedComponents'
    }

    def __init__(self, name=None, value=None, process_group_id=None, affected_components=None):
        """
        VariableDTO - a model defined in Swagger
        """

        self._name = None
        self._value = None
        self._process_group_id = None
        self._affected_components = None

        if name is not None:
          self.name = name
        if value is not None:
          self.value = value
        if process_group_id is not None:
          self.process_group_id = process_group_id
        if affected_components is not None:
          self.affected_components = affected_components

    @property
    def name(self):
        """
        Gets the name of this VariableDTO.
        The name of the variable

        :return: The name of this VariableDTO.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this VariableDTO.
        The name of the variable

        :param name: The name of this VariableDTO.
        :type: str
        """

        self._name = name

    @property
    def value(self):
        """
        Gets the value of this VariableDTO.
        The value of the variable

        :return: The value of this VariableDTO.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this VariableDTO.
        The value of the variable

        :param value: The value of this VariableDTO.
        :type: str
        """

        self._value = value

    @property
    def process_group_id(self):
        """
        Gets the process_group_id of this VariableDTO.
        The ID of the Process Group where this Variable is defined

        :return: The process_group_id of this VariableDTO.
        :rtype: str
        """
        return self._process_group_id

    @process_group_id.setter
    def process_group_id(self, process_group_id):
        """
        Sets the process_group_id of this VariableDTO.
        The ID of the Process Group where this Variable is defined

        :param process_group_id: The process_group_id of this VariableDTO.
        :type: str
        """

        self._process_group_id = process_group_id

    @property
    def affected_components(self):
        """
        Gets the affected_components of this VariableDTO.
        A set of all components that will be affected if the value of this variable is changed

        :return: The affected_components of this VariableDTO.
        :rtype: list[AffectedComponentEntity]
        """
        return self._affected_components

    @affected_components.setter
    def affected_components(self, affected_components):
        """
        Sets the affected_components of this VariableDTO.
        A set of all components that will be affected if the value of this variable is changed

        :param affected_components: The affected_components of this VariableDTO.
        :type: list[AffectedComponentEntity]
        """

        self._affected_components = affected_components

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, VariableDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
