import platform
from selenium import webdriver
from selenium.webdriver.chrome.service import Service
from selenium.webdriver.chrome.options import Options
from selenium.common.exceptions import SessionNotCreatedException
from webdriver_manager.chrome import ChromeDriverManager

from .utils import get_localized_message

def setup_webdriver(lang) -> webdriver.Chrome:
    driver = None
    try:
        chrome_options = Options()
        system_platform = platform.system()
        if system_platform == "Linux":
            chrome_options.add_argument('--no-sandbox')
            chrome_options.add_argument('--disable-dev-shm-usage')
        elif system_platform == "Darwin":
            chrome_options.add_argument('--disable-infobars')
            chrome_options.add_argument('--disable-popup-blocking')
        elif system_platform == "Windows":
            chrome_options.add_argument('--disable-extensions')

        service = Service(ChromeDriverManager().install())
        driver = webdriver.Chrome(service=service, options=chrome_options)
        return driver

    except SessionNotCreatedException as e:
        raise RuntimeError(
            get_localized_message(
                "webdriver_version_mismatch", lang, e
            )
        )
    except Exception as e:
        if driver:
            driver.quit()
        raise RuntimeError(
            get_localized_message(
                "webdriver_setup_failed", lang, e
            )
        )