"use strict";
/*
 * Copyright 2018-2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(require("react"));
class PipelineSubmissionDialog extends React.Component {
    render() {
        const name = this.props.name;
        const runtimes = this.props.runtimes;
        return (React.createElement("form", null,
            React.createElement("label", { htmlFor: "pipeline_name" }, "Pipeline Name:"),
            React.createElement("br", null),
            React.createElement("input", { type: "text", id: "pipeline_name", name: "pipeline_name", defaultValue: name, "data-form-required": true }),
            React.createElement("br", null),
            React.createElement("br", null),
            React.createElement("label", { htmlFor: "runtime_config" }, "Runtime Config:"),
            React.createElement("br", null),
            React.createElement("select", { id: "runtime_config", name: "runtime_config", className: "elyra-form-runtime-config", "data-form-required": true }, runtimes.map(runtime => (React.createElement("option", { key: runtime.name, value: runtime.name }, runtime.display_name))))));
    }
}
exports.PipelineSubmissionDialog = PipelineSubmissionDialog;
//# sourceMappingURL=PipelineSubmissionDialog.js.map