"use strict";
/*
 * Copyright 2018-2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const application_1 = require("@elyra/application");
const ui_components_1 = require("@elyra/ui-components");
const apputils_1 = require("@jupyterlab/apputils");
const React = __importStar(require("react"));
const formDialogWidget_1 = require("./formDialogWidget");
const NotebookSubmissionDialog_1 = require("./NotebookSubmissionDialog");
const PipelineService_1 = require("./PipelineService");
const utils_1 = __importDefault(require("./utils"));
/**
 * Submit notebook button extension
 *  - Attach button to notebook toolbar and launch a dialog requesting
 *  information about the remote location to where submit the notebook
 *  for execution
 */
class SubmitNotebookButtonExtension {
    constructor() {
        this.showWidget = () => __awaiter(this, void 0, void 0, function* () {
            const env = application_1.NotebookParser.getEnvVars(this.panel.content.model.toString());
            const runtimes = yield PipelineService_1.PipelineService.getRuntimes();
            const images = yield PipelineService_1.PipelineService.getRuntimeImages();
            const dialogOptions = {
                title: 'Submit notebook',
                body: formDialogWidget_1.formDialogWidget(React.createElement(NotebookSubmissionDialog_1.NotebookSubmissionDialog, { env: env, runtimes: runtimes, images: images })),
                buttons: [apputils_1.Dialog.cancelButton(), apputils_1.Dialog.okButton()]
            };
            const dialogResult = yield ui_components_1.showFormDialog(dialogOptions);
            if (dialogResult.value == null) {
                // When Cancel is clicked on the dialog, just return
                return;
            }
            const _a = dialogResult.value, { runtime_config, framework, dependency_include, dependencies } = _a, envObject = __rest(_a, ["runtime_config", "framework", "dependency_include", "dependencies"]);
            // prepare notebook submission details
            const pipeline = utils_1.default.generateNotebookPipeline(this.panel.context.path, runtime_config, framework, dependency_include ? dependencies : undefined, envObject);
            const displayName = PipelineService_1.PipelineService.getDisplayName(runtime_config, runtimes);
            PipelineService_1.PipelineService.submitPipeline(pipeline, displayName);
        });
    }
    createNew(panel, context) {
        this.panel = panel;
        // Create the toolbar button
        const submitNotebookButton = new apputils_1.ToolbarButton({
            label: 'Submit Notebook ...',
            onClick: this.showWidget,
            tooltip: 'Submit Notebook ...'
        });
        // Add the toolbar button to the notebook
        panel.toolbar.insertItem(10, 'submitNotebook', submitNotebookButton);
        // The ToolbarButton class implements `IDisposable`, so the
        // button *is* the extension for the purposes of this method.
        return submitNotebookButton;
    }
}
exports.SubmitNotebookButtonExtension = SubmitNotebookButtonExtension;
//# sourceMappingURL=SubmitNotebookButtonExtension.js.map