import { CodeEditor } from '@jupyterlab/codeeditor';
import { DocumentRegistry } from '@jupyterlab/docregistry';
import { KernelManager, KernelSpec, KernelSpecManager, Session, SessionManager } from '@jupyterlab/services';
/**
 * Class: An enhanced Python Script Editor that enables developing and running the script
 */
export declare class PythonRunner {
    sessionManager: SessionManager;
    sessionConnection: Session.ISessionConnection;
    kernelSpecManager: KernelSpecManager;
    kernelManager: KernelManager;
    model: CodeEditor.IModel;
    context: DocumentRegistry.Context;
    disableRun: Function;
    /**
     * Construct a new runner.
     */
    constructor(model: CodeEditor.IModel, context: DocumentRegistry.Context, disableRun: Function);
    private errorDialog;
    /**
     * Function: Starts a session with a python kernel and executes code from file editor.
     */
    runPython: (kernelName: string, handleKernelMsg: Function) => Promise<any>;
    /**
     * Function: Gets available kernel specs.
     */
    getKernelSpecs: () => Promise<KernelSpec.ISpecModels>;
    /**
     * Function: Starts new kernel.
     */
    startSession: (kernelName: string) => Promise<Session.ISessionConnection>;
    /**
     * Function: Shuts down kernel.
     */
    shutdownSession: () => Promise<void>;
}
