import django_filters
from django.forms import CheckboxInput

class AssetFilter(django_filters.FilterSet):
    search = django_filters.CharFilter(
        lookup_expr="icontains", 
        field_name="name",
        label='Search'
    )

    cesmd_not_null = django_filters.BooleanFilter(
        label='On CESMD',
        widget=CheckboxInput(),
        method='filter_cesmd_exists'
    )

    # is_complete = django_filters.BooleanFilter(
    #     field_name='is_complete',
    #     label='Is Complete',
    #     widget=CheckboxInput()
    # )
    district = django_filters.CharFilter(
        label='District',
        method='filter_district'
    )

    max_year = django_filters.NumberFilter(
        label='Max Year',
        method='filter_year',
        # widget=django_filters.widgets.DateInput(attrs={'type': 'date'})
    )
    # max_year = django_filters.DateFilter(
    #     label='Max Year',
    #     field_name='nbi_data__NBI_BRIDGE__Year Built',
    #     lookup_expr='lte'
    # )
    def filter_year(self, queryset, name, value):
        ids = {
            asset.id for asset in queryset if (
                asset.nbi_data and int(asset.nbi_data["NBI_BRIDGE"]["Year Built"] or 0) <= int(value) #.year
            )
        }
        return queryset.filter(id__in=ids)
        if value:
            return queryset.filter(
                nbi_data__NBI_BRIDGE__Year_Built__lte=int(value) #.year
            )
        return 
    
        if value:
            filtered_ids = [
                asset.id for asset in queryset if (
                    asset.nbi_data and asset.nbi_data["NBI_BRIDGE"]["Year Built"] <= value.year
                )
            ]
            return queryset.filter(id__in=filtered_ids)
 

    def filter_cesmd_exists(self, queryset, name, value):
        if value:  # Checkbox is checked
            return queryset.exclude(cesmd__isnull=True).exclude(cesmd__exact='')
        return queryset

    def filter_district(self, queryset, name, value):
        return [
            asset for asset in queryset if (
                asset.nbi_data and asset.nbi_data["NBI_BRIDGE"]["Highway Agency District"] == value
            )
        ]
