/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.functionmanager;

import io.ray.runtime.functionmanager.FunctionDescriptor;
import io.ray.runtime.generated.Common;
import io.ray.shaded.com.google.common.base.Objects;
import java.util.Arrays;
import java.util.List;

public class PyFunctionDescriptor
implements FunctionDescriptor {
    public String moduleName;
    public String className;
    public String functionName;

    public PyFunctionDescriptor(String moduleName, String className, String functionName) {
        this.moduleName = moduleName;
        this.className = className;
        this.functionName = functionName;
    }

    public String toString() {
        return this.moduleName + "." + this.className + "." + this.functionName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyFunctionDescriptor that = (PyFunctionDescriptor)o;
        return Objects.equal(this.moduleName, that.moduleName) && Objects.equal(this.className, that.className) && Objects.equal(this.functionName, that.functionName);
    }

    public int hashCode() {
        return Objects.hashCode(this.moduleName, this.className, this.functionName);
    }

    @Override
    public List<String> toList() {
        return Arrays.asList(this.moduleName, this.className, this.functionName, "");
    }

    @Override
    public Common.Language getLanguage() {
        return Common.Language.PYTHON;
    }
}

