/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.util;

import com.google.gson.Gson;
import io.ray.runtime.config.RayConfig;
import io.ray.runtime.config.RunMode;
import io.ray.shaded.com.google.common.base.Preconditions;
import java.util.HashMap;

public class SystemConfig {
    private static RayConfig rayConfig = null;
    private static Gson gson = new Gson();
    private static HashMap<String, Object> cachedConfigs = new HashMap();
    public static final String KEY_TO_LARGEST_SIZE_PASS_BY_VALUE = "max_direct_call_object_size";

    public static synchronized void setup(RayConfig config) {
        rayConfig = config;
    }

    public static synchronized Object get(String key) {
        Preconditions.checkNotNull(rayConfig);
        if (SystemConfig.rayConfig.runMode == RunMode.LOCAL) {
            return SystemConfig.getInLocalMode(key);
        }
        if (cachedConfigs.containsKey(key)) {
            return cachedConfigs.get(key);
        }
        Object val = gson.fromJson(SystemConfig.nativeGetSystemConfig(key), Object.class);
        Preconditions.checkNotNull(val);
        cachedConfigs.put(key, val);
        return val;
    }

    public static synchronized long getLargestSizePassedByValue() {
        return ((Double)SystemConfig.get(KEY_TO_LARGEST_SIZE_PASS_BY_VALUE)).longValue();
    }

    private static Object getInLocalMode(String key) {
        if (KEY_TO_LARGEST_SIZE_PASS_BY_VALUE.equals(key)) {
            return 102400.0;
        }
        throw new RuntimeException(String.format("Unsupported key: %s", key));
    }

    private static native String nativeGetSystemConfig(String var0);
}

