/*
 * Decompiled with CFR 0.152.
 */
package io.ray.serve.deployment;

import io.ray.serve.api.Serve;
import io.ray.serve.config.DeploymentConfig;
import io.ray.serve.config.ReplicaConfig;
import io.ray.serve.dag.ClassNode;
import io.ray.serve.deployment.Application;
import io.ray.serve.deployment.DeploymentCreator;
import io.ray.serve.handle.DeploymentHandle;
import io.ray.shaded.com.google.common.base.Preconditions;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deployment {
    private static final Logger LOGGER = LoggerFactory.getLogger(Deployment.class);
    private final String name;
    private final DeploymentConfig deploymentConfig;
    private final ReplicaConfig replicaConfig;
    private final String version;
    private String routePrefix;
    private final String url;
    private boolean ingress;

    public Deployment(String name, DeploymentConfig deploymentConfig, ReplicaConfig replicaConfig, String version, String routePrefix) {
        if (StringUtils.isNotBlank(routePrefix)) {
            Preconditions.checkArgument(routePrefix.startsWith("/"), "route_prefix must start with '/'.");
            Preconditions.checkArgument(routePrefix.equals("/") || !routePrefix.endsWith("/"), "route_prefix must not end with '/' unless it's the root.");
            Preconditions.checkArgument(!routePrefix.contains("{") && !routePrefix.contains("}"), "route_prefix may not contain wildcards.");
        }
        Preconditions.checkArgument(version != null || deploymentConfig.getAutoscalingConfig() == null, "Currently autoscaling is only supported for versioned deployments. Try Serve.deployment.setVersion.");
        this.name = name;
        this.version = version;
        this.deploymentConfig = deploymentConfig;
        this.replicaConfig = replicaConfig;
        this.routePrefix = routePrefix;
        this.url = routePrefix != null ? Serve.getGlobalClient().getRootUrl() + routePrefix : null;
    }

    @Deprecated
    public DeploymentHandle getHandle() {
        LOGGER.warn("This API is deprecated and may be removed in future Ray releases. Please see https://docs.ray.io/en/latest/serve/index.html for more information.");
        return Serve.getGlobalClient().getDeploymentHandle(this.name, "", true);
    }

    public DeploymentCreator options() {
        return new DeploymentCreator().setDeploymentDef(this.replicaConfig.getDeploymentDef()).setName(this.name).setVersion(this.version).setNumReplicas(this.deploymentConfig.getNumReplicas()).setInitArgs(this.replicaConfig.getInitArgs()).setRoutePrefix(this.routePrefix).setRayActorOptions(this.replicaConfig.getRayActorOptions()).setUserConfig(this.deploymentConfig.getUserConfig()).setMaxConcurrentQueries(this.deploymentConfig.getMaxConcurrentQueries()).setAutoscalingConfig(this.deploymentConfig.getAutoscalingConfig()).setGracefulShutdownWaitLoopS(this.deploymentConfig.getGracefulShutdownWaitLoopS()).setGracefulShutdownTimeoutS(this.deploymentConfig.getGracefulShutdownTimeoutS()).setHealthCheckPeriodS(this.deploymentConfig.getHealthCheckPeriodS()).setHealthCheckTimeoutS(this.deploymentConfig.getHealthCheckTimeoutS()).setLanguage(this.deploymentConfig.getDeploymentLanguage());
    }

    public Application bind(Object ... args) {
        HashMap<String, Object> otherArgsToResolve = new HashMap<String, Object>();
        otherArgsToResolve.put("deployment_schema", this);
        otherArgsToResolve.put("is_from_serve_deployment", true);
        ClassNode dagNode = new ClassNode(this.replicaConfig.getDeploymentDef(), args, this.replicaConfig.getRayActorOptions(), otherArgsToResolve);
        return Application.fromInternalDagNode(dagNode);
    }

    public String getName() {
        return this.name;
    }

    public DeploymentConfig getDeploymentConfig() {
        return this.deploymentConfig;
    }

    public ReplicaConfig getReplicaConfig() {
        return this.replicaConfig;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRoutePrefix() {
        return this.routePrefix;
    }

    public String getUrl() {
        return this.url;
    }

    public void setRoutePrefix(String routePrefix) {
        this.routePrefix = routePrefix;
    }

    public boolean isIngress() {
        return this.ingress;
    }

    public void setIngress(boolean ingress) {
        this.ingress = ingress;
    }
}

