# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRemediationRunResult',
    'AwaitableGetRemediationRunResult',
    'get_remediation_run',
    'get_remediation_run_output',
]

@pulumi.output_type
class GetRemediationRunResult:
    """
    A collection of values returned by getRemediationRun.
    """
    def __init__(__self__, compartment_id=None, current_stage_type=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, remediation_recipe_id=None, remediation_run_id=None, remediation_run_source=None, stages=None, state=None, system_tags=None, time_created=None, time_finished=None, time_started=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if current_stage_type and not isinstance(current_stage_type, str):
            raise TypeError("Expected argument 'current_stage_type' to be a str")
        pulumi.set(__self__, "current_stage_type", current_stage_type)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if remediation_recipe_id and not isinstance(remediation_recipe_id, str):
            raise TypeError("Expected argument 'remediation_recipe_id' to be a str")
        pulumi.set(__self__, "remediation_recipe_id", remediation_recipe_id)
        if remediation_run_id and not isinstance(remediation_run_id, str):
            raise TypeError("Expected argument 'remediation_run_id' to be a str")
        pulumi.set(__self__, "remediation_run_id", remediation_run_id)
        if remediation_run_source and not isinstance(remediation_run_source, str):
            raise TypeError("Expected argument 'remediation_run_source' to be a str")
        pulumi.set(__self__, "remediation_run_source", remediation_run_source)
        if stages and not isinstance(stages, list):
            raise TypeError("Expected argument 'stages' to be a list")
        pulumi.set(__self__, "stages", stages)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_finished and not isinstance(time_finished, str):
            raise TypeError("Expected argument 'time_finished' to be a str")
        pulumi.set(__self__, "time_finished", time_finished)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the remediation run.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="currentStageType")
    def current_stage_type(self) -> str:
        """
        The type of the current stage of the remediation run.
        """
        return pulumi.get(self, "current_stage_type")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The name of the remediation run.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the remediation run.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="remediationRecipeId")
    def remediation_recipe_id(self) -> str:
        """
        The Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the Remediation Recipe.
        """
        return pulumi.get(self, "remediation_recipe_id")

    @property
    @pulumi.getter(name="remediationRunId")
    def remediation_run_id(self) -> str:
        return pulumi.get(self, "remediation_run_id")

    @property
    @pulumi.getter(name="remediationRunSource")
    def remediation_run_source(self) -> str:
        """
        The source that triggered the Remediation Recipe.
        """
        return pulumi.get(self, "remediation_run_source")

    @property
    @pulumi.getter
    def stages(self) -> Sequence['outputs.GetRemediationRunStageResult']:
        """
        The list of remediation run stage summaries.
        """
        return pulumi.get(self, "stages")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the remediation run.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The creation date and time of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> str:
        """
        The date and time of the finish of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        The date and time of the start of the remediation run (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the remediation run was last updated (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetRemediationRunResult(GetRemediationRunResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRemediationRunResult(
            compartment_id=self.compartment_id,
            current_stage_type=self.current_stage_type,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            remediation_recipe_id=self.remediation_recipe_id,
            remediation_run_id=self.remediation_run_id,
            remediation_run_source=self.remediation_run_source,
            stages=self.stages,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_finished=self.time_finished,
            time_started=self.time_started,
            time_updated=self.time_updated)


def get_remediation_run(remediation_run_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRemediationRunResult:
    """
    This data source provides details about a specific Remediation Run resource in Oracle Cloud Infrastructure Adm service.

    Returns the details of the specified remediation run.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_remediation_run = oci.Adm.get_remediation_run(remediation_run_id=test_remediation_run_oci_adm_remediation_run["id"])
    ```


    :param str remediation_run_id: Unique Remediation Run identifier path parameter.
    """
    __args__ = dict()
    __args__['remediationRunId'] = remediation_run_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Adm/getRemediationRun:getRemediationRun', __args__, opts=opts, typ=GetRemediationRunResult).value

    return AwaitableGetRemediationRunResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        current_stage_type=pulumi.get(__ret__, 'current_stage_type'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        remediation_recipe_id=pulumi.get(__ret__, 'remediation_recipe_id'),
        remediation_run_id=pulumi.get(__ret__, 'remediation_run_id'),
        remediation_run_source=pulumi.get(__ret__, 'remediation_run_source'),
        stages=pulumi.get(__ret__, 'stages'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_finished=pulumi.get(__ret__, 'time_finished'),
        time_started=pulumi.get(__ret__, 'time_started'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_remediation_run_output(remediation_run_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRemediationRunResult]:
    """
    This data source provides details about a specific Remediation Run resource in Oracle Cloud Infrastructure Adm service.

    Returns the details of the specified remediation run.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_remediation_run = oci.Adm.get_remediation_run(remediation_run_id=test_remediation_run_oci_adm_remediation_run["id"])
    ```


    :param str remediation_run_id: Unique Remediation Run identifier path parameter.
    """
    __args__ = dict()
    __args__['remediationRunId'] = remediation_run_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Adm/getRemediationRun:getRemediationRun', __args__, opts=opts, typ=GetRemediationRunResult)
    return __ret__.apply(lambda __response__: GetRemediationRunResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        current_stage_type=pulumi.get(__response__, 'current_stage_type'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        remediation_recipe_id=pulumi.get(__response__, 'remediation_recipe_id'),
        remediation_run_id=pulumi.get(__response__, 'remediation_run_id'),
        remediation_run_source=pulumi.get(__response__, 'remediation_run_source'),
        stages=pulumi.get(__response__, 'stages'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_finished=pulumi.get(__response__, 'time_finished'),
        time_started=pulumi.get(__response__, 'time_started'),
        time_updated=pulumi.get(__response__, 'time_updated')))
