# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBdsInstanceResult',
    'AwaitableGetBdsInstanceResult',
    'get_bds_instance',
    'get_bds_instance_output',
]

@pulumi.output_type
class GetBdsInstanceResult:
    """
    A collection of values returned by getBdsInstance.
    """
    def __init__(__self__, bds_instance_id=None, bootstrap_script_url=None, cloud_sql_details=None, cluster_admin_password=None, cluster_details=None, cluster_profile=None, cluster_public_key=None, cluster_version=None, compartment_id=None, compute_only_worker_nodes=None, created_by=None, defined_tags=None, display_name=None, edge_nodes=None, freeform_tags=None, id=None, ignore_existing_nodes_shapes=None, is_cloud_sql_configured=None, is_force_stop_jobs=None, is_high_availability=None, is_kafka_configured=None, is_secure=None, kafka_broker_nodes=None, kerberos_realm_name=None, kms_key_id=None, master_nodes=None, network_configs=None, nodes=None, number_of_nodes=None, number_of_nodes_requiring_maintenance_reboot=None, os_patch_version=None, state=None, time_created=None, time_updated=None, util_nodes=None, worker_nodes=None):
        if bds_instance_id and not isinstance(bds_instance_id, str):
            raise TypeError("Expected argument 'bds_instance_id' to be a str")
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if bootstrap_script_url and not isinstance(bootstrap_script_url, str):
            raise TypeError("Expected argument 'bootstrap_script_url' to be a str")
        pulumi.set(__self__, "bootstrap_script_url", bootstrap_script_url)
        if cloud_sql_details and not isinstance(cloud_sql_details, list):
            raise TypeError("Expected argument 'cloud_sql_details' to be a list")
        pulumi.set(__self__, "cloud_sql_details", cloud_sql_details)
        if cluster_admin_password and not isinstance(cluster_admin_password, str):
            raise TypeError("Expected argument 'cluster_admin_password' to be a str")
        pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        if cluster_details and not isinstance(cluster_details, list):
            raise TypeError("Expected argument 'cluster_details' to be a list")
        pulumi.set(__self__, "cluster_details", cluster_details)
        if cluster_profile and not isinstance(cluster_profile, str):
            raise TypeError("Expected argument 'cluster_profile' to be a str")
        pulumi.set(__self__, "cluster_profile", cluster_profile)
        if cluster_public_key and not isinstance(cluster_public_key, str):
            raise TypeError("Expected argument 'cluster_public_key' to be a str")
        pulumi.set(__self__, "cluster_public_key", cluster_public_key)
        if cluster_version and not isinstance(cluster_version, str):
            raise TypeError("Expected argument 'cluster_version' to be a str")
        pulumi.set(__self__, "cluster_version", cluster_version)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_only_worker_nodes and not isinstance(compute_only_worker_nodes, list):
            raise TypeError("Expected argument 'compute_only_worker_nodes' to be a list")
        pulumi.set(__self__, "compute_only_worker_nodes", compute_only_worker_nodes)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if edge_nodes and not isinstance(edge_nodes, list):
            raise TypeError("Expected argument 'edge_nodes' to be a list")
        pulumi.set(__self__, "edge_nodes", edge_nodes)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ignore_existing_nodes_shapes and not isinstance(ignore_existing_nodes_shapes, list):
            raise TypeError("Expected argument 'ignore_existing_nodes_shapes' to be a list")
        pulumi.set(__self__, "ignore_existing_nodes_shapes", ignore_existing_nodes_shapes)
        if is_cloud_sql_configured and not isinstance(is_cloud_sql_configured, bool):
            raise TypeError("Expected argument 'is_cloud_sql_configured' to be a bool")
        pulumi.set(__self__, "is_cloud_sql_configured", is_cloud_sql_configured)
        if is_force_stop_jobs and not isinstance(is_force_stop_jobs, bool):
            raise TypeError("Expected argument 'is_force_stop_jobs' to be a bool")
        pulumi.set(__self__, "is_force_stop_jobs", is_force_stop_jobs)
        if is_high_availability and not isinstance(is_high_availability, bool):
            raise TypeError("Expected argument 'is_high_availability' to be a bool")
        pulumi.set(__self__, "is_high_availability", is_high_availability)
        if is_kafka_configured and not isinstance(is_kafka_configured, bool):
            raise TypeError("Expected argument 'is_kafka_configured' to be a bool")
        pulumi.set(__self__, "is_kafka_configured", is_kafka_configured)
        if is_secure and not isinstance(is_secure, bool):
            raise TypeError("Expected argument 'is_secure' to be a bool")
        pulumi.set(__self__, "is_secure", is_secure)
        if kafka_broker_nodes and not isinstance(kafka_broker_nodes, list):
            raise TypeError("Expected argument 'kafka_broker_nodes' to be a list")
        pulumi.set(__self__, "kafka_broker_nodes", kafka_broker_nodes)
        if kerberos_realm_name and not isinstance(kerberos_realm_name, str):
            raise TypeError("Expected argument 'kerberos_realm_name' to be a str")
        pulumi.set(__self__, "kerberos_realm_name", kerberos_realm_name)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if master_nodes and not isinstance(master_nodes, list):
            raise TypeError("Expected argument 'master_nodes' to be a list")
        pulumi.set(__self__, "master_nodes", master_nodes)
        if network_configs and not isinstance(network_configs, list):
            raise TypeError("Expected argument 'network_configs' to be a list")
        pulumi.set(__self__, "network_configs", network_configs)
        if nodes and not isinstance(nodes, list):
            raise TypeError("Expected argument 'nodes' to be a list")
        pulumi.set(__self__, "nodes", nodes)
        if number_of_nodes and not isinstance(number_of_nodes, int):
            raise TypeError("Expected argument 'number_of_nodes' to be a int")
        pulumi.set(__self__, "number_of_nodes", number_of_nodes)
        if number_of_nodes_requiring_maintenance_reboot and not isinstance(number_of_nodes_requiring_maintenance_reboot, int):
            raise TypeError("Expected argument 'number_of_nodes_requiring_maintenance_reboot' to be a int")
        pulumi.set(__self__, "number_of_nodes_requiring_maintenance_reboot", number_of_nodes_requiring_maintenance_reboot)
        if os_patch_version and not isinstance(os_patch_version, str):
            raise TypeError("Expected argument 'os_patch_version' to be a str")
        pulumi.set(__self__, "os_patch_version", os_patch_version)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if util_nodes and not isinstance(util_nodes, list):
            raise TypeError("Expected argument 'util_nodes' to be a list")
        pulumi.set(__self__, "util_nodes", util_nodes)
        if worker_nodes and not isinstance(worker_nodes, list):
            raise TypeError("Expected argument 'worker_nodes' to be a list")
        pulumi.set(__self__, "worker_nodes", worker_nodes)

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> str:
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter(name="bootstrapScriptUrl")
    def bootstrap_script_url(self) -> str:
        """
        pre-authenticated URL of the bootstrap script in Object Store that can be downloaded and executed.
        """
        return pulumi.get(self, "bootstrap_script_url")

    @property
    @pulumi.getter(name="cloudSqlDetails")
    def cloud_sql_details(self) -> Sequence['outputs.GetBdsInstanceCloudSqlDetailResult']:
        """
        The information about added Cloud SQL capability
        """
        return pulumi.get(self, "cloud_sql_details")

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> str:
        return pulumi.get(self, "cluster_admin_password")

    @property
    @pulumi.getter(name="clusterDetails")
    def cluster_details(self) -> Sequence['outputs.GetBdsInstanceClusterDetailResult']:
        """
        Specific info about a Hadoop cluster
        """
        return pulumi.get(self, "cluster_details")

    @property
    @pulumi.getter(name="clusterProfile")
    def cluster_profile(self) -> str:
        """
        Profile of the Big Data Service cluster.
        """
        return pulumi.get(self, "cluster_profile")

    @property
    @pulumi.getter(name="clusterPublicKey")
    def cluster_public_key(self) -> str:
        return pulumi.get(self, "cluster_public_key")

    @property
    @pulumi.getter(name="clusterVersion")
    def cluster_version(self) -> str:
        """
        Version of the Hadoop distribution.
        """
        return pulumi.get(self, "cluster_version")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeOnlyWorkerNodes")
    def compute_only_worker_nodes(self) -> Sequence['outputs.GetBdsInstanceComputeOnlyWorkerNodeResult']:
        return pulumi.get(self, "compute_only_worker_nodes")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        The user who created the cluster.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For example, `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The name of the node.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="edgeNodes")
    def edge_nodes(self) -> Sequence['outputs.GetBdsInstanceEdgeNodeResult']:
        return pulumi.get(self, "edge_nodes")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. For example, `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the Big Data Service resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ignoreExistingNodesShapes")
    def ignore_existing_nodes_shapes(self) -> Sequence[str]:
        return pulumi.get(self, "ignore_existing_nodes_shapes")

    @property
    @pulumi.getter(name="isCloudSqlConfigured")
    def is_cloud_sql_configured(self) -> bool:
        """
        Boolean flag specifying whether or not Cloud SQL should be configured.
        """
        return pulumi.get(self, "is_cloud_sql_configured")

    @property
    @pulumi.getter(name="isForceStopJobs")
    def is_force_stop_jobs(self) -> bool:
        return pulumi.get(self, "is_force_stop_jobs")

    @property
    @pulumi.getter(name="isHighAvailability")
    def is_high_availability(self) -> bool:
        """
        Boolean flag specifying whether or not the cluster is highly available (HA)
        """
        return pulumi.get(self, "is_high_availability")

    @property
    @pulumi.getter(name="isKafkaConfigured")
    def is_kafka_configured(self) -> bool:
        """
        Boolean flag specifying whether or not Kafka should be configured.
        """
        return pulumi.get(self, "is_kafka_configured")

    @property
    @pulumi.getter(name="isSecure")
    def is_secure(self) -> bool:
        """
        Boolean flag specifying whether or not the cluster should be set up as secure.
        """
        return pulumi.get(self, "is_secure")

    @property
    @pulumi.getter(name="kafkaBrokerNodes")
    def kafka_broker_nodes(self) -> Sequence['outputs.GetBdsInstanceKafkaBrokerNodeResult']:
        return pulumi.get(self, "kafka_broker_nodes")

    @property
    @pulumi.getter(name="kerberosRealmName")
    def kerberos_realm_name(self) -> str:
        return pulumi.get(self, "kerberos_realm_name")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        The OCID of the Key Management master encryption key.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="masterNodes")
    def master_nodes(self) -> Sequence['outputs.GetBdsInstanceMasterNodeResult']:
        return pulumi.get(self, "master_nodes")

    @property
    @pulumi.getter(name="networkConfigs")
    def network_configs(self) -> Sequence['outputs.GetBdsInstanceNetworkConfigResult']:
        """
        Additional configuration of the user's network.
        """
        return pulumi.get(self, "network_configs")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetBdsInstanceNodeResult']:
        """
        The list of nodes in the cluster.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="numberOfNodes")
    def number_of_nodes(self) -> int:
        """
        The number of nodes that form the cluster.
        """
        return pulumi.get(self, "number_of_nodes")

    @property
    @pulumi.getter(name="numberOfNodesRequiringMaintenanceReboot")
    def number_of_nodes_requiring_maintenance_reboot(self) -> int:
        """
        Number of nodes that require a maintenance reboot
        """
        return pulumi.get(self, "number_of_nodes_requiring_maintenance_reboot")

    @property
    @pulumi.getter(name="osPatchVersion")
    def os_patch_version(self) -> str:
        return pulumi.get(self, "os_patch_version")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the cluster.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the cluster was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the cluster was updated, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="utilNodes")
    def util_nodes(self) -> Sequence['outputs.GetBdsInstanceUtilNodeResult']:
        return pulumi.get(self, "util_nodes")

    @property
    @pulumi.getter(name="workerNodes")
    def worker_nodes(self) -> Sequence['outputs.GetBdsInstanceWorkerNodeResult']:
        return pulumi.get(self, "worker_nodes")


class AwaitableGetBdsInstanceResult(GetBdsInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBdsInstanceResult(
            bds_instance_id=self.bds_instance_id,
            bootstrap_script_url=self.bootstrap_script_url,
            cloud_sql_details=self.cloud_sql_details,
            cluster_admin_password=self.cluster_admin_password,
            cluster_details=self.cluster_details,
            cluster_profile=self.cluster_profile,
            cluster_public_key=self.cluster_public_key,
            cluster_version=self.cluster_version,
            compartment_id=self.compartment_id,
            compute_only_worker_nodes=self.compute_only_worker_nodes,
            created_by=self.created_by,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            edge_nodes=self.edge_nodes,
            freeform_tags=self.freeform_tags,
            id=self.id,
            ignore_existing_nodes_shapes=self.ignore_existing_nodes_shapes,
            is_cloud_sql_configured=self.is_cloud_sql_configured,
            is_force_stop_jobs=self.is_force_stop_jobs,
            is_high_availability=self.is_high_availability,
            is_kafka_configured=self.is_kafka_configured,
            is_secure=self.is_secure,
            kafka_broker_nodes=self.kafka_broker_nodes,
            kerberos_realm_name=self.kerberos_realm_name,
            kms_key_id=self.kms_key_id,
            master_nodes=self.master_nodes,
            network_configs=self.network_configs,
            nodes=self.nodes,
            number_of_nodes=self.number_of_nodes,
            number_of_nodes_requiring_maintenance_reboot=self.number_of_nodes_requiring_maintenance_reboot,
            os_patch_version=self.os_patch_version,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated,
            util_nodes=self.util_nodes,
            worker_nodes=self.worker_nodes)


def get_bds_instance(bds_instance_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBdsInstanceResult:
    """
    This data source provides details about a specific Bds Instance resource in Oracle Cloud Infrastructure Big Data Service service.

    Returns information about the Big Data Service cluster identified by the given ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance = oci.BigDataService.get_bds_instance(bds_instance_id=test_bds_instance_oci_bds_bds_instance["id"])
    ```


    :param str bds_instance_id: The OCID of the cluster.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:BigDataService/getBdsInstance:getBdsInstance', __args__, opts=opts, typ=GetBdsInstanceResult).value

    return AwaitableGetBdsInstanceResult(
        bds_instance_id=pulumi.get(__ret__, 'bds_instance_id'),
        bootstrap_script_url=pulumi.get(__ret__, 'bootstrap_script_url'),
        cloud_sql_details=pulumi.get(__ret__, 'cloud_sql_details'),
        cluster_admin_password=pulumi.get(__ret__, 'cluster_admin_password'),
        cluster_details=pulumi.get(__ret__, 'cluster_details'),
        cluster_profile=pulumi.get(__ret__, 'cluster_profile'),
        cluster_public_key=pulumi.get(__ret__, 'cluster_public_key'),
        cluster_version=pulumi.get(__ret__, 'cluster_version'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compute_only_worker_nodes=pulumi.get(__ret__, 'compute_only_worker_nodes'),
        created_by=pulumi.get(__ret__, 'created_by'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        edge_nodes=pulumi.get(__ret__, 'edge_nodes'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        ignore_existing_nodes_shapes=pulumi.get(__ret__, 'ignore_existing_nodes_shapes'),
        is_cloud_sql_configured=pulumi.get(__ret__, 'is_cloud_sql_configured'),
        is_force_stop_jobs=pulumi.get(__ret__, 'is_force_stop_jobs'),
        is_high_availability=pulumi.get(__ret__, 'is_high_availability'),
        is_kafka_configured=pulumi.get(__ret__, 'is_kafka_configured'),
        is_secure=pulumi.get(__ret__, 'is_secure'),
        kafka_broker_nodes=pulumi.get(__ret__, 'kafka_broker_nodes'),
        kerberos_realm_name=pulumi.get(__ret__, 'kerberos_realm_name'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        master_nodes=pulumi.get(__ret__, 'master_nodes'),
        network_configs=pulumi.get(__ret__, 'network_configs'),
        nodes=pulumi.get(__ret__, 'nodes'),
        number_of_nodes=pulumi.get(__ret__, 'number_of_nodes'),
        number_of_nodes_requiring_maintenance_reboot=pulumi.get(__ret__, 'number_of_nodes_requiring_maintenance_reboot'),
        os_patch_version=pulumi.get(__ret__, 'os_patch_version'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        util_nodes=pulumi.get(__ret__, 'util_nodes'),
        worker_nodes=pulumi.get(__ret__, 'worker_nodes'))
def get_bds_instance_output(bds_instance_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBdsInstanceResult]:
    """
    This data source provides details about a specific Bds Instance resource in Oracle Cloud Infrastructure Big Data Service service.

    Returns information about the Big Data Service cluster identified by the given ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance = oci.BigDataService.get_bds_instance(bds_instance_id=test_bds_instance_oci_bds_bds_instance["id"])
    ```


    :param str bds_instance_id: The OCID of the cluster.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:BigDataService/getBdsInstance:getBdsInstance', __args__, opts=opts, typ=GetBdsInstanceResult)
    return __ret__.apply(lambda __response__: GetBdsInstanceResult(
        bds_instance_id=pulumi.get(__response__, 'bds_instance_id'),
        bootstrap_script_url=pulumi.get(__response__, 'bootstrap_script_url'),
        cloud_sql_details=pulumi.get(__response__, 'cloud_sql_details'),
        cluster_admin_password=pulumi.get(__response__, 'cluster_admin_password'),
        cluster_details=pulumi.get(__response__, 'cluster_details'),
        cluster_profile=pulumi.get(__response__, 'cluster_profile'),
        cluster_public_key=pulumi.get(__response__, 'cluster_public_key'),
        cluster_version=pulumi.get(__response__, 'cluster_version'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compute_only_worker_nodes=pulumi.get(__response__, 'compute_only_worker_nodes'),
        created_by=pulumi.get(__response__, 'created_by'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        edge_nodes=pulumi.get(__response__, 'edge_nodes'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        ignore_existing_nodes_shapes=pulumi.get(__response__, 'ignore_existing_nodes_shapes'),
        is_cloud_sql_configured=pulumi.get(__response__, 'is_cloud_sql_configured'),
        is_force_stop_jobs=pulumi.get(__response__, 'is_force_stop_jobs'),
        is_high_availability=pulumi.get(__response__, 'is_high_availability'),
        is_kafka_configured=pulumi.get(__response__, 'is_kafka_configured'),
        is_secure=pulumi.get(__response__, 'is_secure'),
        kafka_broker_nodes=pulumi.get(__response__, 'kafka_broker_nodes'),
        kerberos_realm_name=pulumi.get(__response__, 'kerberos_realm_name'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        master_nodes=pulumi.get(__response__, 'master_nodes'),
        network_configs=pulumi.get(__response__, 'network_configs'),
        nodes=pulumi.get(__response__, 'nodes'),
        number_of_nodes=pulumi.get(__response__, 'number_of_nodes'),
        number_of_nodes_requiring_maintenance_reboot=pulumi.get(__response__, 'number_of_nodes_requiring_maintenance_reboot'),
        os_patch_version=pulumi.get(__response__, 'os_patch_version'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        util_nodes=pulumi.get(__response__, 'util_nodes'),
        worker_nodes=pulumi.get(__response__, 'worker_nodes')))
