# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBlockchainPlatformPatchesResult',
    'AwaitableGetBlockchainPlatformPatchesResult',
    'get_blockchain_platform_patches',
    'get_blockchain_platform_patches_output',
]

@pulumi.output_type
class GetBlockchainPlatformPatchesResult:
    """
    A collection of values returned by getBlockchainPlatformPatches.
    """
    def __init__(__self__, blockchain_platform_id=None, blockchain_platform_patch_collections=None, filters=None, id=None):
        if blockchain_platform_id and not isinstance(blockchain_platform_id, str):
            raise TypeError("Expected argument 'blockchain_platform_id' to be a str")
        pulumi.set(__self__, "blockchain_platform_id", blockchain_platform_id)
        if blockchain_platform_patch_collections and not isinstance(blockchain_platform_patch_collections, list):
            raise TypeError("Expected argument 'blockchain_platform_patch_collections' to be a list")
        pulumi.set(__self__, "blockchain_platform_patch_collections", blockchain_platform_patch_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="blockchainPlatformId")
    def blockchain_platform_id(self) -> str:
        return pulumi.get(self, "blockchain_platform_id")

    @property
    @pulumi.getter(name="blockchainPlatformPatchCollections")
    def blockchain_platform_patch_collections(self) -> Sequence['outputs.GetBlockchainPlatformPatchesBlockchainPlatformPatchCollectionResult']:
        """
        The list of blockchain_platform_patch_collection.
        """
        return pulumi.get(self, "blockchain_platform_patch_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBlockchainPlatformPatchesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetBlockchainPlatformPatchesResult(GetBlockchainPlatformPatchesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBlockchainPlatformPatchesResult(
            blockchain_platform_id=self.blockchain_platform_id,
            blockchain_platform_patch_collections=self.blockchain_platform_patch_collections,
            filters=self.filters,
            id=self.id)


def get_blockchain_platform_patches(blockchain_platform_id: Optional[str] = None,
                                    filters: Optional[Sequence[Union['GetBlockchainPlatformPatchesFilterArgs', 'GetBlockchainPlatformPatchesFilterArgsDict']]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBlockchainPlatformPatchesResult:
    """
    This data source provides the list of Blockchain Platform Patches in Oracle Cloud Infrastructure Blockchain service.

    List Blockchain Platform Patches

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_blockchain_platform_patches = oci.Blockchain.get_blockchain_platform_patches(blockchain_platform_id=test_blockchain_platform["id"])
    ```


    :param str blockchain_platform_id: Unique service identifier.
    """
    __args__ = dict()
    __args__['blockchainPlatformId'] = blockchain_platform_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Blockchain/getBlockchainPlatformPatches:getBlockchainPlatformPatches', __args__, opts=opts, typ=GetBlockchainPlatformPatchesResult).value

    return AwaitableGetBlockchainPlatformPatchesResult(
        blockchain_platform_id=pulumi.get(__ret__, 'blockchain_platform_id'),
        blockchain_platform_patch_collections=pulumi.get(__ret__, 'blockchain_platform_patch_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_blockchain_platform_patches_output(blockchain_platform_id: Optional[pulumi.Input[str]] = None,
                                           filters: Optional[pulumi.Input[Optional[Sequence[Union['GetBlockchainPlatformPatchesFilterArgs', 'GetBlockchainPlatformPatchesFilterArgsDict']]]]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBlockchainPlatformPatchesResult]:
    """
    This data source provides the list of Blockchain Platform Patches in Oracle Cloud Infrastructure Blockchain service.

    List Blockchain Platform Patches

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_blockchain_platform_patches = oci.Blockchain.get_blockchain_platform_patches(blockchain_platform_id=test_blockchain_platform["id"])
    ```


    :param str blockchain_platform_id: Unique service identifier.
    """
    __args__ = dict()
    __args__['blockchainPlatformId'] = blockchain_platform_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Blockchain/getBlockchainPlatformPatches:getBlockchainPlatformPatches', __args__, opts=opts, typ=GetBlockchainPlatformPatchesResult)
    return __ret__.apply(lambda __response__: GetBlockchainPlatformPatchesResult(
        blockchain_platform_id=pulumi.get(__response__, 'blockchain_platform_id'),
        blockchain_platform_patch_collections=pulumi.get(__response__, 'blockchain_platform_patch_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
