# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOccCapacityRequestResult',
    'AwaitableGetOccCapacityRequestResult',
    'get_occ_capacity_request',
    'get_occ_capacity_request_output',
]

@pulumi.output_type
class GetOccCapacityRequestResult:
    """
    A collection of values returned by getOccCapacityRequest.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, date_expected_capacity_handover=None, defined_tags=None, description=None, details=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, namespace=None, occ_availability_catalog_id=None, occ_capacity_request_id=None, occ_customer_group_id=None, patch_operations=None, region=None, request_state=None, request_type=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if date_expected_capacity_handover and not isinstance(date_expected_capacity_handover, str):
            raise TypeError("Expected argument 'date_expected_capacity_handover' to be a str")
        pulumi.set(__self__, "date_expected_capacity_handover", date_expected_capacity_handover)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if details and not isinstance(details, list):
            raise TypeError("Expected argument 'details' to be a list")
        pulumi.set(__self__, "details", details)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if occ_availability_catalog_id and not isinstance(occ_availability_catalog_id, str):
            raise TypeError("Expected argument 'occ_availability_catalog_id' to be a str")
        pulumi.set(__self__, "occ_availability_catalog_id", occ_availability_catalog_id)
        if occ_capacity_request_id and not isinstance(occ_capacity_request_id, str):
            raise TypeError("Expected argument 'occ_capacity_request_id' to be a str")
        pulumi.set(__self__, "occ_capacity_request_id", occ_capacity_request_id)
        if occ_customer_group_id and not isinstance(occ_customer_group_id, str):
            raise TypeError("Expected argument 'occ_customer_group_id' to be a str")
        pulumi.set(__self__, "occ_customer_group_id", occ_customer_group_id)
        if patch_operations and not isinstance(patch_operations, list):
            raise TypeError("Expected argument 'patch_operations' to be a list")
        pulumi.set(__self__, "patch_operations", patch_operations)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if request_state and not isinstance(request_state, str):
            raise TypeError("Expected argument 'request_state' to be a str")
        pulumi.set(__self__, "request_state", request_state)
        if request_type and not isinstance(request_type, str):
            raise TypeError("Expected argument 'request_type' to be a str")
        pulumi.set(__self__, "request_type", request_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The availability domain of the resource which is to be transferred. Note that this is only required for Capacity Request Transfer requests.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the tenancy from which the request was made.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dateExpectedCapacityHandover")
    def date_expected_capacity_handover(self) -> str:
        """
        The date by which the capacity requested by customers before dateFinalCustomerOrder needs to be fulfilled.
        """
        return pulumi.get(self, "date_expected_capacity_handover")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Meaningful text about the capacity request.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.GetOccCapacityRequestDetailResult']:
        """
        A list of resources requested as part of this request
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the capacity request.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the capacity request.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in a Failed State.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="occAvailabilityCatalogId")
    def occ_availability_catalog_id(self) -> str:
        """
        The OCID of the availability catalog against which the capacity request was placed.
        """
        return pulumi.get(self, "occ_availability_catalog_id")

    @property
    @pulumi.getter(name="occCapacityRequestId")
    def occ_capacity_request_id(self) -> str:
        return pulumi.get(self, "occ_capacity_request_id")

    @property
    @pulumi.getter(name="occCustomerGroupId")
    def occ_customer_group_id(self) -> str:
        """
        The OCID of the customer group to which this customer belongs to.
        """
        return pulumi.get(self, "occ_customer_group_id")

    @property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> Sequence['outputs.GetOccCapacityRequestPatchOperationResult']:
        return pulumi.get(self, "patch_operations")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The name of the region for which the capacity request was made.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="requestState")
    def request_state(self) -> str:
        """
        The different states the capacity request goes through.
        """
        return pulumi.get(self, "request_state")

    @property
    @pulumi.getter(name="requestType")
    def request_type(self) -> str:
        """
        Type of Capacity Request(New or Transfer)
        """
        return pulumi.get(self, "request_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time when the capacity request was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time when the capacity request was updated.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetOccCapacityRequestResult(GetOccCapacityRequestResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOccCapacityRequestResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            date_expected_capacity_handover=self.date_expected_capacity_handover,
            defined_tags=self.defined_tags,
            description=self.description,
            details=self.details,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            namespace=self.namespace,
            occ_availability_catalog_id=self.occ_availability_catalog_id,
            occ_capacity_request_id=self.occ_capacity_request_id,
            occ_customer_group_id=self.occ_customer_group_id,
            patch_operations=self.patch_operations,
            region=self.region,
            request_state=self.request_state,
            request_type=self.request_type,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_occ_capacity_request(occ_capacity_request_id: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOccCapacityRequestResult:
    """
    This data source provides details about a specific Occ Capacity Request resource in Oracle Cloud Infrastructure Capacity Management service.

    Get details about the capacity request.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_occ_capacity_request = oci.CapacityManagement.get_occ_capacity_request(occ_capacity_request_id=test_occ_capacity_request_oci_capacity_management_occ_capacity_request["id"])
    ```


    :param str occ_capacity_request_id: The OCID of the capacity request.
    """
    __args__ = dict()
    __args__['occCapacityRequestId'] = occ_capacity_request_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CapacityManagement/getOccCapacityRequest:getOccCapacityRequest', __args__, opts=opts, typ=GetOccCapacityRequestResult).value

    return AwaitableGetOccCapacityRequestResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        date_expected_capacity_handover=pulumi.get(__ret__, 'date_expected_capacity_handover'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        details=pulumi.get(__ret__, 'details'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        namespace=pulumi.get(__ret__, 'namespace'),
        occ_availability_catalog_id=pulumi.get(__ret__, 'occ_availability_catalog_id'),
        occ_capacity_request_id=pulumi.get(__ret__, 'occ_capacity_request_id'),
        occ_customer_group_id=pulumi.get(__ret__, 'occ_customer_group_id'),
        patch_operations=pulumi.get(__ret__, 'patch_operations'),
        region=pulumi.get(__ret__, 'region'),
        request_state=pulumi.get(__ret__, 'request_state'),
        request_type=pulumi.get(__ret__, 'request_type'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_occ_capacity_request_output(occ_capacity_request_id: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOccCapacityRequestResult]:
    """
    This data source provides details about a specific Occ Capacity Request resource in Oracle Cloud Infrastructure Capacity Management service.

    Get details about the capacity request.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_occ_capacity_request = oci.CapacityManagement.get_occ_capacity_request(occ_capacity_request_id=test_occ_capacity_request_oci_capacity_management_occ_capacity_request["id"])
    ```


    :param str occ_capacity_request_id: The OCID of the capacity request.
    """
    __args__ = dict()
    __args__['occCapacityRequestId'] = occ_capacity_request_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CapacityManagement/getOccCapacityRequest:getOccCapacityRequest', __args__, opts=opts, typ=GetOccCapacityRequestResult)
    return __ret__.apply(lambda __response__: GetOccCapacityRequestResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        date_expected_capacity_handover=pulumi.get(__response__, 'date_expected_capacity_handover'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        details=pulumi.get(__response__, 'details'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        namespace=pulumi.get(__response__, 'namespace'),
        occ_availability_catalog_id=pulumi.get(__response__, 'occ_availability_catalog_id'),
        occ_capacity_request_id=pulumi.get(__response__, 'occ_capacity_request_id'),
        occ_customer_group_id=pulumi.get(__response__, 'occ_customer_group_id'),
        patch_operations=pulumi.get(__response__, 'patch_operations'),
        region=pulumi.get(__response__, 'region'),
        request_state=pulumi.get(__response__, 'request_state'),
        request_type=pulumi.get(__response__, 'request_type'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
