# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCaBundleResult',
    'AwaitableGetCaBundleResult',
    'get_ca_bundle',
    'get_ca_bundle_output',
]

@pulumi.output_type
class GetCaBundleResult:
    """
    A collection of values returned by getCaBundle.
    """
    def __init__(__self__, ca_bundle_id=None, ca_bundle_pem=None, compartment_id=None, defined_tags=None, description=None, freeform_tags=None, id=None, lifecycle_details=None, name=None, state=None, time_created=None):
        if ca_bundle_id and not isinstance(ca_bundle_id, str):
            raise TypeError("Expected argument 'ca_bundle_id' to be a str")
        pulumi.set(__self__, "ca_bundle_id", ca_bundle_id)
        if ca_bundle_pem and not isinstance(ca_bundle_pem, str):
            raise TypeError("Expected argument 'ca_bundle_pem' to be a str")
        pulumi.set(__self__, "ca_bundle_pem", ca_bundle_pem)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="caBundleId")
    def ca_bundle_id(self) -> str:
        return pulumi.get(self, "ca_bundle_id")

    @property
    @pulumi.getter(name="caBundlePem")
    def ca_bundle_pem(self) -> str:
        return pulumi.get(self, "ca_bundle_pem")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment for the CA bundle.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A brief description of the CA bundle.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the CA bundle.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state of the CA bundle.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A user-friendly name for the CA bundle. Names are unique within a compartment. Avoid entering confidential information. Valid characters include uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the CA bundle.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        A property indicating when the CA bundle was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


class AwaitableGetCaBundleResult(GetCaBundleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCaBundleResult(
            ca_bundle_id=self.ca_bundle_id,
            ca_bundle_pem=self.ca_bundle_pem,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            name=self.name,
            state=self.state,
            time_created=self.time_created)


def get_ca_bundle(ca_bundle_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCaBundleResult:
    """
    This data source provides details about a specific Ca Bundle resource in Oracle Cloud Infrastructure Certificates Management service.

    Gets details about the specified CA bundle.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ca_bundle = oci.CertificatesManagement.get_ca_bundle(ca_bundle_id=test_ca_bundle_oci_certificates_management_ca_bundle["id"])
    ```


    :param str ca_bundle_id: The OCID of the CA bundle.
    """
    __args__ = dict()
    __args__['caBundleId'] = ca_bundle_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CertificatesManagement/getCaBundle:getCaBundle', __args__, opts=opts, typ=GetCaBundleResult).value

    return AwaitableGetCaBundleResult(
        ca_bundle_id=pulumi.get(__ret__, 'ca_bundle_id'),
        ca_bundle_pem=pulumi.get(__ret__, 'ca_bundle_pem'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'))
def get_ca_bundle_output(ca_bundle_id: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCaBundleResult]:
    """
    This data source provides details about a specific Ca Bundle resource in Oracle Cloud Infrastructure Certificates Management service.

    Gets details about the specified CA bundle.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ca_bundle = oci.CertificatesManagement.get_ca_bundle(ca_bundle_id=test_ca_bundle_oci_certificates_management_ca_bundle["id"])
    ```


    :param str ca_bundle_id: The OCID of the CA bundle.
    """
    __args__ = dict()
    __args__['caBundleId'] = ca_bundle_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CertificatesManagement/getCaBundle:getCaBundle', __args__, opts=opts, typ=GetCaBundleResult)
    return __ret__.apply(lambda __response__: GetCaBundleResult(
        ca_bundle_id=pulumi.get(__response__, 'ca_bundle_id'),
        ca_bundle_pem=pulumi.get(__response__, 'ca_bundle_pem'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created')))
