# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AdhocQueryArgs', 'AdhocQuery']

@pulumi.input_type
class AdhocQueryArgs:
    def __init__(__self__, *,
                 adhoc_query_details: pulumi.Input['AdhocQueryAdhocQueryDetailsArgs'],
                 compartment_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AdhocQuery resource.
        :param pulumi.Input['AdhocQueryAdhocQueryDetailsArgs'] adhoc_query_details: Detailed information about the adhoc query.
        :param pulumi.Input[str] compartment_id: Compartment OCID of adhoc query
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "adhoc_query_details", adhoc_query_details)
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="adhocQueryDetails")
    def adhoc_query_details(self) -> pulumi.Input['AdhocQueryAdhocQueryDetailsArgs']:
        """
        Detailed information about the adhoc query.
        """
        return pulumi.get(self, "adhoc_query_details")

    @adhoc_query_details.setter
    def adhoc_query_details(self, value: pulumi.Input['AdhocQueryAdhocQueryDetailsArgs']):
        pulumi.set(self, "adhoc_query_details", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        Compartment OCID of adhoc query
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _AdhocQueryState:
    def __init__(__self__, *,
                 adhoc_query_details: Optional[pulumi.Input['AdhocQueryAdhocQueryDetailsArgs']] = None,
                 adhoc_query_regional_details: Optional[pulumi.Input[Sequence[pulumi.Input['AdhocQueryAdhocQueryRegionalDetailArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 error_message: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AdhocQuery resources.
        :param pulumi.Input['AdhocQueryAdhocQueryDetailsArgs'] adhoc_query_details: Detailed information about the adhoc query.
        :param pulumi.Input[Sequence[pulumi.Input['AdhocQueryAdhocQueryRegionalDetailArgs']]] adhoc_query_regional_details: Instance level status for each region
        :param pulumi.Input[str] compartment_id: Compartment OCID of adhoc query
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] error_message: Error message to show on UI in case of failure
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current lifecycle state of the resource.
        :param pulumi.Input[str] status: Status of the adhoc query
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the adhoc query was created. Format defined by RFC3339.
        :param pulumi.Input[str] time_updated: The date and time the adhoc query was updated. Format defined by RFC3339.
        """
        if adhoc_query_details is not None:
            pulumi.set(__self__, "adhoc_query_details", adhoc_query_details)
        if adhoc_query_regional_details is not None:
            pulumi.set(__self__, "adhoc_query_regional_details", adhoc_query_regional_details)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="adhocQueryDetails")
    def adhoc_query_details(self) -> Optional[pulumi.Input['AdhocQueryAdhocQueryDetailsArgs']]:
        """
        Detailed information about the adhoc query.
        """
        return pulumi.get(self, "adhoc_query_details")

    @adhoc_query_details.setter
    def adhoc_query_details(self, value: Optional[pulumi.Input['AdhocQueryAdhocQueryDetailsArgs']]):
        pulumi.set(self, "adhoc_query_details", value)

    @property
    @pulumi.getter(name="adhocQueryRegionalDetails")
    def adhoc_query_regional_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AdhocQueryAdhocQueryRegionalDetailArgs']]]]:
        """
        Instance level status for each region
        """
        return pulumi.get(self, "adhoc_query_regional_details")

    @adhoc_query_regional_details.setter
    def adhoc_query_regional_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AdhocQueryAdhocQueryRegionalDetailArgs']]]]):
        pulumi.set(self, "adhoc_query_regional_details", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Compartment OCID of adhoc query
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[pulumi.Input[str]]:
        """
        Error message to show on UI in case of failure
        """
        return pulumi.get(self, "error_message")

    @error_message.setter
    def error_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error_message", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the adhoc query
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the adhoc query was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the adhoc query was updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class AdhocQuery(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 adhoc_query_details: Optional[pulumi.Input[Union['AdhocQueryAdhocQueryDetailsArgs', 'AdhocQueryAdhocQueryDetailsArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        This resource provides the Adhoc Query resource in Oracle Cloud Infrastructure Cloud Guard service.

        Creates a AdhocQuery resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_adhoc_query = oci.cloud_guard.AdhocQuery("test_adhoc_query",
            adhoc_query_details={
                "adhoc_query_resources": [{
                    "region": adhoc_query_adhoc_query_details_adhoc_query_resources_region,
                    "resource_ids": adhoc_query_adhoc_query_details_adhoc_query_resources_resource_ids,
                    "resource_type": adhoc_query_adhoc_query_details_adhoc_query_resources_resource_type,
                }],
                "query": adhoc_query_adhoc_query_details_query,
            },
            compartment_id=compartment_id,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        AdhocQueries can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudGuard/adhocQuery:AdhocQuery test_adhoc_query "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AdhocQueryAdhocQueryDetailsArgs', 'AdhocQueryAdhocQueryDetailsArgsDict']] adhoc_query_details: Detailed information about the adhoc query.
        :param pulumi.Input[str] compartment_id: Compartment OCID of adhoc query
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AdhocQueryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Adhoc Query resource in Oracle Cloud Infrastructure Cloud Guard service.

        Creates a AdhocQuery resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_adhoc_query = oci.cloud_guard.AdhocQuery("test_adhoc_query",
            adhoc_query_details={
                "adhoc_query_resources": [{
                    "region": adhoc_query_adhoc_query_details_adhoc_query_resources_region,
                    "resource_ids": adhoc_query_adhoc_query_details_adhoc_query_resources_resource_ids,
                    "resource_type": adhoc_query_adhoc_query_details_adhoc_query_resources_resource_type,
                }],
                "query": adhoc_query_adhoc_query_details_query,
            },
            compartment_id=compartment_id,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        AdhocQueries can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CloudGuard/adhocQuery:AdhocQuery test_adhoc_query "id"
        ```

        :param str resource_name: The name of the resource.
        :param AdhocQueryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AdhocQueryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 adhoc_query_details: Optional[pulumi.Input[Union['AdhocQueryAdhocQueryDetailsArgs', 'AdhocQueryAdhocQueryDetailsArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AdhocQueryArgs.__new__(AdhocQueryArgs)

            if adhoc_query_details is None and not opts.urn:
                raise TypeError("Missing required property 'adhoc_query_details'")
            __props__.__dict__["adhoc_query_details"] = adhoc_query_details
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["adhoc_query_regional_details"] = None
            __props__.__dict__["error_message"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(AdhocQuery, __self__).__init__(
            'oci:CloudGuard/adhocQuery:AdhocQuery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            adhoc_query_details: Optional[pulumi.Input[Union['AdhocQueryAdhocQueryDetailsArgs', 'AdhocQueryAdhocQueryDetailsArgsDict']]] = None,
            adhoc_query_regional_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AdhocQueryAdhocQueryRegionalDetailArgs', 'AdhocQueryAdhocQueryRegionalDetailArgsDict']]]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            error_message: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'AdhocQuery':
        """
        Get an existing AdhocQuery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AdhocQueryAdhocQueryDetailsArgs', 'AdhocQueryAdhocQueryDetailsArgsDict']] adhoc_query_details: Detailed information about the adhoc query.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AdhocQueryAdhocQueryRegionalDetailArgs', 'AdhocQueryAdhocQueryRegionalDetailArgsDict']]]] adhoc_query_regional_details: Instance level status for each region
        :param pulumi.Input[str] compartment_id: Compartment OCID of adhoc query
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] error_message: Error message to show on UI in case of failure
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
               
               Avoid entering confidential information.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current lifecycle state of the resource.
        :param pulumi.Input[str] status: Status of the adhoc query
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the adhoc query was created. Format defined by RFC3339.
        :param pulumi.Input[str] time_updated: The date and time the adhoc query was updated. Format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AdhocQueryState.__new__(_AdhocQueryState)

        __props__.__dict__["adhoc_query_details"] = adhoc_query_details
        __props__.__dict__["adhoc_query_regional_details"] = adhoc_query_regional_details
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["error_message"] = error_message
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return AdhocQuery(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adhocQueryDetails")
    def adhoc_query_details(self) -> pulumi.Output['outputs.AdhocQueryAdhocQueryDetails']:
        """
        Detailed information about the adhoc query.
        """
        return pulumi.get(self, "adhoc_query_details")

    @property
    @pulumi.getter(name="adhocQueryRegionalDetails")
    def adhoc_query_regional_details(self) -> pulumi.Output[Sequence['outputs.AdhocQueryAdhocQueryRegionalDetail']]:
        """
        Instance level status for each region
        """
        return pulumi.get(self, "adhoc_query_regional_details")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        Compartment OCID of adhoc query
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> pulumi.Output[str]:
        """
        Error message to show on UI in case of failure
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`

        Avoid entering confidential information.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the adhoc query
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the adhoc query was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the adhoc query was updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

