# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDataSourceEventsResult',
    'AwaitableGetDataSourceEventsResult',
    'get_data_source_events',
    'get_data_source_events_output',
]

@pulumi.output_type
class GetDataSourceEventsResult:
    """
    A collection of values returned by getDataSourceEvents.
    """
    def __init__(__self__, data_source_event_collections=None, data_source_id=None, filters=None, id=None, region=None):
        if data_source_event_collections and not isinstance(data_source_event_collections, list):
            raise TypeError("Expected argument 'data_source_event_collections' to be a list")
        pulumi.set(__self__, "data_source_event_collections", data_source_event_collections)
        if data_source_id and not isinstance(data_source_id, str):
            raise TypeError("Expected argument 'data_source_id' to be a str")
        pulumi.set(__self__, "data_source_id", data_source_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="dataSourceEventCollections")
    def data_source_event_collections(self) -> Sequence['outputs.GetDataSourceEventsDataSourceEventCollectionResult']:
        """
        The list of data_source_event_collection.
        """
        return pulumi.get(self, "data_source_event_collections")

    @property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> str:
        """
        Unique identifier of data source.
        """
        return pulumi.get(self, "data_source_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDataSourceEventsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Data source event region
        """
        return pulumi.get(self, "region")


class AwaitableGetDataSourceEventsResult(GetDataSourceEventsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataSourceEventsResult(
            data_source_event_collections=self.data_source_event_collections,
            data_source_id=self.data_source_id,
            filters=self.filters,
            id=self.id,
            region=self.region)


def get_data_source_events(data_source_id: Optional[str] = None,
                           filters: Optional[Sequence[Union['GetDataSourceEventsFilterArgs', 'GetDataSourceEventsFilterArgsDict']]] = None,
                           region: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataSourceEventsResult:
    """
    This data source provides the list of Data Source Events in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of data source events
    (DataSourceEventCollection  resource) from the data source
    (DataSource resource) identified by dataSourceId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_source_events = oci.CloudGuard.get_data_source_events(data_source_id=test_data_source["id"],
        region=data_source_event_region)
    ```


    :param str data_source_id: Data source OCID.
    :param str region: A filter to return only resource where their region matches the given region.
    """
    __args__ = dict()
    __args__['dataSourceId'] = data_source_id
    __args__['filters'] = filters
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getDataSourceEvents:getDataSourceEvents', __args__, opts=opts, typ=GetDataSourceEventsResult).value

    return AwaitableGetDataSourceEventsResult(
        data_source_event_collections=pulumi.get(__ret__, 'data_source_event_collections'),
        data_source_id=pulumi.get(__ret__, 'data_source_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'))
def get_data_source_events_output(data_source_id: Optional[pulumi.Input[str]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDataSourceEventsFilterArgs', 'GetDataSourceEventsFilterArgsDict']]]]] = None,
                                  region: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDataSourceEventsResult]:
    """
    This data source provides the list of Data Source Events in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of data source events
    (DataSourceEventCollection  resource) from the data source
    (DataSource resource) identified by dataSourceId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_source_events = oci.CloudGuard.get_data_source_events(data_source_id=test_data_source["id"],
        region=data_source_event_region)
    ```


    :param str data_source_id: Data source OCID.
    :param str region: A filter to return only resource where their region matches the given region.
    """
    __args__ = dict()
    __args__['dataSourceId'] = data_source_id
    __args__['filters'] = filters
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CloudGuard/getDataSourceEvents:getDataSourceEvents', __args__, opts=opts, typ=GetDataSourceEventsResult)
    return __ret__.apply(lambda __response__: GetDataSourceEventsResult(
        data_source_event_collections=pulumi.get(__response__, 'data_source_event_collections'),
        data_source_id=pulumi.get(__response__, 'data_source_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region')))
