# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMigrationAssetsResult',
    'AwaitableGetMigrationAssetsResult',
    'get_migration_assets',
    'get_migration_assets_output',
]

@pulumi.output_type
class GetMigrationAssetsResult:
    """
    A collection of values returned by getMigrationAssets.
    """
    def __init__(__self__, display_name=None, filters=None, id=None, migration_asset_collections=None, migration_asset_id=None, migration_id=None, state=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if migration_asset_collections and not isinstance(migration_asset_collections, list):
            raise TypeError("Expected argument 'migration_asset_collections' to be a list")
        pulumi.set(__self__, "migration_asset_collections", migration_asset_collections)
        if migration_asset_id and not isinstance(migration_asset_id, str):
            raise TypeError("Expected argument 'migration_asset_id' to be a str")
        pulumi.set(__self__, "migration_asset_id", migration_asset_id)
        if migration_id and not isinstance(migration_id, str):
            raise TypeError("Expected argument 'migration_id' to be a str")
        pulumi.set(__self__, "migration_id", migration_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMigrationAssetsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="migrationAssetCollections")
    def migration_asset_collections(self) -> Sequence['outputs.GetMigrationAssetsMigrationAssetCollectionResult']:
        """
        The list of migration_asset_collection.
        """
        return pulumi.get(self, "migration_asset_collections")

    @property
    @pulumi.getter(name="migrationAssetId")
    def migration_asset_id(self) -> Optional[str]:
        return pulumi.get(self, "migration_asset_id")

    @property
    @pulumi.getter(name="migrationId")
    def migration_id(self) -> Optional[str]:
        """
        OCID of the associated migration.
        """
        return pulumi.get(self, "migration_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the migration asset.
        """
        return pulumi.get(self, "state")


class AwaitableGetMigrationAssetsResult(GetMigrationAssetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMigrationAssetsResult(
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            migration_asset_collections=self.migration_asset_collections,
            migration_asset_id=self.migration_asset_id,
            migration_id=self.migration_id,
            state=self.state)


def get_migration_assets(display_name: Optional[str] = None,
                         filters: Optional[Sequence[Union['GetMigrationAssetsFilterArgs', 'GetMigrationAssetsFilterArgsDict']]] = None,
                         migration_asset_id: Optional[str] = None,
                         migration_id: Optional[str] = None,
                         state: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMigrationAssetsResult:
    """
    This data source provides the list of Migration Assets in Oracle Cloud Infrastructure Cloud Migrations service.

    Returns a list of migration assets.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_migration_assets = oci.CloudMigrations.get_migration_assets(display_name=migration_asset_display_name,
        migration_asset_id=test_migration_asset["id"],
        migration_id=test_migration["id"],
        state=migration_asset_state)
    ```


    :param str display_name: A filter to return only resources that match the entire given display name.
    :param str migration_asset_id: Unique migration asset identifier
    :param str migration_id: Unique migration identifier
    :param str state: The current state of the migration asset.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['migrationAssetId'] = migration_asset_id
    __args__['migrationId'] = migration_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudMigrations/getMigrationAssets:getMigrationAssets', __args__, opts=opts, typ=GetMigrationAssetsResult).value

    return AwaitableGetMigrationAssetsResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        migration_asset_collections=pulumi.get(__ret__, 'migration_asset_collections'),
        migration_asset_id=pulumi.get(__ret__, 'migration_asset_id'),
        migration_id=pulumi.get(__ret__, 'migration_id'),
        state=pulumi.get(__ret__, 'state'))
def get_migration_assets_output(display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMigrationAssetsFilterArgs', 'GetMigrationAssetsFilterArgsDict']]]]] = None,
                                migration_asset_id: Optional[pulumi.Input[Optional[str]]] = None,
                                migration_id: Optional[pulumi.Input[Optional[str]]] = None,
                                state: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMigrationAssetsResult]:
    """
    This data source provides the list of Migration Assets in Oracle Cloud Infrastructure Cloud Migrations service.

    Returns a list of migration assets.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_migration_assets = oci.CloudMigrations.get_migration_assets(display_name=migration_asset_display_name,
        migration_asset_id=test_migration_asset["id"],
        migration_id=test_migration["id"],
        state=migration_asset_state)
    ```


    :param str display_name: A filter to return only resources that match the entire given display name.
    :param str migration_asset_id: Unique migration asset identifier
    :param str migration_id: Unique migration identifier
    :param str state: The current state of the migration asset.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['migrationAssetId'] = migration_asset_id
    __args__['migrationId'] = migration_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CloudMigrations/getMigrationAssets:getMigrationAssets', __args__, opts=opts, typ=GetMigrationAssetsResult)
    return __ret__.apply(lambda __response__: GetMigrationAssetsResult(
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        migration_asset_collections=pulumi.get(__response__, 'migration_asset_collections'),
        migration_asset_id=pulumi.get(__response__, 'migration_asset_id'),
        migration_id=pulumi.get(__response__, 'migration_id'),
        state=pulumi.get(__response__, 'state')))
