# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCnvDnsResolverAssociationResult',
    'AwaitableGetCnvDnsResolverAssociationResult',
    'get_cnv_dns_resolver_association',
    'get_cnv_dns_resolver_association_output',
]

@pulumi.output_type
class GetCnvDnsResolverAssociationResult:
    """
    A collection of values returned by getCnvDnsResolverAssociation.
    """
    def __init__(__self__, dns_resolver_id=None, id=None, state=None, vcn_id=None):
        if dns_resolver_id and not isinstance(dns_resolver_id, str):
            raise TypeError("Expected argument 'dns_resolver_id' to be a str")
        pulumi.set(__self__, "dns_resolver_id", dns_resolver_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vcn_id and not isinstance(vcn_id, str):
            raise TypeError("Expected argument 'vcn_id' to be a str")
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="dnsResolverId")
    def dns_resolver_id(self) -> str:
        """
        The OCID of the DNS resolver in the association. We won't have the DNS resolver id as soon as vcn 
        is created, we will create it asynchronously. It would be null until it is actually created.
        """
        return pulumi.get(self, "dns_resolver_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> str:
        """
        The OCID of the VCN in the association.
        """
        return pulumi.get(self, "vcn_id")


class AwaitableGetCnvDnsResolverAssociationResult(GetCnvDnsResolverAssociationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCnvDnsResolverAssociationResult(
            dns_resolver_id=self.dns_resolver_id,
            id=self.id,
            state=self.state,
            vcn_id=self.vcn_id)


def get_cnv_dns_resolver_association(vcn_id: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCnvDnsResolverAssociationResult:
    """
    This data source provides details about a specific Vcn Dns Resolver Association resource in Oracle Cloud Infrastructure Core service.

    Get the associated DNS resolver information with a vcn

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vcn_dns_resolver_association = oci.Core.get_cnv_dns_resolver_association(vcn_id=test_vcn["id"])
    ```


    :param str vcn_id: Specify the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
    """
    __args__ = dict()
    __args__['vcnId'] = vcn_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getCnvDnsResolverAssociation:getCnvDnsResolverAssociation', __args__, opts=opts, typ=GetCnvDnsResolverAssociationResult).value

    return AwaitableGetCnvDnsResolverAssociationResult(
        dns_resolver_id=pulumi.get(__ret__, 'dns_resolver_id'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        vcn_id=pulumi.get(__ret__, 'vcn_id'))
def get_cnv_dns_resolver_association_output(vcn_id: Optional[pulumi.Input[str]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCnvDnsResolverAssociationResult]:
    """
    This data source provides details about a specific Vcn Dns Resolver Association resource in Oracle Cloud Infrastructure Core service.

    Get the associated DNS resolver information with a vcn

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vcn_dns_resolver_association = oci.Core.get_cnv_dns_resolver_association(vcn_id=test_vcn["id"])
    ```


    :param str vcn_id: Specify the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN.
    """
    __args__ = dict()
    __args__['vcnId'] = vcn_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getCnvDnsResolverAssociation:getCnvDnsResolverAssociation', __args__, opts=opts, typ=GetCnvDnsResolverAssociationResult)
    return __ret__.apply(lambda __response__: GetCnvDnsResolverAssociationResult(
        dns_resolver_id=pulumi.get(__response__, 'dns_resolver_id'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        vcn_id=pulumi.get(__response__, 'vcn_id')))
