# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceConfigurationArgs', 'InstanceConfiguration']

@pulumi.input_type
class InstanceConfigurationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 instance_details: Optional[pulumi.Input['InstanceConfigurationInstanceDetailsArgs']] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a InstanceConfiguration resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance to use to create the instance configuration.
        :param pulumi.Input[str] source: The source of the instance configuration. An instance configuration defines the settings to use when creating Compute instances, including details such as the base image, shape, and metadata. You can also specify the associated resources for the instance, such as block volume attachments and network configuration.
               
               When you create an instance configuration using an existing instance as a template, the instance configuration does not include any information from the source instance's boot volume, such as installed applications, binaries, and files on the instance. It also does not include the contents of any block volumes that are attached to the instance.
               
               To create an instance configuration that includes the custom setup from an instance's boot volume, you must first create a custom image from the instance (see [CreateImage](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Image/CreateImage)). Then, use the custom image to launch a new instance (see [LaunchInstance](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Instance/LaunchInstance)). Finally, create the instance configuration based on the instance that you created from the custom image.
               
               To include block volume contents with an instance configuration, first create a backup of the attached block volumes (see [CreateVolumeBackup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/VolumeBackup/CreateVolumeBackup)). Then, create the instance configuration by specifying the list of settings, using [InstanceConfigurationVolumeSourceFromVolumeBackupDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/datatypes/InstanceConfigurationVolumeSourceFromVolumeBackupDetails) to include the block volume backups in the list of settings.
               
               The following values are supported:
               * `NONE`: Creates an instance configuration using the list of settings that you specify.
               * `INSTANCE`: Creates an instance configuration using an existing instance as a template.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if instance_details is not None:
            pulumi.set(__self__, "instance_details", instance_details)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance configuration.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="instanceDetails")
    def instance_details(self) -> Optional[pulumi.Input['InstanceConfigurationInstanceDetailsArgs']]:
        return pulumi.get(self, "instance_details")

    @instance_details.setter
    def instance_details(self, value: Optional[pulumi.Input['InstanceConfigurationInstanceDetailsArgs']]):
        pulumi.set(self, "instance_details", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance to use to create the instance configuration.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        The source of the instance configuration. An instance configuration defines the settings to use when creating Compute instances, including details such as the base image, shape, and metadata. You can also specify the associated resources for the instance, such as block volume attachments and network configuration.

        When you create an instance configuration using an existing instance as a template, the instance configuration does not include any information from the source instance's boot volume, such as installed applications, binaries, and files on the instance. It also does not include the contents of any block volumes that are attached to the instance.

        To create an instance configuration that includes the custom setup from an instance's boot volume, you must first create a custom image from the instance (see [CreateImage](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Image/CreateImage)). Then, use the custom image to launch a new instance (see [LaunchInstance](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Instance/LaunchInstance)). Finally, create the instance configuration based on the instance that you created from the custom image.

        To include block volume contents with an instance configuration, first create a backup of the attached block volumes (see [CreateVolumeBackup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/VolumeBackup/CreateVolumeBackup)). Then, create the instance configuration by specifying the list of settings, using [InstanceConfigurationVolumeSourceFromVolumeBackupDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/datatypes/InstanceConfigurationVolumeSourceFromVolumeBackupDetails) to include the block volume backups in the list of settings.

        The following values are supported:
        * `NONE`: Creates an instance configuration using the list of settings that you specify.
        * `INSTANCE`: Creates an instance configuration using an existing instance as a template.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class _InstanceConfigurationState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 deferred_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 instance_details: Optional[pulumi.Input['InstanceConfigurationInstanceDetailsArgs']] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering InstanceConfiguration resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] deferred_fields: Parameters that were not specified when the instance configuration was created, but that are required to launch an instance from the instance configuration. See the [LaunchInstanceConfiguration](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Instance/LaunchInstanceConfiguration) operation.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance to use to create the instance configuration.
        :param pulumi.Input[str] source: The source of the instance configuration. An instance configuration defines the settings to use when creating Compute instances, including details such as the base image, shape, and metadata. You can also specify the associated resources for the instance, such as block volume attachments and network configuration.
               
               When you create an instance configuration using an existing instance as a template, the instance configuration does not include any information from the source instance's boot volume, such as installed applications, binaries, and files on the instance. It also does not include the contents of any block volumes that are attached to the instance.
               
               To create an instance configuration that includes the custom setup from an instance's boot volume, you must first create a custom image from the instance (see [CreateImage](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Image/CreateImage)). Then, use the custom image to launch a new instance (see [LaunchInstance](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Instance/LaunchInstance)). Finally, create the instance configuration based on the instance that you created from the custom image.
               
               To include block volume contents with an instance configuration, first create a backup of the attached block volumes (see [CreateVolumeBackup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/VolumeBackup/CreateVolumeBackup)). Then, create the instance configuration by specifying the list of settings, using [InstanceConfigurationVolumeSourceFromVolumeBackupDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/datatypes/InstanceConfigurationVolumeSourceFromVolumeBackupDetails) to include the block volume backups in the list of settings.
               
               The following values are supported:
               * `NONE`: Creates an instance configuration using the list of settings that you specify.
               * `INSTANCE`: Creates an instance configuration using an existing instance as a template.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The date and time the instance configuration was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if deferred_fields is not None:
            pulumi.set(__self__, "deferred_fields", deferred_fields)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if instance_details is not None:
            pulumi.set(__self__, "instance_details", instance_details)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance configuration.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="deferredFields")
    def deferred_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Parameters that were not specified when the instance configuration was created, but that are required to launch an instance from the instance configuration. See the [LaunchInstanceConfiguration](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Instance/LaunchInstanceConfiguration) operation.
        """
        return pulumi.get(self, "deferred_fields")

    @deferred_fields.setter
    def deferred_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "deferred_fields", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="instanceDetails")
    def instance_details(self) -> Optional[pulumi.Input['InstanceConfigurationInstanceDetailsArgs']]:
        return pulumi.get(self, "instance_details")

    @instance_details.setter
    def instance_details(self, value: Optional[pulumi.Input['InstanceConfigurationInstanceDetailsArgs']]):
        pulumi.set(self, "instance_details", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance to use to create the instance configuration.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        The source of the instance configuration. An instance configuration defines the settings to use when creating Compute instances, including details such as the base image, shape, and metadata. You can also specify the associated resources for the instance, such as block volume attachments and network configuration.

        When you create an instance configuration using an existing instance as a template, the instance configuration does not include any information from the source instance's boot volume, such as installed applications, binaries, and files on the instance. It also does not include the contents of any block volumes that are attached to the instance.

        To create an instance configuration that includes the custom setup from an instance's boot volume, you must first create a custom image from the instance (see [CreateImage](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Image/CreateImage)). Then, use the custom image to launch a new instance (see [LaunchInstance](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Instance/LaunchInstance)). Finally, create the instance configuration based on the instance that you created from the custom image.

        To include block volume contents with an instance configuration, first create a backup of the attached block volumes (see [CreateVolumeBackup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/VolumeBackup/CreateVolumeBackup)). Then, create the instance configuration by specifying the list of settings, using [InstanceConfigurationVolumeSourceFromVolumeBackupDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/datatypes/InstanceConfigurationVolumeSourceFromVolumeBackupDetails) to include the block volume backups in the list of settings.

        The following values are supported:
        * `NONE`: Creates an instance configuration using the list of settings that you specify.
        * `INSTANCE`: Creates an instance configuration using an existing instance as a template.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the instance configuration was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


class InstanceConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 instance_details: Optional[pulumi.Input[Union['InstanceConfigurationInstanceDetailsArgs', 'InstanceConfigurationInstanceDetailsArgsDict']]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Instance Configuration resource in Oracle Cloud Infrastructure Core service.

        Creates an instance configuration. An instance configuration is a template that defines the
        settings to use when creating Compute instances.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_instance_configuration = oci.core.InstanceConfiguration("test_instance_configuration",
            compartment_id=compartment_id,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=instance_configuration_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            instance_details={
                "instance_type": instance_configuration_instance_details_instance_type,
                "block_volumes": [{
                    "attach_details": {
                        "type": instance_configuration_instance_details_block_volumes_attach_details_type,
                        "device": instance_configuration_instance_details_block_volumes_attach_details_device,
                        "display_name": instance_configuration_instance_details_block_volumes_attach_details_display_name,
                        "is_pv_encryption_in_transit_enabled": instance_configuration_instance_details_block_volumes_attach_details_is_pv_encryption_in_transit_enabled,
                        "is_read_only": instance_configuration_instance_details_block_volumes_attach_details_is_read_only,
                        "is_shareable": instance_configuration_instance_details_block_volumes_attach_details_is_shareable,
                        "use_chap": instance_configuration_instance_details_block_volumes_attach_details_use_chap,
                    },
                    "create_details": {
                        "autotune_policies": [{
                            "autotune_type": instance_configuration_instance_details_block_volumes_create_details_autotune_policies_autotune_type,
                            "max_vpus_per_gb": instance_configuration_instance_details_block_volumes_create_details_autotune_policies_max_vpus_per_gb,
                        }],
                        "availability_domain": instance_configuration_instance_details_block_volumes_create_details_availability_domain,
                        "backup_policy_id": test_volume_backup_policies["volumeBackupPolicies"][0]["id"],
                        "block_volume_replicas": {
                            "availability_domain": instance_configuration_instance_details_block_volumes_create_details_block_volume_replicas_availability_domain,
                            "display_name": instance_configuration_instance_details_block_volumes_create_details_block_volume_replicas_display_name,
                        },
                        "cluster_placement_group_id": cluster_placement_group_id,
                        "compartment_id": compartment_id,
                        "defined_tags": {
                            "operations__cost_center": "42",
                        },
                        "display_name": instance_configuration_instance_details_block_volumes_create_details_display_name,
                        "freeform_tags": {
                            "department": "Finance",
                        },
                        "is_auto_tune_enabled": instance_configuration_instance_details_block_volumes_create_details_is_auto_tune_enabled,
                        "kms_key_id": test_key["id"],
                        "size_in_gbs": instance_configuration_instance_details_block_volumes_create_details_size_in_gbs,
                        "source_details": {
                            "type": instance_configuration_instance_details_block_volumes_create_details_source_details_type,
                            "id": instance_configuration_instance_details_block_volumes_create_details_source_details_id,
                        },
                        "vpus_per_gb": instance_configuration_instance_details_block_volumes_create_details_vpus_per_gb,
                        "xrc_kms_key_id": test_key["id"],
                    },
                    "volume_id": test_volume["id"],
                }],
                "launch_details": {
                    "agent_config": {
                        "are_all_plugins_disabled": instance_configuration_instance_details_launch_details_agent_config_are_all_plugins_disabled,
                        "is_management_disabled": instance_configuration_instance_details_launch_details_agent_config_is_management_disabled,
                        "is_monitoring_disabled": instance_configuration_instance_details_launch_details_agent_config_is_monitoring_disabled,
                        "plugins_configs": [{
                            "desired_state": instance_configuration_instance_details_launch_details_agent_config_plugins_config_desired_state,
                            "name": instance_configuration_instance_details_launch_details_agent_config_plugins_config_name,
                        }],
                    },
                    "availability_config": {
                        "is_live_migration_preferred": instance_configuration_instance_details_launch_details_availability_config_is_live_migration_preferred,
                        "recovery_action": instance_configuration_instance_details_launch_details_availability_config_recovery_action,
                    },
                    "availability_domain": instance_configuration_instance_details_launch_details_availability_domain,
                    "capacity_reservation_id": test_capacity_reservation["id"],
                    "cluster_placement_group_id": test_group["id"],
                    "compartment_id": compartment_id,
                    "create_vnic_details": {
                        "assign_ipv6ip": instance_configuration_instance_details_launch_details_create_vnic_details_assign_ipv6ip,
                        "assign_private_dns_record": instance_configuration_instance_details_launch_details_create_vnic_details_assign_private_dns_record,
                        "assign_public_ip": instance_configuration_instance_details_launch_details_create_vnic_details_assign_public_ip,
                        "defined_tags": {
                            "operations__cost_center": "42",
                        },
                        "display_name": instance_configuration_instance_details_launch_details_create_vnic_details_display_name,
                        "freeform_tags": {
                            "department": "Finance",
                        },
                        "hostname_label": instance_configuration_instance_details_launch_details_create_vnic_details_hostname_label,
                        "ipv6address_ipv6subnet_cidr_pair_details": [{
                            "ipv6address": instance_configuration_instance_details_launch_details_create_vnic_details_ipv6address_ipv6subnet_cidr_pair_details_ipv6address,
                            "ipv6subnet_cidr": instance_configuration_instance_details_launch_details_create_vnic_details_ipv6address_ipv6subnet_cidr_pair_details_ipv6subnet_cidr,
                        }],
                        "nsg_ids": instance_configuration_instance_details_launch_details_create_vnic_details_nsg_ids,
                        "private_ip": instance_configuration_instance_details_launch_details_create_vnic_details_private_ip,
                        "security_attributes": instance_configuration_instance_details_launch_details_create_vnic_details_security_attributes,
                        "skip_source_dest_check": instance_configuration_instance_details_launch_details_create_vnic_details_skip_source_dest_check,
                        "subnet_id": test_subnet["id"],
                    },
                    "dedicated_vm_host_id": test_dedicated_vm_host["id"],
                    "defined_tags": {
                        "operations__cost_center": "42",
                    },
                    "display_name": instance_configuration_instance_details_launch_details_display_name,
                    "extended_metadata": instance_configuration_instance_details_launch_details_extended_metadata,
                    "fault_domain": instance_configuration_instance_details_launch_details_fault_domain,
                    "freeform_tags": {
                        "department": "Finance",
                    },
                    "instance_options": {
                        "are_legacy_imds_endpoints_disabled": instance_configuration_instance_details_launch_details_instance_options_are_legacy_imds_endpoints_disabled,
                    },
                    "ipxe_script": instance_configuration_instance_details_launch_details_ipxe_script,
                    "is_pv_encryption_in_transit_enabled": instance_configuration_instance_details_launch_details_is_pv_encryption_in_transit_enabled,
                    "launch_mode": instance_configuration_instance_details_launch_details_launch_mode,
                    "launch_options": {
                        "boot_volume_type": instance_configuration_instance_details_launch_details_launch_options_boot_volume_type,
                        "firmware": instance_configuration_instance_details_launch_details_launch_options_firmware,
                        "is_consistent_volume_naming_enabled": instance_configuration_instance_details_launch_details_launch_options_is_consistent_volume_naming_enabled,
                        "is_pv_encryption_in_transit_enabled": instance_configuration_instance_details_launch_details_launch_options_is_pv_encryption_in_transit_enabled,
                        "network_type": instance_configuration_instance_details_launch_details_launch_options_network_type,
                        "remote_data_volume_type": instance_configuration_instance_details_launch_details_launch_options_remote_data_volume_type,
                    },
                    "metadata": instance_configuration_instance_details_launch_details_metadata,
                    "platform_config": {
                        "type": instance_configuration_instance_details_launch_details_platform_config_type,
                        "are_virtual_instructions_enabled": instance_configuration_instance_details_launch_details_platform_config_are_virtual_instructions_enabled,
                        "config_map": instance_configuration_instance_details_launch_details_platform_config_config_map,
                        "is_access_control_service_enabled": instance_configuration_instance_details_launch_details_platform_config_is_access_control_service_enabled,
                        "is_input_output_memory_management_unit_enabled": instance_configuration_instance_details_launch_details_platform_config_is_input_output_memory_management_unit_enabled,
                        "is_measured_boot_enabled": instance_configuration_instance_details_launch_details_platform_config_is_measured_boot_enabled,
                        "is_memory_encryption_enabled": instance_configuration_instance_details_launch_details_platform_config_is_memory_encryption_enabled,
                        "is_secure_boot_enabled": instance_configuration_instance_details_launch_details_platform_config_is_secure_boot_enabled,
                        "is_symmetric_multi_threading_enabled": instance_configuration_instance_details_launch_details_platform_config_is_symmetric_multi_threading_enabled,
                        "is_trusted_platform_module_enabled": instance_configuration_instance_details_launch_details_platform_config_is_trusted_platform_module_enabled,
                        "numa_nodes_per_socket": instance_configuration_instance_details_launch_details_platform_config_numa_nodes_per_socket,
                        "percentage_of_cores_enabled": instance_configuration_instance_details_launch_details_platform_config_percentage_of_cores_enabled,
                    },
                    "preemptible_instance_config": {
                        "preemption_action": {
                            "type": instance_configuration_instance_details_launch_details_preemptible_instance_config_preemption_action_type,
                            "preserve_boot_volume": instance_configuration_instance_details_launch_details_preemptible_instance_config_preemption_action_preserve_boot_volume,
                        },
                    },
                    "preferred_maintenance_action": instance_configuration_instance_details_launch_details_preferred_maintenance_action,
                    "security_attributes": instance_configuration_instance_details_launch_details_security_attributes,
                    "shape": instance_configuration_instance_details_launch_details_shape,
                    "shape_config": {
                        "baseline_ocpu_utilization": instance_configuration_instance_details_launch_details_shape_config_baseline_ocpu_utilization,
                        "memory_in_gbs": instance_configuration_instance_details_launch_details_shape_config_memory_in_gbs,
                        "nvmes": instance_configuration_instance_details_launch_details_shape_config_nvmes,
                        "ocpus": instance_configuration_instance_details_launch_details_shape_config_ocpus,
                        "vcpus": instance_configuration_instance_details_launch_details_shape_config_vcpus,
                    },
                    "source_details": {
                        "source_type": instance_configuration_instance_details_launch_details_source_details_source_type,
                        "boot_volume_id": test_boot_volume["id"],
                        "boot_volume_size_in_gbs": instance_configuration_instance_details_launch_details_source_details_boot_volume_size_in_gbs,
                        "boot_volume_vpus_per_gb": instance_configuration_instance_details_launch_details_source_details_boot_volume_vpus_per_gb,
                        "image_id": test_image["id"],
                        "kms_key_id": test_key["id"],
                        "instance_source_image_filter_details": {
                            "compartment_id": compartment_id,
                            "defined_tags_filter": instance_configuration_instance_details_launch_details_source_details_instance_source_image_filter_details_defined_tags_filter,
                            "operating_system": instance_configuration_instance_details_launch_details_source_details_instance_source_image_filter_details_operating_system,
                            "operating_system_version": instance_configuration_instance_details_launch_details_source_details_instance_source_image_filter_details_operating_system_version,
                        },
                    },
                },
                "options": [{
                    "block_volumes": [{
                        "attach_details": {
                            "type": instance_configuration_instance_details_options_block_volumes_attach_details_type,
                            "device": instance_configuration_instance_details_options_block_volumes_attach_details_device,
                            "display_name": instance_configuration_instance_details_options_block_volumes_attach_details_display_name,
                            "is_pv_encryption_in_transit_enabled": instance_configuration_instance_details_options_block_volumes_attach_details_is_pv_encryption_in_transit_enabled,
                            "is_read_only": instance_configuration_instance_details_options_block_volumes_attach_details_is_read_only,
                            "is_shareable": instance_configuration_instance_details_options_block_volumes_attach_details_is_shareable,
                            "use_chap": instance_configuration_instance_details_options_block_volumes_attach_details_use_chap,
                        },
                        "create_details": {
                            "autotune_policies": [{
                                "autotune_type": instance_configuration_instance_details_options_block_volumes_create_details_autotune_policies_autotune_type,
                                "max_vpus_per_gb": instance_configuration_instance_details_options_block_volumes_create_details_autotune_policies_max_vpus_per_gb,
                            }],
                            "availability_domain": instance_configuration_instance_details_options_block_volumes_create_details_availability_domain,
                            "backup_policy_id": test_volume_backup_policies["volumeBackupPolicies"][0]["id"],
                            "cluster_placement_group_id": cluster_placement_group_id,
                            "compartment_id": compartment_id,
                            "defined_tags": {
                                "operations__cost_center": "42",
                            },
                            "display_name": instance_configuration_instance_details_options_block_volumes_create_details_display_name,
                            "freeform_tags": {
                                "department": "Finance",
                            },
                            "kms_key_id": test_key["id"],
                            "size_in_gbs": instance_configuration_instance_details_options_block_volumes_create_details_size_in_gbs,
                            "source_details": {
                                "type": instance_configuration_instance_details_options_block_volumes_create_details_source_details_type,
                                "id": instance_configuration_instance_details_options_block_volumes_create_details_source_details_id,
                            },
                            "vpus_per_gb": instance_configuration_instance_details_options_block_volumes_create_details_vpus_per_gb,
                            "xrc_kms_key_id": test_key["id"],
                        },
                        "volume_id": test_volume["id"],
                    }],
                    "launch_details": {
                        "agent_config": {
                            "are_all_plugins_disabled": instance_configuration_instance_details_options_launch_details_agent_config_are_all_plugins_disabled,
                            "is_management_disabled": instance_configuration_instance_details_options_launch_details_agent_config_is_management_disabled,
                            "is_monitoring_disabled": instance_configuration_instance_details_options_launch_details_agent_config_is_monitoring_disabled,
                            "plugins_configs": [{
                                "desired_state": instance_configuration_instance_details_options_launch_details_agent_config_plugins_config_desired_state,
                                "name": instance_configuration_instance_details_options_launch_details_agent_config_plugins_config_name,
                            }],
                        },
                        "availability_config": {
                            "recovery_action": instance_configuration_instance_details_options_launch_details_availability_config_recovery_action,
                        },
                        "availability_domain": instance_configuration_instance_details_options_launch_details_availability_domain,
                        "capacity_reservation_id": test_capacity_reservation["id"],
                        "cluster_placement_group_id": test_group["id"],
                        "compartment_id": compartment_id,
                        "create_vnic_details": {
                            "assign_ipv6ip": instance_configuration_instance_details_launch_details_create_vnic_details_assign_ipv6ip,
                            "assign_private_dns_record": instance_configuration_instance_details_options_launch_details_create_vnic_details_assign_private_dns_record,
                            "assign_public_ip": instance_configuration_instance_details_options_launch_details_create_vnic_details_assign_public_ip,
                            "defined_tags": {
                                "operations__cost_center": "42",
                            },
                            "display_name": instance_configuration_instance_details_options_launch_details_create_vnic_details_display_name,
                            "freeform_tags": {
                                "department": "Finance",
                            },
                            "hostname_label": instance_configuration_instance_details_options_launch_details_create_vnic_details_hostname_label,
                            "ipv6address_ipv6subnet_cidr_pair_details": [{
                                "ipv6address": instance_configuration_instance_details_launch_details_create_vnic_details_ipv6address_ipv6subnet_cidr_pair_details_ipv6address,
                                "ipv6subnet_cidr": instance_configuration_instance_details_launch_details_create_vnic_details_ipv6address_ipv6subnet_cidr_pair_details_ipv6subnet_cidr,
                            }],
                            "nsg_ids": instance_configuration_instance_details_options_launch_details_create_vnic_details_nsg_ids,
                            "private_ip": instance_configuration_instance_details_options_launch_details_create_vnic_details_private_ip,
                            "security_attributes": instance_configuration_instance_details_options_launch_details_create_vnic_details_security_attributes,
                            "skip_source_dest_check": instance_configuration_instance_details_options_launch_details_create_vnic_details_skip_source_dest_check,
                            "subnet_id": test_subnet["id"],
                        },
                        "dedicated_vm_host_id": test_dedicated_vm_host["id"],
                        "defined_tags": {
                            "operations__cost_center": "42",
                        },
                        "display_name": instance_configuration_instance_details_options_launch_details_display_name,
                        "extended_metadata": instance_configuration_instance_details_options_launch_details_extended_metadata,
                        "fault_domain": instance_configuration_instance_details_options_launch_details_fault_domain,
                        "freeform_tags": {
                            "department": "Finance",
                        },
                        "instance_options": {
                            "are_legacy_imds_endpoints_disabled": instance_configuration_instance_details_options_launch_details_instance_options_are_legacy_imds_endpoints_disabled,
                        },
                        "ipxe_script": instance_configuration_instance_details_options_launch_details_ipxe_script,
                        "is_pv_encryption_in_transit_enabled": instance_configuration_instance_details_options_launch_details_is_pv_encryption_in_transit_enabled,
                        "launch_mode": instance_configuration_instance_details_options_launch_details_launch_mode,
                        "launch_options": {
                            "boot_volume_type": instance_configuration_instance_details_options_launch_details_launch_options_boot_volume_type,
                            "firmware": instance_configuration_instance_details_options_launch_details_launch_options_firmware,
                            "is_consistent_volume_naming_enabled": instance_configuration_instance_details_options_launch_details_launch_options_is_consistent_volume_naming_enabled,
                            "is_pv_encryption_in_transit_enabled": instance_configuration_instance_details_options_launch_details_launch_options_is_pv_encryption_in_transit_enabled,
                            "network_type": instance_configuration_instance_details_options_launch_details_launch_options_network_type,
                            "remote_data_volume_type": instance_configuration_instance_details_options_launch_details_launch_options_remote_data_volume_type,
                        },
                        "metadata": instance_configuration_instance_details_options_launch_details_metadata,
                        "platform_config": {
                            "type": instance_configuration_instance_details_options_launch_details_platform_config_type,
                            "are_virtual_instructions_enabled": instance_configuration_instance_details_options_launch_details_platform_config_are_virtual_instructions_enabled,
                            "is_access_control_service_enabled": instance_configuration_instance_details_options_launch_details_platform_config_is_access_control_service_enabled,
                            "is_input_output_memory_management_unit_enabled": instance_configuration_instance_details_options_launch_details_platform_config_is_input_output_memory_management_unit_enabled,
                            "is_measured_boot_enabled": instance_configuration_instance_details_options_launch_details_platform_config_is_measured_boot_enabled,
                            "is_memory_encryption_enabled": instance_configuration_instance_details_options_launch_details_platform_config_is_memory_encryption_enabled,
                            "is_secure_boot_enabled": instance_configuration_instance_details_options_launch_details_platform_config_is_secure_boot_enabled,
                            "is_symmetric_multi_threading_enabled": instance_configuration_instance_details_options_launch_details_platform_config_is_symmetric_multi_threading_enabled,
                            "is_trusted_platform_module_enabled": instance_configuration_instance_details_options_launch_details_platform_config_is_trusted_platform_module_enabled,
                            "numa_nodes_per_socket": instance_configuration_instance_details_options_launch_details_platform_config_numa_nodes_per_socket,
                            "percentage_of_cores_enabled": instance_configuration_instance_details_options_launch_details_platform_config_percentage_of_cores_enabled,
                        },
                        "preemptible_instance_config": {
                            "preemption_action": {
                                "type": instance_configuration_instance_details_options_launch_details_preemptible_instance_config_preemption_action_type,
                                "preserve_boot_volume": instance_configuration_instance_details_options_launch_details_preemptible_instance_config_preemption_action_preserve_boot_volume,
                            },
                        },
                        "preferred_maintenance_action": instance_configuration_instance_details_options_launch_details_preferred_maintenance_action,
                        "security_attributes": instance_configuration_instance_details_options_launch_details_security_attributes,
                        "shape": instance_configuration_instance_details_options_launch_details_shape,
                        "shape_config": {
                            "baseline_ocpu_utilization": instance_configuration_instance_details_options_launch_details_shape_config_baseline_ocpu_utilization,
                            "memory_in_gbs": instance_configuration_instance_details_options_launch_details_shape_config_memory_in_gbs,
                            "nvmes": instance_configuration_instance_details_options_launch_details_shape_config_nvmes,
                            "ocpus": instance_configuration_instance_details_options_launch_details_shape_config_ocpus,
                            "vcpus": instance_configuration_instance_details_options_launch_details_shape_config_vcpus,
                        },
                        "source_details": {
                            "source_type": instance_configuration_instance_details_options_launch_details_source_details_source_type,
                            "boot_volume_id": test_boot_volume["id"],
                            "boot_volume_size_in_gbs": instance_configuration_instance_details_options_launch_details_source_details_boot_volume_size_in_gbs,
                            "boot_volume_vpus_per_gb": instance_configuration_instance_details_options_launch_details_source_details_boot_volume_vpus_per_gb,
                            "image_id": test_image["id"],
                            "instance_source_image_filter_details": {
                                "compartment_id": compartment_id,
                                "defined_tags_filter": instance_configuration_instance_details_options_launch_details_source_details_instance_source_image_filter_details_defined_tags_filter,
                                "operating_system": instance_configuration_instance_details_options_launch_details_source_details_instance_source_image_filter_details_operating_system,
                                "operating_system_version": instance_configuration_instance_details_options_launch_details_source_details_instance_source_image_filter_details_operating_system_version,
                            },
                        },
                    },
                    "secondary_vnics": [{
                        "create_vnic_details": {
                            "assign_ipv6ip": instance_configuration_instance_details_secondary_vnics_create_vnic_details_assign_ipv6ip,
                            "assign_private_dns_record": instance_configuration_instance_details_options_secondary_vnics_create_vnic_details_assign_private_dns_record,
                            "assign_public_ip": instance_configuration_instance_details_options_secondary_vnics_create_vnic_details_assign_public_ip,
                            "defined_tags": {
                                "operations__cost_center": "42",
                            },
                            "display_name": instance_configuration_instance_details_options_secondary_vnics_create_vnic_details_display_name,
                            "freeform_tags": {
                                "department": "Finance",
                            },
                            "hostname_label": instance_configuration_instance_details_options_secondary_vnics_create_vnic_details_hostname_label,
                            "ipv6address_ipv6subnet_cidr_pair_details": [{
                                "ipv6address": instance_configuration_instance_details_secondary_vnics_create_vnic_details_ipv6address_ipv6subnet_cidr_pair_details_ipv6address,
                                "ipv6subnet_cidr": instance_configuration_instance_details_secondary_vnics_create_vnic_details_ipv6address_ipv6subnet_cidr_pair_details_ipv6subnet_cidr,
                            }],
                            "nsg_ids": instance_configuration_instance_details_options_secondary_vnics_create_vnic_details_nsg_ids,
                            "private_ip": instance_configuration_instance_details_options_secondary_vnics_create_vnic_details_private_ip,
                            "security_attributes": instance_configuration_instance_details_options_secondary_vnics_create_vnic_details_security_attributes,
                            "skip_source_dest_check": instance_configuration_instance_details_options_secondary_vnics_create_vnic_details_skip_source_dest_check,
                            "subnet_id": test_subnet["id"],
                        },
                        "display_name": instance_configuration_instance_details_options_secondary_vnics_display_name,
                        "nic_index": instance_configuration_instance_details_options_secondary_vnics_nic_index,
                    }],
                }],
                "secondary_vnics": [{
                    "create_vnic_details": {
                        "assign_private_dns_record": instance_configuration_instance_details_secondary_vnics_create_vnic_details_assign_private_dns_record,
                        "assign_public_ip": instance_configuration_instance_details_secondary_vnics_create_vnic_details_assign_public_ip,
                        "defined_tags": {
                            "operations__cost_center": "42",
                        },
                        "display_name": instance_configuration_instance_details_secondary_vnics_create_vnic_details_display_name,
                        "freeform_tags": {
                            "department": "Finance",
                        },
                        "hostname_label": instance_configuration_instance_details_secondary_vnics_create_vnic_details_hostname_label,
                        "nsg_ids": instance_configuration_instance_details_secondary_vnics_create_vnic_details_nsg_ids,
                        "private_ip": instance_configuration_instance_details_secondary_vnics_create_vnic_details_private_ip,
                        "security_attributes": instance_configuration_instance_details_secondary_vnics_create_vnic_details_security_attributes,
                        "skip_source_dest_check": instance_configuration_instance_details_secondary_vnics_create_vnic_details_skip_source_dest_check,
                        "subnet_id": test_subnet["id"],
                    },
                    "display_name": instance_configuration_instance_details_secondary_vnics_display_name,
                    "nic_index": instance_configuration_instance_details_secondary_vnics_nic_index,
                }],
            },
            instance_id=test_instance["id"],
            source=instance_configuration_source)
        ```

        ## Import

        InstanceConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/instanceConfiguration:InstanceConfiguration test_instance_configuration "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance to use to create the instance configuration.
        :param pulumi.Input[str] source: The source of the instance configuration. An instance configuration defines the settings to use when creating Compute instances, including details such as the base image, shape, and metadata. You can also specify the associated resources for the instance, such as block volume attachments and network configuration.
               
               When you create an instance configuration using an existing instance as a template, the instance configuration does not include any information from the source instance's boot volume, such as installed applications, binaries, and files on the instance. It also does not include the contents of any block volumes that are attached to the instance.
               
               To create an instance configuration that includes the custom setup from an instance's boot volume, you must first create a custom image from the instance (see [CreateImage](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Image/CreateImage)). Then, use the custom image to launch a new instance (see [LaunchInstance](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Instance/LaunchInstance)). Finally, create the instance configuration based on the instance that you created from the custom image.
               
               To include block volume contents with an instance configuration, first create a backup of the attached block volumes (see [CreateVolumeBackup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/VolumeBackup/CreateVolumeBackup)). Then, create the instance configuration by specifying the list of settings, using [InstanceConfigurationVolumeSourceFromVolumeBackupDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/datatypes/InstanceConfigurationVolumeSourceFromVolumeBackupDetails) to include the block volume backups in the list of settings.
               
               The following values are supported:
               * `NONE`: Creates an instance configuration using the list of settings that you specify.
               * `INSTANCE`: Creates an instance configuration using an existing instance as a template.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Instance Configuration resource in Oracle Cloud Infrastructure Core service.

        Creates an instance configuration. An instance configuration is a template that defines the
        settings to use when creating Compute instances.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_instance_configuration = oci.core.InstanceConfiguration("test_instance_configuration",
            compartment_id=compartment_id,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=instance_configuration_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            instance_details={
                "instance_type": instance_configuration_instance_details_instance_type,
                "block_volumes": [{
                    "attach_details": {
                        "type": instance_configuration_instance_details_block_volumes_attach_details_type,
                        "device": instance_configuration_instance_details_block_volumes_attach_details_device,
                        "display_name": instance_configuration_instance_details_block_volumes_attach_details_display_name,
                        "is_pv_encryption_in_transit_enabled": instance_configuration_instance_details_block_volumes_attach_details_is_pv_encryption_in_transit_enabled,
                        "is_read_only": instance_configuration_instance_details_block_volumes_attach_details_is_read_only,
                        "is_shareable": instance_configuration_instance_details_block_volumes_attach_details_is_shareable,
                        "use_chap": instance_configuration_instance_details_block_volumes_attach_details_use_chap,
                    },
                    "create_details": {
                        "autotune_policies": [{
                            "autotune_type": instance_configuration_instance_details_block_volumes_create_details_autotune_policies_autotune_type,
                            "max_vpus_per_gb": instance_configuration_instance_details_block_volumes_create_details_autotune_policies_max_vpus_per_gb,
                        }],
                        "availability_domain": instance_configuration_instance_details_block_volumes_create_details_availability_domain,
                        "backup_policy_id": test_volume_backup_policies["volumeBackupPolicies"][0]["id"],
                        "block_volume_replicas": {
                            "availability_domain": instance_configuration_instance_details_block_volumes_create_details_block_volume_replicas_availability_domain,
                            "display_name": instance_configuration_instance_details_block_volumes_create_details_block_volume_replicas_display_name,
                        },
                        "cluster_placement_group_id": cluster_placement_group_id,
                        "compartment_id": compartment_id,
                        "defined_tags": {
                            "operations__cost_center": "42",
                        },
                        "display_name": instance_configuration_instance_details_block_volumes_create_details_display_name,
                        "freeform_tags": {
                            "department": "Finance",
                        },
                        "is_auto_tune_enabled": instance_configuration_instance_details_block_volumes_create_details_is_auto_tune_enabled,
                        "kms_key_id": test_key["id"],
                        "size_in_gbs": instance_configuration_instance_details_block_volumes_create_details_size_in_gbs,
                        "source_details": {
                            "type": instance_configuration_instance_details_block_volumes_create_details_source_details_type,
                            "id": instance_configuration_instance_details_block_volumes_create_details_source_details_id,
                        },
                        "vpus_per_gb": instance_configuration_instance_details_block_volumes_create_details_vpus_per_gb,
                        "xrc_kms_key_id": test_key["id"],
                    },
                    "volume_id": test_volume["id"],
                }],
                "launch_details": {
                    "agent_config": {
                        "are_all_plugins_disabled": instance_configuration_instance_details_launch_details_agent_config_are_all_plugins_disabled,
                        "is_management_disabled": instance_configuration_instance_details_launch_details_agent_config_is_management_disabled,
                        "is_monitoring_disabled": instance_configuration_instance_details_launch_details_agent_config_is_monitoring_disabled,
                        "plugins_configs": [{
                            "desired_state": instance_configuration_instance_details_launch_details_agent_config_plugins_config_desired_state,
                            "name": instance_configuration_instance_details_launch_details_agent_config_plugins_config_name,
                        }],
                    },
                    "availability_config": {
                        "is_live_migration_preferred": instance_configuration_instance_details_launch_details_availability_config_is_live_migration_preferred,
                        "recovery_action": instance_configuration_instance_details_launch_details_availability_config_recovery_action,
                    },
                    "availability_domain": instance_configuration_instance_details_launch_details_availability_domain,
                    "capacity_reservation_id": test_capacity_reservation["id"],
                    "cluster_placement_group_id": test_group["id"],
                    "compartment_id": compartment_id,
                    "create_vnic_details": {
                        "assign_ipv6ip": instance_configuration_instance_details_launch_details_create_vnic_details_assign_ipv6ip,
                        "assign_private_dns_record": instance_configuration_instance_details_launch_details_create_vnic_details_assign_private_dns_record,
                        "assign_public_ip": instance_configuration_instance_details_launch_details_create_vnic_details_assign_public_ip,
                        "defined_tags": {
                            "operations__cost_center": "42",
                        },
                        "display_name": instance_configuration_instance_details_launch_details_create_vnic_details_display_name,
                        "freeform_tags": {
                            "department": "Finance",
                        },
                        "hostname_label": instance_configuration_instance_details_launch_details_create_vnic_details_hostname_label,
                        "ipv6address_ipv6subnet_cidr_pair_details": [{
                            "ipv6address": instance_configuration_instance_details_launch_details_create_vnic_details_ipv6address_ipv6subnet_cidr_pair_details_ipv6address,
                            "ipv6subnet_cidr": instance_configuration_instance_details_launch_details_create_vnic_details_ipv6address_ipv6subnet_cidr_pair_details_ipv6subnet_cidr,
                        }],
                        "nsg_ids": instance_configuration_instance_details_launch_details_create_vnic_details_nsg_ids,
                        "private_ip": instance_configuration_instance_details_launch_details_create_vnic_details_private_ip,
                        "security_attributes": instance_configuration_instance_details_launch_details_create_vnic_details_security_attributes,
                        "skip_source_dest_check": instance_configuration_instance_details_launch_details_create_vnic_details_skip_source_dest_check,
                        "subnet_id": test_subnet["id"],
                    },
                    "dedicated_vm_host_id": test_dedicated_vm_host["id"],
                    "defined_tags": {
                        "operations__cost_center": "42",
                    },
                    "display_name": instance_configuration_instance_details_launch_details_display_name,
                    "extended_metadata": instance_configuration_instance_details_launch_details_extended_metadata,
                    "fault_domain": instance_configuration_instance_details_launch_details_fault_domain,
                    "freeform_tags": {
                        "department": "Finance",
                    },
                    "instance_options": {
                        "are_legacy_imds_endpoints_disabled": instance_configuration_instance_details_launch_details_instance_options_are_legacy_imds_endpoints_disabled,
                    },
                    "ipxe_script": instance_configuration_instance_details_launch_details_ipxe_script,
                    "is_pv_encryption_in_transit_enabled": instance_configuration_instance_details_launch_details_is_pv_encryption_in_transit_enabled,
                    "launch_mode": instance_configuration_instance_details_launch_details_launch_mode,
                    "launch_options": {
                        "boot_volume_type": instance_configuration_instance_details_launch_details_launch_options_boot_volume_type,
                        "firmware": instance_configuration_instance_details_launch_details_launch_options_firmware,
                        "is_consistent_volume_naming_enabled": instance_configuration_instance_details_launch_details_launch_options_is_consistent_volume_naming_enabled,
                        "is_pv_encryption_in_transit_enabled": instance_configuration_instance_details_launch_details_launch_options_is_pv_encryption_in_transit_enabled,
                        "network_type": instance_configuration_instance_details_launch_details_launch_options_network_type,
                        "remote_data_volume_type": instance_configuration_instance_details_launch_details_launch_options_remote_data_volume_type,
                    },
                    "metadata": instance_configuration_instance_details_launch_details_metadata,
                    "platform_config": {
                        "type": instance_configuration_instance_details_launch_details_platform_config_type,
                        "are_virtual_instructions_enabled": instance_configuration_instance_details_launch_details_platform_config_are_virtual_instructions_enabled,
                        "config_map": instance_configuration_instance_details_launch_details_platform_config_config_map,
                        "is_access_control_service_enabled": instance_configuration_instance_details_launch_details_platform_config_is_access_control_service_enabled,
                        "is_input_output_memory_management_unit_enabled": instance_configuration_instance_details_launch_details_platform_config_is_input_output_memory_management_unit_enabled,
                        "is_measured_boot_enabled": instance_configuration_instance_details_launch_details_platform_config_is_measured_boot_enabled,
                        "is_memory_encryption_enabled": instance_configuration_instance_details_launch_details_platform_config_is_memory_encryption_enabled,
                        "is_secure_boot_enabled": instance_configuration_instance_details_launch_details_platform_config_is_secure_boot_enabled,
                        "is_symmetric_multi_threading_enabled": instance_configuration_instance_details_launch_details_platform_config_is_symmetric_multi_threading_enabled,
                        "is_trusted_platform_module_enabled": instance_configuration_instance_details_launch_details_platform_config_is_trusted_platform_module_enabled,
                        "numa_nodes_per_socket": instance_configuration_instance_details_launch_details_platform_config_numa_nodes_per_socket,
                        "percentage_of_cores_enabled": instance_configuration_instance_details_launch_details_platform_config_percentage_of_cores_enabled,
                    },
                    "preemptible_instance_config": {
                        "preemption_action": {
                            "type": instance_configuration_instance_details_launch_details_preemptible_instance_config_preemption_action_type,
                            "preserve_boot_volume": instance_configuration_instance_details_launch_details_preemptible_instance_config_preemption_action_preserve_boot_volume,
                        },
                    },
                    "preferred_maintenance_action": instance_configuration_instance_details_launch_details_preferred_maintenance_action,
                    "security_attributes": instance_configuration_instance_details_launch_details_security_attributes,
                    "shape": instance_configuration_instance_details_launch_details_shape,
                    "shape_config": {
                        "baseline_ocpu_utilization": instance_configuration_instance_details_launch_details_shape_config_baseline_ocpu_utilization,
                        "memory_in_gbs": instance_configuration_instance_details_launch_details_shape_config_memory_in_gbs,
                        "nvmes": instance_configuration_instance_details_launch_details_shape_config_nvmes,
                        "ocpus": instance_configuration_instance_details_launch_details_shape_config_ocpus,
                        "vcpus": instance_configuration_instance_details_launch_details_shape_config_vcpus,
                    },
                    "source_details": {
                        "source_type": instance_configuration_instance_details_launch_details_source_details_source_type,
                        "boot_volume_id": test_boot_volume["id"],
                        "boot_volume_size_in_gbs": instance_configuration_instance_details_launch_details_source_details_boot_volume_size_in_gbs,
                        "boot_volume_vpus_per_gb": instance_configuration_instance_details_launch_details_source_details_boot_volume_vpus_per_gb,
                        "image_id": test_image["id"],
                        "kms_key_id": test_key["id"],
                        "instance_source_image_filter_details": {
                            "compartment_id": compartment_id,
                            "defined_tags_filter": instance_configuration_instance_details_launch_details_source_details_instance_source_image_filter_details_defined_tags_filter,
                            "operating_system": instance_configuration_instance_details_launch_details_source_details_instance_source_image_filter_details_operating_system,
                            "operating_system_version": instance_configuration_instance_details_launch_details_source_details_instance_source_image_filter_details_operating_system_version,
                        },
                    },
                },
                "options": [{
                    "block_volumes": [{
                        "attach_details": {
                            "type": instance_configuration_instance_details_options_block_volumes_attach_details_type,
                            "device": instance_configuration_instance_details_options_block_volumes_attach_details_device,
                            "display_name": instance_configuration_instance_details_options_block_volumes_attach_details_display_name,
                            "is_pv_encryption_in_transit_enabled": instance_configuration_instance_details_options_block_volumes_attach_details_is_pv_encryption_in_transit_enabled,
                            "is_read_only": instance_configuration_instance_details_options_block_volumes_attach_details_is_read_only,
                            "is_shareable": instance_configuration_instance_details_options_block_volumes_attach_details_is_shareable,
                            "use_chap": instance_configuration_instance_details_options_block_volumes_attach_details_use_chap,
                        },
                        "create_details": {
                            "autotune_policies": [{
                                "autotune_type": instance_configuration_instance_details_options_block_volumes_create_details_autotune_policies_autotune_type,
                                "max_vpus_per_gb": instance_configuration_instance_details_options_block_volumes_create_details_autotune_policies_max_vpus_per_gb,
                            }],
                            "availability_domain": instance_configuration_instance_details_options_block_volumes_create_details_availability_domain,
                            "backup_policy_id": test_volume_backup_policies["volumeBackupPolicies"][0]["id"],
                            "cluster_placement_group_id": cluster_placement_group_id,
                            "compartment_id": compartment_id,
                            "defined_tags": {
                                "operations__cost_center": "42",
                            },
                            "display_name": instance_configuration_instance_details_options_block_volumes_create_details_display_name,
                            "freeform_tags": {
                                "department": "Finance",
                            },
                            "kms_key_id": test_key["id"],
                            "size_in_gbs": instance_configuration_instance_details_options_block_volumes_create_details_size_in_gbs,
                            "source_details": {
                                "type": instance_configuration_instance_details_options_block_volumes_create_details_source_details_type,
                                "id": instance_configuration_instance_details_options_block_volumes_create_details_source_details_id,
                            },
                            "vpus_per_gb": instance_configuration_instance_details_options_block_volumes_create_details_vpus_per_gb,
                            "xrc_kms_key_id": test_key["id"],
                        },
                        "volume_id": test_volume["id"],
                    }],
                    "launch_details": {
                        "agent_config": {
                            "are_all_plugins_disabled": instance_configuration_instance_details_options_launch_details_agent_config_are_all_plugins_disabled,
                            "is_management_disabled": instance_configuration_instance_details_options_launch_details_agent_config_is_management_disabled,
                            "is_monitoring_disabled": instance_configuration_instance_details_options_launch_details_agent_config_is_monitoring_disabled,
                            "plugins_configs": [{
                                "desired_state": instance_configuration_instance_details_options_launch_details_agent_config_plugins_config_desired_state,
                                "name": instance_configuration_instance_details_options_launch_details_agent_config_plugins_config_name,
                            }],
                        },
                        "availability_config": {
                            "recovery_action": instance_configuration_instance_details_options_launch_details_availability_config_recovery_action,
                        },
                        "availability_domain": instance_configuration_instance_details_options_launch_details_availability_domain,
                        "capacity_reservation_id": test_capacity_reservation["id"],
                        "cluster_placement_group_id": test_group["id"],
                        "compartment_id": compartment_id,
                        "create_vnic_details": {
                            "assign_ipv6ip": instance_configuration_instance_details_launch_details_create_vnic_details_assign_ipv6ip,
                            "assign_private_dns_record": instance_configuration_instance_details_options_launch_details_create_vnic_details_assign_private_dns_record,
                            "assign_public_ip": instance_configuration_instance_details_options_launch_details_create_vnic_details_assign_public_ip,
                            "defined_tags": {
                                "operations__cost_center": "42",
                            },
                            "display_name": instance_configuration_instance_details_options_launch_details_create_vnic_details_display_name,
                            "freeform_tags": {
                                "department": "Finance",
                            },
                            "hostname_label": instance_configuration_instance_details_options_launch_details_create_vnic_details_hostname_label,
                            "ipv6address_ipv6subnet_cidr_pair_details": [{
                                "ipv6address": instance_configuration_instance_details_launch_details_create_vnic_details_ipv6address_ipv6subnet_cidr_pair_details_ipv6address,
                                "ipv6subnet_cidr": instance_configuration_instance_details_launch_details_create_vnic_details_ipv6address_ipv6subnet_cidr_pair_details_ipv6subnet_cidr,
                            }],
                            "nsg_ids": instance_configuration_instance_details_options_launch_details_create_vnic_details_nsg_ids,
                            "private_ip": instance_configuration_instance_details_options_launch_details_create_vnic_details_private_ip,
                            "security_attributes": instance_configuration_instance_details_options_launch_details_create_vnic_details_security_attributes,
                            "skip_source_dest_check": instance_configuration_instance_details_options_launch_details_create_vnic_details_skip_source_dest_check,
                            "subnet_id": test_subnet["id"],
                        },
                        "dedicated_vm_host_id": test_dedicated_vm_host["id"],
                        "defined_tags": {
                            "operations__cost_center": "42",
                        },
                        "display_name": instance_configuration_instance_details_options_launch_details_display_name,
                        "extended_metadata": instance_configuration_instance_details_options_launch_details_extended_metadata,
                        "fault_domain": instance_configuration_instance_details_options_launch_details_fault_domain,
                        "freeform_tags": {
                            "department": "Finance",
                        },
                        "instance_options": {
                            "are_legacy_imds_endpoints_disabled": instance_configuration_instance_details_options_launch_details_instance_options_are_legacy_imds_endpoints_disabled,
                        },
                        "ipxe_script": instance_configuration_instance_details_options_launch_details_ipxe_script,
                        "is_pv_encryption_in_transit_enabled": instance_configuration_instance_details_options_launch_details_is_pv_encryption_in_transit_enabled,
                        "launch_mode": instance_configuration_instance_details_options_launch_details_launch_mode,
                        "launch_options": {
                            "boot_volume_type": instance_configuration_instance_details_options_launch_details_launch_options_boot_volume_type,
                            "firmware": instance_configuration_instance_details_options_launch_details_launch_options_firmware,
                            "is_consistent_volume_naming_enabled": instance_configuration_instance_details_options_launch_details_launch_options_is_consistent_volume_naming_enabled,
                            "is_pv_encryption_in_transit_enabled": instance_configuration_instance_details_options_launch_details_launch_options_is_pv_encryption_in_transit_enabled,
                            "network_type": instance_configuration_instance_details_options_launch_details_launch_options_network_type,
                            "remote_data_volume_type": instance_configuration_instance_details_options_launch_details_launch_options_remote_data_volume_type,
                        },
                        "metadata": instance_configuration_instance_details_options_launch_details_metadata,
                        "platform_config": {
                            "type": instance_configuration_instance_details_options_launch_details_platform_config_type,
                            "are_virtual_instructions_enabled": instance_configuration_instance_details_options_launch_details_platform_config_are_virtual_instructions_enabled,
                            "is_access_control_service_enabled": instance_configuration_instance_details_options_launch_details_platform_config_is_access_control_service_enabled,
                            "is_input_output_memory_management_unit_enabled": instance_configuration_instance_details_options_launch_details_platform_config_is_input_output_memory_management_unit_enabled,
                            "is_measured_boot_enabled": instance_configuration_instance_details_options_launch_details_platform_config_is_measured_boot_enabled,
                            "is_memory_encryption_enabled": instance_configuration_instance_details_options_launch_details_platform_config_is_memory_encryption_enabled,
                            "is_secure_boot_enabled": instance_configuration_instance_details_options_launch_details_platform_config_is_secure_boot_enabled,
                            "is_symmetric_multi_threading_enabled": instance_configuration_instance_details_options_launch_details_platform_config_is_symmetric_multi_threading_enabled,
                            "is_trusted_platform_module_enabled": instance_configuration_instance_details_options_launch_details_platform_config_is_trusted_platform_module_enabled,
                            "numa_nodes_per_socket": instance_configuration_instance_details_options_launch_details_platform_config_numa_nodes_per_socket,
                            "percentage_of_cores_enabled": instance_configuration_instance_details_options_launch_details_platform_config_percentage_of_cores_enabled,
                        },
                        "preemptible_instance_config": {
                            "preemption_action": {
                                "type": instance_configuration_instance_details_options_launch_details_preemptible_instance_config_preemption_action_type,
                                "preserve_boot_volume": instance_configuration_instance_details_options_launch_details_preemptible_instance_config_preemption_action_preserve_boot_volume,
                            },
                        },
                        "preferred_maintenance_action": instance_configuration_instance_details_options_launch_details_preferred_maintenance_action,
                        "security_attributes": instance_configuration_instance_details_options_launch_details_security_attributes,
                        "shape": instance_configuration_instance_details_options_launch_details_shape,
                        "shape_config": {
                            "baseline_ocpu_utilization": instance_configuration_instance_details_options_launch_details_shape_config_baseline_ocpu_utilization,
                            "memory_in_gbs": instance_configuration_instance_details_options_launch_details_shape_config_memory_in_gbs,
                            "nvmes": instance_configuration_instance_details_options_launch_details_shape_config_nvmes,
                            "ocpus": instance_configuration_instance_details_options_launch_details_shape_config_ocpus,
                            "vcpus": instance_configuration_instance_details_options_launch_details_shape_config_vcpus,
                        },
                        "source_details": {
                            "source_type": instance_configuration_instance_details_options_launch_details_source_details_source_type,
                            "boot_volume_id": test_boot_volume["id"],
                            "boot_volume_size_in_gbs": instance_configuration_instance_details_options_launch_details_source_details_boot_volume_size_in_gbs,
                            "boot_volume_vpus_per_gb": instance_configuration_instance_details_options_launch_details_source_details_boot_volume_vpus_per_gb,
                            "image_id": test_image["id"],
                            "instance_source_image_filter_details": {
                                "compartment_id": compartment_id,
                                "defined_tags_filter": instance_configuration_instance_details_options_launch_details_source_details_instance_source_image_filter_details_defined_tags_filter,
                                "operating_system": instance_configuration_instance_details_options_launch_details_source_details_instance_source_image_filter_details_operating_system,
                                "operating_system_version": instance_configuration_instance_details_options_launch_details_source_details_instance_source_image_filter_details_operating_system_version,
                            },
                        },
                    },
                    "secondary_vnics": [{
                        "create_vnic_details": {
                            "assign_ipv6ip": instance_configuration_instance_details_secondary_vnics_create_vnic_details_assign_ipv6ip,
                            "assign_private_dns_record": instance_configuration_instance_details_options_secondary_vnics_create_vnic_details_assign_private_dns_record,
                            "assign_public_ip": instance_configuration_instance_details_options_secondary_vnics_create_vnic_details_assign_public_ip,
                            "defined_tags": {
                                "operations__cost_center": "42",
                            },
                            "display_name": instance_configuration_instance_details_options_secondary_vnics_create_vnic_details_display_name,
                            "freeform_tags": {
                                "department": "Finance",
                            },
                            "hostname_label": instance_configuration_instance_details_options_secondary_vnics_create_vnic_details_hostname_label,
                            "ipv6address_ipv6subnet_cidr_pair_details": [{
                                "ipv6address": instance_configuration_instance_details_secondary_vnics_create_vnic_details_ipv6address_ipv6subnet_cidr_pair_details_ipv6address,
                                "ipv6subnet_cidr": instance_configuration_instance_details_secondary_vnics_create_vnic_details_ipv6address_ipv6subnet_cidr_pair_details_ipv6subnet_cidr,
                            }],
                            "nsg_ids": instance_configuration_instance_details_options_secondary_vnics_create_vnic_details_nsg_ids,
                            "private_ip": instance_configuration_instance_details_options_secondary_vnics_create_vnic_details_private_ip,
                            "security_attributes": instance_configuration_instance_details_options_secondary_vnics_create_vnic_details_security_attributes,
                            "skip_source_dest_check": instance_configuration_instance_details_options_secondary_vnics_create_vnic_details_skip_source_dest_check,
                            "subnet_id": test_subnet["id"],
                        },
                        "display_name": instance_configuration_instance_details_options_secondary_vnics_display_name,
                        "nic_index": instance_configuration_instance_details_options_secondary_vnics_nic_index,
                    }],
                }],
                "secondary_vnics": [{
                    "create_vnic_details": {
                        "assign_private_dns_record": instance_configuration_instance_details_secondary_vnics_create_vnic_details_assign_private_dns_record,
                        "assign_public_ip": instance_configuration_instance_details_secondary_vnics_create_vnic_details_assign_public_ip,
                        "defined_tags": {
                            "operations__cost_center": "42",
                        },
                        "display_name": instance_configuration_instance_details_secondary_vnics_create_vnic_details_display_name,
                        "freeform_tags": {
                            "department": "Finance",
                        },
                        "hostname_label": instance_configuration_instance_details_secondary_vnics_create_vnic_details_hostname_label,
                        "nsg_ids": instance_configuration_instance_details_secondary_vnics_create_vnic_details_nsg_ids,
                        "private_ip": instance_configuration_instance_details_secondary_vnics_create_vnic_details_private_ip,
                        "security_attributes": instance_configuration_instance_details_secondary_vnics_create_vnic_details_security_attributes,
                        "skip_source_dest_check": instance_configuration_instance_details_secondary_vnics_create_vnic_details_skip_source_dest_check,
                        "subnet_id": test_subnet["id"],
                    },
                    "display_name": instance_configuration_instance_details_secondary_vnics_display_name,
                    "nic_index": instance_configuration_instance_details_secondary_vnics_nic_index,
                }],
            },
            instance_id=test_instance["id"],
            source=instance_configuration_source)
        ```

        ## Import

        InstanceConfigurations can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/instanceConfiguration:InstanceConfiguration test_instance_configuration "id"
        ```

        :param str resource_name: The name of the resource.
        :param InstanceConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 instance_details: Optional[pulumi.Input[Union['InstanceConfigurationInstanceDetailsArgs', 'InstanceConfigurationInstanceDetailsArgsDict']]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceConfigurationArgs.__new__(InstanceConfigurationArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["instance_details"] = instance_details
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["source"] = source
            __props__.__dict__["deferred_fields"] = None
            __props__.__dict__["time_created"] = None
        super(InstanceConfiguration, __self__).__init__(
            'oci:Core/instanceConfiguration:InstanceConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            deferred_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            instance_details: Optional[pulumi.Input[Union['InstanceConfigurationInstanceDetailsArgs', 'InstanceConfigurationInstanceDetailsArgsDict']]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None) -> 'InstanceConfiguration':
        """
        Get an existing InstanceConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance configuration.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] deferred_fields: Parameters that were not specified when the instance configuration was created, but that are required to launch an instance from the instance configuration. See the [LaunchInstanceConfiguration](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Instance/LaunchInstanceConfiguration) operation.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance to use to create the instance configuration.
        :param pulumi.Input[str] source: The source of the instance configuration. An instance configuration defines the settings to use when creating Compute instances, including details such as the base image, shape, and metadata. You can also specify the associated resources for the instance, such as block volume attachments and network configuration.
               
               When you create an instance configuration using an existing instance as a template, the instance configuration does not include any information from the source instance's boot volume, such as installed applications, binaries, and files on the instance. It also does not include the contents of any block volumes that are attached to the instance.
               
               To create an instance configuration that includes the custom setup from an instance's boot volume, you must first create a custom image from the instance (see [CreateImage](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Image/CreateImage)). Then, use the custom image to launch a new instance (see [LaunchInstance](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Instance/LaunchInstance)). Finally, create the instance configuration based on the instance that you created from the custom image.
               
               To include block volume contents with an instance configuration, first create a backup of the attached block volumes (see [CreateVolumeBackup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/VolumeBackup/CreateVolumeBackup)). Then, create the instance configuration by specifying the list of settings, using [InstanceConfigurationVolumeSourceFromVolumeBackupDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/datatypes/InstanceConfigurationVolumeSourceFromVolumeBackupDetails) to include the block volume backups in the list of settings.
               
               The following values are supported:
               * `NONE`: Creates an instance configuration using the list of settings that you specify.
               * `INSTANCE`: Creates an instance configuration using an existing instance as a template.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The date and time the instance configuration was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceConfigurationState.__new__(_InstanceConfigurationState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["deferred_fields"] = deferred_fields
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["instance_details"] = instance_details
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["source"] = source
        __props__.__dict__["time_created"] = time_created
        return InstanceConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the instance configuration.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="deferredFields")
    def deferred_fields(self) -> pulumi.Output[Sequence[str]]:
        """
        Parameters that were not specified when the instance configuration was created, but that are required to launch an instance from the instance configuration. See the [LaunchInstanceConfiguration](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Instance/LaunchInstanceConfiguration) operation.
        """
        return pulumi.get(self, "deferred_fields")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="instanceDetails")
    def instance_details(self) -> pulumi.Output['outputs.InstanceConfigurationInstanceDetails']:
        return pulumi.get(self, "instance_details")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance to use to create the instance configuration.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[str]:
        """
        The source of the instance configuration. An instance configuration defines the settings to use when creating Compute instances, including details such as the base image, shape, and metadata. You can also specify the associated resources for the instance, such as block volume attachments and network configuration.

        When you create an instance configuration using an existing instance as a template, the instance configuration does not include any information from the source instance's boot volume, such as installed applications, binaries, and files on the instance. It also does not include the contents of any block volumes that are attached to the instance.

        To create an instance configuration that includes the custom setup from an instance's boot volume, you must first create a custom image from the instance (see [CreateImage](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Image/CreateImage)). Then, use the custom image to launch a new instance (see [LaunchInstance](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Instance/LaunchInstance)). Finally, create the instance configuration based on the instance that you created from the custom image.

        To include block volume contents with an instance configuration, first create a backup of the attached block volumes (see [CreateVolumeBackup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/VolumeBackup/CreateVolumeBackup)). Then, create the instance configuration by specifying the list of settings, using [InstanceConfigurationVolumeSourceFromVolumeBackupDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/datatypes/InstanceConfigurationVolumeSourceFromVolumeBackupDetails) to include the block volume backups in the list of settings.

        The following values are supported:
        * `NONE`: Creates an instance configuration using the list of settings that you specify.
        * `INSTANCE`: Creates an instance configuration using an existing instance as a template.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the instance configuration was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

