# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutonomousDatabasesResult',
    'AwaitableGetAutonomousDatabasesResult',
    'get_autonomous_databases',
    'get_autonomous_databases_output',
]

@pulumi.output_type
class GetAutonomousDatabasesResult:
    """
    A collection of values returned by getAutonomousDatabases.
    """
    def __init__(__self__, autonomous_container_database_id=None, autonomous_databases=None, compartment_id=None, db_version=None, db_workload=None, display_name=None, filters=None, id=None, infrastructure_type=None, is_data_guard_enabled=None, is_free_tier=None, is_refreshable_clone=None, is_resource_pool_leader=None, lifecycle_state_not_equal_to=None, resource_pool_leader_id=None, state=None):
        if autonomous_container_database_id and not isinstance(autonomous_container_database_id, str):
            raise TypeError("Expected argument 'autonomous_container_database_id' to be a str")
        pulumi.set(__self__, "autonomous_container_database_id", autonomous_container_database_id)
        if autonomous_databases and not isinstance(autonomous_databases, list):
            raise TypeError("Expected argument 'autonomous_databases' to be a list")
        pulumi.set(__self__, "autonomous_databases", autonomous_databases)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_version and not isinstance(db_version, str):
            raise TypeError("Expected argument 'db_version' to be a str")
        pulumi.set(__self__, "db_version", db_version)
        if db_workload and not isinstance(db_workload, str):
            raise TypeError("Expected argument 'db_workload' to be a str")
        pulumi.set(__self__, "db_workload", db_workload)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if infrastructure_type and not isinstance(infrastructure_type, str):
            raise TypeError("Expected argument 'infrastructure_type' to be a str")
        pulumi.set(__self__, "infrastructure_type", infrastructure_type)
        if is_data_guard_enabled and not isinstance(is_data_guard_enabled, bool):
            raise TypeError("Expected argument 'is_data_guard_enabled' to be a bool")
        pulumi.set(__self__, "is_data_guard_enabled", is_data_guard_enabled)
        if is_free_tier and not isinstance(is_free_tier, bool):
            raise TypeError("Expected argument 'is_free_tier' to be a bool")
        pulumi.set(__self__, "is_free_tier", is_free_tier)
        if is_refreshable_clone and not isinstance(is_refreshable_clone, bool):
            raise TypeError("Expected argument 'is_refreshable_clone' to be a bool")
        pulumi.set(__self__, "is_refreshable_clone", is_refreshable_clone)
        if is_resource_pool_leader and not isinstance(is_resource_pool_leader, bool):
            raise TypeError("Expected argument 'is_resource_pool_leader' to be a bool")
        pulumi.set(__self__, "is_resource_pool_leader", is_resource_pool_leader)
        if lifecycle_state_not_equal_to and not isinstance(lifecycle_state_not_equal_to, str):
            raise TypeError("Expected argument 'lifecycle_state_not_equal_to' to be a str")
        pulumi.set(__self__, "lifecycle_state_not_equal_to", lifecycle_state_not_equal_to)
        if resource_pool_leader_id and not isinstance(resource_pool_leader_id, str):
            raise TypeError("Expected argument 'resource_pool_leader_id' to be a str")
        pulumi.set(__self__, "resource_pool_leader_id", resource_pool_leader_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="autonomousContainerDatabaseId")
    def autonomous_container_database_id(self) -> Optional[str]:
        """
        The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_container_database_id")

    @property
    @pulumi.getter(name="autonomousDatabases")
    def autonomous_databases(self) -> Sequence['outputs.GetAutonomousDatabasesAutonomousDatabaseResult']:
        return pulumi.get(self, "autonomous_databases")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[str]:
        """
        A valid Oracle Database version for Autonomous Database.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="dbWorkload")
    def db_workload(self) -> Optional[str]:
        """
        The Autonomous Database workload type. The following values are valid:
        * OLTP - indicates an Autonomous Transaction Processing database
        * DW - indicates an Autonomous Data Warehouse database
        * AJD - indicates an Autonomous JSON Database
        * APEX - indicates an Autonomous Database with the Oracle APEX Application Development workload type.
        """
        return pulumi.get(self, "db_workload")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The user-friendly name for the Autonomous Database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutonomousDatabasesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="infrastructureType")
    def infrastructure_type(self) -> Optional[str]:
        """
        The infrastructure type this resource belongs to.
        """
        return pulumi.get(self, "infrastructure_type")

    @property
    @pulumi.getter(name="isDataGuardEnabled")
    def is_data_guard_enabled(self) -> Optional[bool]:
        """
        **Deprecated.** Indicates whether the Autonomous Database has local (in-region) Data Guard enabled. Not applicable to cross-region Autonomous Data Guard associations, or to Autonomous Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "is_data_guard_enabled")

    @property
    @pulumi.getter(name="isFreeTier")
    def is_free_tier(self) -> Optional[bool]:
        """
        Indicates if this is an Always Free resource. The default value is false. Note that Always Free Autonomous Databases have 1 CPU and 20GB of memory. For Always Free databases, memory and CPU cannot be scaled.
        """
        return pulumi.get(self, "is_free_tier")

    @property
    @pulumi.getter(name="isRefreshableClone")
    def is_refreshable_clone(self) -> Optional[bool]:
        """
        Indicates if the Autonomous Database is a refreshable clone.
        """
        return pulumi.get(self, "is_refreshable_clone")

    @property
    @pulumi.getter(name="isResourcePoolLeader")
    def is_resource_pool_leader(self) -> Optional[bool]:
        return pulumi.get(self, "is_resource_pool_leader")

    @property
    @pulumi.getter(name="lifecycleStateNotEqualTo")
    def lifecycle_state_not_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "lifecycle_state_not_equal_to")

    @property
    @pulumi.getter(name="resourcePoolLeaderId")
    def resource_pool_leader_id(self) -> Optional[str]:
        """
        The unique identifier for leader autonomous database OCID [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "resource_pool_leader_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the Autonomous Database.
        """
        return pulumi.get(self, "state")


class AwaitableGetAutonomousDatabasesResult(GetAutonomousDatabasesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousDatabasesResult(
            autonomous_container_database_id=self.autonomous_container_database_id,
            autonomous_databases=self.autonomous_databases,
            compartment_id=self.compartment_id,
            db_version=self.db_version,
            db_workload=self.db_workload,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            infrastructure_type=self.infrastructure_type,
            is_data_guard_enabled=self.is_data_guard_enabled,
            is_free_tier=self.is_free_tier,
            is_refreshable_clone=self.is_refreshable_clone,
            is_resource_pool_leader=self.is_resource_pool_leader,
            lifecycle_state_not_equal_to=self.lifecycle_state_not_equal_to,
            resource_pool_leader_id=self.resource_pool_leader_id,
            state=self.state)


def get_autonomous_databases(autonomous_container_database_id: Optional[str] = None,
                             compartment_id: Optional[str] = None,
                             db_version: Optional[str] = None,
                             db_workload: Optional[str] = None,
                             display_name: Optional[str] = None,
                             filters: Optional[Sequence[Union['GetAutonomousDatabasesFilterArgs', 'GetAutonomousDatabasesFilterArgsDict']]] = None,
                             infrastructure_type: Optional[str] = None,
                             is_data_guard_enabled: Optional[bool] = None,
                             is_free_tier: Optional[bool] = None,
                             is_refreshable_clone: Optional[bool] = None,
                             is_resource_pool_leader: Optional[bool] = None,
                             lifecycle_state_not_equal_to: Optional[str] = None,
                             resource_pool_leader_id: Optional[str] = None,
                             state: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousDatabasesResult:
    """
    ## 

    ***
    ## subcategory: "Database"

    layout: "oci"
    page_title: "Oracle Cloud Infrastructure: database_get_autonomous_databases"
    sidebar_current: "docs-oci-datasource-database-autonomous_databases"
    description: |-
      Provides the list of Autonomous Databases in Oracle Cloud Infrastructure Database service
    ---

    # Data Source: database_get_autonomous_databases
    This data source provides the list of Autonomous Databases in Oracle Cloud Infrastructure Database service.

    Gets a list of Autonomous Databases based on the query parameters specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_databases = oci.Database.get_autonomous_databases(compartment_id=compartment_id,
        autonomous_container_database_id=test_autonomous_container_database["id"],
        db_version=autonomous_database_db_version,
        db_workload=autonomous_database_db_workload,
        display_name=autonomous_database_display_name,
        infrastructure_type=autonomous_database_infrastructure_type,
        is_data_guard_enabled=autonomous_database_is_data_guard_enabled,
        is_free_tier=autonomous_database_is_free_tier,
        is_refreshable_clone=autonomous_database_is_refreshable_clone,
        is_resource_pool_leader=autonomous_database_is_resource_pool_leader,
        lifecycle_state_not_equal_to=autonomous_database_lifecycle_state_not_equal_to,
        resource_pool_leader_id=test_resource_pool_leader["id"],
        state=autonomous_database_state)
    ```


    :param str autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str db_version: A filter to return only autonomous database resources that match the specified dbVersion.
    :param str db_workload: A filter to return only autonomous database resources that match the specified workload type.
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str infrastructure_type: A filter to return only resources that match the given Infrastructure Type.
    :param bool is_data_guard_enabled: A filter to return only resources that have Data Guard enabled.
    :param bool is_free_tier: Filter on the value of the resource's 'isFreeTier' property. A value of `true` returns only Always Free resources. A value of `false` excludes Always Free resources from the returned results. Omitting this parameter returns both Always Free and paid resources.
    :param bool is_refreshable_clone: Filter on the value of the resource's 'isRefreshableClone' property. A value of `true` returns only refreshable clones. A value of `false` excludes refreshable clones from the returned results. Omitting this parameter returns both refreshable clones and databases that are not refreshable clones.
    :param bool is_resource_pool_leader: Filter if the resource is the resource pool leader. A value of `true` returns only resource pool leader.
    :param str resource_pool_leader_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resourcepool Leader Autonomous Database.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['autonomousContainerDatabaseId'] = autonomous_container_database_id
    __args__['compartmentId'] = compartment_id
    __args__['dbVersion'] = db_version
    __args__['dbWorkload'] = db_workload
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['infrastructureType'] = infrastructure_type
    __args__['isDataGuardEnabled'] = is_data_guard_enabled
    __args__['isFreeTier'] = is_free_tier
    __args__['isRefreshableClone'] = is_refreshable_clone
    __args__['isResourcePoolLeader'] = is_resource_pool_leader
    __args__['lifecycleStateNotEqualTo'] = lifecycle_state_not_equal_to
    __args__['resourcePoolLeaderId'] = resource_pool_leader_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousDatabases:getAutonomousDatabases', __args__, opts=opts, typ=GetAutonomousDatabasesResult).value

    return AwaitableGetAutonomousDatabasesResult(
        autonomous_container_database_id=pulumi.get(__ret__, 'autonomous_container_database_id'),
        autonomous_databases=pulumi.get(__ret__, 'autonomous_databases'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_version=pulumi.get(__ret__, 'db_version'),
        db_workload=pulumi.get(__ret__, 'db_workload'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        infrastructure_type=pulumi.get(__ret__, 'infrastructure_type'),
        is_data_guard_enabled=pulumi.get(__ret__, 'is_data_guard_enabled'),
        is_free_tier=pulumi.get(__ret__, 'is_free_tier'),
        is_refreshable_clone=pulumi.get(__ret__, 'is_refreshable_clone'),
        is_resource_pool_leader=pulumi.get(__ret__, 'is_resource_pool_leader'),
        lifecycle_state_not_equal_to=pulumi.get(__ret__, 'lifecycle_state_not_equal_to'),
        resource_pool_leader_id=pulumi.get(__ret__, 'resource_pool_leader_id'),
        state=pulumi.get(__ret__, 'state'))
def get_autonomous_databases_output(autonomous_container_database_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    compartment_id: Optional[pulumi.Input[str]] = None,
                                    db_version: Optional[pulumi.Input[Optional[str]]] = None,
                                    db_workload: Optional[pulumi.Input[Optional[str]]] = None,
                                    display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                    filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAutonomousDatabasesFilterArgs', 'GetAutonomousDatabasesFilterArgsDict']]]]] = None,
                                    infrastructure_type: Optional[pulumi.Input[Optional[str]]] = None,
                                    is_data_guard_enabled: Optional[pulumi.Input[Optional[bool]]] = None,
                                    is_free_tier: Optional[pulumi.Input[Optional[bool]]] = None,
                                    is_refreshable_clone: Optional[pulumi.Input[Optional[bool]]] = None,
                                    is_resource_pool_leader: Optional[pulumi.Input[Optional[bool]]] = None,
                                    lifecycle_state_not_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                    resource_pool_leader_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    state: Optional[pulumi.Input[Optional[str]]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAutonomousDatabasesResult]:
    """
    ## 

    ***
    ## subcategory: "Database"

    layout: "oci"
    page_title: "Oracle Cloud Infrastructure: database_get_autonomous_databases"
    sidebar_current: "docs-oci-datasource-database-autonomous_databases"
    description: |-
      Provides the list of Autonomous Databases in Oracle Cloud Infrastructure Database service
    ---

    # Data Source: database_get_autonomous_databases
    This data source provides the list of Autonomous Databases in Oracle Cloud Infrastructure Database service.

    Gets a list of Autonomous Databases based on the query parameters specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_databases = oci.Database.get_autonomous_databases(compartment_id=compartment_id,
        autonomous_container_database_id=test_autonomous_container_database["id"],
        db_version=autonomous_database_db_version,
        db_workload=autonomous_database_db_workload,
        display_name=autonomous_database_display_name,
        infrastructure_type=autonomous_database_infrastructure_type,
        is_data_guard_enabled=autonomous_database_is_data_guard_enabled,
        is_free_tier=autonomous_database_is_free_tier,
        is_refreshable_clone=autonomous_database_is_refreshable_clone,
        is_resource_pool_leader=autonomous_database_is_resource_pool_leader,
        lifecycle_state_not_equal_to=autonomous_database_lifecycle_state_not_equal_to,
        resource_pool_leader_id=test_resource_pool_leader["id"],
        state=autonomous_database_state)
    ```


    :param str autonomous_container_database_id: The Autonomous Container Database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str db_version: A filter to return only autonomous database resources that match the specified dbVersion.
    :param str db_workload: A filter to return only autonomous database resources that match the specified workload type.
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str infrastructure_type: A filter to return only resources that match the given Infrastructure Type.
    :param bool is_data_guard_enabled: A filter to return only resources that have Data Guard enabled.
    :param bool is_free_tier: Filter on the value of the resource's 'isFreeTier' property. A value of `true` returns only Always Free resources. A value of `false` excludes Always Free resources from the returned results. Omitting this parameter returns both Always Free and paid resources.
    :param bool is_refreshable_clone: Filter on the value of the resource's 'isRefreshableClone' property. A value of `true` returns only refreshable clones. A value of `false` excludes refreshable clones from the returned results. Omitting this parameter returns both refreshable clones and databases that are not refreshable clones.
    :param bool is_resource_pool_leader: Filter if the resource is the resource pool leader. A value of `true` returns only resource pool leader.
    :param str resource_pool_leader_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resourcepool Leader Autonomous Database.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['autonomousContainerDatabaseId'] = autonomous_container_database_id
    __args__['compartmentId'] = compartment_id
    __args__['dbVersion'] = db_version
    __args__['dbWorkload'] = db_workload
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['infrastructureType'] = infrastructure_type
    __args__['isDataGuardEnabled'] = is_data_guard_enabled
    __args__['isFreeTier'] = is_free_tier
    __args__['isRefreshableClone'] = is_refreshable_clone
    __args__['isResourcePoolLeader'] = is_resource_pool_leader
    __args__['lifecycleStateNotEqualTo'] = lifecycle_state_not_equal_to
    __args__['resourcePoolLeaderId'] = resource_pool_leader_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getAutonomousDatabases:getAutonomousDatabases', __args__, opts=opts, typ=GetAutonomousDatabasesResult)
    return __ret__.apply(lambda __response__: GetAutonomousDatabasesResult(
        autonomous_container_database_id=pulumi.get(__response__, 'autonomous_container_database_id'),
        autonomous_databases=pulumi.get(__response__, 'autonomous_databases'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        db_version=pulumi.get(__response__, 'db_version'),
        db_workload=pulumi.get(__response__, 'db_workload'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        infrastructure_type=pulumi.get(__response__, 'infrastructure_type'),
        is_data_guard_enabled=pulumi.get(__response__, 'is_data_guard_enabled'),
        is_free_tier=pulumi.get(__response__, 'is_free_tier'),
        is_refreshable_clone=pulumi.get(__response__, 'is_refreshable_clone'),
        is_resource_pool_leader=pulumi.get(__response__, 'is_resource_pool_leader'),
        lifecycle_state_not_equal_to=pulumi.get(__response__, 'lifecycle_state_not_equal_to'),
        resource_pool_leader_id=pulumi.get(__response__, 'resource_pool_leader_id'),
        state=pulumi.get(__response__, 'state')))
