# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMaintenanceRunsResult',
    'AwaitableGetMaintenanceRunsResult',
    'get_maintenance_runs',
    'get_maintenance_runs_output',
]

@pulumi.output_type
class GetMaintenanceRunsResult:
    """
    A collection of values returned by getMaintenanceRuns.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, filters=None, id=None, maintenance_runs=None, maintenance_subtype=None, maintenance_type=None, state=None, target_resource_id=None, target_resource_type=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if maintenance_runs and not isinstance(maintenance_runs, list):
            raise TypeError("Expected argument 'maintenance_runs' to be a list")
        pulumi.set(__self__, "maintenance_runs", maintenance_runs)
        if maintenance_subtype and not isinstance(maintenance_subtype, str):
            raise TypeError("Expected argument 'maintenance_subtype' to be a str")
        pulumi.set(__self__, "maintenance_subtype", maintenance_subtype)
        if maintenance_type and not isinstance(maintenance_type, str):
            raise TypeError("Expected argument 'maintenance_type' to be a str")
        pulumi.set(__self__, "maintenance_type", maintenance_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_resource_id and not isinstance(target_resource_id, str):
            raise TypeError("Expected argument 'target_resource_id' to be a str")
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        if target_resource_type and not isinstance(target_resource_type, str):
            raise TypeError("Expected argument 'target_resource_type' to be a str")
        pulumi.set(__self__, "target_resource_type", target_resource_type)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[str]:
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMaintenanceRunsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maintenanceRuns")
    def maintenance_runs(self) -> Sequence['outputs.GetMaintenanceRunsMaintenanceRunResult']:
        """
        The list of maintenance_runs.
        """
        return pulumi.get(self, "maintenance_runs")

    @property
    @pulumi.getter(name="maintenanceSubtype")
    def maintenance_subtype(self) -> Optional[str]:
        """
        Maintenance sub-type.
        """
        return pulumi.get(self, "maintenance_subtype")

    @property
    @pulumi.getter(name="maintenanceType")
    def maintenance_type(self) -> Optional[str]:
        """
        Maintenance type.
        """
        return pulumi.get(self, "maintenance_type")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the maintenance run. For Autonomous Database Serverless instances, valid states are IN_PROGRESS, SUCCEEDED, and FAILED.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[str]:
        """
        The ID of the target resource on which the maintenance run occurs.
        """
        return pulumi.get(self, "target_resource_id")

    @property
    @pulumi.getter(name="targetResourceType")
    def target_resource_type(self) -> Optional[str]:
        """
        The type of the target resource on which the maintenance run occurs.
        """
        return pulumi.get(self, "target_resource_type")


class AwaitableGetMaintenanceRunsResult(GetMaintenanceRunsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMaintenanceRunsResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            maintenance_runs=self.maintenance_runs,
            maintenance_subtype=self.maintenance_subtype,
            maintenance_type=self.maintenance_type,
            state=self.state,
            target_resource_id=self.target_resource_id,
            target_resource_type=self.target_resource_type)


def get_maintenance_runs(availability_domain: Optional[str] = None,
                         compartment_id: Optional[str] = None,
                         filters: Optional[Sequence[Union['GetMaintenanceRunsFilterArgs', 'GetMaintenanceRunsFilterArgsDict']]] = None,
                         maintenance_subtype: Optional[str] = None,
                         maintenance_type: Optional[str] = None,
                         state: Optional[str] = None,
                         target_resource_id: Optional[str] = None,
                         target_resource_type: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMaintenanceRunsResult:
    """
    This data source provides the list of Maintenance Runs in Oracle Cloud Infrastructure Database service.

    Gets a list of the maintenance runs in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_maintenance_runs = oci.Database.get_maintenance_runs(compartment_id=compartment_id,
        availability_domain=maintenance_run_availability_domain,
        maintenance_subtype=maintenance_run_maintenance_subtype,
        maintenance_type=maintenance_run_maintenance_type,
        state=maintenance_run_state,
        target_resource_id=test_target_resource["id"],
        target_resource_type=maintenance_run_target_resource_type)
    ```


    :param str availability_domain: A filter to return only resources that match the given availability domain exactly.
    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str maintenance_subtype: The sub-type of the maintenance run.
    :param str maintenance_type: The maintenance type.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    :param str target_resource_id: The target resource ID.
    :param str target_resource_type: The type of the target resource. Accepted values are: AUTONOMOUS_CONTAINER_DATABASE, AUTONOMOUS_EXADATA_INFRASTRUCTURE, EXADATA_DB_SYSTEM
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['maintenanceSubtype'] = maintenance_subtype
    __args__['maintenanceType'] = maintenance_type
    __args__['state'] = state
    __args__['targetResourceId'] = target_resource_id
    __args__['targetResourceType'] = target_resource_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getMaintenanceRuns:getMaintenanceRuns', __args__, opts=opts, typ=GetMaintenanceRunsResult).value

    return AwaitableGetMaintenanceRunsResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        maintenance_runs=pulumi.get(__ret__, 'maintenance_runs'),
        maintenance_subtype=pulumi.get(__ret__, 'maintenance_subtype'),
        maintenance_type=pulumi.get(__ret__, 'maintenance_type'),
        state=pulumi.get(__ret__, 'state'),
        target_resource_id=pulumi.get(__ret__, 'target_resource_id'),
        target_resource_type=pulumi.get(__ret__, 'target_resource_type'))
def get_maintenance_runs_output(availability_domain: Optional[pulumi.Input[Optional[str]]] = None,
                                compartment_id: Optional[pulumi.Input[str]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMaintenanceRunsFilterArgs', 'GetMaintenanceRunsFilterArgsDict']]]]] = None,
                                maintenance_subtype: Optional[pulumi.Input[Optional[str]]] = None,
                                maintenance_type: Optional[pulumi.Input[Optional[str]]] = None,
                                state: Optional[pulumi.Input[Optional[str]]] = None,
                                target_resource_id: Optional[pulumi.Input[Optional[str]]] = None,
                                target_resource_type: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMaintenanceRunsResult]:
    """
    This data source provides the list of Maintenance Runs in Oracle Cloud Infrastructure Database service.

    Gets a list of the maintenance runs in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_maintenance_runs = oci.Database.get_maintenance_runs(compartment_id=compartment_id,
        availability_domain=maintenance_run_availability_domain,
        maintenance_subtype=maintenance_run_maintenance_subtype,
        maintenance_type=maintenance_run_maintenance_type,
        state=maintenance_run_state,
        target_resource_id=test_target_resource["id"],
        target_resource_type=maintenance_run_target_resource_type)
    ```


    :param str availability_domain: A filter to return only resources that match the given availability domain exactly.
    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str maintenance_subtype: The sub-type of the maintenance run.
    :param str maintenance_type: The maintenance type.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    :param str target_resource_id: The target resource ID.
    :param str target_resource_type: The type of the target resource. Accepted values are: AUTONOMOUS_CONTAINER_DATABASE, AUTONOMOUS_EXADATA_INFRASTRUCTURE, EXADATA_DB_SYSTEM
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['maintenanceSubtype'] = maintenance_subtype
    __args__['maintenanceType'] = maintenance_type
    __args__['state'] = state
    __args__['targetResourceId'] = target_resource_id
    __args__['targetResourceType'] = target_resource_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getMaintenanceRuns:getMaintenanceRuns', __args__, opts=opts, typ=GetMaintenanceRunsResult)
    return __ret__.apply(lambda __response__: GetMaintenanceRunsResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        maintenance_runs=pulumi.get(__response__, 'maintenance_runs'),
        maintenance_subtype=pulumi.get(__response__, 'maintenance_subtype'),
        maintenance_type=pulumi.get(__response__, 'maintenance_type'),
        state=pulumi.get(__response__, 'state'),
        target_resource_id=pulumi.get(__response__, 'target_resource_id'),
        target_resource_type=pulumi.get(__response__, 'target_resource_type')))
