# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDatabaseToolsPrivateEndpointResult',
    'AwaitableGetDatabaseToolsPrivateEndpointResult',
    'get_database_tools_private_endpoint',
    'get_database_tools_private_endpoint_output',
]

@pulumi.output_type
class GetDatabaseToolsPrivateEndpointResult:
    """
    A collection of values returned by getDatabaseToolsPrivateEndpoint.
    """
    def __init__(__self__, additional_fqdns=None, compartment_id=None, database_tools_private_endpoint_id=None, defined_tags=None, description=None, display_name=None, endpoint_fqdn=None, endpoint_service_id=None, freeform_tags=None, id=None, lifecycle_details=None, locks=None, nsg_ids=None, private_endpoint_ip=None, private_endpoint_vnic_id=None, reverse_connection_configurations=None, state=None, subnet_id=None, system_tags=None, time_created=None, time_updated=None, vcn_id=None):
        if additional_fqdns and not isinstance(additional_fqdns, list):
            raise TypeError("Expected argument 'additional_fqdns' to be a list")
        pulumi.set(__self__, "additional_fqdns", additional_fqdns)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_tools_private_endpoint_id and not isinstance(database_tools_private_endpoint_id, str):
            raise TypeError("Expected argument 'database_tools_private_endpoint_id' to be a str")
        pulumi.set(__self__, "database_tools_private_endpoint_id", database_tools_private_endpoint_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if endpoint_fqdn and not isinstance(endpoint_fqdn, str):
            raise TypeError("Expected argument 'endpoint_fqdn' to be a str")
        pulumi.set(__self__, "endpoint_fqdn", endpoint_fqdn)
        if endpoint_service_id and not isinstance(endpoint_service_id, str):
            raise TypeError("Expected argument 'endpoint_service_id' to be a str")
        pulumi.set(__self__, "endpoint_service_id", endpoint_service_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if locks and not isinstance(locks, list):
            raise TypeError("Expected argument 'locks' to be a list")
        pulumi.set(__self__, "locks", locks)
        if nsg_ids and not isinstance(nsg_ids, list):
            raise TypeError("Expected argument 'nsg_ids' to be a list")
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        if private_endpoint_ip and not isinstance(private_endpoint_ip, str):
            raise TypeError("Expected argument 'private_endpoint_ip' to be a str")
        pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        if private_endpoint_vnic_id and not isinstance(private_endpoint_vnic_id, str):
            raise TypeError("Expected argument 'private_endpoint_vnic_id' to be a str")
        pulumi.set(__self__, "private_endpoint_vnic_id", private_endpoint_vnic_id)
        if reverse_connection_configurations and not isinstance(reverse_connection_configurations, list):
            raise TypeError("Expected argument 'reverse_connection_configurations' to be a list")
        pulumi.set(__self__, "reverse_connection_configurations", reverse_connection_configurations)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if vcn_id and not isinstance(vcn_id, str):
            raise TypeError("Expected argument 'vcn_id' to be a str")
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="additionalFqdns")
    def additional_fqdns(self) -> Sequence[str]:
        """
        A list of additional FQDNs that can be also be used for the private endpoint.
        """
        return pulumi.get(self, "additional_fqdns")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the Database Tools private endpoint.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseToolsPrivateEndpointId")
    def database_tools_private_endpoint_id(self) -> str:
        return pulumi.get(self, "database_tools_private_endpoint_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the Database Tools private endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endpointFqdn")
    def endpoint_fqdn(self) -> str:
        """
        Then FQDN to use for the private endpoint.
        """
        return pulumi.get(self, "endpoint_fqdn")

    @property
    @pulumi.getter(name="endpointServiceId")
    def endpoint_service_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools Endpoint Service.
        """
        return pulumi.get(self, "endpoint_service_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Tools private endpoint.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetDatabaseToolsPrivateEndpointLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups that the private endpoint's VNIC belongs to.  For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> str:
        """
        The private IP address that represents the access point for the associated endpoint service.
        """
        return pulumi.get(self, "private_endpoint_ip")

    @property
    @pulumi.getter(name="privateEndpointVnicId")
    def private_endpoint_vnic_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private endpoint's VNIC.
        """
        return pulumi.get(self, "private_endpoint_vnic_id")

    @property
    @pulumi.getter(name="reverseConnectionConfigurations")
    def reverse_connection_configurations(self) -> Sequence['outputs.GetDatabaseToolsPrivateEndpointReverseConnectionConfigurationResult']:
        """
        Reverse connection configuration details of the private endpoint.
        """
        return pulumi.get(self, "reverse_connection_configurations")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Database Tools private endpoint.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet that the private endpoint belongs to.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the Database Tools private endpoint was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the Database Tools private endpoint was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VCN that the private endpoint belongs to.
        """
        return pulumi.get(self, "vcn_id")


class AwaitableGetDatabaseToolsPrivateEndpointResult(GetDatabaseToolsPrivateEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseToolsPrivateEndpointResult(
            additional_fqdns=self.additional_fqdns,
            compartment_id=self.compartment_id,
            database_tools_private_endpoint_id=self.database_tools_private_endpoint_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            endpoint_fqdn=self.endpoint_fqdn,
            endpoint_service_id=self.endpoint_service_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            locks=self.locks,
            nsg_ids=self.nsg_ids,
            private_endpoint_ip=self.private_endpoint_ip,
            private_endpoint_vnic_id=self.private_endpoint_vnic_id,
            reverse_connection_configurations=self.reverse_connection_configurations,
            state=self.state,
            subnet_id=self.subnet_id,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            vcn_id=self.vcn_id)


def get_database_tools_private_endpoint(database_tools_private_endpoint_id: Optional[str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseToolsPrivateEndpointResult:
    """
    This data source provides details about a specific Database Tools Private Endpoint resource in Oracle Cloud Infrastructure Database Tools service.

    Gets details of a specified Database Tools private endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_tools_private_endpoint = oci.DatabaseTools.get_database_tools_private_endpoint(database_tools_private_endpoint_id=test_database_tools_private_endpoint_oci_database_tools_database_tools_private_endpoint["id"])
    ```


    :param str database_tools_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Database Tools private endpoint.
    """
    __args__ = dict()
    __args__['databaseToolsPrivateEndpointId'] = database_tools_private_endpoint_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseTools/getDatabaseToolsPrivateEndpoint:getDatabaseToolsPrivateEndpoint', __args__, opts=opts, typ=GetDatabaseToolsPrivateEndpointResult).value

    return AwaitableGetDatabaseToolsPrivateEndpointResult(
        additional_fqdns=pulumi.get(__ret__, 'additional_fqdns'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_tools_private_endpoint_id=pulumi.get(__ret__, 'database_tools_private_endpoint_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        endpoint_fqdn=pulumi.get(__ret__, 'endpoint_fqdn'),
        endpoint_service_id=pulumi.get(__ret__, 'endpoint_service_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        locks=pulumi.get(__ret__, 'locks'),
        nsg_ids=pulumi.get(__ret__, 'nsg_ids'),
        private_endpoint_ip=pulumi.get(__ret__, 'private_endpoint_ip'),
        private_endpoint_vnic_id=pulumi.get(__ret__, 'private_endpoint_vnic_id'),
        reverse_connection_configurations=pulumi.get(__ret__, 'reverse_connection_configurations'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        vcn_id=pulumi.get(__ret__, 'vcn_id'))
def get_database_tools_private_endpoint_output(database_tools_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDatabaseToolsPrivateEndpointResult]:
    """
    This data source provides details about a specific Database Tools Private Endpoint resource in Oracle Cloud Infrastructure Database Tools service.

    Gets details of a specified Database Tools private endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_tools_private_endpoint = oci.DatabaseTools.get_database_tools_private_endpoint(database_tools_private_endpoint_id=test_database_tools_private_endpoint_oci_database_tools_database_tools_private_endpoint["id"])
    ```


    :param str database_tools_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a Database Tools private endpoint.
    """
    __args__ = dict()
    __args__['databaseToolsPrivateEndpointId'] = database_tools_private_endpoint_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseTools/getDatabaseToolsPrivateEndpoint:getDatabaseToolsPrivateEndpoint', __args__, opts=opts, typ=GetDatabaseToolsPrivateEndpointResult)
    return __ret__.apply(lambda __response__: GetDatabaseToolsPrivateEndpointResult(
        additional_fqdns=pulumi.get(__response__, 'additional_fqdns'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        database_tools_private_endpoint_id=pulumi.get(__response__, 'database_tools_private_endpoint_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        endpoint_fqdn=pulumi.get(__response__, 'endpoint_fqdn'),
        endpoint_service_id=pulumi.get(__response__, 'endpoint_service_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        locks=pulumi.get(__response__, 'locks'),
        nsg_ids=pulumi.get(__response__, 'nsg_ids'),
        private_endpoint_ip=pulumi.get(__response__, 'private_endpoint_ip'),
        private_endpoint_vnic_id=pulumi.get(__response__, 'private_endpoint_vnic_id'),
        reverse_connection_configurations=pulumi.get(__response__, 'reverse_connection_configurations'),
        state=pulumi.get(__response__, 'state'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        vcn_id=pulumi.get(__response__, 'vcn_id')))
