# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMaskingAnalyticResult',
    'AwaitableGetMaskingAnalyticResult',
    'get_masking_analytic',
    'get_masking_analytic_output',
]

@pulumi.output_type
class GetMaskingAnalyticResult:
    """
    A collection of values returned by getMaskingAnalytic.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, group_by=None, id=None, items=None, masking_policy_id=None, target_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if group_by and not isinstance(group_by, str):
            raise TypeError("Expected argument 'group_by' to be a str")
        pulumi.set(__self__, "group_by", group_by)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if masking_policy_id and not isinstance(masking_policy_id, str):
            raise TypeError("Expected argument 'masking_policy_id' to be a str")
        pulumi.set(__self__, "masking_policy_id", masking_policy_id)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="groupBy")
    def group_by(self) -> Optional[str]:
        return pulumi.get(self, "group_by")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetMaskingAnalyticItemResult']:
        """
        An array of masking analytics summary objects.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="maskingPolicyId")
    def masking_policy_id(self) -> Optional[str]:
        return pulumi.get(self, "masking_policy_id")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[str]:
        """
        The OCID of the target database.
        """
        return pulumi.get(self, "target_id")


class AwaitableGetMaskingAnalyticResult(GetMaskingAnalyticResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMaskingAnalyticResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            group_by=self.group_by,
            id=self.id,
            items=self.items,
            masking_policy_id=self.masking_policy_id,
            target_id=self.target_id)


def get_masking_analytic(compartment_id: Optional[str] = None,
                         compartment_id_in_subtree: Optional[bool] = None,
                         group_by: Optional[str] = None,
                         masking_policy_id: Optional[str] = None,
                         target_id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMaskingAnalyticResult:
    """
    This data source provides details about a specific Masking Analytic resource in Oracle Cloud Infrastructure Data Safe service.

    Gets consolidated masking analytics data based on the specified query parameters.
    If CompartmentIdInSubtreeQueryParam is specified as true, the behaviour
    is equivalent to accessLevel "ACCESSIBLE" by default.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_masking_analytic = oci.DataSafe.get_masking_analytic(compartment_id=compartment_id,
        compartment_id_in_subtree=masking_analytic_compartment_id_in_subtree,
        group_by=masking_analytic_group_by,
        masking_policy_id=test_masking_policy["id"],
        target_id=test_target["id"])
    ```


    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str group_by: Attribute by which the masking analytics data should be grouped.
    :param str masking_policy_id: A filter to return only the resources that match the specified masking policy OCID.
    :param str target_id: A filter to return only items related to a specific target OCID.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['groupBy'] = group_by
    __args__['maskingPolicyId'] = masking_policy_id
    __args__['targetId'] = target_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getMaskingAnalytic:getMaskingAnalytic', __args__, opts=opts, typ=GetMaskingAnalyticResult).value

    return AwaitableGetMaskingAnalyticResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        group_by=pulumi.get(__ret__, 'group_by'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        masking_policy_id=pulumi.get(__ret__, 'masking_policy_id'),
        target_id=pulumi.get(__ret__, 'target_id'))
def get_masking_analytic_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                group_by: Optional[pulumi.Input[Optional[str]]] = None,
                                masking_policy_id: Optional[pulumi.Input[Optional[str]]] = None,
                                target_id: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMaskingAnalyticResult]:
    """
    This data source provides details about a specific Masking Analytic resource in Oracle Cloud Infrastructure Data Safe service.

    Gets consolidated masking analytics data based on the specified query parameters.
    If CompartmentIdInSubtreeQueryParam is specified as true, the behaviour
    is equivalent to accessLevel "ACCESSIBLE" by default.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_masking_analytic = oci.DataSafe.get_masking_analytic(compartment_id=compartment_id,
        compartment_id_in_subtree=masking_analytic_compartment_id_in_subtree,
        group_by=masking_analytic_group_by,
        masking_policy_id=test_masking_policy["id"],
        target_id=test_target["id"])
    ```


    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str group_by: Attribute by which the masking analytics data should be grouped.
    :param str masking_policy_id: A filter to return only the resources that match the specified masking policy OCID.
    :param str target_id: A filter to return only items related to a specific target OCID.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['groupBy'] = group_by
    __args__['maskingPolicyId'] = masking_policy_id
    __args__['targetId'] = target_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getMaskingAnalytic:getMaskingAnalytic', __args__, opts=opts, typ=GetMaskingAnalyticResult)
    return __ret__.apply(lambda __response__: GetMaskingAnalyticResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        group_by=pulumi.get(__response__, 'group_by'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        masking_policy_id=pulumi.get(__response__, 'masking_policy_id'),
        target_id=pulumi.get(__response__, 'target_id')))
