# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBuildPipelineStagesResult',
    'AwaitableGetBuildPipelineStagesResult',
    'get_build_pipeline_stages',
    'get_build_pipeline_stages_output',
]

@pulumi.output_type
class GetBuildPipelineStagesResult:
    """
    A collection of values returned by getBuildPipelineStages.
    """
    def __init__(__self__, build_pipeline_id=None, build_pipeline_stage_collections=None, compartment_id=None, display_name=None, filters=None, id=None, state=None):
        if build_pipeline_id and not isinstance(build_pipeline_id, str):
            raise TypeError("Expected argument 'build_pipeline_id' to be a str")
        pulumi.set(__self__, "build_pipeline_id", build_pipeline_id)
        if build_pipeline_stage_collections and not isinstance(build_pipeline_stage_collections, list):
            raise TypeError("Expected argument 'build_pipeline_stage_collections' to be a list")
        pulumi.set(__self__, "build_pipeline_stage_collections", build_pipeline_stage_collections)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="buildPipelineId")
    def build_pipeline_id(self) -> Optional[str]:
        """
        The OCID of the build pipeline.
        """
        return pulumi.get(self, "build_pipeline_id")

    @property
    @pulumi.getter(name="buildPipelineStageCollections")
    def build_pipeline_stage_collections(self) -> Sequence['outputs.GetBuildPipelineStagesBuildPipelineStageCollectionResult']:
        """
        The list of build_pipeline_stage_collection.
        """
        return pulumi.get(self, "build_pipeline_stage_collections")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The OCID of the compartment where the pipeline is created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Stage display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBuildPipelineStagesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the stage.
        """
        return pulumi.get(self, "state")


class AwaitableGetBuildPipelineStagesResult(GetBuildPipelineStagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBuildPipelineStagesResult(
            build_pipeline_id=self.build_pipeline_id,
            build_pipeline_stage_collections=self.build_pipeline_stage_collections,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_build_pipeline_stages(build_pipeline_id: Optional[str] = None,
                              compartment_id: Optional[str] = None,
                              display_name: Optional[str] = None,
                              filters: Optional[Sequence[Union['GetBuildPipelineStagesFilterArgs', 'GetBuildPipelineStagesFilterArgsDict']]] = None,
                              id: Optional[str] = None,
                              state: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBuildPipelineStagesResult:
    """
    This data source provides the list of Build Pipeline Stages in Oracle Cloud Infrastructure Devops service.

    Returns a list of all stages in a compartment or build pipeline.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_build_pipeline_stages = oci.DevOps.get_build_pipeline_stages(build_pipeline_id=test_build_pipeline["id"],
        compartment_id=compartment_id,
        display_name=build_pipeline_stage_display_name,
        id=build_pipeline_stage_id,
        state=build_pipeline_stage_state)
    ```


    :param str build_pipeline_id: The OCID of the parent build pipeline.
    :param str compartment_id: The OCID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: Unique identifier or OCID for listing a single resource by ID.
    :param str state: A filter to return the stages that matches the given lifecycle state.
    """
    __args__ = dict()
    __args__['buildPipelineId'] = build_pipeline_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getBuildPipelineStages:getBuildPipelineStages', __args__, opts=opts, typ=GetBuildPipelineStagesResult).value

    return AwaitableGetBuildPipelineStagesResult(
        build_pipeline_id=pulumi.get(__ret__, 'build_pipeline_id'),
        build_pipeline_stage_collections=pulumi.get(__ret__, 'build_pipeline_stage_collections'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_build_pipeline_stages_output(build_pipeline_id: Optional[pulumi.Input[Optional[str]]] = None,
                                     compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                     display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetBuildPipelineStagesFilterArgs', 'GetBuildPipelineStagesFilterArgsDict']]]]] = None,
                                     id: Optional[pulumi.Input[Optional[str]]] = None,
                                     state: Optional[pulumi.Input[Optional[str]]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBuildPipelineStagesResult]:
    """
    This data source provides the list of Build Pipeline Stages in Oracle Cloud Infrastructure Devops service.

    Returns a list of all stages in a compartment or build pipeline.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_build_pipeline_stages = oci.DevOps.get_build_pipeline_stages(build_pipeline_id=test_build_pipeline["id"],
        compartment_id=compartment_id,
        display_name=build_pipeline_stage_display_name,
        id=build_pipeline_stage_id,
        state=build_pipeline_stage_state)
    ```


    :param str build_pipeline_id: The OCID of the parent build pipeline.
    :param str compartment_id: The OCID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: Unique identifier or OCID for listing a single resource by ID.
    :param str state: A filter to return the stages that matches the given lifecycle state.
    """
    __args__ = dict()
    __args__['buildPipelineId'] = build_pipeline_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DevOps/getBuildPipelineStages:getBuildPipelineStages', __args__, opts=opts, typ=GetBuildPipelineStagesResult)
    return __ret__.apply(lambda __response__: GetBuildPipelineStagesResult(
        build_pipeline_id=pulumi.get(__response__, 'build_pipeline_id'),
        build_pipeline_stage_collections=pulumi.get(__response__, 'build_pipeline_stage_collections'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
