# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RepositoryProtectedBranchManagementArgs', 'RepositoryProtectedBranchManagement']

@pulumi.input_type
class RepositoryProtectedBranchManagementArgs:
    def __init__(__self__, *,
                 branch_name: pulumi.Input[str],
                 repository_id: pulumi.Input[str],
                 protection_levels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a RepositoryProtectedBranchManagement resource.
        :param pulumi.Input[str] branch_name: Name of a branch to protect.
        :param pulumi.Input[str] repository_id: Unique repository identifier.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protection_levels: Level of protection to add on a branch.
        """
        pulumi.set(__self__, "branch_name", branch_name)
        pulumi.set(__self__, "repository_id", repository_id)
        if protection_levels is not None:
            pulumi.set(__self__, "protection_levels", protection_levels)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> pulumi.Input[str]:
        """
        Name of a branch to protect.
        """
        return pulumi.get(self, "branch_name")

    @branch_name.setter
    def branch_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "branch_name", value)

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Input[str]:
        """
        Unique repository identifier.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository_id", value)

    @property
    @pulumi.getter(name="protectionLevels")
    def protection_levels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Level of protection to add on a branch.
        """
        return pulumi.get(self, "protection_levels")

    @protection_levels.setter
    def protection_levels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "protection_levels", value)


@pulumi.input_type
class _RepositoryProtectedBranchManagementState:
    def __init__(__self__, *,
                 branch_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 protection_levels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 repository_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RepositoryProtectedBranchManagement resources.
        :param pulumi.Input[str] branch_name: Name of a branch to protect.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protection_levels: Level of protection to add on a branch.
        :param pulumi.Input[str] repository_id: Unique repository identifier.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if protection_levels is not None:
            pulumi.set(__self__, "protection_levels", protection_levels)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a branch to protect.
        """
        return pulumi.get(self, "branch_name")

    @branch_name.setter
    def branch_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="protectionLevels")
    def protection_levels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Level of protection to add on a branch.
        """
        return pulumi.get(self, "protection_levels")

    @protection_levels.setter
    def protection_levels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "protection_levels", value)

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique repository identifier.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_id", value)


class RepositoryProtectedBranchManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branch_name: Optional[pulumi.Input[str]] = None,
                 protection_levels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 repository_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Repository Protected Branch Management resource in Oracle Cloud Infrastructure Devops service.

        Creates a restriction on a branch that prevents certain actions on it.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_repository_protected_branch_management = oci.dev_ops.RepositoryProtectedBranchManagement("test_repository_protected_branch_management",
            branch_name=repository_protected_branch_management_branch_name,
            repository_id=test_repository["id"],
            protection_levels=repository_protected_branch_management_protection_levels)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branch_name: Name of a branch to protect.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protection_levels: Level of protection to add on a branch.
        :param pulumi.Input[str] repository_id: Unique repository identifier.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepositoryProtectedBranchManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Repository Protected Branch Management resource in Oracle Cloud Infrastructure Devops service.

        Creates a restriction on a branch that prevents certain actions on it.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_repository_protected_branch_management = oci.dev_ops.RepositoryProtectedBranchManagement("test_repository_protected_branch_management",
            branch_name=repository_protected_branch_management_branch_name,
            repository_id=test_repository["id"],
            protection_levels=repository_protected_branch_management_protection_levels)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param RepositoryProtectedBranchManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositoryProtectedBranchManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branch_name: Optional[pulumi.Input[str]] = None,
                 protection_levels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 repository_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositoryProtectedBranchManagementArgs.__new__(RepositoryProtectedBranchManagementArgs)

            if branch_name is None and not opts.urn:
                raise TypeError("Missing required property 'branch_name'")
            __props__.__dict__["branch_name"] = branch_name
            __props__.__dict__["protection_levels"] = protection_levels
            if repository_id is None and not opts.urn:
                raise TypeError("Missing required property 'repository_id'")
            __props__.__dict__["repository_id"] = repository_id
            __props__.__dict__["freeform_tags"] = None
        super(RepositoryProtectedBranchManagement, __self__).__init__(
            'oci:DevOps/repositoryProtectedBranchManagement:RepositoryProtectedBranchManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            branch_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            protection_levels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            repository_id: Optional[pulumi.Input[str]] = None) -> 'RepositoryProtectedBranchManagement':
        """
        Get an existing RepositoryProtectedBranchManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branch_name: Name of a branch to protect.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protection_levels: Level of protection to add on a branch.
        :param pulumi.Input[str] repository_id: Unique repository identifier.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RepositoryProtectedBranchManagementState.__new__(_RepositoryProtectedBranchManagementState)

        __props__.__dict__["branch_name"] = branch_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["protection_levels"] = protection_levels
        __props__.__dict__["repository_id"] = repository_id
        return RepositoryProtectedBranchManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> pulumi.Output[str]:
        """
        Name of a branch to protect.
        """
        return pulumi.get(self, "branch_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="protectionLevels")
    def protection_levels(self) -> pulumi.Output[Sequence[str]]:
        """
        Level of protection to add on a branch.
        """
        return pulumi.get(self, "protection_levels")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Output[str]:
        """
        Unique repository identifier.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "repository_id")

